/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.ColorQuantizerOpImage;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class NeuQuantOpImage
extends ColorQuantizerOpImage {
    protected static final int prime1 = 499;
    protected static final int prime2 = 491;
    protected static final int prime3 = 487;
    protected static final int prime4 = 503;
    protected static final int minpicturebytes = 1509;
    private int ncycles;
    private final int maxnetpos;
    private final int netbiasshift = 4;
    private final int intbiasshift = 16;
    private final int intbias = 65536;
    private final int gammashift = 10;
    private final int gamma = 1024;
    private final int betashift = 10;
    private final int beta = 64;
    private final int betagamma = 65536;
    private final int initrad;
    private final int radiusbiasshift = 6;
    private final int radiusbias = 64;
    private final int initradius;
    private final int radiusdec = 30;
    private final int alphabiasshift = 10;
    private final int initalpha = 1024;
    private int alphadec;
    private final int radbiasshift = 8;
    private final int radbias = 256;
    private final int alpharadbshift = 18;
    private final int alpharadbias = 262144;
    private int[][] network;
    private int[] netindex;
    private int[] bias;
    private int[] freq;
    private int[] radpower;

    public NeuQuantOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, int n3, ROI rOI, int n4, int n5) {
        super(renderedImage, map, imageLayout, n2, rOI, n4, n5);
        this.maxnetpos = this.maxColorNum - 1;
        this.netbiasshift = 4;
        this.intbiasshift = 16;
        this.intbias = 65536;
        this.gammashift = 10;
        this.gamma = 1024;
        this.betashift = 10;
        this.beta = 64;
        this.betagamma = 65536;
        this.initrad = this.maxColorNum >> 3;
        this.radiusbiasshift = 6;
        this.radiusbias = 64;
        this.initradius = this.initrad * 64;
        this.radiusdec = 30;
        this.alphabiasshift = 10;
        this.initalpha = 1024;
        this.radbiasshift = 8;
        this.radbias = 256;
        this.alpharadbshift = 18;
        this.alpharadbias = 262144;
        this.netindex = new int[256];
        this.bias = new int[this.maxColorNum];
        this.freq = new int[this.maxColorNum];
        this.radpower = new int[this.initrad];
        this.colorMap = null;
        this.ncycles = n3;
    }

    protected synchronized void train() {
        Object object;
        this.network = new int[this.maxColorNum][];
        int n2 = 0;
        while (n2 < this.maxColorNum) {
            this.network[n2] = new int[4];
            object = this.network[n2];
            int n3 = (n2 << 12) / this.maxColorNum;
            object[2] = n3;
            object[1] = n3;
            object[0] = n3;
            this.freq[n2] = 65536 / this.maxColorNum;
            this.bias[n2] = 0;
            ++n2;
        }
        object = this.getSourceImage(0);
        Rectangle rectangle = ((PlanarImage)object).getBounds();
        if (this.roi != null) {
            rectangle = this.roi.getBounds();
        }
        RandomIter randomIter = RandomIterFactory.create((RenderedImage)object, rectangle);
        int n4 = this.xPeriod * this.yPeriod;
        int n5 = rectangle.x / this.xPeriod;
        int n6 = rectangle.y / this.yPeriod;
        int n7 = rectangle.x % this.xPeriod;
        int n8 = rectangle.y % this.yPeriod;
        int n9 = (rectangle.width - 1) / this.xPeriod + 1;
        int n10 = n9 * ((rectangle.height - 1) / this.yPeriod + 1);
        if (n10 < 1509) {
            n4 = 1;
        }
        this.alphadec = 30 + (n4 - 1) / 3;
        int n11 = 0;
        int n12 = n10 / this.ncycles;
        int n13 = 1024;
        int n14 = this.initradius;
        int n15 = n14 >> 6;
        if (n15 <= 1) {
            n15 = 0;
        }
        int n16 = 0;
        while (n16 < n15) {
            this.radpower[n16] = n13 * ((n15 * n15 - n16 * n16) * 256 / (n15 * n15));
            ++n16;
        }
        int n17 = n10 < 1509 ? 3 : (n10 % 499 != 0 ? 1497 : (n10 % 491 != 0 ? 1473 : (n10 % 487 != 0 ? 1461 : 1509)));
        int[] nArray = new int[3];
        int n18 = 0;
        while (n18 < n10) {
            int n19 = (n11 / n9 + n6) * this.yPeriod + n8;
            int n20 = (n11 % n9 + n5) * this.xPeriod + n7;
            try {
                randomIter.getPixel(n20, n19, nArray);
            }
            catch (Exception exception) {
                continue;
            }
            int n21 = nArray[2] << 4;
            int n22 = nArray[1] << 4;
            int n23 = nArray[0] << 4;
            int n24 = this.contest(n21, n22, n23);
            this.altersingle(n13, n24, n21, n22, n23);
            if (n15 != 0) {
                this.alterneigh(n15, n24, n21, n22, n23);
            }
            if ((n11 += n17) >= n10) {
                n11 -= n10;
            }
            if (++n18 % n12 != 0) continue;
            n13 -= n13 / this.alphadec;
            if ((n15 = (n14 -= n14 / 30) >> 6) <= 1) {
                n15 = 0;
            }
            n24 = 0;
            while (n24 < n15) {
                this.radpower[n24] = n13 * ((n15 * n15 - n24 * n24) * 256 / (n15 * n15));
                ++n24;
            }
        }
        this.unbiasnet();
        this.inxbuild();
        this.createLUT();
        this.setProperty("LUT", this.colorMap);
    }

    private void createLUT() {
        this.colorMap = new LookupTableJAI(new byte[3][this.maxColorNum]);
        byte[][] byArray = this.colorMap.getByteData();
        int[] nArray = new int[this.maxColorNum];
        int n2 = 0;
        while (n2 < this.maxColorNum) {
            nArray[this.network[n2][3]] = n2;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.maxColorNum) {
            int n4 = nArray[n3];
            byArray[2][n3] = (byte)this.network[n4][0];
            byArray[1][n3] = (byte)this.network[n4][1];
            byArray[0][n3] = (byte)this.network[n4][2];
            ++n3;
        }
    }

    private void inxbuild() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.maxColorNum) {
            int[] nArray;
            int[] nArray2 = this.network[n4];
            int n5 = n4;
            int n6 = nArray2[1];
            int n7 = n4 + 1;
            while (n7 < this.maxColorNum) {
                nArray = this.network[n7];
                if (nArray[1] < n6) {
                    n5 = n7;
                    n6 = nArray[1];
                }
                ++n7;
            }
            nArray = this.network[n5];
            if (n4 != n5) {
                n7 = nArray[0];
                nArray[0] = nArray2[0];
                nArray2[0] = n7;
                n7 = nArray[1];
                nArray[1] = nArray2[1];
                nArray2[1] = n7;
                n7 = nArray[2];
                nArray[2] = nArray2[2];
                nArray2[2] = n7;
                n7 = nArray[3];
                nArray[3] = nArray2[3];
                nArray2[3] = n7;
            }
            if (n6 != n2) {
                this.netindex[n2] = n3 + n4 >> 1;
                n7 = n2 + 1;
                while (n7 < n6) {
                    this.netindex[n7] = n4;
                    ++n7;
                }
                n2 = n6;
                n3 = n4;
            }
            ++n4;
        }
        this.netindex[n2] = n3 + this.maxnetpos >> 1;
        int n8 = n2 + 1;
        while (n8 < 256) {
            this.netindex[n8] = this.maxnetpos;
            ++n8;
        }
    }

    protected byte findNearestEntry(int n2, int n3, int n4) {
        int n5 = 1000;
        int n6 = -1;
        int n7 = this.netindex[n3];
        int n8 = n7 - 1;
        while (n7 < this.maxColorNum || n8 >= 0) {
            int n9;
            int n10;
            int[] nArray;
            if (n7 < this.maxColorNum) {
                nArray = this.network[n7];
                n10 = nArray[1] - n3;
                if (n10 >= n5) {
                    n7 = this.maxColorNum;
                } else {
                    ++n7;
                    if (n10 < 0) {
                        n10 = -n10;
                    }
                    if ((n9 = nArray[0] - n4) < 0) {
                        n9 = -n9;
                    }
                    if ((n10 += n9) < n5) {
                        n9 = nArray[2] - n2;
                        if (n9 < 0) {
                            n9 = -n9;
                        }
                        if ((n10 += n9) < n5) {
                            n5 = n10;
                            n6 = nArray[3];
                        }
                    }
                }
            }
            if (n8 < 0) continue;
            nArray = this.network[n8];
            n10 = n3 - nArray[1];
            if (n10 >= n5) {
                n8 = -1;
                continue;
            }
            --n8;
            if (n10 < 0) {
                n10 = -n10;
            }
            if ((n9 = nArray[0] - n4) < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) >= n5) continue;
            n9 = nArray[2] - n2;
            if (n9 < 0) {
                n9 = -n9;
            }
            if ((n10 += n9) >= n5) continue;
            n5 = n10;
            n6 = nArray[3];
        }
        return (byte)n6;
    }

    private void unbiasnet() {
        int n2 = 0;
        while (n2 < this.maxColorNum) {
            int[] nArray = this.network[n2];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[n2];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[n2];
            nArray3[2] = nArray3[2] >> 4;
            this.network[n2][3] = n2;
            ++n2;
        }
    }

    private void alterneigh(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n3 - n2;
        if (n8 < -1) {
            n8 = -1;
        }
        if ((n7 = n3 + n2) > this.maxColorNum) {
            n7 = this.maxColorNum;
        }
        int n9 = n3 + 1;
        int n10 = n3 - 1;
        int n11 = 1;
        while (n9 < n7 || n10 > n8) {
            int[] nArray;
            int n12 = this.radpower[n11++];
            if (n9 < n7) {
                nArray = this.network[n9++];
                nArray[0] = nArray[0] - n12 * (nArray[0] - n4) / 262144;
                nArray[1] = nArray[1] - n12 * (nArray[1] - n5) / 262144;
                nArray[2] = nArray[2] - n12 * (nArray[2] - n6) / 262144;
            }
            if (n10 <= n8) continue;
            nArray = this.network[n10--];
            nArray[0] = nArray[0] - n12 * (nArray[0] - n4) / 262144;
            nArray[1] = nArray[1] - n12 * (nArray[1] - n5) / 262144;
            nArray[2] = nArray[2] - n12 * (nArray[2] - n6) / 262144;
        }
    }

    private void altersingle(int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = this.network[n3];
        nArray[0] = nArray[0] - n2 * (nArray[0] - n4) / 1024;
        nArray[1] = nArray[1] - n2 * (nArray[1] - n5) / 1024;
        nArray[2] = nArray[2] - n2 * (nArray[2] - n6) / 1024;
    }

    private int contest(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n6 = Integer.MAX_VALUE;
        int n8 = n5 = -1;
        int n9 = 0;
        while (n9 < this.maxColorNum) {
            int n10;
            int n11;
            int[] nArray = this.network[n9];
            int n12 = nArray[0] - n2;
            if (n12 < 0) {
                n12 = -n12;
            }
            if ((n11 = nArray[1] - n3) < 0) {
                n11 = -n11;
            }
            n12 += n11;
            n11 = nArray[2] - n4;
            if (n11 < 0) {
                n11 = -n11;
            }
            if ((n12 += n11) < n6) {
                n6 = n12;
                n5 = n9;
            }
            if ((n10 = n12 - (this.bias[n9] >> 12)) < n7) {
                n7 = n10;
                n8 = n9;
            }
            int n13 = this.freq[n9] >> 10;
            int n14 = n9;
            this.freq[n14] = this.freq[n14] - n13;
            int n15 = n9++;
            this.bias[n15] = this.bias[n15] + (n13 << 10);
        }
        int n16 = n5;
        this.freq[n16] = this.freq[n16] + 64;
        int n17 = n5;
        this.bias[n17] = this.bias[n17] - 65536;
        return n8;
    }
}

