/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class OrConstOpImage
extends ColormapOpImage {
    protected int[] constants;

    public OrConstOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int[] nArray) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.getSampleModel().getNumBands();
        if (nArray.length < n2) {
            this.constants = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.constants[n3] = nArray[0];
                ++n3;
            }
        } else {
            this.constants = (int[])nArray.clone();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray2 = byArray[n2];
            int n3 = byArray2.length;
            int n4 = n2 < this.constants.length ? this.constants[n2] : this.constants[0];
            int n5 = 0;
            while (n5 < n3) {
                byArray2[n5] = ImageUtil.clampRoundByte(byArray2[n5] & 0xFF | n4);
                ++n5;
            }
            ++n2;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor2, rasterAccessor);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(rasterAccessor2, rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor2, rasterAccessor);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int n10 = this.constants[n9];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n11 = nArray[n9];
            int n12 = nArray2[n9];
            int n13 = 0;
            while (n13 < n3) {
                int n14 = n11;
                int n15 = n12;
                n11 += n5;
                n12 += n7;
                int n16 = 0;
                while (n16 < n2) {
                    byArray3[n14] = (byte)(byArray4[n15] | n10);
                    n14 += n6;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int n10 = this.constants[n9];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n11 = nArray[n9];
            int n12 = nArray2[n9];
            int n13 = 0;
            while (n13 < n3) {
                int n14 = n11;
                int n15 = n12;
                n11 += n5;
                n12 += n7;
                int n16 = 0;
                while (n16 < n2) {
                    sArray3[n14] = (short)(sArray4[n15] | n10);
                    n14 += n6;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int n10 = this.constants[n9];
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n11 = nArray[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n3) {
                int n14 = n11;
                int n15 = n12;
                n11 += n5;
                n12 += n7;
                int n16 = 0;
                while (n16 < n2) {
                    nArray5[n14] = nArray6[n15] | n10;
                    n14 += n6;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }
}

