/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class OrderedDitherOpImage
extends PointOpImage {
    private static final int TYPE_OD_GENERAL = 0;
    private static final int TYPE_OD_BYTE_LUT_3BAND = 1;
    private static final int TYPE_OD_BYTE_LUT_NBAND = 2;
    private static final int DITHER_LUT_LENGTH_MAX = 262144;
    private static final int DITHER_LUT_CACHE_LENGTH_MAX = 4;
    private static Vector ditherLUTCache = new Vector(0, 4);
    private int odType = 0;
    protected int numBands;
    protected int[] dims;
    protected int[] mults;
    protected int adjustedOffset;
    protected int maskWidth;
    protected int maskHeight;
    protected byte[][] maskDataByte;
    protected int[][] maskDataInt;
    protected long[][] maskDataLong;
    protected float[][] maskDataFloat;
    protected DitherLUT odLUT = null;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (colorCube.getNumBands() == 1 && colorCube.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n2 = colorCube.getNumEntries();
            byte[][] byArray = new byte[3][256];
            int n3 = 0;
            while (n3 < 3) {
                byte[] byArray2 = byArray[n3];
                byte[] byArray3 = colorCube.getByteData(n3);
                int n4 = colorCube.getOffset(n3);
                int n5 = n4 + n2;
                int n6 = 0;
                while (n6 < n4) {
                    byArray2[n6] = 0;
                    ++n6;
                }
                int n7 = n4;
                while (n7 < n5) {
                    byArray2[n7] = byArray3[n7 - n4];
                    ++n7;
                }
                int n8 = n5;
                while (n8 < 256) {
                    byArray2[n8] = -1;
                    ++n8;
                }
                ++n3;
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public OrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, OrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.numBands = colorCube.getNumBands();
        this.mults = (int[])colorCube.getMultipliers().clone();
        this.dims = (int[])colorCube.getDimsLessOne().clone();
        this.adjustedOffset = colorCube.getAdjustedOffset();
        this.maskWidth = kernelJAIArray[0].getWidth();
        this.maskHeight = kernelJAIArray[0].getHeight();
        this.initializeDitherData(this.sampleModel.getTransferType(), kernelJAIArray);
        this.permitInPlaceOperation();
    }

    private void initializeDitherData(int n2, KernelJAI[] kernelJAIArray) {
        switch (n2) {
            case 0: {
                this.maskDataByte = new byte[kernelJAIArray.length][];
                int n3 = 0;
                while (n3 < this.maskDataByte.length) {
                    float[] fArray = kernelJAIArray[n3].getKernelData();
                    this.maskDataByte[n3] = new byte[fArray.length];
                    int n4 = 0;
                    while (n4 < fArray.length) {
                        this.maskDataByte[n3][n4] = (byte)((int)(fArray[n4] * 255.0f) & 0xFF);
                        ++n4;
                    }
                    ++n3;
                }
                this.initializeDitherLUT();
                break;
            }
            case 1: 
            case 2: {
                int n5 = 65535;
                this.maskDataInt = new int[kernelJAIArray.length][];
                int n6 = 0;
                while (n6 < this.maskDataInt.length) {
                    float[] fArray = kernelJAIArray[n6].getKernelData();
                    this.maskDataInt[n6] = new int[fArray.length];
                    int n7 = 0;
                    while (n7 < fArray.length) {
                        this.maskDataInt[n6][n7] = (int)(fArray[n7] * (float)n5);
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            case 3: {
                long l2 = 0xFFFFFFFFL;
                this.maskDataLong = new long[kernelJAIArray.length][];
                int n8 = 0;
                while (n8 < this.maskDataLong.length) {
                    float[] fArray = kernelJAIArray[n8].getKernelData();
                    this.maskDataLong[n8] = new long[fArray.length];
                    int n9 = 0;
                    while (n9 < fArray.length) {
                        this.maskDataLong[n8][n9] = (long)(fArray[n9] * (float)l2);
                        ++n9;
                    }
                    ++n8;
                }
                break;
            }
            case 4: 
            case 5: {
                this.maskDataFloat = new float[kernelJAIArray.length][];
                int n10 = 0;
                while (n10 < this.maskDataFloat.length) {
                    this.maskDataFloat[n10] = kernelJAIArray[n10].getKernelData();
                    ++n10;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private synchronized void initializeDitherLUT() {
        if (this.numBands * this.maskHeight * this.maskWidth * 256 > 262144) {
            this.odType = 0;
            return;
        }
        this.odType = this.numBands == 3 ? 1 : 2;
        int n2 = 0;
        while (n2 < ditherLUTCache.size()) {
            SoftReference softReference = (SoftReference)ditherLUTCache.get(n2);
            DitherLUT ditherLUT = (DitherLUT)softReference.get();
            if (ditherLUT == null) {
                ditherLUTCache.remove(n2);
                continue;
            }
            if (ditherLUT.equals(this.dims, this.mults, this.maskDataByte)) {
                this.odLUT = ditherLUT;
                break;
            }
            ++n2;
        }
        if (this.odLUT == null) {
            this.odLUT = new DitherLUT(this.dims, this.mults, this.maskDataByte);
            if (ditherLUTCache.size() < 4) {
                ditherLUTCache.add(new SoftReference<DitherLUT>(this.odLUT));
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        RenderedImage[] renderedImageArray;
        RasterFormatTag[] rasterFormatTagArray = null;
        if (ImageUtil.isBinary(this.getSampleModel()) && !ImageUtil.isBinary(this.getSourceImage(0).getSampleModel())) {
            renderedImageArray = new RenderedImage[]{this.getSourceImage(0)};
            object = RasterAccessor.findCompatibleTags(renderedImageArray, renderedImageArray[0]);
            RasterFormatTag[] rasterFormatTagArray2 = RasterAccessor.findCompatibleTags(renderedImageArray, this);
            rasterFormatTagArray = new RasterFormatTag[]{object[0], rasterFormatTagArray2[1]};
        } else {
            rasterFormatTagArray = this.getFormatTags();
        }
        renderedImageArray = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        object = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (renderedImageArray.getDataType()) {
            case 0: {
                this.computeRectByte((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 2: {
                this.computeRectShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 1: {
                this.computeRectUShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 3: {
                this.computeRectInt((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 4: {
                this.computeRectFloat((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 5: {
                this.computeRectDouble((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage1"));
            }
        }
        ((RasterAccessor)object).copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        byte[] byArray2 = rasterAccessor2.getByteDataArray(0);
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        switch (this.odType) {
            case 1: 
            case 2: {
                int[] nArray2 = (int[])nArray.clone();
                int[] nArray3 = (int[])nArray2.clone();
                int n12 = n9;
                int n13 = 0;
                while (n13 < n6) {
                    int n14 = (n11 + n13) % this.maskHeight;
                    if (this.odType == 1) {
                        this.computeLineByteLUT3(byArray, nArray3, n4, byArray2, n12, n8, n5, n10, n14);
                    } else {
                        this.computeLineByteLUTN(byArray, nArray3, n4, byArray2, n12, n8, n5, n10, n14);
                    }
                    int n15 = 0;
                    while (n15 < n2) {
                        int n16 = n15;
                        nArray2[n16] = nArray2[n16] + n3;
                        nArray3[n15] = nArray2[n15];
                        ++n15;
                    }
                    n12 += n7;
                    ++n13;
                }
                break;
            }
            default: {
                this.computeRectByteGeneral(byArray, nArray, n3, n4, byArray2, n9, n7, n8, n5, n6, n10, n11);
            }
        }
    }

    private void computeLineByteLUT3(byte[][] byArray, int[] nArray, int n2, byte[] byArray2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.odLUT.ditherLUTBandStride;
        int n9 = this.odLUT.ditherLUTRowStride;
        int n10 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n11 = this.adjustedOffset;
        int n12 = n7 * n9;
        int n13 = n12 + n8;
        int n14 = n13 + n8;
        int n15 = n12 + n9;
        int n16 = n6 * n10;
        int n17 = n12 + n16;
        int n18 = n13 + n16;
        int n19 = n14 + n16;
        byte[] byArray4 = byArray[0];
        byte[] byArray5 = byArray[1];
        byte[] byArray6 = byArray[2];
        int n20 = n5;
        while (n20 > 0) {
            int n21 = (byArray3[n17 + (byArray4[nArray[0]] & 0xFF)] & 0xFF) + (byArray3[n18 + (byArray5[nArray[1]] & 0xFF)] & 0xFF) + (byArray3[n19 + (byArray6[nArray[2]] & 0xFF)] & 0xFF);
            byArray2[n3] = (byte)(n21 + n11 & 0xFF);
            nArray[0] = nArray[0] + n2;
            nArray[1] = nArray[1] + n2;
            nArray[2] = nArray[2] + n2;
            n3 += n4;
            if ((n17 += n10) >= n15) {
                n17 = n12;
                n18 = n13;
                n19 = n14;
            } else {
                n18 += n10;
                n19 += n10;
            }
            --n20;
        }
    }

    private void computeLineByteLUTN(byte[][] byArray, int[] nArray, int n2, byte[] byArray2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.odLUT.ditherLUTBandStride;
        int n9 = this.odLUT.ditherLUTRowStride;
        int n10 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n11 = this.adjustedOffset;
        int n12 = n7 * n9;
        int n13 = n12 + n6 * n10;
        int n14 = n12 + n9;
        int n15 = n5;
        while (n15 > 0) {
            int n16 = n13;
            int n17 = n11;
            int n18 = 0;
            while (n18 < this.numBands) {
                n17 += byArray3[n16 + (byArray[n18][nArray[n18]] & 0xFF)] & 0xFF;
                n16 += n8;
                int n19 = n18++;
                nArray[n19] = nArray[n19] + n2;
            }
            byArray2[n3] = (byte)(n17 & 0xFF);
            n3 += n4;
            if ((n13 += n10) >= n14) {
                n13 = n12;
            }
            --n15;
        }
    }

    private void computeRectByteGeneral(byte[][] byArray, int[] nArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (this.adjustedOffset > 0) {
            Arrays.fill(byArray2, (byte)(this.adjustedOffset & 0xFF));
        }
        int n11 = nArray.length;
        int n12 = 0;
        while (n12 < n11) {
            byte[] byArray3 = byArray[n12];
            byte[] byArray4 = byArray2;
            byte[] byArray5 = this.maskDataByte[n12];
            int n13 = nArray[n12];
            int n14 = n4;
            int n15 = 0;
            while (n15 < n8) {
                int n16 = (n10 + n15) % this.maskHeight;
                int n17 = n16 * this.maskWidth;
                int n18 = n17 + this.maskWidth;
                int n19 = n17 + n9;
                int n20 = n13;
                int n21 = n14;
                int n22 = 0;
                while (n22 < n7) {
                    int n23 = (byArray3[n20] & 0xFF) * this.dims[n12];
                    int n24 = n23 & 0xFF;
                    n23 >>= 8;
                    if (n24 > (byArray5[n19] & 0xFF)) {
                        ++n23;
                    }
                    int n25 = (byArray4[n21] & 0xFF) + n23 * this.mults[n12];
                    byArray4[n21] = (byte)(n25 & 0xFF);
                    n20 += n3;
                    n21 += n6;
                    if (++n19 >= n18) {
                        n19 = n17;
                    }
                    ++n22;
                }
                n13 += n2;
                n14 += n5;
                ++n15;
            }
            ++n12;
        }
        if (this.adjustedOffset < 0) {
            int n26 = byArray2.length;
            int n27 = 0;
            while (n27 < n26) {
                byArray2[n27] = (byte)((byArray2[n27] & 0xFF) + this.adjustedOffset);
                ++n27;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        int n12 = 0;
        while (n12 < n2) {
            short[] sArray3 = sArray[n12];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[n12];
            int n13 = nArray[n12];
            int n14 = n9;
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n13;
                int n17 = n14;
                n13 += n3;
                n14 += n7;
                int n18 = (n11 + n15) % this.maskHeight * this.maskWidth;
                int n19 = n18 + this.maskWidth;
                int n20 = n18 + n10;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = (sArray3[n16] - Short.MIN_VALUE) * this.dims[n12];
                    int n23 = n22 & 0xFFFF;
                    int n24 = (sArray4[n17] & 0xFFFF) + (n22 >> 16) * this.mults[n12];
                    if (n23 > nArray2[n20]) {
                        n24 += this.mults[n12];
                    }
                    sArray4[n17] = (short)(n24 & 0xFFFF);
                    n16 += n4;
                    n17 += n8;
                    if (++n20 >= n19) {
                        n20 = n18;
                    }
                    ++n21;
                }
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        int n12 = 0;
        while (n12 < n2) {
            short[] sArray3 = sArray[n12];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[n12];
            int n13 = nArray[n12];
            int n14 = n9;
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n13;
                int n17 = n14;
                n13 += n3;
                n14 += n7;
                int n18 = (n11 + n15) % this.maskHeight * this.maskWidth;
                int n19 = n18 + this.maskWidth;
                int n20 = n18 + n10;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = (sArray3[n16] & 0xFFFF) * this.dims[n12];
                    int n23 = n22 & 0xFFFF;
                    int n24 = (sArray4[n17] & 0xFFFF) + (n22 >> 16) * this.mults[n12];
                    if (n23 > nArray2[n20]) {
                        n24 += this.mults[n12];
                    }
                    sArray4[n17] = (short)(n24 & 0xFFFF);
                    n16 += n4;
                    n17 += n8;
                    if (++n20 >= n19) {
                        n20 = n18;
                    }
                    ++n21;
                }
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        int[] nArray3 = rasterAccessor2.getIntDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(nArray3, this.adjustedOffset);
        }
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        int n12 = 0;
        while (n12 < n2) {
            int[] nArray4 = nArray2[n12];
            int[] nArray5 = nArray3;
            long[] lArray = this.maskDataLong[n12];
            int n13 = nArray[n12];
            int n14 = n9;
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n13;
                int n17 = n14;
                n13 += n3;
                n14 += n7;
                int n18 = (n11 + n15) % this.maskHeight * this.maskWidth;
                int n19 = n18 + this.maskWidth;
                int n20 = n18 + n10;
                int n21 = 0;
                while (n21 < n5) {
                    long l2 = ((long)nArray4[n16] - Integer.MIN_VALUE) * (long)this.dims[n12];
                    long l3 = l2 & 0xFFFFFFFFFFFFFFFFL;
                    int n22 = nArray5[n17] + (int)(l2 >> 32) * this.mults[n12];
                    if (l3 > lArray[n20]) {
                        n22 += this.mults[n12];
                    }
                    nArray5[n17] = n22;
                    n16 += n4;
                    n17 += n8;
                    if (++n20 >= n19) {
                        n20 = n18;
                    }
                    ++n21;
                }
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        float[] fArray2 = rasterAccessor2.getFloatDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(fArray2, (float)this.adjustedOffset);
        }
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        int n12 = 0;
        while (n12 < n2) {
            float[] fArray3 = fArray[n12];
            float[] fArray4 = fArray2;
            float[] fArray5 = this.maskDataFloat[n12];
            int n13 = nArray[n12];
            int n14 = n9;
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n13;
                int n17 = n14;
                n13 += n3;
                n14 += n7;
                int n18 = (n11 + n15) % this.maskHeight * this.maskWidth;
                int n19 = n18 + this.maskWidth;
                int n20 = n18 + n10;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = (int)(fArray3[n16] * (float)this.dims[n12]);
                    float f2 = fArray3[n16] * (float)this.dims[n12] - (float)n22;
                    float f3 = fArray4[n17] + (float)(n22 * this.mults[n12]);
                    if (f2 > fArray5[n20]) {
                        f3 += (float)this.mults[n12];
                    }
                    fArray4[n17] = f3;
                    n16 += n4;
                    n17 += n8;
                    if (++n20 >= n19) {
                        n20 = n18;
                    }
                    ++n21;
                }
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getNumBands();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int n9 = rasterAccessor2.getBandOffset(0);
        double[] dArray2 = rasterAccessor2.getDoubleDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dArray2, (double)this.adjustedOffset);
        }
        int n10 = rasterAccessor2.getX() % this.maskWidth;
        int n11 = rasterAccessor2.getY();
        int n12 = 0;
        while (n12 < n2) {
            double[] dArray3 = dArray[n12];
            double[] dArray4 = dArray2;
            float[] fArray = this.maskDataFloat[n12];
            int n13 = nArray[n12];
            int n14 = n9;
            int n15 = 0;
            while (n15 < n6) {
                int n16 = n13;
                int n17 = n14;
                n13 += n3;
                n14 += n7;
                int n18 = (n11 + n15) % this.maskHeight * this.maskWidth;
                int n19 = n18 + this.maskWidth;
                int n20 = n18 + n10;
                int n21 = 0;
                while (n21 < n5) {
                    int n22 = (int)(dArray3[n16] * (double)this.dims[n12]);
                    float f2 = (float)(dArray3[n16] * (double)this.dims[n12] - (double)n22);
                    double d2 = dArray4[n17] + (double)(n22 * this.mults[n12]);
                    if (f2 > fArray[n20]) {
                        d2 += (double)this.mults[n12];
                    }
                    dArray4[n17] = d2;
                    n16 += n4;
                    n17 += n8;
                    if (++n20 >= n19) {
                        n20 = n18;
                    }
                    ++n21;
                }
                ++n15;
            }
            ++n12;
        }
    }

    private class DitherLUT {
        private int[] dimsCache;
        private int[] multsCache;
        private byte[][] maskDataCache;
        public int ditherLUTBandStride;
        public int ditherLUTRowStride;
        public int ditherLUTColStride;
        public byte[] ditherLUT;

        DitherLUT(int[] nArray, int[] nArray2, byte[][] byArray) {
            this.dimsCache = (int[])nArray.clone();
            this.multsCache = (int[])nArray2.clone();
            this.maskDataCache = new byte[byArray.length][];
            int n2 = 0;
            while (n2 < byArray.length) {
                this.maskDataCache[n2] = (byte[])byArray[n2].clone();
                ++n2;
            }
            this.ditherLUTColStride = 256;
            this.ditherLUTRowStride = OrderedDitherOpImage.this.maskWidth * this.ditherLUTColStride;
            this.ditherLUTBandStride = OrderedDitherOpImage.this.maskHeight * this.ditherLUTRowStride;
            this.ditherLUT = new byte[OrderedDitherOpImage.this.numBands * this.ditherLUTBandStride];
            int n3 = 0;
            int n4 = OrderedDitherOpImage.this.maskWidth * OrderedDitherOpImage.this.maskHeight;
            int n5 = 0;
            while (n5 < OrderedDitherOpImage.this.numBands) {
                int n6 = nArray[n5];
                int n7 = nArray2[n5];
                byte[] byArray2 = byArray[n5];
                int n8 = 0;
                int n9 = 0;
                while (n9 < 256) {
                    int n10 = n8;
                    int n11 = n10 & 0xFF;
                    int n12 = n10 >> 8;
                    int n13 = n12 * n7;
                    int n14 = n13 + n7;
                    int n15 = n3 + n9;
                    int n16 = 0;
                    while (n16 < n4) {
                        int n17 = byArray2[n16] & 0xFF;
                        this.ditherLUT[n15] = n11 > n17 ? (byte)(n14 & 0xFF) : (byte)(n13 & 0xFF);
                        n15 += 256;
                        ++n16;
                    }
                    n8 += n6;
                    ++n9;
                }
                n3 += this.ditherLUTBandStride;
                ++n5;
            }
        }

        public boolean equals(int[] nArray, int[] nArray2, byte[][] byArray) {
            if (nArray.length != this.dimsCache.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != this.dimsCache[n2]) {
                    return false;
                }
                ++n2;
            }
            if (nArray2.length != this.multsCache.length) {
                return false;
            }
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (nArray2[n3] != this.multsCache[n3]) {
                    return false;
                }
                ++n3;
            }
            if (byArray.length != OrderedDitherOpImage.this.maskDataByte.length) {
                return false;
            }
            int n4 = 0;
            while (n4 < byArray.length) {
                if (byArray[n4].length != this.maskDataCache[n4].length) {
                    return false;
                }
                byte[] byArray2 = this.maskDataCache[n4];
                byte[] byArray3 = byArray[n4];
                int n5 = 0;
                while (n5 < byArray[n4].length) {
                    if (byArray3[n5] != byArray2[n5]) {
                        return false;
                    }
                    ++n5;
                }
                ++n4;
            }
            return true;
        }
    }
}

