/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

final class PeriodicShiftOpImage
extends OpImage {
    private int[] xTrans;
    private int[] yTrans;
    private TranslateIntOpImage[] images;
    private Rectangle[] bounds;

    public PeriodicShiftOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2, int n3) {
        super(OpImage.vectorize(renderedImage), imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone(), map, false);
        this.xTrans = new int[]{-n2, -n2, this.width - n2, this.width - n2};
        this.yTrans = new int[]{-n3, this.height - n3, -n3, this.height - n3};
        this.images = new TranslateIntOpImage[4];
        int n4 = 0;
        while (n4 < 4) {
            this.images[n4] = new TranslateIntOpImage(renderedImage, null, this.xTrans[n4], this.yTrans[n4]);
            ++n4;
        }
        Rectangle rectangle = this.getBounds();
        this.bounds = new Rectangle[4];
        int n5 = 0;
        while (n5 < 4) {
            this.bounds[n5] = rectangle.intersection(this.images[n5].getBounds());
            ++n5;
        }
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        int n4 = 0;
        while (n4 < 4) {
            Rectangle rectangle3 = rectangle2.intersection(this.bounds[n4]);
            if (!rectangle3.isEmpty()) {
                JDKWorkarounds.setRect(writableRaster, this.images[n4].getData(rectangle3));
            }
            ++n4;
        }
        return writableRaster;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        int n3 = 0;
        while (n3 < 4) {
            Rectangle rectangle3 = rectangle;
            rectangle3.translate(this.xTrans[n3], this.yTrans[n3]);
            Rectangle rectangle4 = rectangle3.intersection(this.getBounds());
            if (!rectangle4.isEmpty()) {
                rectangle2 = rectangle2 == null ? rectangle4 : rectangle2.union(rectangle4);
            }
            ++n3;
        }
        return rectangle2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("PeriodicShiftOpImage0"));
        }
        Rectangle rectangle2 = null;
        int n3 = 0;
        while (n3 < 4) {
            Rectangle rectangle3 = rectangle.intersection(this.bounds[n3]);
            if (!rectangle3.isEmpty()) {
                rectangle3.translate(-this.xTrans[n3], -this.yTrans[n3]);
                rectangle2 = rectangle2 == null ? rectangle3 : rectangle2.union(rectangle3);
            }
            ++n3;
        }
        return rectangle2;
    }
}

