/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class PiecewiseOpImage
extends ColormapOpImage {
    private float[][] abscissas;
    private float[][] slopes;
    private float[][] intercepts;
    private float[] minOrdinates;
    private float[] maxOrdinates;
    private boolean isByteData = false;
    private LookupTableJAI lut;

    private static float binarySearch(float[] fArray, float f2, float f3, float[] fArray2, float[] fArray3, float f4) {
        int n2 = fArray.length - 1;
        if (f4 <= fArray[0]) {
            return f2;
        }
        if (f4 >= fArray[n2]) {
            return f3;
        }
        int n3 = 0;
        int n4 = n2 - n3;
        while (n4 > 1) {
            int n5 = n3 + n4 / 2;
            if (f4 >= fArray[n5]) {
                n3 = n5;
            } else {
                n2 = n5;
            }
            n4 = n2 - n3;
        }
        return fArray2[n3] * f4 + fArray3[n3];
    }

    public PiecewiseOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, float[][][] fArray) {
        super(renderedImage, imageLayout, map, true);
        int n2 = this.sampleModel.getNumBands();
        this.initFields(n2, fArray);
        boolean bl2 = this.isByteData = this.sampleModel.getTransferType() == 0;
        if (this.isByteData) {
            this.createLUT();
            this.unsetFields();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        byte[][] byArray2 = this.lut.getByteData();
        int n2 = 0;
        while (n2 < 3) {
            byte[] byArray3 = byArray[n2];
            byte[] byArray4 = byArray2[n2 >= byArray2.length ? 0 : n2];
            int n3 = byArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                byArray3[n4] = byArray4[byArray3[n4] & 0xFF];
                ++n4;
            }
            ++n2;
        }
    }

    private void initFields(int n2, float[][][] fArray) {
        this.abscissas = new float[n2][];
        this.slopes = new float[n2][];
        this.intercepts = new float[n2][];
        this.minOrdinates = new float[n2];
        this.maxOrdinates = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.abscissas[n3] = fArray.length == 1 ? fArray[0][0] : fArray[n3][0];
            int n4 = this.abscissas[n3].length - 1;
            this.minOrdinates[n3] = fArray.length == 1 ? fArray[0][1][0] : fArray[n3][1][0];
            this.maxOrdinates[n3] = fArray.length == 1 ? fArray[0][1][n4] : fArray[n3][1][n4];
            this.slopes[n3] = new float[n4];
            this.intercepts[n3] = new float[n4];
            float[] fArray2 = this.abscissas[n3];
            float[] fArray3 = fArray.length == 1 ? fArray[0][1] : fArray[n3][1];
            float[] fArray4 = this.slopes[n3];
            float[] fArray5 = this.intercepts[n3];
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n5 + 1;
                fArray4[n5] = (fArray3[n6] - fArray3[n5]) / (fArray2[n6] - fArray2[n5]);
                fArray5[n5] = fArray3[n5] - fArray2[n5] * fArray4[n5];
                ++n5;
            }
            ++n3;
        }
    }

    private void unsetFields() {
        this.abscissas = null;
        this.slopes = null;
        this.intercepts = null;
        this.minOrdinates = null;
        this.maxOrdinates = null;
    }

    private void createLUT() {
        int n2 = this.abscissas.length;
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        while (n3 < n2) {
            byArrayArray[n3] = new byte[256];
            byte[] byArray = byArrayArray[n3];
            float[] fArray = this.abscissas[n3];
            float[] fArray2 = this.slopes[n3];
            float[] fArray3 = this.intercepts[n3];
            float f2 = this.minOrdinates[n3];
            float f3 = this.maxOrdinates[n3];
            int n4 = 0;
            while (n4 < 256) {
                byArray[n4] = ImageUtil.clampRoundByte(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, n4));
                ++n4;
            }
            ++n3;
        }
        this.lut = new LookupTableJAI(byArrayArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        if (this.isByteData) {
            this.computeRectByte(rasterArray, writableRaster, rectangle);
        } else {
            RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
            RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
            switch (rasterAccessor.getDataType()) {
                case 1: {
                    this.computeRectUShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 4: {
                    this.computeRectFloat(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 5: {
                    this.computeRectDouble(rasterAccessor2, rasterAccessor);
                }
            }
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.lut.lookup(rasterArray[0], writableRaster, rectangle);
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            float[] fArray = this.abscissas[n9];
            float[] fArray2 = this.slopes[n9];
            float[] fArray3 = this.intercepts[n9];
            float f2 = this.minOrdinates[n9];
            float f3 = this.maxOrdinates[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    sArray3[n13] = ImageUtil.clampRoundUShort(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, sArray4[n14] & 0xFFFF));
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            float[] fArray = this.abscissas[n9];
            float[] fArray2 = this.slopes[n9];
            float[] fArray3 = this.intercepts[n9];
            float f2 = this.minOrdinates[n9];
            float f3 = this.maxOrdinates[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    sArray3[n13] = ImageUtil.clampRoundShort(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, sArray4[n14]));
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            int[] nArray5 = nArray2[n9];
            int[] nArray6 = nArray4[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            float[] fArray = this.abscissas[n9];
            float[] fArray2 = this.slopes[n9];
            float[] fArray3 = this.intercepts[n9];
            float f2 = this.minOrdinates[n9];
            float f3 = this.maxOrdinates[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    nArray5[n13] = ImageUtil.clampRoundInt(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, nArray6[n14]));
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            float[] fArray5 = this.abscissas[n9];
            float[] fArray6 = this.slopes[n9];
            float[] fArray7 = this.intercepts[n9];
            float f2 = this.minOrdinates[n9];
            float f3 = this.maxOrdinates[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    fArray3[n13] = PiecewiseOpImage.binarySearch(fArray5, f2, f3, fArray6, fArray7, fArray4[n14]);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor2.getWidth();
        int n3 = rasterAccessor2.getHeight();
        int n4 = rasterAccessor2.getNumBands();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n9 = 0;
        while (n9 < n4) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            float[] fArray = this.abscissas[n9];
            float[] fArray2 = this.slopes[n9];
            float[] fArray3 = this.intercepts[n9];
            float f2 = this.minOrdinates[n9];
            float f3 = this.maxOrdinates[n9];
            int n12 = 0;
            while (n12 < n3) {
                int n13 = n10;
                int n14 = n11;
                n10 += n5;
                n11 += n7;
                int n15 = 0;
                while (n15 < n2) {
                    dArray3[n13] = PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, (float)dArray4[n14]);
                    n13 += n6;
                    n14 += n8;
                    ++n15;
                }
                ++n12;
            }
            ++n9;
        }
    }
}

