/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBicubicOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    private int[] tableDataHi = null;
    private int[] tableDataVi = null;
    private float[] tableDataHf = null;
    private float[] tableDataVf = null;
    private double[] tableDataHd = null;
    private double[] tableDataVd = null;
    private int precisionBits;
    private int round;
    private Rational half = new Rational(1L, 2L);
    InterpolationTable interpTable;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBicubicOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f2, f3, f4, f5);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.interpTable = (InterpolationTable)interpolation;
        this.one = 1 << this.subsampleBits;
        this.precisionBits = this.interpTable.getPrecisionBits();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n7];
        int[] nArray4 = new int[n6];
        long l2 = n5;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n4;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n11 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n12 = 0;
        while (n12 < n6) {
            nArray2[n12] = (n11 - n2) * n8;
            nArray4[n12] = (int)((float)l9 / (float)l10 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n11;
                l9 -= l10;
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            nArray[n13] = (n10 - n3) * n9;
            nArray3[n13] = (int)((float)l4 / (float)l5 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n13;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.initTableDataI();
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 2: {
                this.initTableDataI();
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 1: {
                this.initTableDataI();
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 3: {
                this.initTableDataI();
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 4: {
                this.initTableDataF();
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            case 5: {
                this.initTableDataD();
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray4, nArray3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 - n3;
                int n17 = n15 + n3;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 - n2;
                    int n23 = n21 + n2;
                    int n24 = n23 + n2;
                    int n25 = byArray4[n22 + n16] & 0xFF;
                    int n26 = byArray4[n21 + n16] & 0xFF;
                    int n27 = byArray4[n23 + n16] & 0xFF;
                    int n28 = byArray4[n24 + n16] & 0xFF;
                    int n29 = byArray4[n22 + n15] & 0xFF;
                    int n30 = byArray4[n21 + n15] & 0xFF;
                    int n31 = byArray4[n23 + n15] & 0xFF;
                    int n32 = byArray4[n24 + n15] & 0xFF;
                    int n33 = byArray4[n22 + n17] & 0xFF;
                    int n34 = byArray4[n21 + n17] & 0xFF;
                    int n35 = byArray4[n23 + n17] & 0xFF;
                    int n36 = byArray4[n24 + n17] & 0xFF;
                    int n37 = byArray4[n22 + n18] & 0xFF;
                    int n38 = byArray4[n21 + n18] & 0xFF;
                    int n39 = byArray4[n23 + n18] & 0xFF;
                    int n40 = byArray4[n24 + n18] & 0xFF;
                    int n41 = 4 * n20;
                    int n42 = n41 + 1;
                    int n43 = n41 + 2;
                    int n44 = n41 + 3;
                    long l2 = (long)this.tableDataHi[n41] * (long)n25;
                    l2 += (long)this.tableDataHi[n42] * (long)n26;
                    l2 += (long)this.tableDataHi[n43] * (long)n27;
                    l2 += (long)this.tableDataHi[n44] * (long)n28;
                    long l3 = (long)this.tableDataHi[n41] * (long)n29;
                    l3 += (long)this.tableDataHi[n42] * (long)n30;
                    l3 += (long)this.tableDataHi[n43] * (long)n31;
                    l3 += (long)this.tableDataHi[n44] * (long)n32;
                    long l4 = (long)this.tableDataHi[n41] * (long)n33;
                    l4 += (long)this.tableDataHi[n42] * (long)n34;
                    l4 += (long)this.tableDataHi[n43] * (long)n35;
                    l4 += (long)this.tableDataHi[n44] * (long)n36;
                    long l5 = (long)this.tableDataHi[n41] * (long)n37;
                    l5 += (long)this.tableDataHi[n42] * (long)n38;
                    l5 += (long)this.tableDataHi[n43] * (long)n39;
                    l5 += (long)this.tableDataHi[n44] * (long)n40;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n45 = 4 * n14;
                    long l6 = (long)this.tableDataVi[n45] * l2;
                    l6 += (long)this.tableDataVi[n45 + 1] * l3;
                    l6 += (long)this.tableDataVi[n45 + 2] * l4;
                    int n46 = (int)((l6 += (long)this.tableDataVi[n45 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n46 > 255) {
                        n46 = 255;
                    } else if (n46 < 0) {
                        n46 = 0;
                    }
                    byArray3[n13] = (byte)(n46 & 0xFF);
                    n13 += n7;
                    ++n19;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 - n3;
                int n17 = n15 + n3;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 - n2;
                    int n23 = n21 + n2;
                    int n24 = n23 + n2;
                    short s2 = sArray4[n22 + n16];
                    short s3 = sArray4[n21 + n16];
                    short s4 = sArray4[n23 + n16];
                    short s5 = sArray4[n24 + n16];
                    short s6 = sArray4[n22 + n15];
                    short s7 = sArray4[n21 + n15];
                    short s8 = sArray4[n23 + n15];
                    short s9 = sArray4[n24 + n15];
                    short s10 = sArray4[n22 + n17];
                    short s11 = sArray4[n21 + n17];
                    short s12 = sArray4[n23 + n17];
                    short s13 = sArray4[n24 + n17];
                    short s14 = sArray4[n22 + n18];
                    short s15 = sArray4[n21 + n18];
                    short s16 = sArray4[n23 + n18];
                    short s17 = sArray4[n24 + n18];
                    int n25 = 4 * n20;
                    int n26 = n25 + 1;
                    int n27 = n25 + 2;
                    int n28 = n25 + 3;
                    long l2 = (long)this.tableDataHi[n25] * (long)s2;
                    l2 += (long)this.tableDataHi[n26] * (long)s3;
                    l2 += (long)this.tableDataHi[n27] * (long)s4;
                    l2 += (long)this.tableDataHi[n28] * (long)s5;
                    long l3 = (long)this.tableDataHi[n25] * (long)s6;
                    l3 += (long)this.tableDataHi[n26] * (long)s7;
                    l3 += (long)this.tableDataHi[n27] * (long)s8;
                    l3 += (long)this.tableDataHi[n28] * (long)s9;
                    long l4 = (long)this.tableDataHi[n25] * (long)s10;
                    l4 += (long)this.tableDataHi[n26] * (long)s11;
                    l4 += (long)this.tableDataHi[n27] * (long)s12;
                    l4 += (long)this.tableDataHi[n28] * (long)s13;
                    long l5 = (long)this.tableDataHi[n25] * (long)s14;
                    l5 += (long)this.tableDataHi[n26] * (long)s15;
                    l5 += (long)this.tableDataHi[n27] * (long)s16;
                    l5 += (long)this.tableDataHi[n28] * (long)s17;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n29 = 4 * n14;
                    long l6 = (long)this.tableDataVi[n29] * l2;
                    l6 += (long)this.tableDataVi[n29 + 1] * l3;
                    l6 += (long)this.tableDataVi[n29 + 2] * l4;
                    int n30 = (int)((l6 += (long)this.tableDataVi[n29 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n30 > Short.MAX_VALUE) {
                        n30 = Short.MAX_VALUE;
                    } else if (n30 < Short.MIN_VALUE) {
                        n30 = Short.MIN_VALUE;
                    }
                    sArray3[n13] = (short)n30;
                    n13 += n7;
                    ++n19;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 - n3;
                int n17 = n15 + n3;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 - n2;
                    int n23 = n21 + n2;
                    int n24 = n23 + n2;
                    int n25 = sArray4[n22 + n16] & 0xFFFF;
                    int n26 = sArray4[n21 + n16] & 0xFFFF;
                    int n27 = sArray4[n23 + n16] & 0xFFFF;
                    int n28 = sArray4[n24 + n16] & 0xFFFF;
                    int n29 = sArray4[n22 + n15] & 0xFFFF;
                    int n30 = sArray4[n21 + n15] & 0xFFFF;
                    int n31 = sArray4[n23 + n15] & 0xFFFF;
                    int n32 = sArray4[n24 + n15] & 0xFFFF;
                    int n33 = sArray4[n22 + n17] & 0xFFFF;
                    int n34 = sArray4[n21 + n17] & 0xFFFF;
                    int n35 = sArray4[n23 + n17] & 0xFFFF;
                    int n36 = sArray4[n24 + n17] & 0xFFFF;
                    int n37 = sArray4[n22 + n18] & 0xFFFF;
                    int n38 = sArray4[n21 + n18] & 0xFFFF;
                    int n39 = sArray4[n23 + n18] & 0xFFFF;
                    int n40 = sArray4[n24 + n18] & 0xFFFF;
                    int n41 = 4 * n20;
                    int n42 = n41 + 1;
                    int n43 = n41 + 2;
                    int n44 = n41 + 3;
                    long l2 = (long)this.tableDataHi[n41] * (long)n25;
                    l2 += (long)this.tableDataHi[n42] * (long)n26;
                    l2 += (long)this.tableDataHi[n43] * (long)n27;
                    l2 += (long)this.tableDataHi[n44] * (long)n28;
                    long l3 = (long)this.tableDataHi[n41] * (long)n29;
                    l3 += (long)this.tableDataHi[n42] * (long)n30;
                    l3 += (long)this.tableDataHi[n43] * (long)n31;
                    l3 += (long)this.tableDataHi[n44] * (long)n32;
                    long l4 = (long)this.tableDataHi[n41] * (long)n33;
                    l4 += (long)this.tableDataHi[n42] * (long)n34;
                    l4 += (long)this.tableDataHi[n43] * (long)n35;
                    l4 += (long)this.tableDataHi[n44] * (long)n36;
                    long l5 = (long)this.tableDataHi[n41] * (long)n37;
                    l5 += (long)this.tableDataHi[n42] * (long)n38;
                    l5 += (long)this.tableDataHi[n43] * (long)n39;
                    l5 += (long)this.tableDataHi[n44] * (long)n40;
                    l2 = l2 + (long)this.round >> this.precisionBits;
                    l3 = l3 + (long)this.round >> this.precisionBits;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    int n45 = 4 * n14;
                    long l6 = (long)this.tableDataVi[n45] * l2;
                    l6 += (long)this.tableDataVi[n45 + 1] * l3;
                    l6 += (long)this.tableDataVi[n45 + 2] * l4;
                    int n46 = (int)((l6 += (long)this.tableDataVi[n45 + 3] * l5) + (long)this.round >> this.precisionBits);
                    if (n46 > 65536) {
                        n46 = 65536;
                    } else if (n46 < 0) {
                        n46 = 0;
                    }
                    sArray3[n13] = (short)(n46 & 0xFFFF);
                    n13 += n7;
                    ++n19;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray9 = nArray5[n9];
            int[] nArray10 = nArray7[n9];
            int n10 = nArray6[n9];
            int n11 = nArray8[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                long l2 = nArray4[n12];
                int n14 = nArray2[n12] + n11;
                int n15 = n14 - n3;
                int n16 = n14 + n3;
                int n17 = n16 + n3;
                int n18 = 0;
                while (n18 < n4) {
                    int n19;
                    long l3 = nArray3[n18];
                    int n20 = nArray[n18];
                    int n21 = n20 - n2;
                    int n22 = n20 + n2;
                    int n23 = n22 + n2;
                    int n24 = nArray10[n21 + n15];
                    int n25 = nArray10[n20 + n15];
                    int n26 = nArray10[n22 + n15];
                    int n27 = nArray10[n23 + n15];
                    int n28 = nArray10[n21 + n14];
                    int n29 = nArray10[n20 + n14];
                    int n30 = nArray10[n22 + n14];
                    int n31 = nArray10[n23 + n14];
                    int n32 = nArray10[n21 + n16];
                    int n33 = nArray10[n20 + n16];
                    int n34 = nArray10[n22 + n16];
                    int n35 = nArray10[n23 + n16];
                    int n36 = nArray10[n21 + n17];
                    int n37 = nArray10[n20 + n17];
                    int n38 = nArray10[n22 + n17];
                    int n39 = nArray10[n23 + n17];
                    int n40 = (int)(4L * l3);
                    int n41 = n40 + 1;
                    int n42 = n40 + 2;
                    int n43 = n40 + 3;
                    long l4 = (long)this.tableDataHi[n40] * (long)n24;
                    l4 += (long)this.tableDataHi[n41] * (long)n25;
                    l4 += (long)this.tableDataHi[n42] * (long)n26;
                    l4 += (long)this.tableDataHi[n43] * (long)n27;
                    long l5 = (long)this.tableDataHi[n40] * (long)n28;
                    l5 += (long)this.tableDataHi[n41] * (long)n29;
                    l5 += (long)this.tableDataHi[n42] * (long)n30;
                    l5 += (long)this.tableDataHi[n43] * (long)n31;
                    long l6 = (long)this.tableDataHi[n40] * (long)n32;
                    l6 += (long)this.tableDataHi[n41] * (long)n33;
                    l6 += (long)this.tableDataHi[n42] * (long)n34;
                    l6 += (long)this.tableDataHi[n43] * (long)n35;
                    long l7 = (long)this.tableDataHi[n40] * (long)n36;
                    l7 += (long)this.tableDataHi[n41] * (long)n37;
                    l7 += (long)this.tableDataHi[n42] * (long)n38;
                    l7 += (long)this.tableDataHi[n43] * (long)n39;
                    l4 = l4 + (long)this.round >> this.precisionBits;
                    l5 = l5 + (long)this.round >> this.precisionBits;
                    l6 = l6 + (long)this.round >> this.precisionBits;
                    l7 = l7 + (long)this.round >> this.precisionBits;
                    int n44 = (int)(4L * l2);
                    long l8 = (long)this.tableDataVi[n44] * l4;
                    l8 += (long)this.tableDataVi[n44 + 1] * l5;
                    l8 += (long)this.tableDataVi[n44 + 2] * l6;
                    nArray9[n13] = n19 = (int)((l8 += (long)this.tableDataVi[n44 + 3] * l7) + (long)this.round >> this.precisionBits);
                    n13 += n7;
                    ++n18;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 - n3;
                int n17 = n15 + n3;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 - n2;
                    int n23 = n21 + n2;
                    int n24 = n23 + n2;
                    float f2 = fArray4[n22 + n16];
                    float f3 = fArray4[n21 + n16];
                    float f4 = fArray4[n23 + n16];
                    float f5 = fArray4[n24 + n16];
                    float f6 = fArray4[n22 + n15];
                    float f7 = fArray4[n21 + n15];
                    float f8 = fArray4[n23 + n15];
                    float f9 = fArray4[n24 + n15];
                    float f10 = fArray4[n22 + n17];
                    float f11 = fArray4[n21 + n17];
                    float f12 = fArray4[n23 + n17];
                    float f13 = fArray4[n24 + n17];
                    float f14 = fArray4[n22 + n18];
                    float f15 = fArray4[n21 + n18];
                    float f16 = fArray4[n23 + n18];
                    float f17 = fArray4[n24 + n18];
                    int n25 = 4 * n20;
                    int n26 = n25 + 1;
                    int n27 = n25 + 2;
                    int n28 = n25 + 3;
                    double d2 = this.tableDataHf[n25] * f2;
                    d2 += (double)(this.tableDataHf[n26] * f3);
                    d2 += (double)(this.tableDataHf[n27] * f4);
                    d2 += (double)(this.tableDataHf[n28] * f5);
                    double d3 = this.tableDataHf[n25] * f6;
                    d3 += (double)(this.tableDataHf[n26] * f7);
                    d3 += (double)(this.tableDataHf[n27] * f8);
                    d3 += (double)(this.tableDataHf[n28] * f9);
                    double d4 = this.tableDataHf[n25] * f10;
                    d4 += (double)(this.tableDataHf[n26] * f11);
                    d4 += (double)(this.tableDataHf[n27] * f12);
                    d4 += (double)(this.tableDataHf[n28] * f13);
                    double d5 = this.tableDataHf[n25] * f14;
                    d5 += (double)(this.tableDataHf[n26] * f15);
                    d5 += (double)(this.tableDataHf[n27] * f16);
                    d5 += (double)(this.tableDataHf[n28] * f17);
                    int n29 = 4 * n14;
                    double d6 = (double)this.tableDataVf[n29] * d2;
                    d6 += (double)this.tableDataVf[n29 + 1] * d3;
                    d6 += (double)this.tableDataVf[n29 + 2] * d4;
                    if ((d6 += (double)this.tableDataVf[n29 + 3] * d5) > 3.4028234663852886E38) {
                        d6 = 3.4028234663852886E38;
                    } else if (d6 < -3.4028234663852886E38) {
                        d6 = -3.4028234663852886E38;
                    }
                    fArray3[n13] = (float)d6;
                    n13 += n7;
                    ++n19;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n9 = 0;
        while (n9 < n6) {
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = n15 - n3;
                int n17 = n15 + n3;
                int n18 = n17 + n3;
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = nArray3[n19];
                    int n21 = nArray[n19];
                    int n22 = n21 - n2;
                    int n23 = n21 + n2;
                    int n24 = n23 + n2;
                    double d2 = dArray4[n22 + n16];
                    double d3 = dArray4[n21 + n16];
                    double d4 = dArray4[n23 + n16];
                    double d5 = dArray4[n24 + n16];
                    double d6 = dArray4[n22 + n15];
                    double d7 = dArray4[n21 + n15];
                    double d8 = dArray4[n23 + n15];
                    double d9 = dArray4[n24 + n15];
                    double d10 = dArray4[n22 + n17];
                    double d11 = dArray4[n21 + n17];
                    double d12 = dArray4[n23 + n17];
                    double d13 = dArray4[n24 + n17];
                    double d14 = dArray4[n22 + n18];
                    double d15 = dArray4[n21 + n18];
                    double d16 = dArray4[n23 + n18];
                    double d17 = dArray4[n24 + n18];
                    int n25 = 4 * n20;
                    int n26 = n25 + 1;
                    int n27 = n25 + 2;
                    int n28 = n25 + 3;
                    double d18 = this.tableDataHd[n25] * d2;
                    d18 += this.tableDataHd[n26] * d3;
                    d18 += this.tableDataHd[n27] * d4;
                    d18 += this.tableDataHd[n28] * d5;
                    double d19 = this.tableDataHd[n25] * d6;
                    d19 += this.tableDataHd[n26] * d7;
                    d19 += this.tableDataHd[n27] * d8;
                    d19 += this.tableDataHd[n28] * d9;
                    double d20 = this.tableDataHd[n25] * d10;
                    d20 += this.tableDataHd[n26] * d11;
                    d20 += this.tableDataHd[n27] * d12;
                    d20 += this.tableDataHd[n28] * d13;
                    double d21 = this.tableDataHd[n25] * d14;
                    d21 += this.tableDataHd[n26] * d15;
                    d21 += this.tableDataHd[n27] * d16;
                    int n29 = 4 * n14;
                    double d22 = this.tableDataVd[n29] * d18;
                    d22 += this.tableDataVd[n29 + 1] * d19;
                    d22 += this.tableDataVd[n29 + 2] * d20;
                    dArray3[n13] = d22 += this.tableDataVd[n29 + 3] * (d21 += this.tableDataHd[n28] * d17);
                    n13 += n7;
                    ++n19;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private synchronized void initTableDataI() {
        if (this.tableDataHi == null || this.tableDataVi == null) {
            this.tableDataHi = this.interpTable.getHorizontalTableData();
            this.tableDataVi = this.interpTable.getVerticalTableData();
        }
    }

    private synchronized void initTableDataF() {
        if (this.tableDataHf == null || this.tableDataVf == null) {
            this.tableDataHf = this.interpTable.getHorizontalTableDataFloat();
            this.tableDataVf = this.interpTable.getVerticalTableDataFloat();
        }
    }

    private synchronized void initTableDataD() {
        if (this.tableDataHd == null || this.tableDataVd == null) {
            this.tableDataHd = this.interpTable.getHorizontalTableDataDouble();
            this.tableDataVd = this.interpTable.getVerticalTableDataDouble();
        }
    }
}

