/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleGeneralOpImage
extends ScaleOpImage {
    private int subsampleBits;
    private int one;
    Rational half = new Rational(1L, 2L);
    private int interp_width;
    private int interp_height;
    private int interp_left;
    private int interp_top;
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f2, f3, f4, f5);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.interp_width = interpolation.getWidth();
        this.interp_height = interpolation.getHeight();
        this.interp_left = interpolation.getLeftPadding();
        this.interp_top = interpolation.getTopPadding();
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n2];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n3];
                nArray3 = new int[n2];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n4, n5, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n3];
                fArray = new float[n2];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n4, n5, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l2 = n9;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n8;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n11 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n12 = 0;
        while (n12 < n6) {
            nArray[n12] = (n11 - n2) * n4;
            nArray3[n12] = (int)((float)l9 / (float)l10 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n11;
                l9 -= l10;
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            nArray2[n13] = (n10 - n3) * n5;
            nArray4[n13] = (int)((float)l4 / (float)l5 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n13;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l2 = n9;
        long l3 = 1L;
        l2 = l2 * this.transYRationalDenom - this.transYRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transYRationalDenom);
        l3 *= 2L;
        l2 *= this.invScaleYRationalNum;
        l2 = 2L * l2 - (l3 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l2, l3 *= 2L);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleYRationalDenom;
        l4 *= this.invScaleYRationalDenom;
        long l6 = this.invScaleYFrac * l3;
        long l7 = n8;
        long l8 = 1L;
        l7 = l7 * this.transXRationalDenom - this.transXRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transXRationalDenom);
        l8 *= 2L;
        l7 *= this.invScaleXRationalNum;
        l7 = 2L * l7 - (l8 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l7, l8 *= 2L);
        long l9 = l7 % l8;
        if (n11 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleXRationalDenom;
        l9 *= this.invScaleXRationalDenom;
        long l11 = this.invScaleXFrac * l8;
        int n12 = 0;
        while (n12 < n6) {
            nArray[n12] = (n11 - n2) * n4;
            fArray[n12] = (float)l9 / (float)l10;
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l9 += l11) >= l10) {
                ++n11;
                l9 -= l10;
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            nArray2[n13] = (n10 - n3) * n5;
            fArray2[n13] = (float)l4 / (float)l5;
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n13;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = 0;
                while (n16 < n4) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = this.interp_left * n2 + this.interp_top * n3;
                    n19 = n18 + n15 - n19;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < this.interp_height) {
                        int n23 = n19;
                        int n24 = 0;
                        while (n24 < this.interp_width) {
                            nArray7[n21][n20++] = byArray4[n19] & 0xFF;
                            n19 += n2;
                            ++n24;
                        }
                        ++n21;
                        n20 = 0;
                        n19 = n23 + n3;
                        ++n22;
                    }
                    int n25 = this.interp.interpolate(nArray7, n17, n14);
                    if (n25 > 255) {
                        n25 = 255;
                    } else if (n25 < 0) {
                        n25 = 0;
                    }
                    byArray3[n13] = (byte)(n25 & 0xFF);
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = 0;
                while (n16 < n4) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = this.interp_left * n2 + this.interp_top * n3;
                    n19 = n18 + n15 - n19;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < this.interp_height) {
                        int n23 = n19;
                        int n24 = 0;
                        while (n24 < this.interp_width) {
                            nArray7[n21][n20++] = sArray4[n19];
                            n19 += n2;
                            ++n24;
                        }
                        ++n21;
                        n20 = 0;
                        n19 = n23 + n3;
                        ++n22;
                    }
                    int n25 = this.interp.interpolate(nArray7, n17, n14);
                    if (n25 > Short.MAX_VALUE) {
                        n25 = Short.MAX_VALUE;
                    } else if (n25 < Short.MIN_VALUE) {
                        n25 = Short.MIN_VALUE;
                    }
                    sArray3[n13] = (short)n25;
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int[][] nArray7 = new int[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray5[n9];
            int n11 = nArray6[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = 0;
                while (n16 < n4) {
                    int n17 = nArray3[n16];
                    int n18 = nArray[n16];
                    int n19 = this.interp_left * n2 + this.interp_top * n3;
                    n19 = n18 + n15 - n19;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < this.interp_height) {
                        int n23 = n19;
                        int n24 = 0;
                        while (n24 < this.interp_width) {
                            nArray7[n21][n20++] = sArray4[n19] & 0xFFFF;
                            n19 += n2;
                            ++n24;
                        }
                        ++n21;
                        n20 = 0;
                        n19 = n23 + n3;
                        ++n22;
                    }
                    int n25 = this.interp.interpolate(nArray7, n17, n14);
                    if (n25 > 65536) {
                        n25 = 65536;
                    } else if (n25 < 0) {
                        n25 = 0;
                    }
                    sArray3[n13] = (short)(n25 & 0xFFFF);
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int[][] nArray9 = new int[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray10 = nArray5[n9];
            int[] nArray11 = nArray7[n9];
            int n10 = nArray6[n9];
            int n11 = nArray8[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                int n14 = nArray4[n12];
                int n15 = nArray2[n12] + n11;
                int n16 = 0;
                while (n16 < n4) {
                    int n17;
                    int n18 = nArray3[n16];
                    int n19 = nArray[n16];
                    int n20 = this.interp_left * n2 + this.interp_top * n3;
                    n20 = n19 + n15 - n20;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    while (n23 < this.interp_height) {
                        int n24 = n20;
                        int n25 = 0;
                        while (n25 < this.interp_width) {
                            nArray9[n22][n21++] = nArray11[n20];
                            n20 += n2;
                            ++n25;
                        }
                        ++n22;
                        n21 = 0;
                        n20 = n24 + n3;
                        ++n23;
                    }
                    nArray10[n13] = n17 = this.interp.interpolate(nArray9, n18, n14);
                    n13 += n7;
                    ++n16;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        float[][] fArray5 = new float[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            float[] fArray6 = fArray3[n9];
            float[] fArray7 = fArray4[n9];
            int n10 = nArray3[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                float f2 = fArray2[n12];
                int n14 = nArray2[n12] + n11;
                int n15 = 0;
                while (n15 < n4) {
                    float f3 = fArray[n15];
                    int n16 = nArray[n15];
                    int n17 = this.interp_left * n2 + this.interp_top * n3;
                    n17 = n16 + n14 - n17;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < this.interp_height) {
                        int n21 = n17;
                        int n22 = 0;
                        while (n22 < this.interp_width) {
                            fArray5[n19][n18++] = fArray7[n17];
                            n17 += n2;
                            ++n22;
                        }
                        ++n19;
                        n18 = 0;
                        n17 = n21 + n3;
                        ++n20;
                    }
                    float f4 = this.interp.interpolate(fArray5, f3, f2);
                    if (f4 > Float.MAX_VALUE) {
                        f4 = Float.MAX_VALUE;
                    } else if (f4 < -3.4028235E38f) {
                        f4 = -3.4028235E38f;
                    }
                    fArray6[n13] = f4;
                    n13 += n7;
                    ++n15;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        double[][] dArray3 = new double[this.interp_height][this.interp_width];
        int n9 = 0;
        while (n9 < n6) {
            double[] dArray4 = dArray[n9];
            double[] dArray5 = dArray2[n9];
            int n10 = nArray3[n9];
            int n11 = nArray4[n9];
            int n12 = 0;
            while (n12 < n5) {
                int n13 = n10;
                float f2 = fArray2[n12];
                int n14 = nArray2[n12] + n11;
                int n15 = 0;
                while (n15 < n4) {
                    double d2;
                    float f3 = fArray[n15];
                    int n16 = nArray[n15];
                    int n17 = this.interp_left * n2 + this.interp_top * n3;
                    n17 = n16 + n14 - n17;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    while (n20 < this.interp_height) {
                        int n21 = n17;
                        int n22 = 0;
                        while (n22 < this.interp_width) {
                            dArray3[n19][n18++] = dArray5[n17];
                            n17 += n2;
                            ++n22;
                        }
                        ++n19;
                        n18 = 0;
                        n17 = n21 + n3;
                        ++n20;
                    }
                    dArray4[n13] = d2 = this.interp.interpolate(dArray3, f3, f2);
                    n13 += n7;
                    ++n15;
                }
                n10 += n8;
                ++n12;
            }
            ++n9;
        }
    }
}

