/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleNearestOpImage
extends ScaleOpImage {
    long invScaleXInt;
    long invScaleXFrac;
    long invScaleYInt;
    long invScaleYFrac;

    public ScaleNearestOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f2, f3, f4, f5);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int[] nArray = new int[n8];
        long l2 = n6;
        long l3 = 1L;
        l2 = l2 * this.transXRationalDenom - this.transXRationalNum * l3;
        l2 = 2L * l2 + (l3 *= this.transXRationalDenom);
        l3 *= 2L;
        int n10 = Rational.floor(l2 *= this.invScaleXRationalNum, l3 *= this.invScaleXRationalDenom);
        long l4 = l2 % l3;
        if (n10 < 0) {
            l4 = l3 + l4;
        }
        long l5 = l3 * this.invScaleXRationalDenom;
        l4 *= this.invScaleXRationalDenom;
        long l6 = this.invScaleXFrac * l3;
        int n11 = 0;
        while (n11 < n8) {
            nArray[n11] = (n10 - n2) * n5;
            n10 = (int)((long)n10 + this.invScaleXInt);
            if ((l4 += l6) >= l5) {
                ++n10;
                l4 -= l5;
            }
            ++n11;
        }
        int[] nArray2 = new int[n9];
        long l7 = n7;
        long l8 = 1L;
        l7 = l7 * this.transYRationalDenom - this.transYRationalNum * l8;
        l7 = 2L * l7 + (l8 *= this.transYRationalDenom);
        l8 *= 2L;
        int n12 = Rational.floor(l7 *= this.invScaleYRationalNum, l8 *= this.invScaleYRationalDenom);
        long l9 = l7 % l8;
        if (n12 < 0) {
            l9 = l8 + l9;
        }
        long l10 = l8 * this.invScaleYRationalDenom;
        l9 *= this.invScaleYRationalDenom;
        long l11 = this.invScaleYFrac * l8;
        int n13 = 0;
        while (n13 < n9) {
            nArray2[n13] = (n12 - n3) * n4;
            n12 = (int)((long)n12 + this.invScaleYInt);
            if ((l9 += l11) >= l10) {
                ++n12;
                l9 -= l10;
            }
            ++n13;
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray, nArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getNumBands();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n6) {
            byte[] byArray3 = byArray[n7];
            byte[] byArray4 = byArray2[n7];
            int n8 = nArray4[n7];
            int n9 = nArray3[n7];
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n9;
                int n12 = nArray2[n10] + n8;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n14 + n12;
                    byArray3[n11] = byArray4[n15];
                    n11 += n4;
                    ++n13;
                }
                n9 += n5;
                ++n10;
            }
            ++n7;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int n6 = rasterAccessor2.getNumBands();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n6) {
            short[] sArray3 = sArray[n7];
            short[] sArray4 = sArray2[n7];
            int n8 = nArray4[n7];
            int n9 = nArray3[n7];
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n9;
                int n12 = nArray2[n10] + n8;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n14 + n12;
                    sArray3[n11] = sArray4[n15];
                    n11 += n4;
                    ++n13;
                }
                n9 += n5;
                ++n10;
            }
            ++n7;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rasterAccessor2.getNumBands();
        int[][] nArray3 = rasterAccessor2.getIntDataArrays();
        int[] nArray4 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray5 = rasterAccessor.getBandOffsets();
        int[][] nArray6 = rasterAccessor.getIntDataArrays();
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n4) {
            int[] nArray7 = nArray3[n7];
            int[] nArray8 = nArray6[n7];
            int n8 = nArray5[n7];
            int n9 = nArray4[n7];
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n9;
                int n12 = nArray2[n10] + n8;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n14 + n12;
                    nArray7[n11] = nArray8[n15];
                    n11 += n5;
                    ++n13;
                }
                n9 += n6;
                ++n10;
            }
            ++n7;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n4) {
            float[] fArray3 = fArray[n7];
            float[] fArray4 = fArray2[n7];
            int n8 = nArray4[n7];
            int n9 = nArray3[n7];
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n9;
                int n12 = nArray2[n10] + n8;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n14 + n12;
                    fArray3[n11] = fArray4[n15];
                    n11 += n5;
                    ++n13;
                }
                n9 += n6;
                ++n10;
            }
            ++n7;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2) {
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int n4 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n4) {
            double[] dArray3 = dArray[n7];
            double[] dArray4 = dArray2[n7];
            int n8 = nArray4[n7];
            int n9 = nArray3[n7];
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n9;
                int n12 = nArray2[n10] + n8;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n14 + n12;
                    dArray3[n11] = dArray4[n15];
                    n11 += n5;
                    ++n13;
                }
                n9 += n6;
                ++n10;
            }
            ++n7;
        }
    }
}

