/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.OperationRegistry;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class StreamRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderingHints);
        SeekableStream seekableStream = (SeekableStream)parameterBlock.getObjectParameter(0);
        try {
            seekableStream.seek(0L);
        }
        catch (IOException iOException) {
            imagingListener.errorOccurred(JaiI18N.getString("StreamRIF0"), iOException, this, false);
            return null;
        }
        ImageDecodeParam imageDecodeParam = null;
        if (parameterBlock.getNumParameters() > 1) {
            imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
        }
        String[] stringArray = ImageCodec.getDecoderNames(seekableStream);
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        int n2 = 2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (renderingHints != null) {
            RenderingHints.Key key = JAI.KEY_OPERATION_REGISTRY;
            if (renderingHints.containsKey(key)) {
                operationRegistry = (OperationRegistry)renderingHints.get(key);
            }
            if (renderingHints.containsKey(key = JAI.KEY_OPERATION_BOUND)) {
                n2 = (Integer)renderingHints.get(key);
            }
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            RenderedImage renderedImage;
            RenderedImageFactory renderedImageFactory = null;
            try {
                renderedImageFactory = RIFRegistry.get(operationRegistry, stringArray[n3]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (renderedImageFactory != null && (renderedImage = RIFRegistry.create(operationRegistry, stringArray[n3], parameterBlock, renderingHints)) != null) {
                return renderedImage;
            }
            ++n3;
        }
        boolean bl2 = seekableStream.canSeekBackwards();
        long l2 = Long.MIN_VALUE;
        if (bl2) {
            try {
                l2 = seekableStream.getFilePointer();
            }
            catch (IOException iOException) {
                imagingListener.errorOccurred(JaiI18N.getString("StreamRIF1"), iOException, this, false);
                bl2 = false;
            }
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder(stringArray[n4], seekableStream, imageDecodeParam);
            RenderedImage renderedImage = null;
            try {
                renderedImage = imageDecoder.decodeAsRenderedImage();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Object object;
                if (bl2) {
                    object = RIFUtil.getTileCacheHint(renderingHints);
                    if (object != null) {
                        object.flush();
                    }
                    System.gc();
                    try {
                        seekableStream.seek(l2);
                        renderedImage = imageDecoder.decodeAsRenderedImage();
                    }
                    catch (IOException iOException) {
                        imagingListener.errorOccurred(JaiI18N.getString("StreamRIF2"), iOException, this, false);
                        renderedImage = null;
                    }
                } else {
                    object = JaiI18N.getString("CodecRIFUtil0");
                    imagingListener.errorOccurred((String)object, new ImagingException((String)object, outOfMemoryError), this, false);
                }
            }
            catch (IOException iOException) {
                imagingListener.errorOccurred(JaiI18N.getString("StreamRIF2"), iOException, this, false);
                renderedImage = null;
            }
            if (renderedImage != null) {
                return new NullOpImage(renderedImage, imageLayout, (Map)renderingHints, n2);
            }
            ++n4;
        }
        return null;
    }
}

