/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.SubsampleBinaryToGrayOpImage;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

class SubsampleBinaryToGray4x4OpImage
extends GeometricOpImage {
    private int blockX = 4;
    private int blockY = 4;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private int[] lut;
    private byte[] lutGray;

    public SubsampleBinaryToGray4x4OpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map) {
        super(OpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, 0.25f, 0.25f, imageLayout, map), map, true, null, null, null);
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        this.blockY = 4;
        this.blockX = 4;
        this.dWidth = n2 / this.blockX;
        this.dHeight = n3 / this.blockY;
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(this.dWidth, this.dHeight);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * 4.0, point2D.getY() * 4.0);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / 4.0, point2D.getY() / 4.0);
        return point2D2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = n3 / this.blockX;
        int n6 = n4 / this.blockY;
        int n7 = rectangle.x + rectangle.width - 1;
        int n8 = rectangle.y + rectangle.height - 1;
        int n9 = n7 / this.blockX;
        int n10 = n8 / this.blockY;
        return new Rectangle(n5, n6, n9 - n5 + 1, n10 - n6 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x * this.blockX;
        int n4 = rectangle.y * this.blockY;
        int n5 = (rectangle.x + rectangle.width - 1) * this.blockX;
        int n6 = (rectangle.y + rectangle.height - 1) * this.blockY;
        return new Rectangle(n3, n4, n5 - n3 + this.blockX, n6 - n4 + this.blockY);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop4x4(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop4x4(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        if (packedImageData.bitOffset % 4 != 0) {
            this.byteLoop(raster, writableRaster, rectangle);
            return;
        }
        byte[] byArray = packedImageData.data;
        int n2 = packedImageData.offset;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        int n7 = packedImageData.rect.x;
        int n8 = packedImageData.rect.y;
        int n9 = packedImageData.bitOffset;
        int n10 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n14 = dataBufferByte.getOffset();
        int[] nArray = new int[2];
        int n15 = 0;
        while (n15 < n6) {
            int n16 = n4 + n15 << 2;
            int n17 = (n16 - n8) * n10 + n2;
            int n18 = (n15 + n4 - n12) * n13 + n14;
            n18 += n3 - n11;
            int n19 = (n3 << 2) - n7 + n9;
            int n20 = 0;
            while (n20 < n5) {
                int n21 = n19 >> 3;
                int n22 = n19 % 8;
                int n23 = n17 + n21;
                nArray[1] = 0;
                nArray[0] = 0;
                int n24 = 0;
                while (n24 < 4) {
                    int n25 = 0xFF & byArray[n23];
                    nArray[1] = nArray[1] + this.lut[n25 & 0xF];
                    nArray[0] = nArray[0] + this.lut[n25 >> 4];
                    ++n24;
                    n23 += n10;
                }
                n22 >>= 2;
                while (n22 < 2 && n20 < n5) {
                    byArray2[n18 + n20] = this.lutGray[nArray[n22]];
                    ++n22;
                    ++n20;
                    n19 += this.blockX;
                }
            }
            ++n15;
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n2;
        int n3;
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n4 = packedImageData.offset;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = packedImageData.rect.x;
        int n10 = packedImageData.rect.y;
        int n11 = packedImageData.bitOffset;
        int n12 = packedImageData.lineStride;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n13 = writableRaster.getSampleModelTranslateX();
        int n14 = writableRaster.getSampleModelTranslateY();
        int n15 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n16 = dataBufferByte.getOffset();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        int n17 = 0;
        while (n17 < n7) {
            n3 = this.xValues[n5 + n17];
            n2 = n11 + (n3 - n9);
            nArray[n17] = n2 >> 3;
            nArray2[n17] = n2 % 8;
            ++n17;
        }
        n3 = 0;
        while (n3 < n8) {
            int n18;
            int n19;
            n2 = 0;
            while (n2 < n7) {
                nArray3[n2] = 0;
                ++n2;
            }
            int n20 = this.yValues[n6 + n3];
            while (n20 < this.yValues[n6 + n3] + this.blockY) {
                n19 = (n20 - n10) * n12 + n4;
                int n21 = 0;
                while (n21 < n7) {
                    n18 = 0;
                    int n22 = nArray2[n21] + this.blockX - 1;
                    int n23 = nArray[n21] + (n22 >> 3);
                    n22 %= 8;
                    int n24 = 0xFF & byArray[n19 + nArray[n21]];
                    int n25 = 24 + nArray2[n21];
                    if (nArray[n21] == n23) {
                        n24 <<= n25;
                        n18 += this.lut[n24 >>>= 31 - n22 + nArray2[n21]];
                    } else {
                        n24 <<= n25;
                        n18 += this.lut[n24 >>>= n25];
                        int n26 = nArray[n21] + 1;
                        while (n26 < n23) {
                            n24 = 0xFF & byArray[n19 + n26];
                            n18 += this.lut[n24];
                            ++n26;
                        }
                        n24 = 0xFF & byArray[n19 + n23];
                        n18 += this.lut[n24 >>>= 7 - n22];
                    }
                    int n27 = n21++;
                    nArray3[n27] = nArray3[n27] + n18;
                }
                ++n20;
            }
            n19 = (n3 + n6 - n14) * n15 + n16;
            n19 += n5 - n13;
            n18 = 0;
            while (n18 < n7) {
                byArray2[n19 + n18] = this.lutGray[nArray3[n18]];
                ++n18;
            }
            ++n3;
        }
    }

    private final void buildLookupTables() {
        int n2;
        this.lut = new int[16];
        this.lut[0] = 0;
        this.lut[1] = 1;
        this.lut[2] = 1;
        this.lut[3] = 2;
        this.lut[4] = 1;
        this.lut[5] = 2;
        this.lut[6] = 2;
        this.lut[7] = 3;
        int n3 = 8;
        while (n3 < 16) {
            this.lut[n3] = 1 + this.lut[n3 - 8];
            ++n3;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        int n4 = 0;
        while (n4 < this.lutGray.length) {
            n2 = Math.round(255.0f * (float)n4 / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n4] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n4;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n2 = 0;
            while (n2 < this.lutGray.length) {
                this.lutGray[n2] = (byte)(255 - (0xFF & this.lutGray[n2]));
                ++n2;
            }
        }
    }

    private void computeXYValues(int n2, int n3) {
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[n2];
            this.yValues = new int[n3];
        }
        int n4 = 0;
        while (n4 < n2) {
            this.xValues[n4] = n4 << 2;
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            this.yValues[n5] = n5 << 2;
            ++n5;
        }
    }
}

