/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.PackedImageData;
import javax.media.jai.PixelAccessor;

public class SubsampleBinaryToGrayOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float invScaleX;
    protected float invScaleY;
    private float floatTol;
    private int blockX;
    private int blockY;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private int[] lut = new int[256];
    protected byte[] lutGray;

    static ImageLayout layoutHelper(RenderedImage renderedImage, float f2, float f3, ImageLayout imageLayout, Map map) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        float f4 = f2 * (float)n2;
        float f5 = f3 * (float)n3;
        float f6 = 0.1f * Math.min(f2 / (f4 + 1.0f), f3 / (f5 + 1.0f));
        int n4 = (int)f4;
        int n5 = (int)f5;
        if (Math.abs((float)Math.round(f4) - f4) < f6) {
            n4 = Math.round(f4);
        }
        if (Math.abs((float)Math.round(f5) - f5) < f6) {
            n5 = Math.round(f5);
        }
        imageLayout2.setMinX((int)(f2 * (float)renderedImage.getMinX()));
        imageLayout2.setMinY((int)(f3 * (float)renderedImage.getMinY()));
        imageLayout2.setWidth(n4);
        imageLayout2.setHeight(n5);
        SampleModel sampleModel = imageLayout2.getSampleModel(null);
        if (sampleModel == null || sampleModel.getDataType() != 0 || !(sampleModel instanceof PixelInterleavedSampleModel) && (!(sampleModel instanceof SinglePixelPackedSampleModel) || sampleModel.getNumBands() != 1)) {
            sampleModel = new PixelInterleavedSampleModel(0, 1, 1, 1, 1, new int[]{0});
        }
        imageLayout2.setSampleModel(sampleModel);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public SubsampleBinaryToGrayOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, float f2, float f3) {
        super(OpImage.vectorize(renderedImage), SubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, f2, f3, imageLayout, map), SubsampleBinaryToGrayOpImage.configHelper(map), true, null, null, null);
        this.scaleX = f2;
        this.scaleY = f3;
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        this.computeDestInfo(n4, n5);
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(n4, n5, n2, n3);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() / (double)this.scaleX, point2D.getY() / (double)this.scaleY);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(point2D.getX() * (double)this.scaleX, point2D.getY() * (double)this.scaleY);
        return point2D2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = rectangle.x - this.blockX + 1;
        int n4 = rectangle.y - this.blockY + 1;
        n3 = n3 < 0 ? 0 : n3;
        n4 = n4 < 0 ? 0 : n4;
        int n5 = (int)((float)n3 * this.scaleX);
        int n6 = (int)((float)n4 * this.scaleY);
        while (this.xValues[n5] > n3 && n5 > 0) {
            --n5;
        }
        while (this.yValues[n6] > n4 && n6 > 0) {
            --n6;
        }
        int n7 = rectangle.x + rectangle.width - 1;
        int n8 = rectangle.y + rectangle.height - 1;
        int n9 = Math.round((float)n7 * this.scaleX);
        int n10 = Math.round((float)n8 * this.scaleY);
        n9 = n9 >= this.dWidth ? this.dWidth - 1 : n9;
        n10 = n10 >= this.dHeight ? this.dHeight - 1 : n10;
        while (this.xValues[n9] < n7 && n9 < this.dWidth - 1) {
            ++n9;
        }
        while (this.yValues[n10] < n8 && n10 < this.dHeight - 1) {
            ++n10;
        }
        return new Rectangle(n5 += this.minX, n6 += this.minY, (n9 += this.minX) - n5 + 1, (n10 += this.minY) - n6 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = this.xValues[rectangle.x - this.minX];
        int n4 = this.yValues[rectangle.y - this.minY];
        int n5 = this.xValues[rectangle.x - this.minX + rectangle.width - 1];
        int n6 = this.yValues[rectangle.y - this.minY + rectangle.height - 1];
        return new Rectangle(n3, n4, n5 - n3 + this.blockX, n6 - n4 + this.blockY);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SubsampleBinaryToGrayOpImage0"));
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n2;
        int n3;
        PixelAccessor pixelAccessor = new PixelAccessor(raster.getSampleModel(), null);
        PackedImageData packedImageData = pixelAccessor.getPackedPixels(raster, raster.getBounds(), false, false);
        byte[] byArray = packedImageData.data;
        int n4 = packedImageData.offset;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = packedImageData.rect.x;
        int n10 = packedImageData.rect.y;
        PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n11 = writableRaster.getSampleModelTranslateX();
        int n12 = writableRaster.getSampleModelTranslateY();
        int n13 = pixelInterleavedSampleModel.getScanlineStride();
        byte[] byArray2 = dataBufferByte.getData();
        int n14 = dataBufferByte.getOffset();
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        int n15 = 0;
        while (n15 < n7) {
            n3 = this.xValues[n5 + n15 - this.minX];
            n2 = packedImageData.bitOffset + (n3 - n9);
            nArray[n15] = n2 >> 3;
            nArray2[n15] = n2 % 8;
            ++n15;
        }
        n3 = 0;
        while (n3 < n8) {
            int n16;
            int n17;
            n2 = 0;
            while (n2 < n7) {
                nArray3[n2] = 0;
                ++n2;
            }
            int n18 = this.yValues[n6 + n3 - this.minY];
            while (n18 < this.yValues[n6 + n3 - this.minY] + this.blockY) {
                n17 = (n18 - n10) * packedImageData.lineStride + n4;
                n16 = 0;
                int n19 = 0;
                while (n19 < n7) {
                    n16 = 0;
                    int n20 = nArray2[n19] + this.blockX - 1;
                    int n21 = nArray[n19] + (n20 >> 3);
                    n20 %= 8;
                    int n22 = 0xFF & byArray[n17 + nArray[n19]];
                    if (nArray[n19] == n21) {
                        n22 <<= 24 + nArray2[n19];
                        n16 += this.lut[n22 >>>= 31 - n20 + nArray2[n19]];
                    } else {
                        n22 <<= 24 + nArray2[n19];
                        n16 += this.lut[n22 >>>= 24];
                        int n23 = nArray[n19] + 1;
                        while (n23 < n21) {
                            n22 = 0xFF & byArray[n17 + n23];
                            n16 += this.lut[n22];
                            ++n23;
                        }
                        n22 = 0xFF & byArray[n17 + n21];
                        n16 += this.lut[n22 >>>= 7 - n20];
                    }
                    int n24 = n19++;
                    nArray3[n24] = nArray3[n24] + n16;
                }
                ++n18;
            }
            n17 = (n3 + n6 - n12) * n13 + n14;
            n17 += n5 - n11;
            n16 = 0;
            while (n16 < n7) {
                byArray2[n17 + n16] = this.lutGray[nArray3[n16]];
                ++n16;
            }
            ++n3;
        }
    }

    private void computeDestInfo(int n2, int n3) {
        this.invScaleX = 1.0f / this.scaleX;
        this.invScaleY = 1.0f / this.scaleY;
        this.blockX = (int)Math.ceil(this.invScaleX);
        this.blockY = (int)Math.ceil(this.invScaleY);
        float f2 = this.scaleX * (float)n2;
        float f3 = this.scaleY * (float)n3;
        this.floatTol = 0.1f * Math.min(this.scaleX / (f2 + 1.0f), this.scaleY / (f3 + 1.0f));
        this.dWidth = (int)f2;
        this.dHeight = (int)f3;
        if (Math.abs((float)Math.round(f2) - f2) < this.floatTol) {
            this.dWidth = Math.round(f2);
        }
        if (Math.abs((float)Math.round(f3) - f3) < this.floatTol) {
            this.dHeight = Math.round(f3);
        }
        if (Math.abs((float)Math.round(this.invScaleX) - this.invScaleX) < this.floatTol) {
            this.invScaleX = Math.round(this.invScaleX);
            this.blockX = (int)this.invScaleX;
        }
        if (Math.abs((float)Math.round(this.invScaleY) - this.invScaleY) < this.floatTol) {
            this.invScaleY = Math.round(this.invScaleY);
            this.blockY = (int)this.invScaleY;
        }
    }

    private final void buildLookupTables() {
        int n2;
        this.lut[0] = 0;
        this.lut[1] = 1;
        this.lut[2] = 1;
        this.lut[3] = 2;
        this.lut[4] = 1;
        this.lut[5] = 2;
        this.lut[6] = 2;
        this.lut[7] = 3;
        this.lut[8] = 1;
        this.lut[9] = 2;
        this.lut[10] = 2;
        this.lut[11] = 3;
        this.lut[12] = 2;
        this.lut[13] = 3;
        this.lut[14] = 3;
        this.lut[15] = 4;
        int n3 = 16;
        while (n3 < 256) {
            this.lut[n3] = this.lut[n3 & 0xF] + this.lut[n3 >> 4 & 0xF];
            ++n3;
        }
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        int n4 = 0;
        while (n4 < this.lutGray.length) {
            n2 = Math.round(255.0f * (float)n4 / ((float)this.lutGray.length - 1.0f));
            this.lutGray[n4] = (byte)(n2 > 255 ? -1 : (byte)n2);
            ++n4;
        }
        if (SubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n2 = 0;
            while (n2 < this.lutGray.length) {
                this.lutGray[n2] = (byte)(255 - (0xFF & this.lutGray[n2]));
                ++n2;
            }
        }
    }

    private void computeXYValues(int n2, int n3, int n4, int n5) {
        float f2;
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[this.dWidth];
            this.yValues = new int[this.dHeight];
        }
        int n6 = 0;
        while (n6 < this.dWidth) {
            f2 = this.invScaleX * (float)n6;
            this.xValues[n6] = Math.round(f2);
            ++n6;
        }
        if (this.xValues[this.dWidth - 1] + this.blockX > n2) {
            int n7 = this.dWidth - 1;
            this.xValues[n7] = this.xValues[n7] - 1;
        }
        int n8 = 0;
        while (n8 < this.dHeight) {
            f2 = this.invScaleY * (float)n8;
            this.yValues[n8] = Math.round(f2);
            ++n8;
        }
        if (this.yValues[this.dHeight - 1] + this.blockY > n3) {
            int n9 = this.dHeight - 1;
            this.yValues[n9] = this.yValues[n9] - 1;
        }
        if (n4 != 0) {
            int n10 = 0;
            while (n10 < this.dWidth) {
                int n11 = n10++;
                this.xValues[n11] = this.xValues[n11] + n4;
            }
        }
        if (n5 != 0) {
            int n12 = 0;
            while (n12 < this.dHeight) {
                int n13 = n12++;
                this.yValues[n13] = this.yValues[n13] + n5;
            }
        }
    }

    static boolean isMinWhite(ColorModel colorModel) {
        if (colorModel == null || !(colorModel instanceof IndexColorModel)) {
            return false;
        }
        byte[] byArray = new byte[256];
        ((IndexColorModel)colorModel).getReds(byArray);
        return byArray[0] == -1;
    }
}

