/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

class TransposeOpImage
extends GeometricOpImage {
    protected int type;
    protected int src_width;
    protected int src_height;
    protected Rectangle sourceBounds;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n2) {
        ImageLayout imageLayout2 = imageLayout != null ? (ImageLayout)imageLayout.clone() : new ImageLayout();
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = TransposeOpImage.mapRect(rectangle, rectangle, n2, true);
        imageLayout2.setMinX(rectangle2.x);
        imageLayout2.setMinY(rectangle2.y);
        imageLayout2.setWidth(rectangle2.width);
        imageLayout2.setHeight(rectangle2.height);
        Rectangle rectangle3 = new Rectangle(renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset(), renderedImage.getTileWidth(), renderedImage.getTileHeight());
        rectangle2 = TransposeOpImage.mapRect(rectangle3, rectangle, n2, true);
        if (imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(rectangle2.x);
        }
        if (imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(rectangle2.y);
        }
        if (imageLayout2.isValid(64)) {
            imageLayout2.setTileWidth(Math.abs(rectangle2.width));
        }
        if (imageLayout2.isValid(128)) {
            imageLayout2.setTileHeight(Math.abs(rectangle2.height));
        }
        return imageLayout2;
    }

    public TransposeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n2) {
        super(OpImage.vectorize(renderedImage), TransposeOpImage.layoutHelper(imageLayout, renderedImage, n2), map, true, null, null, null);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
        this.type = n2;
        this.src_width = renderedImage.getWidth();
        this.src_height = renderedImage.getHeight();
        this.sourceBounds = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n2) {
        return TransposeOpImage.mapRect(rectangle, this.sourceBounds, this.type, true);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n2) {
        return TransposeOpImage.mapRect(rectangle, this.sourceBounds, this.type, false);
    }

    protected static void mapPoint(int[] nArray, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = -1;
        int n10 = -1;
        switch (n6) {
            case 0: {
                n9 = n7;
                n10 = n3 + n5 - n8;
                break;
            }
            case 1: {
                n9 = n2 + n4 - n7;
                n10 = n8;
                break;
            }
            case 2: {
                n9 = n2 - n3 + n8;
                n10 = n3 - n2 + n7;
                break;
            }
            case 3: {
                if (bl2) {
                    n9 = n2 + n5 - n8;
                    n10 = n3 + n4 - n7;
                    break;
                }
                n9 = n3 + n4 - n8;
                n10 = n2 + n5 - n7;
                break;
            }
            case 4: {
                if (bl2) {
                    n9 = n2 + n5 - n8;
                    n10 = n3 - n2 + n7;
                    break;
                }
                n9 = n2 - n3 + n8;
                n10 = n2 + n5 - n7;
                break;
            }
            case 5: {
                n9 = n2 + n4 - n7;
                n10 = n3 + n5 - n8;
                break;
            }
            case 6: {
                if (bl2) {
                    n9 = n2 - n3 + n8;
                    n10 = n4 + n3 - n7;
                    break;
                }
                n9 = n4 + n3 - n8;
                n10 = n3 - n2 + n7;
            }
        }
        nArray[0] = n9;
        nArray[1] = n10;
    }

    private static Rectangle mapRect(Rectangle rectangle, Rectangle rectangle2, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        int n7 = n5 + rectangle2.width - 1;
        int n8 = n6 + rectangle2.height - 1;
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        TransposeOpImage.mapPoint(nArray, n5, n6, n7, n8, n2, bl2);
        int n9 = n4 = nArray[0];
        int n10 = n3 = nArray[1];
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y;
        TransposeOpImage.mapPoint(nArray, n5, n6, n7, n8, n2, bl2);
        n9 = Math.min(n9, nArray[0]);
        n10 = Math.min(n10, nArray[1]);
        n4 = Math.max(n4, nArray[0]);
        n3 = Math.max(n3, nArray[1]);
        nArray[0] = rectangle.x;
        nArray[1] = rectangle.y + rectangle.height - 1;
        TransposeOpImage.mapPoint(nArray, n5, n6, n7, n8, n2, bl2);
        n9 = Math.min(n9, nArray[0]);
        n10 = Math.min(n10, nArray[1]);
        n4 = Math.max(n4, nArray[0]);
        n3 = Math.max(n3, nArray[1]);
        nArray[0] = rectangle.x + rectangle.width - 1;
        nArray[1] = rectangle.y + rectangle.height - 1;
        TransposeOpImage.mapPoint(nArray, n5, n6, n7, n8, n2, bl2);
        n9 = Math.min(n9, nArray[0]);
        n10 = Math.min(n10, nArray[1]);
        n4 = Math.max(n4, nArray[0]);
        n3 = Math.max(n3, nArray[1]);
        return new Rectangle(n9, n10, n4 - n9 + 1, n3 - n10 + 1);
    }

    public Raster computeTile(int n2, int n3) {
        int n4;
        int n5;
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        int n6 = writableRaster.getMinX();
        int n7 = writableRaster.getMinY();
        int n8 = n6 + writableRaster.getWidth();
        int n9 = n7 + writableRaster.getHeight();
        Rectangle rectangle = this.getBounds();
        if (n6 < rectangle.x) {
            n6 = rectangle.x;
        }
        if (n8 > (n5 = rectangle.x + rectangle.width)) {
            n8 = n5;
        }
        if (n7 < rectangle.y) {
            n7 = rectangle.y;
        }
        if (n9 > (n4 = rectangle.y + rectangle.height)) {
            n9 = n4;
        }
        if (n6 >= n8 || n7 >= n9) {
            return writableRaster;
        }
        Rectangle rectangle2 = new Rectangle(n6, n7, n8 - n6, n9 - n7);
        IntegerSequence integerSequence = new IntegerSequence(n6, n8);
        integerSequence.insert(n6);
        integerSequence.insert(n8);
        IntegerSequence integerSequence2 = new IntegerSequence(n7, n9);
        integerSequence2.insert(n7);
        integerSequence2.insert(n9);
        PlanarImage planarImage = this.getSource(0);
        int n10 = planarImage.getMinX();
        int n11 = planarImage.getMinY();
        int n12 = planarImage.getWidth();
        int n13 = planarImage.getHeight();
        int n14 = n10 + n12 - 1;
        int n15 = n11 + n13 - 1;
        int n16 = planarImage.getTileWidth();
        int n17 = planarImage.getTileHeight();
        int n18 = planarImage.getTileGridXOffset();
        int n19 = planarImage.getTileGridYOffset();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[] nArray = new int[]{n18, n19};
        TransposeOpImage.mapPoint(nArray, n10, n11, n14, n15, this.type, true);
        n20 = nArray[0];
        n22 = nArray[1];
        switch (this.type) {
            case 0: {
                ++n22;
                n21 = n16;
                n23 = n17;
                break;
            }
            case 1: {
                ++n20;
                n21 = n16;
                n23 = n17;
                break;
            }
            case 2: {
                n21 = n17;
                n23 = n16;
                break;
            }
            case 3: {
                ++n20;
                ++n22;
                n21 = n17;
                n23 = n16;
                break;
            }
            case 4: {
                ++n20;
                n21 = n17;
                n23 = n16;
                break;
            }
            case 5: {
                ++n20;
                ++n22;
                n21 = n16;
                n23 = n17;
                break;
            }
            case 6: {
                ++n22;
                n21 = n17;
                n23 = n16;
            }
        }
        int n24 = (int)Math.floor((double)(n6 - n20) / (double)n21);
        int n25 = n20 + n24 * n21;
        while (n25 < n8) {
            integerSequence.insert(n25);
            n25 += n21;
        }
        int n26 = (int)Math.floor((double)(n7 - n22) / (double)n23);
        int n27 = n22 + n26 * n23;
        while (n27 < n9) {
            integerSequence2.insert(n27);
            n27 += n23;
        }
        Raster[] rasterArray = new Raster[1];
        Rectangle rectangle3 = new Rectangle();
        integerSequence2.startEnumeration();
        int n28 = integerSequence2.nextElement();
        while (integerSequence2.hasMoreElements()) {
            int n29 = integerSequence2.nextElement();
            int n30 = n29 - n28;
            integerSequence.startEnumeration();
            int n31 = integerSequence.nextElement();
            while (integerSequence.hasMoreElements()) {
                int n32 = integerSequence.nextElement();
                int n33 = n32 - n31;
                nArray[0] = n31;
                nArray[1] = n28;
                TransposeOpImage.mapPoint(nArray, n10, n11, n14, n15, this.type, false);
                int n34 = planarImage.XToTileX(nArray[0]);
                int n35 = planarImage.YToTileY(nArray[1]);
                rasterArray[0] = planarImage.getTile(n34, n35);
                rectangle3.x = n31;
                rectangle3.y = n28;
                rectangle3.width = n33;
                rectangle3.height = n30;
                this.computeRect(rasterArray, writableRaster, rectangle3);
                n31 = n32;
            }
            n28 = n29;
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        PlanarImage planarImage = this.getSource(0);
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getWidth();
        int n5 = planarImage.getHeight();
        int n6 = n2 + n4 - 1;
        int n7 = n3 + n5 - 1;
        int n8 = raster.getSampleModelTranslateX();
        int n9 = raster.getSampleModelTranslateY();
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = rasterAccessor.getPixelStride();
        int n15 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[]{rectangle.x, rectangle.y};
        TransposeOpImage.mapPoint(nArray, n2, n3, n6, n7, this.type, false);
        n12 = nArray[0];
        n13 = nArray[1];
        switch (this.type) {
            case 0: {
                n10 = n14;
                n11 = -n15;
                break;
            }
            case 1: {
                n10 = -n14;
                n11 = n15;
                break;
            }
            case 2: {
                n10 = n15;
                n11 = n14;
                break;
            }
            case 3: {
                n10 = -n15;
                n11 = -n14;
                break;
            }
            case 4: {
                n10 = -n15;
                n11 = n14;
                break;
            }
            case 5: {
                n10 = -n14;
                n11 = -n15;
                break;
            }
            case 6: {
                n10 = n15;
                n11 = -n14;
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n8, n9, rasterAccessor2, n10, n11, n12, n13);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n8, n9, rasterAccessor2, n10, n11, n12, n13);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n8, n9, rasterAccessor2, n10, n11, n12, n13);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n8, n9, rasterAccessor2, n10, n11, n12, n13);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n8, n9, rasterAccessor2, n10, n11, n12, n13);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2, int n4, int n5, int n6, int n7) {
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor2.getNumBands();
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = (n7 - n3) * n14;
        int n21 = (n6 - n2) * n13;
        int n22 = n21 + n20;
        int n23 = 0;
        int n24 = n17;
        while (n24 < n19) {
            int n25 = 0;
            while (n25 < n15) {
                byte[] byArray3 = byArray2[n25];
                byte[] byArray4 = byArray[n25];
                int n26 = n23 + nArray[n25];
                int n27 = n22 + nArray2[n25];
                int n28 = n16;
                while (n28 < n18) {
                    byArray4[n26] = byArray3[n27];
                    n27 += n4;
                    n26 += n11;
                    ++n28;
                }
                ++n25;
            }
            n22 += n5;
            n23 += n12;
            ++n24;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2, int n4, int n5, int n6, int n7) {
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getOffsetsForBands();
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor2.getNumBands();
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = (n7 - n3) * n14;
        int n21 = (n6 - n2) * n13;
        int n22 = n21 + n20;
        int n23 = 0;
        int n24 = n17;
        while (n24 < n19) {
            int n25 = 0;
            while (n25 < n15) {
                int[] nArray5 = nArray3[n25];
                int[] nArray6 = nArray[n25];
                int n26 = n23 + nArray2[n25];
                int n27 = n22 + nArray4[n25];
                int n28 = n16;
                while (n28 < n18) {
                    nArray6[n26] = nArray5[n27];
                    n27 += n4;
                    n26 += n11;
                    ++n28;
                }
                ++n25;
            }
            n22 += n5;
            n23 += n12;
            ++n24;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2, int n4, int n5, int n6, int n7) {
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor2.getNumBands();
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = (n7 - n3) * n14;
        int n21 = (n6 - n2) * n13;
        int n22 = n21 + n20;
        int n23 = 0;
        int n24 = n17;
        while (n24 < n19) {
            int n25 = 0;
            while (n25 < n15) {
                short[] sArray3 = sArray2[n25];
                short[] sArray4 = sArray[n25];
                int n26 = n23 + nArray[n25];
                int n27 = n22 + nArray2[n25];
                int n28 = n16;
                while (n28 < n18) {
                    sArray4[n26] = sArray3[n27];
                    n27 += n4;
                    n26 += n11;
                    ++n28;
                }
                ++n25;
            }
            n22 += n5;
            n23 += n12;
            ++n24;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2, int n4, int n5, int n6, int n7) {
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor2.getNumBands();
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = (n7 - n3) * n14;
        int n21 = (n6 - n2) * n13;
        int n22 = n21 + n20;
        int n23 = 0;
        int n24 = n17;
        while (n24 < n19) {
            int n25 = 0;
            while (n25 < n15) {
                float[] fArray3 = fArray2[n25];
                float[] fArray4 = fArray[n25];
                int n26 = n23 + nArray[n25];
                int n27 = n22 + nArray2[n25];
                int n28 = n16;
                while (n28 < n18) {
                    fArray4[n26] = fArray3[n27];
                    n27 += n4;
                    n26 += n11;
                    ++n28;
                }
                ++n25;
            }
            n22 += n5;
            n23 += n12;
            ++n24;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n2, int n3, RasterAccessor rasterAccessor2, int n4, int n5, int n6, int n7) {
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n11 = rasterAccessor2.getPixelStride();
        int n12 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getOffsetsForBands();
        int n13 = rasterAccessor.getPixelStride();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor2.getNumBands();
        int n16 = rectangle.x;
        int n17 = rectangle.y;
        int n18 = rectangle.x + rectangle.width;
        int n19 = rectangle.y + rectangle.height;
        int n20 = (n7 - n3) * n14;
        int n21 = (n6 - n2) * n13;
        int n22 = n21 + n20;
        int n23 = 0;
        int n24 = n17;
        while (n24 < n19) {
            int n25 = 0;
            while (n25 < n15) {
                double[] dArray3 = dArray2[n25];
                double[] dArray4 = dArray[n25];
                int n26 = n23 + nArray[n25];
                int n27 = n22 + nArray2[n25];
                int n28 = n16;
                while (n28 < n18) {
                    dArray4[n26] = dArray3[n27];
                    n27 += n4;
                    n26 += n11;
                    ++n28;
                }
                ++n25;
            }
            n22 += n5;
            n23 += n12;
            ++n24;
        }
    }
}

