/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpNearestOpImage
extends WarpOpImage {
    public WarpNearestOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, null, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        byte[] byArray2 = new byte[n8];
        int n12 = 0;
        while (n12 < n8) {
            byArray2[n12] = (byte)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                int n18 = WarpNearestOpImage.round(fArray[n15++]);
                int n19 = WarpNearestOpImage.round(fArray[n15++]);
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            byArray[n17][n14 + nArray[n17]] = byArray2[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        byArray[n17][n14 + nArray[n17]] = (byte)(randomIter.getSample(n18, n19, n17) & 0xFF);
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        int n12 = 0;
        while (n12 < n8) {
            sArray2[n12] = (short)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                int n18 = WarpNearestOpImage.round(fArray[n15++]);
                int n19 = WarpNearestOpImage.round(fArray[n15++]);
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            sArray[n17][n14 + nArray[n17]] = sArray2[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        sArray[n17][n14 + nArray[n17]] = (short)(randomIter.getSample(n18, n19, n17) & 0xFFFF);
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        short[] sArray2 = new short[n8];
        int n12 = 0;
        while (n12 < n8) {
            sArray2[n12] = (short)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                int n18 = WarpNearestOpImage.round(fArray[n15++]);
                int n19 = WarpNearestOpImage.round(fArray[n15++]);
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            sArray[n17][n14 + nArray[n17]] = sArray2[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        sArray[n17][n14 + nArray[n17]] = (short)randomIter.getSample(n18, n19, n17);
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int[] nArray3 = new int[n8];
        int n12 = 0;
        while (n12 < n8) {
            nArray3[n12] = (int)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                int n18 = WarpNearestOpImage.round(fArray[n15++]);
                int n19 = WarpNearestOpImage.round(fArray[n15++]);
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            nArray2[n17][n14 + nArray[n17]] = nArray3[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        nArray2[n17][n14 + nArray[n17]] = randomIter.getSample(n18, n19, n17);
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n6];
        int n11 = 0;
        float[] fArray3 = new float[n8];
        int n12 = 0;
        while (n12 < n8) {
            fArray3[n12] = (float)this.backgroundValues[n12];
            ++n12;
        }
        int n13 = 0;
        while (n13 < n7) {
            int n14 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n13, n6, 1, fArray2);
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                int n17;
                int n18 = WarpNearestOpImage.round(fArray2[n15++]);
                int n19 = WarpNearestOpImage.round(fArray2[n15++]);
                if (n18 < n2 || n18 >= n3 || n19 < n4 || n19 >= n5) {
                    if (this.setBackground) {
                        n17 = 0;
                        while (n17 < n8) {
                            fArray[n17][n14 + nArray[n17]] = fArray3[n17];
                            ++n17;
                        }
                    }
                } else {
                    n17 = 0;
                    while (n17 < n8) {
                        fArray[n17][n14 + nArray[n17]] = randomIter.getSampleFloat(n18, n19, n17);
                        ++n17;
                    }
                }
                n14 += n10;
                ++n16;
            }
            ++n13;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n2 = planarImage.getMinX();
        int n3 = planarImage.getMaxX();
        int n4 = planarImage.getMinY();
        int n5 = planarImage.getMaxY();
        int n6 = rasterAccessor.getWidth();
        int n7 = rasterAccessor.getHeight();
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n6];
        int n11 = 0;
        int n12 = 0;
        while (n12 < n7) {
            int n13 = n11;
            n11 += n9;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n6, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n6) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray[n14++]);
                int n18 = WarpNearestOpImage.round(fArray[n14++]);
                if (n17 < n2 || n17 >= n3 || n18 < n4 || n18 >= n5) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n8) {
                            dArray[n16][n13 + nArray[n16]] = this.backgroundValues[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n8) {
                        dArray[n16][n13 + nArray[n16]] = randomIter.getSampleDouble(n17, n18, n16);
                        ++n16;
                    }
                }
                n13 += n10;
                ++n15;
            }
            ++n12;
        }
    }

    private static final int round(float f2) {
        return f2 >= 0.0f ? (int)(f2 + 0.5f) : (int)(f2 - 0.5f);
    }
}

