/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.remote.JAIServerConfigurationSpi;
import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIUtil;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.RMIImageImpl;
import com.sun.media.jai.rmi.RMIServerProxy;
import com.sun.media.jai.rmi.RenderableRMIServerProxy;
import com.sun.media.jai.rmi.SerializableRenderableImage;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Service;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.CollectionImage;
import javax.media.jai.JAI;
import javax.media.jai.OpImage;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.registry.CRIFRegistry;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoderFactory;
import javax.media.jai.util.ImagingListener;

public class JAIRMIImageServer
extends UnicastRemoteObject
implements ImageServer {
    private boolean DEBUG = true;
    public static final Object NULL_PROPERTY = RMIImageImpl.NULL_PROPERTY;
    private static long idCounter = 0L;
    private static Hashtable nodes = new Hashtable();
    private static Hashtable negotiated = new Hashtable();
    private static Hashtable refCount = new Hashtable();
    static /* synthetic */ Class class$javax$media$jai$tilecodec$TileEncoderFactory;
    static /* synthetic */ Class class$javax$media$jai$OperationDescriptor;
    static /* synthetic */ Class class$com$sun$media$jai$remote$JAIServerConfigurationSpi;
    static /* synthetic */ Class class$com$sun$media$jai$rmi$JAIRMIImageServer;

    private static PlanarImage getSource(Long l2) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (nodes == null) break block2;
                Object v2 = nodes.get(l2);
                var1_1 = v2;
                if (v2 != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    private static PropertySource getPropertySource(Long l2) throws RemoteException {
        Object v2 = nodes.get(l2);
        return (PropertySource)v2;
    }

    public JAIRMIImageServer(int n2) throws RemoteException {
        super(n2);
    }

    public synchronized Long getRemoteID() throws RemoteException {
        return new Long(++idCounter);
    }

    public synchronized void dispose(Long l2) throws RemoteException {
        int n2 = (Integer)refCount.get(l2);
        if (n2 == 1) {
            if (nodes != null) {
                nodes.remove(l2);
                negotiated.remove(l2);
            }
            refCount.remove(l2);
        } else {
            if (--n2 == 0) {
                refCount.remove(l2);
            }
            refCount.put(l2, new Integer(n2));
        }
    }

    public void incrementRefCount(Long l2) throws RemoteException {
        Integer n2 = (Integer)refCount.get(l2);
        int n3 = 0;
        if (n2 != null) {
            n3 = n2;
        }
        refCount.put(l2, new Integer(++n3));
    }

    public Object getProperty(Long l2, String string) throws RemoteException {
        PropertySource propertySource = JAIRMIImageServer.getPropertySource(l2);
        Object object = propertySource.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            object = NULL_PROPERTY;
        }
        return object;
    }

    public String[] getPropertyNames(Long l2) throws RemoteException {
        PropertySource propertySource = JAIRMIImageServer.getPropertySource(l2);
        return propertySource.getPropertyNames();
    }

    public String[] getPropertyNames(String string) throws RemoteException {
        return CRIFRegistry.get(null, string).getPropertyNames();
    }

    public int getMinX(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMinX();
    }

    public int getMaxX(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMaxX();
    }

    public int getMinY(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMinY();
    }

    public int getMaxY(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMaxY();
    }

    public int getWidth(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getWidth();
    }

    public int getHeight(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getHeight();
    }

    public int getTileWidth(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getTileWidth();
    }

    public int getTileHeight(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getTileHeight();
    }

    public int getTileGridXOffset(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getTileGridXOffset();
    }

    public int getTileGridYOffset(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getTileGridYOffset();
    }

    public int getMinTileX(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMinTileX();
    }

    public int getNumXTiles(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getNumXTiles();
    }

    public int getMinTileY(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMinTileY();
    }

    public int getNumYTiles(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getNumYTiles();
    }

    public int getMaxTileX(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMaxTileX();
    }

    public int getMaxTileY(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getMaxTileY();
    }

    public SerializableState getSampleModel(Long l2) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l2).getSampleModel(), null);
    }

    public SerializableState getColorModel(Long l2) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l2).getColorModel(), null);
    }

    public Rectangle getBounds(Long l2) throws RemoteException {
        return JAIRMIImageServer.getSource(l2).getBounds();
    }

    public SerializableState getTile(Long l2, int n2, int n3) throws RemoteException {
        Raster raster = JAIRMIImageServer.getSource(l2).getTile(n2, n3);
        return SerializerFactory.getState(raster, null);
    }

    public byte[] getCompressedTile(Long l2, int n2, int n3) throws RemoteException {
        TileCodecParameterList tileCodecParameterList = null;
        TileEncoderFactory tileEncoderFactory = null;
        NegotiableCapability negotiableCapability = null;
        if (negotiated != null) {
            negotiableCapability = ((NegotiableCapabilitySet)negotiated.get(l2)).getNegotiatedValue("tileCodec");
        }
        if (negotiableCapability != null) {
            Object object;
            Object object2;
            Object object3;
            String string = negotiableCapability.getCategory();
            String string2 = negotiableCapability.getCapabilityName();
            List list = negotiableCapability.getGenerators();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (tileEncoderFactory != null || !(class$javax$media$jai$tilecodec$TileEncoderFactory == null ? JAIRMIImageServer.class$("javax.media.jai.tilecodec.TileEncoderFactory") : class$javax$media$jai$tilecodec$TileEncoderFactory).isAssignableFrom(clazz)) continue;
                try {
                    tileEncoderFactory = (TileEncoderFactory)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException.getMessage());
                }
            }
            if (tileEncoderFactory == null) {
                throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer0"));
            }
            TileCodecDescriptor tileCodecDescriptor = (TileCodecDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor("tileEncoder", string2);
            if (!tileCodecDescriptor.includesSampleModelInfo() || !tileCodecDescriptor.includesLocationInfo()) {
                throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer1"));
            }
            ParameterListDescriptor parameterListDescriptor = tileCodecDescriptor.getParameterListDescriptor("tileEncoder");
            tileCodecParameterList = new TileCodecParameterList(string2, new String[]{"tileEncoder"}, parameterListDescriptor);
            if (parameterListDescriptor != null && (object3 = parameterListDescriptor.getParamNames()) != null) {
                int n4 = 0;
                while (n4 < ((String[])object3).length) {
                    block14: {
                        object2 = object3[n4];
                        try {
                            object = negotiableCapability.getNegotiatedValue((String)object2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block14;
                        }
                        tileCodecParameterList.setParameter((String)object2, object);
                    }
                    ++n4;
                }
            }
            object3 = JAIRMIImageServer.getSource(l2).getTile(n2, n3);
            object2 = new ByteArrayOutputStream();
            object = tileEncoderFactory.createEncoder((OutputStream)object2, tileCodecParameterList, ((Raster)object3).getSampleModel());
            try {
                object.encode((Raster)object3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            return ((ByteArrayOutputStream)object2).toByteArray();
        }
        throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer2"));
    }

    public SerializableState getData(Long l2) throws RemoteException {
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l2).getData(), null);
    }

    public SerializableState getData(Long l2, Rectangle rectangle) throws RemoteException {
        if (rectangle == null) {
            return this.getData(l2);
        }
        rectangle = rectangle.intersection(this.getBounds(l2));
        return SerializerFactory.getState(JAIRMIImageServer.getSource(l2).getData(rectangle), null);
    }

    public SerializableState copyData(Long l2, Rectangle rectangle) throws RemoteException {
        return this.getData(l2, rectangle);
    }

    public void createRenderedOp(Long l2, String string, ParameterBlock parameterBlock, SerializableState serializableState) throws RemoteException {
        RenderingHints renderingHints = (RenderingHints)serializableState.getObject();
        JAIRMIUtil.checkServerParameters(parameterBlock, nodes);
        RenderedOp renderedOp = new RenderedOp(string, parameterBlock, renderingHints);
        renderedOp.removeSinks();
        nodes.put(l2, renderedOp);
    }

    public boolean getRendering(Long l2) throws RemoteException {
        RenderedOp renderedOp = this.getNode(l2);
        return renderedOp.getRendering() != null;
    }

    public RenderedOp getNode(Long l2) throws RemoteException {
        return (RenderedOp)nodes.get(l2);
    }

    public synchronized void setRenderedSource(Long l2, RenderedImage renderedImage, int n2) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        Object v2 = nodes.get(l2);
        if (v2 instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v2;
            renderedOp.setSource(planarImage, n2);
            ((PlanarImage)renderedOp.getSourceObject(n2)).removeSinks();
        } else if (v2 instanceof RenderableOp) {
            ((RenderableOp)v2).setSource(planarImage, n2);
        }
    }

    public synchronized void setRenderedSource(Long l2, RenderedOp renderedOp, int n2) throws RemoteException {
        Object v2 = nodes.get(l2);
        if (v2 instanceof RenderedOp) {
            RenderedOp renderedOp2 = (RenderedOp)v2;
            renderedOp2.setSource(renderedOp.getRendering(), n2);
            ((PlanarImage)renderedOp2.getSourceObject(n2)).removeSinks();
        } else if (v2 instanceof RenderableOp) {
            ((RenderableOp)v2).setSource(renderedOp.getRendering(), n2);
        }
    }

    public synchronized void setRenderedSource(Long l2, Long l3, int n2) throws RemoteException {
        Object v2 = nodes.get(l2);
        if (v2 instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v2;
            renderedOp.setSource(nodes.get(l3), n2);
            ((PlanarImage)nodes.get(l3)).removeSinks();
        } else if (v2 instanceof RenderableOp) {
            ((RenderableOp)v2).setSource(nodes.get(l3), n2);
        }
    }

    public synchronized void setRenderedSource(Long l2, Long l3, String string, String string2, int n2) throws RemoteException {
        Object v2 = nodes.get(l2);
        if (v2 instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)v2;
            renderedOp.setSource(new RMIServerProxy(string + "::" + l3, string2, null), n2);
            ((PlanarImage)renderedOp.getSourceObject(n2)).removeSinks();
        } else if (v2 instanceof RenderableOp) {
            ((RenderableOp)v2).setSource(new RMIServerProxy(string + "::" + l3, string2, null), n2);
        }
    }

    public float getRenderableMinX(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        return renderableImage.getMinX();
    }

    public float getRenderableMinY(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        return renderableImage.getMinY();
    }

    public float getRenderableWidth(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        return renderableImage.getWidth();
    }

    public float getRenderableHeight(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        return renderableImage.getHeight();
    }

    public RenderedImage createScaledRendering(Long l2, int n2, int n3, SerializableState serializableState) throws RemoteException {
        RenderingHints renderingHints;
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        RenderedImage renderedImage = renderableImage.createScaledRendering(n2, n3, renderingHints = (RenderingHints)serializableState.getObject());
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public RenderedImage createDefaultRendering(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public RenderedImage createRendering(Long l2, SerializableState serializableState) throws RemoteException {
        RenderContext renderContext;
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        RenderedImage renderedImage = renderableImage.createRendering(renderContext = (RenderContext)serializableState.getObject());
        if (renderedImage instanceof Serializable) {
            return renderedImage;
        }
        return new SerializableRenderedImage(renderedImage);
    }

    public synchronized void createRenderableOp(Long l2, String string, ParameterBlock parameterBlock) throws RemoteException {
        RenderableOp renderableOp = new RenderableOp(string, parameterBlock);
        nodes.put(l2, renderableOp);
    }

    public synchronized Long getRendering(Long l2, SerializableState serializableState) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderableOp.createRendering((RenderContext)serializableState.getObject()));
        Long l3 = this.getRemoteID();
        nodes.put(l3, planarImage);
        this.setServerNegotiatedValues(l3, (NegotiableCapabilitySet)negotiated.get(l2));
        return l3;
    }

    public synchronized void setRenderableSource(Long l2, Long l3, int n2) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        Object v2 = nodes.get(l3);
        if (v2 instanceof RenderableOp) {
            renderableOp.setSource((RenderableOp)v2, n2);
        } else if (v2 instanceof RenderedImage) {
            renderableOp.setSource(PlanarImage.wrapRenderedImage((RenderedImage)v2), n2);
        }
    }

    public synchronized void setRenderableSource(Long l2, Long l3, String string, String string2, int n2) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        renderableOp.setSource(new RMIServerProxy(string + "::" + l3, string2, null), n2);
    }

    public synchronized void setRenderableRMIServerProxyAsSource(Long l2, Long l3, String string, String string2, int n2) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        renderableOp.setSource(new RenderableRMIServerProxy(string, string2, null, l3), n2);
    }

    public synchronized void setRenderableSource(Long l2, RenderableOp renderableOp, int n2) throws RemoteException {
        RenderableOp renderableOp2 = (RenderableOp)nodes.get(l2);
        renderableOp2.setSource(renderableOp, n2);
    }

    public synchronized void setRenderableSource(Long l2, SerializableRenderableImage serializableRenderableImage, int n2) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        renderableOp.setSource(serializableRenderableImage, n2);
    }

    public synchronized void setRenderableSource(Long l2, RenderedImage renderedImage, int n2) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        renderableOp.setSource(planarImage, n2);
    }

    public SerializableState mapRenderContext(int n2, Long l2, String string, SerializableState serializableState) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        ContextualRenderedImageFactory contextualRenderedImageFactory = CRIFRegistry.get(renderableOp.getRegistry(), string);
        if (contextualRenderedImageFactory == null) {
            throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer3"));
        }
        RenderContext renderContext = contextualRenderedImageFactory.mapRenderContext(n2, (RenderContext)serializableState.getObject(), renderableOp.getParameterBlock(), renderableOp);
        return SerializerFactory.getState(renderContext, null);
    }

    public SerializableState getBounds2D(Long l2, String string) throws RemoteException {
        RenderableOp renderableOp = (RenderableOp)nodes.get(l2);
        ContextualRenderedImageFactory contextualRenderedImageFactory = CRIFRegistry.get(renderableOp.getRegistry(), string);
        if (contextualRenderedImageFactory == null) {
            throw new RuntimeException(JaiI18N.getString("JAIRMIImageServer3"));
        }
        Rectangle2D rectangle2D = contextualRenderedImageFactory.getBounds2D(renderableOp.getParameterBlock());
        return SerializerFactory.getState(rectangle2D, null);
    }

    public boolean isDynamic(String string) throws RemoteException {
        return CRIFRegistry.get(null, string).isDynamic();
    }

    public boolean isDynamic(Long l2) throws RemoteException {
        RenderableImage renderableImage = (RenderableImage)nodes.get(l2);
        return renderableImage.isDynamic();
    }

    public String[] getServerSupportedOperationNames() throws RemoteException {
        return JAI.getDefaultInstance().getOperationRegistry().getDescriptorNames(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = JAIRMIImageServer.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
    }

    public List getOperationDescriptors() throws RemoteException {
        return JAI.getDefaultInstance().getOperationRegistry().getDescriptors(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = JAIRMIImageServer.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor);
    }

    public synchronized SerializableState getInvalidRegion(Long l2, ParameterBlock parameterBlock, SerializableState serializableState, ParameterBlock parameterBlock2, SerializableState serializableState2) throws RemoteException {
        Serializable serializable;
        Object object;
        RenderingHints renderingHints = (RenderingHints)serializableState.getObject();
        RenderingHints renderingHints2 = (RenderingHints)serializableState2.getObject();
        RenderedOp renderedOp = (RenderedOp)nodes.get(l2);
        OperationDescriptor operationDescriptor = (OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor("rendered", renderedOp.getOperationName());
        boolean bl2 = false;
        if (parameterBlock == parameterBlock2) {
            bl2 = true;
        }
        Vector<Object> vector = parameterBlock.getSources();
        parameterBlock.removeSources();
        Vector vector2 = JAIRMIUtil.replaceIdWithSources(vector, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
        parameterBlock.setSources(vector2);
        if (bl2) {
            parameterBlock2 = parameterBlock;
        } else {
            object = parameterBlock2.getSources();
            parameterBlock2.removeSources();
            serializable = JAIRMIUtil.replaceIdWithSources(object, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            parameterBlock2.setSources((Vector<Object>)serializable);
        }
        object = operationDescriptor.getInvalidRegion("rendered", parameterBlock, renderingHints, parameterBlock2, renderingHints2, renderedOp);
        serializable = SerializerFactory.getState((Shape)object, null);
        return serializable;
    }

    public Rectangle mapSourceRect(Long l2, Rectangle rectangle, int n2) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l2);
        OpImage opImage = (OpImage)renderedOp.getRendering();
        return opImage.mapSourceRect(rectangle, n2);
    }

    public Rectangle mapDestRect(Long l2, Rectangle rectangle, int n2) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l2);
        OpImage opImage = (OpImage)renderedOp.getRendering();
        return opImage.mapDestRect(rectangle, n2);
    }

    public synchronized Long handleEvent(Long l2, String string, Object object, Object object2) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l2);
        PlanarImage planarImage = renderedOp.getRendering();
        Long l3 = this.getRemoteID();
        nodes.put(l3, planarImage);
        this.setServerNegotiatedValues(l3, (NegotiableCapabilitySet)negotiated.get(l2));
        if (string.equals("operationname")) {
            renderedOp.setOperationName((String)object2);
        } else if (string.equals("parameterblock")) {
            ParameterBlock parameterBlock = (ParameterBlock)object2;
            Vector<Object> vector = parameterBlock.getSources();
            parameterBlock.removeSources();
            JAIRMIUtil.checkServerParameters(parameterBlock, nodes);
            Vector vector2 = JAIRMIUtil.replaceIdWithSources(vector, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            parameterBlock.setSources(vector2);
            renderedOp.setParameterBlock(parameterBlock);
            Vector<Object> vector3 = parameterBlock.getSources();
            if (vector3 != null && vector3.size() > 0) {
                Iterator iterator = ((AbstractList)vector3).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 instanceof PlanarImage) {
                        ((PlanarImage)e2).removeSinks();
                        continue;
                    }
                    if (!(e2 instanceof CollectionImage)) continue;
                    ((CollectionImage)e2).removeSinks();
                }
            }
        } else if (string.equals("sources")) {
            Vector vector = JAIRMIUtil.replaceIdWithSources((Vector)object2, nodes, renderedOp.getOperationName(), renderedOp.getRenderingHints());
            renderedOp.setSources(vector);
            if (vector != null && vector.size() > 0) {
                Iterator iterator = ((AbstractList)vector).iterator();
                while (iterator.hasNext()) {
                    Object e3 = iterator.next();
                    if (e3 instanceof PlanarImage) {
                        ((PlanarImage)e3).removeSinks();
                        continue;
                    }
                    if (!(e3 instanceof CollectionImage)) continue;
                    ((CollectionImage)e3).removeSinks();
                }
            }
        } else if (string.equals("parameters")) {
            Vector vector = (Vector)object2;
            JAIRMIUtil.checkServerParameters(vector, nodes);
            renderedOp.setParameters(vector);
        } else if (string.equals("renderinghints")) {
            SerializableState serializableState = (SerializableState)object2;
            renderedOp.setRenderingHints((RenderingHints)serializableState.getObject());
        }
        return l3;
    }

    public synchronized Long handleEvent(Long l2, int n2, SerializableState serializableState, Object object) throws RemoteException {
        RenderedOp renderedOp = (RenderedOp)nodes.get(l2);
        PlanarImage planarImage = renderedOp.getRendering();
        Long l3 = this.getRemoteID();
        nodes.put(l3, planarImage);
        this.setServerNegotiatedValues(l3, (NegotiableCapabilitySet)negotiated.get(l2));
        PlanarImage planarImage2 = null;
        PlanarImage planarImage3 = null;
        String string = null;
        Object var11_11 = null;
        if (object instanceof String) {
            boolean bl2;
            string = (String)object;
            int n3 = string.indexOf("::");
            boolean bl3 = bl2 = n3 != -1;
            planarImage2 = bl2 ? new RMIServerProxy(string, renderedOp.getOperationName(), renderedOp.getRenderingHints()) : ((var11_11 = nodes.get(Long.valueOf(string))) instanceof RenderedOp ? ((RenderedOp)var11_11).getRendering() : PlanarImage.wrapRenderedImage(var11_11));
        } else {
            planarImage2 = PlanarImage.wrapRenderedImage((RenderedImage)object);
        }
        PlanarImage planarImage4 = renderedOp.getSource(n2);
        if (planarImage4 instanceof RenderedOp) {
            planarImage3 = ((RenderedOp)planarImage4).getRendering();
        } else if (planarImage4 instanceof RenderedImage) {
            planarImage3 = PlanarImage.wrapRenderedImage(planarImage4);
        }
        Shape shape = (Shape)serializableState.getObject();
        RenderingChangeEvent renderingChangeEvent = new RenderingChangeEvent((RenderedOp)renderedOp.getSource(n2), planarImage2, planarImage3, shape);
        renderedOp.propertyChange(renderingChangeEvent);
        return l3;
    }

    public synchronized NegotiableCapabilitySet getServerCapabilities() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        String string = "tileEncoder";
        String[] stringArray = operationRegistry.getDescriptorNames(string);
        TileEncoderFactory tileEncoderFactory = null;
        NegotiableCapabilitySet negotiableCapabilitySet = new NegotiableCapabilitySet(false);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Iterator iterator = operationRegistry.getFactoryIterator(string, stringArray[n2]);
            while (iterator.hasNext()) {
                tileEncoderFactory = (TileEncoderFactory)iterator.next();
                negotiableCapabilitySet.add(tileEncoderFactory.getEncodeCapability());
            }
            ++n2;
        }
        return negotiableCapabilitySet;
    }

    public void setServerNegotiatedValues(Long l2, NegotiableCapabilitySet negotiableCapabilitySet) throws RemoteException {
        if (negotiableCapabilitySet != null) {
            negotiated.put(l2, negotiableCapabilitySet);
        } else {
            negotiated.remove(l2);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        Iterator iterator = Service.providers(class$com$sun$media$jai$remote$JAIServerConfigurationSpi == null ? (class$com$sun$media$jai$remote$JAIServerConfigurationSpi = JAIRMIImageServer.class$("com.sun.media.jai.remote.JAIServerConfigurationSpi")) : class$com$sun$media$jai$remote$JAIServerConfigurationSpi);
        JAI jAI = JAI.getDefaultInstance();
        while (iterator.hasNext()) {
            object2 = (JAIServerConfigurationSpi)iterator.next();
            object2.updateServer(jAI);
        }
        object2 = null;
        int n2 = 1099;
        int n3 = 0;
        if (stringArray.length != 0) {
            int n4 = 0;
            while (n4 < stringArray.length) {
                int n5;
                int n6;
                int n7;
                if (stringArray[n4].equalsIgnoreCase("-help")) {
                    System.out.println("Usage: java -Djava.rmi.server.codebase=file:$JAI/lib/jai.jar \\");
                    System.out.println("-Djava.rmi.server.useCodebaseOnly=false \\");
                    System.out.println("-Djava.security.policy=file:`pwd`/policy \\");
                    System.out.println("com.sun.media.jai.rmi.JAIRMIImageServer \\");
                    System.out.println("\nwhere options are:");
                    System.out.println("\t-host <string> The server name or server IP address");
                    System.out.println("\t-port <integer> The port that rmiregistry is running on");
                    System.out.println("\t-rmiRegistryPort <integer> Same as -port option");
                    System.out.println("\t-serverPort <integer> The port that the server should listen on, for connections from clients");
                    System.out.println("\t-cacheMemCapacity <long> The memory capacity in bytes.");
                    System.out.println("\t-cacheMemThreshold <float> The memory threshold, which is the fractional amount of cache memory to retain during tile removal");
                    System.out.println("\t-disableDefaultCache Disable use of default tile cache. Tiles are not stored.");
                    System.out.println("\t-schedulerParallelism <integer> The degree of parallelism of the default TileScheduler");
                    System.out.println("\t-schedulerPrefetchParallelism <integer> The degree of parallelism of the default TileScheduler for tile prefetching");
                    System.out.println("\t-schedulerPriority <integer> The priority of tile scheduling for the default TileScheduler");
                    System.out.println("\t-schedulerPrefetchPriority <integer> The priority of tile prefetch scheduling for the default TileScheduler");
                    System.out.println("\t-defaultTileSize <integer>x<integer> The default tile dimensions in the form <xSize>x<ySize>");
                    System.out.println("\t-defaultRenderingSize <integer>x<integer> The default size to render a RenderableImage to, in the form <xSize>x<ySize>");
                    System.out.println("\t-serializeDeepCopy <boolean> Whether a deep copy of the image data should be used when serializing images");
                    System.out.println("\t-tileCodecFormat <string> The default format to be used for tile serialization via TileCodecs");
                    System.out.println("\t-retryInterval <integer> The retry interval value to be used for dealing with network errors during remote imaging");
                    System.out.println("\t-numRetries <integer> The number of retries to be used for dealing with network errors during remote imaging");
                } else if (stringArray[n4].equalsIgnoreCase("-host")) {
                    object2 = stringArray[++n4];
                } else if (stringArray[n4].equalsIgnoreCase("-port") || stringArray[n4].equalsIgnoreCase("-rmiRegistryPort")) {
                    n2 = Integer.parseInt(stringArray[++n4]);
                } else if (stringArray[n4].equalsIgnoreCase("-serverport")) {
                    n3 = Integer.parseInt(stringArray[++n4]);
                } else if (stringArray[n4].equalsIgnoreCase("-cacheMemCapacity")) {
                    jAI.getTileCache().setMemoryCapacity(Long.parseLong(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-cacheMemThreshold")) {
                    jAI.getTileCache().setMemoryThreshold(Float.parseFloat(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-disableDefaultCache")) {
                    JAI.disableDefaultTileCache();
                } else if (stringArray[n4].equalsIgnoreCase("-schedulerParallelism")) {
                    jAI.getTileScheduler().setParallelism(Integer.parseInt(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-schedulerPrefetchParallelism")) {
                    jAI.getTileScheduler().setPrefetchParallelism(Integer.parseInt(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-schedulerPriority")) {
                    jAI.getTileScheduler().setPriority(Integer.parseInt(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-schedulerPrefetchPriority")) {
                    jAI.getTileScheduler().setPrefetchPriority(Integer.parseInt(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-defaultTileSize")) {
                    object = stringArray[++n4].toLowerCase();
                    n7 = ((String)object).indexOf("x");
                    n6 = Integer.parseInt(((String)object).substring(0, n7));
                    n5 = Integer.parseInt(((String)object).substring(n7 + 1));
                    JAI.setDefaultTileSize(new Dimension(n6, n5));
                } else if (stringArray[n4].equalsIgnoreCase("-defaultRenderingSize")) {
                    object = stringArray[++n4].toLowerCase();
                    n7 = ((String)object).indexOf("x");
                    n6 = Integer.parseInt(((String)object).substring(0, n7));
                    n5 = Integer.parseInt(((String)object).substring(n7 + 1));
                    JAI.setDefaultRenderingSize(new Dimension(n6, n5));
                } else if (stringArray[n4].equalsIgnoreCase("-serializeDeepCopy")) {
                    jAI.setRenderingHint(JAI.KEY_SERIALIZE_DEEP_COPY, Boolean.valueOf(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-tileCodecFormat")) {
                    jAI.setRenderingHint(JAI.KEY_TILE_CODEC_FORMAT, stringArray[++n4]);
                } else if (stringArray[n4].equalsIgnoreCase("-retryInterval")) {
                    jAI.setRenderingHint(JAI.KEY_RETRY_INTERVAL, Integer.valueOf(stringArray[++n4]));
                } else if (stringArray[n4].equalsIgnoreCase("-numRetries")) {
                    jAI.setRenderingHint(JAI.KEY_NUM_RETRIES, Integer.valueOf(stringArray[++n4]));
                }
                ++n4;
            }
        }
        if (object2 == null) {
            try {
                object2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                String string = JaiI18N.getString("RMIImageImpl1");
                JAIRMIImageServer.sendExceptionToListener(string, new RemoteImagingException(string, unknownHostException));
            }
        }
        System.out.println(JaiI18N.getString("RMIImageImpl3") + " " + (String)object2 + ":" + n2);
        try {
            object = new JAIRMIImageServer(n3);
            String string = new String("rmi://" + (String)object2 + ":" + n2 + "/" + "JAIRMIRemoteServer1.1");
            System.out.println(JaiI18N.getString("RMIImageImpl4") + " \"" + string + "\".");
            Naming.rebind(string, (Remote)object);
            System.out.println(JaiI18N.getString("RMIImageImpl5"));
        }
        catch (Exception exception) {
            String string = JaiI18N.getString("RMIImageImpl1");
            JAIRMIImageServer.sendExceptionToListener(string, new RemoteImagingException(string, exception));
        }
    }

    private static void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, new RemoteImagingException(string, exception), class$com$sun$media$jai$rmi$JAIRMIImageServer == null ? (class$com$sun$media$jai$rmi$JAIRMIImageServer = JAIRMIImageServer.class$("com.sun.media.jai.rmi.JAIRMIImageServer")) : class$com$sun$media$jai$rmi$JAIRMIImageServer, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

