/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ColorModelProxy;
import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.NullPropertyTag;
import com.sun.media.jai.rmi.RMIImage;
import com.sun.media.jai.rmi.RasterProxy;
import com.sun.media.jai.rmi.RenderContextProxy;
import com.sun.media.jai.rmi.SampleModelProxy;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.util.ImagingListener;

public class RMIImageImpl
implements RMIImage {
    public static final Object NULL_PROPERTY = new NullPropertyTag();
    private static long idCounter = 0L;
    private static Hashtable sources = null;
    private static Hashtable propertySources = null;

    private static synchronized void addSource(Long l2, RenderedImage renderedImage, PropertySource propertySource) {
        if (sources == null) {
            sources = new Hashtable();
            propertySources = new Hashtable();
        }
        sources.put(l2, renderedImage);
        propertySources.put(l2, propertySource);
    }

    private static PlanarImage getSource(Long l2) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (sources == null) break block2;
                Object v2 = sources.get(l2);
                var1_1 = v2;
                if (v2 != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    private static PropertySource getPropertySource(Long l2) throws RemoteException {
        Object var1_1;
        block3: {
            block2: {
                var1_1 = null;
                if (propertySources == null) break block2;
                Object v2 = propertySources.get(l2);
                var1_1 = v2;
                if (v2 != null) break block3;
            }
            throw new RemoteException(JaiI18N.getString("RMIImageImpl2"));
        }
        return var1_1;
    }

    public RMIImageImpl() throws RemoteException {
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
            ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
            String string = JaiI18N.getString("RMIImageImpl0");
            imagingListener.errorOccurred(string, new RemoteImagingException(string, remoteException), this, false);
        }
    }

    public synchronized Long getRemoteID() throws RemoteException {
        return new Long(++idCounter);
    }

    public void setSource(Long l2, RenderedImage renderedImage) throws RemoteException {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RMIImageImpl.addSource(l2, planarImage, planarImage);
    }

    public void setSource(Long l2, RenderedOp renderedOp) throws RemoteException {
        RMIImageImpl.addSource(l2, renderedOp.getRendering(), renderedOp);
    }

    public void setSource(Long l2, RenderableOp renderableOp, RenderContextProxy renderContextProxy) throws RemoteException {
        RenderContext renderContext = renderContextProxy.getRenderContext();
        RenderedImage renderedImage = renderableOp.createRendering(renderContext);
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        RMIImageImpl.addSource(l2, planarImage, planarImage);
    }

    public void dispose(Long l2) throws RemoteException {
        if (sources != null) {
            sources.remove(l2);
            propertySources.remove(l2);
        }
    }

    public Object getProperty(Long l2, String string) throws RemoteException {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l2);
        Object object = propertySource.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            object = NULL_PROPERTY;
        }
        return object;
    }

    public String[] getPropertyNames(Long l2) throws RemoteException {
        PropertySource propertySource = RMIImageImpl.getPropertySource(l2);
        return propertySource.getPropertyNames();
    }

    public int getMinX(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMinX();
    }

    public int getMaxX(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMaxX();
    }

    public int getMinY(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMinY();
    }

    public int getMaxY(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMaxY();
    }

    public int getWidth(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getWidth();
    }

    public int getHeight(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getHeight();
    }

    public int getTileWidth(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getTileWidth();
    }

    public int getTileHeight(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getTileHeight();
    }

    public int getTileGridXOffset(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getTileGridXOffset();
    }

    public int getTileGridYOffset(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getTileGridYOffset();
    }

    public int getMinTileX(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMinTileX();
    }

    public int getNumXTiles(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getNumXTiles();
    }

    public int getMinTileY(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMinTileY();
    }

    public int getNumYTiles(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getNumYTiles();
    }

    public int getMaxTileX(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMaxTileX();
    }

    public int getMaxTileY(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getMaxTileY();
    }

    public SampleModelProxy getSampleModel(Long l2) throws RemoteException {
        return new SampleModelProxy(RMIImageImpl.getSource(l2).getSampleModel());
    }

    public ColorModelProxy getColorModel(Long l2) throws RemoteException {
        return new ColorModelProxy(RMIImageImpl.getSource(l2).getColorModel());
    }

    public Vector getSources(Long l2) throws RemoteException {
        Vector vector = RMIImageImpl.getSource(l2).getSources();
        int n2 = vector.size();
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            RenderedImage renderedImage = (RenderedImage)vector.get(n3);
            if (!(renderedImage instanceof Serializable)) {
                if (!bl2) {
                    vector = (Vector)vector.clone();
                }
                vector.set(n3, new SerializableRenderedImage(renderedImage, false));
            }
            ++n3;
        }
        return vector;
    }

    public Rectangle getBounds(Long l2) throws RemoteException {
        return RMIImageImpl.getSource(l2).getBounds();
    }

    public RasterProxy getTile(Long l2, int n2, int n3) throws RemoteException {
        return new RasterProxy(RMIImageImpl.getSource(l2).getTile(n2, n3));
    }

    public RasterProxy getData(Long l2) throws RemoteException {
        return new RasterProxy(RMIImageImpl.getSource(l2).getData());
    }

    public RasterProxy getData(Long l2, Rectangle rectangle) throws RemoteException {
        RasterProxy rasterProxy = null;
        if (rectangle == null) {
            rasterProxy = this.getData(l2);
        } else {
            rectangle = rectangle.intersection(this.getBounds(l2));
            rasterProxy = new RasterProxy(RMIImageImpl.getSource(l2).getData(rectangle));
        }
        return rasterProxy;
    }

    public RasterProxy copyData(Long l2, Rectangle rectangle) throws RemoteException {
        return this.getData(l2, rectangle);
    }

    public static void main(String[] stringArray) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String string = null;
        int n2 = 1099;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equalsIgnoreCase("-host")) {
                string = stringArray[++n3];
            } else if (stringArray[n3].equalsIgnoreCase("-port")) {
                n2 = Integer.parseInt(stringArray[++n3]);
            }
            ++n3;
        }
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(JaiI18N.getString("RMIImageImpl1") + unknownHostException.getMessage());
                unknownHostException.printStackTrace();
            }
        }
        System.out.println(JaiI18N.getString("RMIImageImpl3") + " " + string + ":" + n2);
        try {
            RMIImageImpl rMIImageImpl = new RMIImageImpl();
            String string2 = new String("rmi://" + string + ":" + n2 + "/" + "RemoteImageServer");
            System.out.println(JaiI18N.getString("RMIImageImpl4") + " \"" + string2 + "\".");
            Naming.rebind(string2, rMIImageImpl);
            System.out.println(JaiI18N.getString("RMIImageImpl5"));
        }
        catch (Exception exception) {
            System.err.println(JaiI18N.getString("RMIImageImpl0") + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

