/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.SerializableStateImpl;
import java.awt.RenderingHints;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.RasterFactory;

public class SampleModelState
extends SerializableStateImpl {
    private static final int TYPE_BANDED = 1;
    private static final int TYPE_PIXEL_INTERLEAVED = 2;
    private static final int TYPE_SINGLE_PIXEL_PACKED = 3;
    private static final int TYPE_MULTI_PIXEL_PACKED = 4;
    private static final int TYPE_COMPONENT_JAI = 5;
    private static final int TYPE_COMPONENT = 6;
    static /* synthetic */ Class class$java$awt$image$BandedSampleModel;
    static /* synthetic */ Class class$java$awt$image$PixelInterleavedSampleModel;
    static /* synthetic */ Class class$java$awt$image$ComponentSampleModel;
    static /* synthetic */ Class class$java$awt$image$MultiPixelPackedSampleModel;
    static /* synthetic */ Class class$java$awt$image$SinglePixelPackedSampleModel;
    static /* synthetic */ Class class$javax$media$jai$ComponentSampleModelJAI;
    static /* synthetic */ Class class$com$sun$media$jai$codecimpl$util$ComponentSampleModelJAI;

    public static Class[] getSupportedClasses() {
        return new Class[]{class$java$awt$image$BandedSampleModel == null ? (class$java$awt$image$BandedSampleModel = SampleModelState.class$("java.awt.image.BandedSampleModel")) : class$java$awt$image$BandedSampleModel, class$java$awt$image$PixelInterleavedSampleModel == null ? (class$java$awt$image$PixelInterleavedSampleModel = SampleModelState.class$("java.awt.image.PixelInterleavedSampleModel")) : class$java$awt$image$PixelInterleavedSampleModel, class$java$awt$image$ComponentSampleModel == null ? (class$java$awt$image$ComponentSampleModel = SampleModelState.class$("java.awt.image.ComponentSampleModel")) : class$java$awt$image$ComponentSampleModel, class$java$awt$image$MultiPixelPackedSampleModel == null ? (class$java$awt$image$MultiPixelPackedSampleModel = SampleModelState.class$("java.awt.image.MultiPixelPackedSampleModel")) : class$java$awt$image$MultiPixelPackedSampleModel, class$java$awt$image$SinglePixelPackedSampleModel == null ? (class$java$awt$image$SinglePixelPackedSampleModel = SampleModelState.class$("java.awt.image.SinglePixelPackedSampleModel")) : class$java$awt$image$SinglePixelPackedSampleModel, class$javax$media$jai$ComponentSampleModelJAI == null ? (class$javax$media$jai$ComponentSampleModelJAI = SampleModelState.class$("javax.media.jai.ComponentSampleModelJAI")) : class$javax$media$jai$ComponentSampleModelJAI, class$com$sun$media$jai$codecimpl$util$ComponentSampleModelJAI == null ? (class$com$sun$media$jai$codecimpl$util$ComponentSampleModelJAI = SampleModelState.class$("com.sun.media.jai.codecimpl.util.ComponentSampleModelJAI")) : class$com$sun$media$jai$codecimpl$util$ComponentSampleModelJAI};
    }

    public SampleModelState(Class clazz, Object object, RenderingHints renderingHints) {
        super(clazz, object, renderingHints);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        SampleModel sampleModel = (SampleModel)this.theObject;
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int n2 = 6;
            int n3 = componentSampleModel.getTransferType();
            if (sampleModel instanceof PixelInterleavedSampleModel) {
                n2 = 2;
            } else if (sampleModel instanceof BandedSampleModel) {
                n2 = 1;
            } else if (sampleModel instanceof ComponentSampleModelJAI || n3 == 4 || n3 == 5) {
                n2 = 5;
            }
            objectOutputStream.writeInt(n2);
            objectOutputStream.writeInt(n3);
            objectOutputStream.writeInt(componentSampleModel.getWidth());
            objectOutputStream.writeInt(componentSampleModel.getHeight());
            if (n2 != 1) {
                objectOutputStream.writeInt(componentSampleModel.getPixelStride());
            }
            objectOutputStream.writeInt(componentSampleModel.getScanlineStride());
            if (n2 != 2) {
                objectOutputStream.writeObject(componentSampleModel.getBankIndices());
            }
            objectOutputStream.writeObject(componentSampleModel.getBandOffsets());
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            objectOutputStream.writeInt(3);
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getTransferType());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getWidth());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getHeight());
            objectOutputStream.writeInt(singlePixelPackedSampleModel.getScanlineStride());
            objectOutputStream.writeObject(singlePixelPackedSampleModel.getBitMasks());
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            objectOutputStream.writeInt(4);
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getTransferType());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getWidth());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getHeight());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getPixelBitStride());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getScanlineStride());
            objectOutputStream.writeInt(multiPixelPackedSampleModel.getDataBitOffset());
        } else {
            throw new RuntimeException(JaiI18N.getString("SampleModelState0"));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        SampleModel sampleModel = null;
        int n2 = objectInputStream.readInt();
        switch (n2) {
            case 2: {
                sampleModel = RasterFactory.createPixelInterleavedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject());
                break;
            }
            case 1: {
                sampleModel = RasterFactory.createBandedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 5: {
                sampleModel = new ComponentSampleModelJAI(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 6: {
                sampleModel = new ComponentSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), (int[])objectInputStream.readObject());
                break;
            }
            case 3: {
                sampleModel = new SinglePixelPackedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject());
                break;
            }
            case 4: {
                sampleModel = new MultiPixelPackedSampleModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("SampleModelState0"));
            }
        }
        this.theObject = sampleModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

