/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public abstract class SerializableStateImpl
implements SerializableState {
    protected Class theClass;
    protected transient Object theObject;

    public static Class[] getSupportedClasses() {
        throw new RuntimeException(JaiI18N.getString("SerializableStateImpl0"));
    }

    public static boolean permitsSubclasses() {
        return false;
    }

    protected SerializableStateImpl(Class clazz, Object object, RenderingHints renderingHints) {
        if (clazz == null || object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl1"));
        }
        boolean bl2 = clazz.isInterface();
        if (bl2 && !clazz.isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl2"));
        }
        if (!bl2) {
            boolean bl3 = false;
            try {
                Method method = this.getClass().getMethod("permitsSubclasses", null);
                bl3 = (Boolean)method.invoke(null, null);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl5"));
            }
            if (!bl3 && !clazz.equals(object.getClass())) {
                throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl3"));
            }
            if (bl3 && !clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException(JaiI18N.getString("SerializableStateImpl4"));
            }
        }
        this.theClass = clazz;
        this.theObject = object;
    }

    public Class getObjectClass() {
        return this.theClass;
    }

    public Object getObject() {
        return this.theObject;
    }

    protected Object getSerializableForm(Object object) {
        if (object instanceof Serializable) {
            return object;
        }
        if (object != null) {
            try {
                object = SerializerFactory.getState(object, null);
            }
            catch (Exception exception) {
                object = null;
            }
        }
        return object;
    }

    protected Object getDeserializedFrom(Object object) {
        if (object instanceof SerializableState) {
            object = ((SerializableState)object).getObject();
        }
        return object;
    }
}

