/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.JaiI18N;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.UnpackedImageData;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class ImageUtil {
    private static final float FLOAT_MIN = -3.4028235E38f;
    private static long counter;
    public static final int BYTE_MASK = 255;
    public static final int USHORT_MASK = 65535;
    static /* synthetic */ Class class$java$awt$image$ColorModel;
    static /* synthetic */ Class class$java$awt$image$SampleModel;
    static /* synthetic */ Class class$com$sun$media$jai$util$ImageUtil;

    public static final byte clampByte(int n2) {
        return n2 > 255 ? (byte)-1 : (n2 >= 0 ? (byte)n2 : (byte)0);
    }

    public static final short clampUShort(int n2) {
        return n2 > 65535 ? (short)-1 : (n2 >= 0 ? (short)n2 : (short)0);
    }

    public static final short clampShort(int n2) {
        return (short)(n2 > Short.MAX_VALUE ? Short.MAX_VALUE : (n2 >= Short.MIN_VALUE ? (int)n2 : Short.MIN_VALUE));
    }

    public static final int clampInt(long l2) {
        return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l2 >= Integer.MIN_VALUE ? (int)l2 : Integer.MIN_VALUE);
    }

    public static final float clampFloat(double d2) {
        return d2 > 3.4028234663852886E38 ? Float.MAX_VALUE : (d2 >= -3.4028234663852886E38 ? (float)d2 : -3.4028235E38f);
    }

    public static final byte clampRoundByte(float f2) {
        return f2 > 255.0f ? (byte)-1 : (f2 >= 0.0f ? (byte)(f2 + 0.5f) : (byte)0);
    }

    public static final byte clampRoundByte(double d2) {
        return d2 > 255.0 ? (byte)-1 : (d2 >= 0.0 ? (byte)(d2 + 0.5) : (byte)0);
    }

    public static final short clampRoundUShort(float f2) {
        return f2 > 65535.0f ? (short)-1 : (f2 >= 0.0f ? (short)(f2 + 0.5f) : (short)0);
    }

    public static final short clampRoundUShort(double d2) {
        return d2 > 65535.0 ? (short)-1 : (d2 >= 0.0 ? (short)(d2 + 0.5) : (short)0);
    }

    public static final short clampRoundShort(float f2) {
        return (short)(f2 > 32767.0f ? Short.MAX_VALUE : (f2 >= -32768.0f ? (int)((int)Math.floor(f2 + 0.5f)) : Short.MIN_VALUE));
    }

    public static final short clampRoundShort(double d2) {
        return (short)(d2 > 32767.0 ? Short.MAX_VALUE : (d2 >= -32768.0 ? (int)((int)Math.floor(d2 + 0.5)) : Short.MIN_VALUE));
    }

    public static final int clampRoundInt(float f2) {
        return f2 > 2.1474836E9f ? Integer.MAX_VALUE : (f2 >= -2.1474836E9f ? (int)Math.floor(f2 + 0.5f) : Integer.MIN_VALUE);
    }

    public static final int clampRoundInt(double d2) {
        return d2 > 2.147483647E9 ? Integer.MAX_VALUE : (d2 >= -2.147483648E9 ? (int)Math.floor(d2 + 0.5) : Integer.MIN_VALUE);
    }

    public static final byte clampBytePositive(int n2) {
        return (byte)(n2 > 255 ? -1 : (byte)n2);
    }

    public static final byte clampByteNegative(int n2) {
        return n2 < 0 ? (byte)0 : (byte)n2;
    }

    public static final short clampUShortPositive(int n2) {
        return (short)(n2 > 65535 ? -1 : (short)n2);
    }

    public static final short clampUShortNegative(int n2) {
        return n2 < 0 ? (short)0 : (short)n2;
    }

    public static final void copyRaster(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n2 = rasterAccessor.getPixelStride();
        int n3 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getWidth() * n4;
        int n7 = rasterAccessor2.getHeight() * n5;
        int n8 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor.getByteDataArrays();
                byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
                int n9 = 0;
                while (n9 < n8) {
                    byte[] byArray3 = byArray[n9];
                    byte[] byArray4 = byArray2[n9];
                    int n10 = nArray2[n9] + n7;
                    int n11 = nArray2[n9];
                    int n12 = nArray[n9];
                    while (n11 < n10) {
                        int n13 = n11 + n6;
                        int n14 = n11;
                        int n15 = n12;
                        while (n14 < n13) {
                            byArray4[n14] = byArray3[n15];
                            n14 += n4;
                            n15 += n2;
                        }
                        n11 += n5;
                        n12 += n3;
                    }
                    ++n9;
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor.getShortDataArrays();
                short[][] sArray2 = rasterAccessor2.getShortDataArrays();
                int n16 = 0;
                while (n16 < n8) {
                    short[] sArray3 = sArray[n16];
                    short[] sArray4 = sArray2[n16];
                    int n17 = nArray2[n16] + n7;
                    int n18 = nArray2[n16];
                    int n19 = nArray[n16];
                    while (n18 < n17) {
                        int n20 = n18 + n6;
                        int n21 = n18;
                        int n22 = n19;
                        while (n21 < n20) {
                            sArray4[n21] = sArray3[n22];
                            n21 += n4;
                            n22 += n2;
                        }
                        n18 += n5;
                        n19 += n3;
                    }
                    ++n16;
                }
                break;
            }
            case 3: {
                int[][] nArray3 = rasterAccessor.getIntDataArrays();
                int[][] nArray4 = rasterAccessor2.getIntDataArrays();
                int n23 = 0;
                while (n23 < n8) {
                    int[] nArray5 = nArray3[n23];
                    int[] nArray6 = nArray4[n23];
                    int n24 = nArray2[n23] + n7;
                    int n25 = nArray2[n23];
                    int n26 = nArray[n23];
                    while (n25 < n24) {
                        int n27 = n25 + n6;
                        int n28 = n25;
                        int n29 = n26;
                        while (n28 < n27) {
                            nArray6[n28] = nArray5[n29];
                            n28 += n4;
                            n29 += n2;
                        }
                        n25 += n5;
                        n26 += n3;
                    }
                    ++n23;
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor.getFloatDataArrays();
                float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
                int n30 = 0;
                while (n30 < n8) {
                    float[] fArray3 = fArray[n30];
                    float[] fArray4 = fArray2[n30];
                    int n31 = nArray2[n30] + n7;
                    int n32 = nArray2[n30];
                    int n33 = nArray[n30];
                    while (n32 < n31) {
                        int n34 = n32 + n6;
                        int n35 = n32;
                        int n36 = n33;
                        while (n35 < n34) {
                            fArray4[n35] = fArray3[n36];
                            n35 += n4;
                            n36 += n2;
                        }
                        n32 += n5;
                        n33 += n3;
                    }
                    ++n30;
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor.getDoubleDataArrays();
                double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
                int n37 = 0;
                while (n37 < n8) {
                    double[] dArray3 = dArray[n37];
                    double[] dArray4 = dArray2[n37];
                    int n38 = nArray2[n37] + n7;
                    int n39 = nArray2[n37];
                    int n40 = nArray[n37];
                    while (n39 < n38) {
                        int n41 = n39 + n6;
                        int n42 = n39;
                        int n43 = n40;
                        while (n42 < n41) {
                            dArray4[n42] = dArray3[n43];
                            n42 += n4;
                            n43 += n2;
                        }
                        n39 += n5;
                        n40 += n3;
                    }
                    ++n37;
                }
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    public boolean areEqualSampleModels(SampleModel sampleModel, SampleModel sampleModel2) {
        if (sampleModel == sampleModel2) {
            return true;
        }
        if (sampleModel.getClass() == sampleModel2.getClass() && sampleModel.getDataType() == sampleModel2.getDataType() && sampleModel.getTransferType() == sampleModel2.getTransferType() && sampleModel.getWidth() == sampleModel2.getWidth() && sampleModel.getHeight() == sampleModel2.getHeight()) {
            if (sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)sampleModel2;
                return componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride() && Arrays.equals(componentSampleModel.getBankIndices(), componentSampleModel2.getBankIndices()) && Arrays.equals(componentSampleModel.getBandOffsets(), componentSampleModel2.getBandOffsets());
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
                return multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            }
            if (sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)sampleModel2;
                return singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride() && Arrays.equals(singlePixelPackedSampleModel.getBitMasks(), singlePixelPackedSampleModel2.getBitMasks());
            }
        }
        return false;
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n8 = rectangle.x;
                        int n9 = rectangle.y;
                        n7 = rectangle.width;
                        n6 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n10 = n8 - raster.getSampleModelTranslateX();
                        int n11 = n9 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n5 = multiPixelPackedSampleModel.getScanlineStride();
                        n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                        n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                        n2 = (n7 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n4 == 0 && n3 == 0 && n2 == n5 && ((DataBufferByte)dataBuffer).getData().length == n2 * n6) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n2 * n6];
                        int n12 = 0;
                        if (n3 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n13 = n2;
                        int n14 = 0;
                        int n15 = 0;
                        while (n15 < n6) {
                            System.arraycopy(byArray2, n4, byArray, n14, n13);
                            n14 += n13;
                            n4 += n5;
                            ++n15;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n16 = 0;
                    while (n16 < n6) {
                        int n17 = n7;
                        int n18 = n4;
                        while (n17 > 8) {
                            short s2 = sArray[n18++];
                            byArray[n12++] = (byte)(s2 >>> 8 & 0xFF);
                            byArray[n12++] = (byte)(s2 & 0xFF);
                            n17 -= 16;
                        }
                        if (n17 > 0) {
                            byArray[n12++] = (byte)(sArray[n18] >>> 8 & 0xFF);
                        }
                        n4 += n5;
                        ++n16;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n19 = 0;
                while (n19 < n6) {
                    int n20;
                    int n21 = n7;
                    int n22 = n4;
                    while (n21 > 24) {
                        n20 = nArray[n22++];
                        byArray[n12++] = (byte)(n20 >>> 24 & 0xFF);
                        byArray[n12++] = (byte)(n20 >>> 16 & 0xFF);
                        byArray[n12++] = (byte)(n20 >>> 8 & 0xFF);
                        byArray[n12++] = (byte)(n20 & 0xFF);
                        n21 -= 32;
                    }
                    n20 = 24;
                    while (n21 > 0) {
                        byArray[n12++] = (byte)(nArray[n22] >>> n20 & 0xFF);
                        n20 -= 8;
                        n21 -= 8;
                    }
                    n4 += n5;
                    ++n19;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n3 & 7) == 0) {
                    int n23 = n2;
                    int n24 = 0;
                    int n25 = 0;
                    while (n25 < n6) {
                        System.arraycopy(byArray3, n4, byArray, n24, n23);
                        n24 += n23;
                        n4 += n5;
                        ++n25;
                    }
                } else {
                    int n26 = n3 & 7;
                    int n27 = 8 - n26;
                    int n28 = 0;
                    while (n28 < n6) {
                        int n29 = n4;
                        int n30 = n7;
                        while (n30 > 0) {
                            byArray[n12++] = n30 > n27 ? (byte)((byArray3[n29++] & 0xFF) << n26 | (byArray3[n29] & 0xFF) >>> n27) : (byte)((byArray3[n29] & 0xFF) << n26);
                            n30 -= 8;
                        }
                        n4 += n5;
                        ++n28;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n31 = 0;
                while (n31 < n6) {
                    int n32 = n3;
                    int n33 = 0;
                    while (n33 < n7) {
                        int n34 = n4 + n32 / 16;
                        int n35 = n32 % 16;
                        int n36 = sArray[n34] & 0xFFFF;
                        if (n35 <= 8) {
                            byArray[n12++] = (byte)(n36 >>> 8 - n35);
                        } else {
                            int n37 = n35 - 8;
                            int n38 = sArray[n34 + 1] & 0xFFFF;
                            byArray[n12++] = (byte)(n36 << n37 | n38 >>> 16 - n37);
                        }
                        n33 += 8;
                        n32 += 8;
                    }
                    n4 += n5;
                    ++n31;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n39 = 0;
                while (n39 < n6) {
                    int n40 = n3;
                    int n41 = 0;
                    while (n41 < n7) {
                        int n42 = n4 + n40 / 32;
                        int n43 = n40 % 32;
                        int n44 = nArray[n42];
                        if (n43 <= 24) {
                            byArray[n12++] = (byte)(n44 >>> 24 - n43);
                        } else {
                            int n45 = n43 - 24;
                            int n46 = nArray[n42 + 1];
                            byArray[n12++] = (byte)(n44 << n45 | n46 >>> 32 - n45);
                        }
                        n41 += 8;
                        n40 += 8;
                    }
                    n4 += n5;
                    ++n39;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            DataBuffer dataBuffer;
            int n7;
            int n8;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    n8 = rectangle.x;
                    n7 = rectangle.y;
                    int n9 = rectangle.width;
                    int n10 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n11 = n8 - raster.getSampleModelTranslateX();
                    int n12 = n7 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n6 = multiPixelPackedSampleModel.getScanlineStride();
                    n5 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n11, n12);
                    n4 = multiPixelPackedSampleModel.getBitOffset(n11);
                    byArray = new byte[n9 * n10];
                    n3 = n7 + n10;
                    n2 = n8 + n9;
                    int n13 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n14 = n7;
                    while (n14 < n3) {
                        int n15 = n5 * 8 + n4;
                        int n16 = n8;
                        while (n16 < n2) {
                            byte by2 = byArray2[n15 / 8];
                            byArray[n13++] = (byte)(by2 >>> (7 - n15 & 7) & 1);
                            ++n15;
                            ++n16;
                        }
                        n5 += n6;
                        ++n14;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n17 = n7;
                while (n17 < n3) {
                    int n18 = n5 * 16 + n4;
                    int n19 = n8;
                    while (n19 < n2) {
                        short s2 = sArray[n18 / 16];
                        byArray[n13++] = (byte)(s2 >>> 15 - n18 % 16 & 1);
                        ++n18;
                        ++n19;
                    }
                    n5 += n6;
                    ++n17;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n20 = n7;
            while (n20 < n3) {
                int n21 = n5 * 32 + n4;
                int n22 = n8;
                while (n22 < n2) {
                    int n23 = nArray[n21 / 32];
                    byArray[n13++] = (byte)(n23 >>> 31 - n21 % 32 & 1);
                    ++n21;
                    ++n22;
                }
                n5 += n6;
                ++n20;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block43: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block41: {
                block44: {
                    block42: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                        }
                        int n8 = rectangle.x;
                        int n9 = rectangle.y;
                        n7 = rectangle.width;
                        n6 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n10 = n8 - writableRaster.getSampleModelTranslateX();
                        int n11 = n9 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n5 = multiPixelPackedSampleModel.getScanlineStride();
                        n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                        n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                        n2 = 0;
                        if (n3 != 0) break block41;
                        if (!(dataBuffer instanceof DataBufferByte)) break block42;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n12 = (n7 + 7) / 8;
                        int n13 = 0;
                        int n14 = 0;
                        while (n14 < n6) {
                            System.arraycopy(byArray, n13, byArray2, n4, n12);
                            n13 += n12;
                            n4 += n5;
                            ++n14;
                        }
                        break block43;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block44;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    int n15 = 0;
                    while (n15 < n6) {
                        int n16 = n7;
                        int n17 = n4;
                        while (n16 > 8) {
                            sArray[n17++] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
                            n16 -= 16;
                        }
                        if (n16 > 0) {
                            sArray[n17++] = (short)((byArray[n2++] & 0xFF) << 8);
                        }
                        n4 += n5;
                        ++n15;
                    }
                    break block43;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block43;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n18 = 0;
                while (n18 < n6) {
                    int n19 = n7;
                    int n20 = n4;
                    while (n19 > 24) {
                        nArray[n20++] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                        n19 -= 32;
                    }
                    int n21 = 24;
                    while (n19 > 0) {
                        int n22 = n20;
                        nArray[n22] = nArray[n22] | (byArray[n2++] & 0xFF) << n21;
                        n21 -= 8;
                        n19 -= 8;
                    }
                    n4 += n5;
                    ++n18;
                }
                break block43;
            }
            int n23 = (n7 + 7) / 8;
            int n24 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n3 & 7) == 0) {
                    int n25 = 0;
                    while (n25 < n6) {
                        System.arraycopy(byArray, n24, byArray3, n4, n23);
                        n24 += n23;
                        n4 += n5;
                        ++n25;
                    }
                } else {
                    int n26 = n3 & 7;
                    int n27 = 8 - n26;
                    int n28 = 8 + n27;
                    byte by2 = (byte)(255 << n27);
                    byte by3 = ~by2;
                    int n29 = 0;
                    while (n29 < n6) {
                        int n30 = n4;
                        int n31 = n7;
                        while (n31 > 0) {
                            byte by4 = byArray[n2++];
                            if (n31 > n28) {
                                byArray3[n30] = (byte)(byArray3[n30] & by2 | (by4 & 0xFF) >>> n26);
                                byArray3[++n30] = (byte)((by4 & 0xFF) << n27);
                            } else if (n31 > n27) {
                                byArray3[n30] = (byte)(byArray3[n30] & by2 | (by4 & 0xFF) >>> n26);
                                byArray3[++n30] = (byte)(byArray3[n30] & by3 | (by4 & 0xFF) << n27);
                            } else {
                                int n32 = (1 << n27 - n31) - 1;
                                byArray3[n30] = (byte)(byArray3[n30] & (by2 | n32) | (by4 & 0xFF) >>> n26 & ~n32);
                            }
                            n31 -= 8;
                        }
                        n4 += n5;
                        ++n29;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n33 = n3 & 7;
                int n34 = 8 - n33;
                int n35 = 16 + n34;
                short s2 = (short)(~(255 << n34));
                short s3 = (short)(65535 << n34);
                short s4 = ~s3;
                int n36 = 0;
                while (n36 < n6) {
                    int n37 = n3;
                    int n38 = n7;
                    int n39 = 0;
                    while (n39 < n7) {
                        int n40 = n4 + (n37 >> 4);
                        int n41 = n37 & 0xF;
                        int n42 = byArray[n2++] & 0xFF;
                        if (n41 <= 8) {
                            if (n38 < 8) {
                                n42 &= 255 << 8 - n38;
                            }
                            sArray[n40] = (short)(sArray[n40] & s2 | n42 << n34);
                        } else if (n38 > n35) {
                            sArray[n40] = (short)(sArray[n40] & s3 | n42 >>> n33 & 0xFFFF);
                            sArray[++n40] = (short)(n42 << n34 & 0xFFFF);
                        } else if (n38 > n34) {
                            sArray[n40] = (short)(sArray[n40] & s3 | n42 >>> n33 & 0xFFFF);
                            sArray[++n40] = (short)(sArray[n40] & s4 | n42 << n34 & 0xFFFF);
                        } else {
                            int n43 = (1 << n34 - n38) - 1;
                            sArray[n40] = (short)(sArray[n40] & (s3 | n43) | n42 >>> n33 & 0xFFFF & ~n43);
                        }
                        n39 += 8;
                        n37 += 8;
                        n38 -= 8;
                    }
                    n4 += n5;
                    ++n36;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n44 = n3 & 7;
                int n45 = 8 - n44;
                int n46 = 32 + n45;
                int n47 = -1 << n45;
                int n48 = ~n47;
                int n49 = 0;
                while (n49 < n6) {
                    int n50 = n3;
                    int n51 = n7;
                    int n52 = 0;
                    while (n52 < n7) {
                        int n53;
                        int n54 = n4 + (n50 >> 5);
                        int n55 = n50 & 0x1F;
                        int n56 = byArray[n2++] & 0xFF;
                        if (n55 <= 24) {
                            n53 = 24 - n55;
                            if (n51 < 8) {
                                n56 &= 255 << 8 - n51;
                            }
                            nArray[n54] = nArray[n54] & ~(255 << n53) | n56 << n53;
                        } else if (n51 > n46) {
                            nArray[n54] = nArray[n54] & n47 | n56 >>> n44;
                            nArray[++n54] = n56 << n45;
                        } else if (n51 > n45) {
                            nArray[n54] = nArray[n54] & n47 | n56 >>> n44;
                            nArray[++n54] = nArray[n54] & n48 | n56 << n45;
                        } else {
                            n53 = (1 << n45 - n51) - 1;
                            nArray[n54] = nArray[n54] & (n47 | n53) | n56 >>> n44 & ~n53;
                        }
                        n52 += 8;
                        n50 += 8;
                        n51 -= 8;
                    }
                    n4 += n5;
                    ++n49;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            int n6;
            int n7;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(JaiI18N.getString("ImageUtil0"));
                    }
                    int n8 = rectangle.x;
                    int n9 = rectangle.y;
                    n7 = rectangle.width;
                    n6 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n10 = n8 - writableRaster.getSampleModelTranslateX();
                    int n11 = n9 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    n2 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    int n12 = 0;
                    while (n12 < n6) {
                        int n13 = n4 * 8 + n3;
                        int n14 = 0;
                        while (n14 < n7) {
                            if (byArray[n2++] != 0) {
                                int n15 = n13 / 8;
                                byArray2[n15] = (byte)(byArray2[n15] | (byte)(1 << (7 - n13 & 7)));
                            }
                            ++n13;
                            ++n14;
                        }
                        n4 += n5;
                        ++n12;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n16 = 0;
                while (n16 < n6) {
                    int n17 = n4 * 16 + n3;
                    int n18 = 0;
                    while (n18 < n7) {
                        if (byArray[n2++] != 0) {
                            int n19 = n17 / 16;
                            sArray[n19] = (short)(sArray[n19] | (short)(1 << 15 - n17 % 16));
                        }
                        ++n17;
                        ++n18;
                    }
                    n4 += n5;
                    ++n16;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            int n20 = 0;
            while (n20 < n6) {
                int n21 = n4 * 32 + n3;
                int n22 = 0;
                while (n22 < n7) {
                    if (byArray[n2++] != 0) {
                        int n23 = n21 / 32;
                        nArray[n23] = nArray[n23] | 1 << 31 - n21 % 32;
                    }
                    ++n21;
                    ++n22;
                }
                n4 += n5;
                ++n20;
            }
        }
    }

    public static void fillBackground(WritableRaster writableRaster, Rectangle rectangle, double[] dArray) {
        block41: {
            PixelAccessor pixelAccessor;
            block40: {
                rectangle = rectangle.intersection(writableRaster.getBounds());
                int n2 = writableRaster.getSampleModel().getNumBands();
                SampleModel sampleModel = writableRaster.getSampleModel();
                pixelAccessor = new PixelAccessor(sampleModel, null);
                if (!ImageUtil.isBinary(sampleModel)) break block40;
                byte by2 = (byte)((int)dArray[0] & 1);
                if (by2 == 0) {
                    return;
                }
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                int n5 = rectangle.width;
                int n6 = rectangle.height;
                int n7 = n3 - writableRaster.getSampleModelTranslateX();
                int n8 = n4 - writableRaster.getSampleModelTranslateY();
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                int n9 = multiPixelPackedSampleModel.getScanlineStride();
                int n10 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n7, n8);
                int n11 = multiPixelPackedSampleModel.getBitOffset(n7);
                switch (sampleModel.getDataType()) {
                    case 0: {
                        byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                        int n12 = n11 & 7;
                        int n13 = n12 == 0 ? 0 : 8 - n12;
                        byte by3 = (byte)(255 >> n12);
                        int n14 = (n5 - n13) / 8;
                        int n15 = n5 - n13 & 7;
                        byte by4 = (byte)(255 << 8 - n15);
                        int n16 = 0;
                        while (n16 < n6) {
                            int n17 = n10;
                            if (n12 != 0) {
                                byArray[n17++] = by3;
                            }
                            int n18 = n17 + n14;
                            while (n17 < n18) {
                                byArray[n17++] = -1;
                            }
                            if (n15 != 0) {
                                byArray[n17++] = by4;
                            }
                            n10 += n9;
                            ++n16;
                        }
                        break block41;
                    }
                    case 1: 
                    case 2: {
                        short[] sArray = ((DataBufferShort)dataBuffer).getData();
                        int n19 = n11 & 0xF;
                        int n20 = n19 == 0 ? 0 : 16 - n19;
                        short s2 = (short)(65535 >> n19);
                        int n21 = (n5 - n20) / 16;
                        int n22 = n5 - n20 & 0xF;
                        short s3 = (short)(65535 << 16 - n22);
                        int n23 = 0;
                        while (n23 < n6) {
                            int n24 = n10;
                            if (n19 != 0) {
                                sArray[n24++] = s2;
                            }
                            int n25 = n24 + n21;
                            while (n24 < n25) {
                                sArray[n24++] = -1;
                            }
                            if (n22 != 0) {
                                sArray[n24++] = s3;
                            }
                            n10 += n9;
                            ++n23;
                        }
                        break block41;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n26 = n11 & 0x1F;
                        int n27 = n26 == 0 ? 0 : 32 - n26;
                        short s4 = (short)(-1 >> n26);
                        int n28 = (n5 - n27) / 32;
                        int n29 = n5 - n27 & 0x1F;
                        short s5 = (short)(-1 << 32 - n29);
                        int n30 = 0;
                        while (n30 < n6) {
                            int n31 = n10;
                            if (n26 != 0) {
                                nArray[n31++] = s4;
                            }
                            int n32 = n31 + n28;
                            while (n31 < n32) {
                                nArray[n31++] = -1;
                            }
                            if (n29 != 0) {
                                nArray[n31++] = s5;
                            }
                            n10 += n9;
                            ++n30;
                        }
                        break block41;
                    }
                }
                break block41;
            }
            int n33 = pixelAccessor.sampleType == -1 ? 0 : pixelAccessor.sampleType;
            UnpackedImageData unpackedImageData = pixelAccessor.getPixels(writableRaster, rectangle, n33, false);
            rectangle = unpackedImageData.rect;
            int n34 = unpackedImageData.lineStride;
            int n35 = unpackedImageData.pixelStride;
            switch (unpackedImageData.type) {
                case 0: {
                    byte[][] byArray = unpackedImageData.getByteData();
                    int n36 = 0;
                    while (n36 < pixelAccessor.numBands) {
                        byte by5 = (byte)dArray[n36];
                        byte[] byArray2 = byArray[n36];
                        int n37 = unpackedImageData.bandOffsets[n36] + rectangle.height * n34;
                        int n38 = unpackedImageData.bandOffsets[n36];
                        while (n38 < n37) {
                            int n39 = n38 + rectangle.width * n35;
                            int n40 = n38;
                            while (n40 < n39) {
                                byArray2[n40] = by5;
                                n40 += n35;
                            }
                            n38 += n34;
                        }
                        ++n36;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = unpackedImageData.getShortData();
                    int n41 = 0;
                    while (n41 < pixelAccessor.numBands) {
                        short s6 = (short)dArray[n41];
                        short[] sArray2 = sArray[n41];
                        int n42 = unpackedImageData.bandOffsets[n41] + rectangle.height * n34;
                        int n43 = unpackedImageData.bandOffsets[n41];
                        while (n43 < n42) {
                            int n44 = n43 + rectangle.width * n35;
                            int n45 = n43;
                            while (n45 < n44) {
                                sArray2[n45] = s6;
                                n45 += n35;
                            }
                            n43 += n34;
                        }
                        ++n41;
                    }
                    break;
                }
                case 3: {
                    int[][] nArray = unpackedImageData.getIntData();
                    int n46 = 0;
                    while (n46 < pixelAccessor.numBands) {
                        int n47 = (int)dArray[n46];
                        int[] nArray2 = nArray[n46];
                        int n48 = unpackedImageData.bandOffsets[n46] + rectangle.height * n34;
                        int n49 = unpackedImageData.bandOffsets[n46];
                        while (n49 < n48) {
                            int n50 = n49 + rectangle.width * n35;
                            int n51 = n49;
                            while (n51 < n50) {
                                nArray2[n51] = n47;
                                n51 += n35;
                            }
                            n49 += n34;
                        }
                        ++n46;
                    }
                    break;
                }
                case 4: {
                    float[][] fArray = unpackedImageData.getFloatData();
                    int n52 = 0;
                    while (n52 < pixelAccessor.numBands) {
                        float f2 = (float)dArray[n52];
                        float[] fArray2 = fArray[n52];
                        int n53 = unpackedImageData.bandOffsets[n52] + rectangle.height * n34;
                        int n54 = unpackedImageData.bandOffsets[n52];
                        while (n54 < n53) {
                            int n55 = n54 + rectangle.width * n35;
                            int n56 = n54;
                            while (n56 < n55) {
                                fArray2[n56] = f2;
                                n56 += n35;
                            }
                            n54 += n34;
                        }
                        ++n52;
                    }
                    break;
                }
                case 5: {
                    double[][] dArray2 = unpackedImageData.getDoubleData();
                    int n57 = 0;
                    while (n57 < pixelAccessor.numBands) {
                        double d2 = dArray[n57];
                        double[] dArray3 = dArray2[n57];
                        int n58 = unpackedImageData.bandOffsets[n57] + rectangle.height * n34;
                        int n59 = unpackedImageData.bandOffsets[n57];
                        while (n59 < n58) {
                            int n60 = n59 + rectangle.width * n35;
                            int n61 = n59;
                            while (n61 < n60) {
                                dArray3[n61] = d2;
                                n61 += n35;
                            }
                            n59 += n34;
                        }
                        ++n57;
                    }
                    break;
                }
            }
        }
    }

    public static void fillBordersWithBackgroundValues(Rectangle rectangle, Rectangle rectangle2, WritableRaster writableRaster, double[] dArray) {
        Rectangle rectangle3;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        int n4 = rectangle2.x + rectangle2.width;
        int n5 = rectangle2.y + rectangle2.height;
        if (rectangle.x < rectangle2.x) {
            rectangle3 = new Rectangle(rectangle.x, rectangle2.y, rectangle2.x - rectangle.x, n3 - rectangle2.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (rectangle.y < rectangle2.y) {
            rectangle3 = new Rectangle(rectangle.x, rectangle.y, n4 - rectangle.x, rectangle2.y - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n2 > n4) {
            rectangle3 = new Rectangle(n4, rectangle.y, n2 - n4, n5 - rectangle.y);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
        if (n3 > n5) {
            rectangle3 = new Rectangle(rectangle2.x, n5, n2 - rectangle2.x, n3 - n5);
            ImageUtil.fillBackground(writableRaster, rectangle3, dArray);
        }
    }

    public static KernelJAI getUnsharpMaskEquivalentKernel(KernelJAI kernelJAI, float f2) {
        int n2 = kernelJAI.getWidth();
        int n3 = kernelJAI.getHeight();
        int n4 = kernelJAI.getXOrigin();
        int n5 = kernelJAI.getYOrigin();
        float[] fArray = kernelJAI.getKernelData();
        float[] fArray2 = new float[fArray.length];
        int n6 = 0;
        while (n6 < n2 * n3) {
            fArray2[n6] = -f2 * fArray[n6];
            ++n6;
        }
        n6 = n5 * n2 + n4;
        fArray2[n6] = 1.0f + f2 * (1.0f - fArray[n6]);
        return new KernelJAI(n2, n3, n4, n5, fArray2);
    }

    public static final Point[] getTileIndices(int n2, int n3, int n4, int n5) {
        if (n2 > n3 || n4 > n5) {
            return null;
        }
        Point[] pointArray = new Point[(n3 - n2 + 1) * (n5 - n4 + 1)];
        int n6 = 0;
        int n7 = n4;
        while (n7 <= n5) {
            int n8 = n2;
            while (n8 <= n3) {
                pointArray[n6++] = new Point(n8, n7);
                ++n8;
            }
            ++n7;
        }
        return pointArray;
    }

    public static Vector evaluateParameters(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException();
        }
        Vector vector2 = vector;
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = vector.get(n3);
            if (e2 instanceof DeferredData) {
                if (vector2 == vector) {
                    vector2 = (Vector)vector.clone();
                }
                vector2.set(n3, ((DeferredData)e2).getData());
            }
            ++n3;
        }
        return vector2;
    }

    public static ParameterBlock evaluateParameters(ParameterBlock parameterBlock) {
        if (parameterBlock == null) {
            throw new IllegalArgumentException();
        }
        Vector<Object> vector = parameterBlock.getParameters();
        Vector vector2 = ImageUtil.evaluateParameters(vector);
        return vector2 == vector ? parameterBlock : new ParameterBlock(parameterBlock.getSources(), vector2);
    }

    public static ColorModel getCompatibleColorModel(SampleModel sampleModel, Map map) {
        ColorModel colorModel = null;
        if (map == null || !Boolean.FALSE.equals(map.get(JAI.KEY_DEFAULT_COLOR_MODEL_ENABLED))) {
            if (map != null && map.containsKey(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD)) {
                Method method = (Method)map.get(JAI.KEY_DEFAULT_COLOR_MODEL_METHOD);
                Class<?>[] classArray = method.getParameterTypes();
                if ((method.getModifiers() & 8) != 8) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil1"));
                }
                if (method.getReturnType() != (class$java$awt$image$ColorModel == null ? (class$java$awt$image$ColorModel = ImageUtil.class$("java.awt.image.ColorModel")) : class$java$awt$image$ColorModel)) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil2"));
                }
                if (classArray.length != 1 || !classArray[0].equals(class$java$awt$image$SampleModel == null ? (class$java$awt$image$SampleModel = ImageUtil.class$("java.awt.image.SampleModel")) : class$java$awt$image$SampleModel)) {
                    throw new RuntimeException(JaiI18N.getString("ImageUtil3"));
                }
                try {
                    Object[] objectArray = new Object[]{sampleModel};
                    colorModel = (ColorModel)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    String string = JaiI18N.getString("ImageUtil4") + method.getName();
                    ImageUtil.sendExceptionToListener(string, new ImagingException(string, exception));
                }
            } else {
                colorModel = PlanarImage.createColorModel(sampleModel);
            }
        }
        return colorModel;
    }

    public static String getStackTraceString(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static ImagingListener getImagingListener(RenderingHints renderingHints) {
        ImagingListener imagingListener = null;
        if (renderingHints != null) {
            imagingListener = (ImagingListener)renderingHints.get(JAI.KEY_IMAGING_LISTENER);
        }
        if (imagingListener == null) {
            imagingListener = JAI.getDefaultInstance().getImagingListener();
        }
        return imagingListener;
    }

    public static ImagingListener getImagingListener(RenderContext renderContext) {
        return ImageUtil.getImagingListener(renderContext.getRenderingHints());
    }

    public static synchronized Object generateID(Object object) {
        Class<?> clazz = object.getClass();
        ++counter;
        byte[] byArray = new byte[32];
        int n2 = 0;
        int n3 = 7;
        int n4 = 0;
        while (n3 >= 0) {
            byArray[n2++] = (byte)(counter >> n4);
            --n3;
            n4 += 8;
        }
        int n5 = clazz.hashCode();
        int n6 = 3;
        int n7 = 0;
        while (n6 >= 0) {
            byArray[n2++] = (byte)(n5 >> n7);
            --n6;
            n7 += 8;
        }
        n5 = object.hashCode();
        int n8 = 3;
        int n9 = 0;
        while (n8 >= 0) {
            byArray[n2++] = (byte)(n5 >> n9);
            --n8;
            n9 += 8;
        }
        long l2 = System.currentTimeMillis();
        int n10 = 7;
        int n11 = 0;
        while (n10 >= 0) {
            byArray[n2++] = (byte)(l2 >> n11);
            --n10;
            n11 += 8;
        }
        long l3 = Double.doubleToLongBits(new Double(Math.random()));
        int n12 = 7;
        int n13 = 0;
        while (n12 >= 0) {
            byArray[n2++] = (byte)(l3 >> n13);
            --n12;
            n13 += 8;
        }
        return new BigInteger(byArray);
    }

    static void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, exception, class$com$sun$media$jai$util$ImageUtil == null ? (class$com$sun$media$jai$util$ImageUtil = ImageUtil.class$("com.sun.media.jai.util.ImageUtil")) : class$com$sun$media$jai$util$ImageUtil, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

