/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.util.Random;

public class PolyWarpSolver {
    private static Random myRandom = new Random(0L);
    private static double[] c0 = new double[6];
    private static double[] c1 = new double[6];
    private static double noise = 0.0;

    private static double sign(double d2, double d3) {
        d2 = Math.abs(d2);
        if (d3 >= 0.0) {
            return d2;
        }
        return -d2;
    }

    private static final double square(double d2) {
        return d2 * d2;
    }

    private static final double sqrt(double d2) {
        return Math.sqrt(d2);
    }

    private static final double hypot(double d2, double d3) {
        double d4;
        double d5 = Math.abs(d2);
        if (d5 > (d4 = Math.abs(d3))) {
            return d5 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d4 / d5) + 1.0);
        }
        if (d4 != 0.0) {
            return d4 * PolyWarpSolver.sqrt(PolyWarpSolver.square(d5 / d4) + 1.0);
        }
        return d5;
    }

    public static double[][] matmul_t(double[][] dArray, double[][] dArray2) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray2[0].length;
        int n5 = dArray2.length;
        double[][] dArray3 = new double[n2][n5];
        int n6 = 0;
        while (n6 < n2) {
            double[] dArray4 = dArray3[n6];
            double[] dArray5 = dArray[n6];
            int n7 = 0;
            while (n7 < n5) {
                double d2 = 0.0;
                int n8 = 0;
                while (n8 < n3) {
                    d2 += dArray5[n8] * dArray2[n7][n8];
                    ++n8;
                }
                dArray4[n7] = d2;
                ++n7;
            }
            ++n6;
        }
        return dArray3;
    }

    private static boolean SVD(double[][] dArray, double[] dArray2, double[][] dArray3, double[][] dArray4) {
        double d2;
        double d3;
        int n2;
        double d4;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = dArray.length;
        int n7 = dArray[0].length;
        double[] dArray5 = new double[n7];
        int n8 = 0;
        while (n8 < n6) {
            n3 = 0;
            while (n3 < n7) {
                dArray3[n8][n3] = dArray[n8][n3];
                ++n3;
            }
            ++n8;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        n8 = 0;
        while (n8 < n7) {
            n4 = n8 + 1;
            dArray5[n8] = d6 * d5;
            d5 = 0.0;
            d4 = 0.0;
            d6 = 0.0;
            if (n8 < n6) {
                n2 = n8;
                while (n2 < n6) {
                    d6 += Math.abs(dArray3[n2][n8]);
                    ++n2;
                }
                if (d6 != 0.0) {
                    n2 = n8;
                    while (n2 < n6) {
                        double[] dArray6 = dArray3[n2];
                        int n9 = n8;
                        dArray6[n9] = dArray6[n9] / d6;
                        d4 += PolyWarpSolver.square(dArray3[n2][n8]);
                        ++n2;
                    }
                    d3 = dArray3[n8][n8];
                    d5 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d4), d3);
                    d2 = d3 * d5 - d4;
                    dArray3[n8][n8] = d3 - d5;
                    n3 = n4;
                    while (n3 < n7) {
                        d4 = 0.0;
                        n2 = n8;
                        while (n2 < n6) {
                            d4 += dArray3[n2][n8] * dArray3[n2][n3];
                            ++n2;
                        }
                        d3 = d4 / d2;
                        n2 = n8;
                        while (n2 < n6) {
                            double[] dArray7 = dArray3[n2];
                            int n10 = n3;
                            dArray7[n10] = dArray7[n10] + d3 * dArray3[n2][n8];
                            ++n2;
                        }
                        ++n3;
                    }
                    n2 = n8;
                    while (n2 < n6) {
                        double[] dArray8 = dArray3[n2];
                        int n11 = n8;
                        dArray8[n11] = dArray8[n11] * d6;
                        ++n2;
                    }
                }
            }
            dArray2[n8] = d6 * d5;
            d5 = 0.0;
            d4 = 0.0;
            d6 = 0.0;
            if (n8 < n6 && n8 != n7 - 1) {
                n2 = n4;
                while (n2 < n7) {
                    d6 += Math.abs(dArray3[n8][n2]);
                    ++n2;
                }
                if (d6 != 0.0) {
                    n2 = n4;
                    while (n2 < n7) {
                        double[] dArray9 = dArray3[n8];
                        int n12 = n2;
                        dArray9[n12] = dArray9[n12] / d6;
                        d4 += PolyWarpSolver.square(dArray3[n8][n2]);
                        ++n2;
                    }
                    d3 = dArray3[n8][n4];
                    d5 = -PolyWarpSolver.sign(PolyWarpSolver.sqrt(d4), d3);
                    d2 = d3 * d5 - d4;
                    dArray3[n8][n4] = d3 - d5;
                    n2 = n4;
                    while (n2 < n7) {
                        dArray5[n2] = dArray3[n8][n2] / d2;
                        ++n2;
                    }
                    n3 = n4;
                    while (n3 < n6) {
                        d4 = 0.0;
                        n2 = n4;
                        while (n2 < n7) {
                            d4 += dArray3[n3][n2] * dArray3[n8][n2];
                            ++n2;
                        }
                        n2 = n4;
                        while (n2 < n7) {
                            double[] dArray10 = dArray3[n3];
                            int n13 = n2;
                            dArray10[n13] = dArray10[n13] + d4 * dArray5[n2];
                            ++n2;
                        }
                        ++n3;
                    }
                    n2 = n4;
                    while (n2 < n7) {
                        double[] dArray11 = dArray3[n8];
                        int n14 = n2++;
                        dArray11[n14] = dArray11[n14] * d6;
                    }
                }
            }
            d7 = Math.max(d7, Math.abs(dArray2[n8]) + Math.abs(dArray5[n8]));
            ++n8;
        }
        n8 = n7 - 1;
        while (n8 >= 0) {
            if (n8 != n7 - 1) {
                if (d5 != 0.0) {
                    n3 = n4;
                    while (n3 < n7) {
                        dArray4[n3][n8] = dArray3[n8][n3] / dArray3[n8][n4] / d5;
                        ++n3;
                    }
                    n3 = n4;
                    while (n3 < n7) {
                        d4 = 0.0;
                        n2 = n4;
                        while (n2 < n7) {
                            d4 += dArray3[n8][n2] * dArray4[n2][n3];
                            ++n2;
                        }
                        n2 = n4;
                        while (n2 < n7) {
                            double[] dArray12 = dArray4[n2];
                            int n15 = n3;
                            dArray12[n15] = dArray12[n15] + d4 * dArray4[n2][n8];
                            ++n2;
                        }
                        ++n3;
                    }
                }
                n3 = n4;
                while (n3 < n7) {
                    dArray4[n3][n8] = 0.0;
                    dArray4[n8][n3] = 0.0;
                    ++n3;
                }
            }
            dArray4[n8][n8] = 1.0;
            d5 = dArray5[n8];
            n4 = n8--;
        }
        int n16 = Math.min(n6, n7);
        n8 = n16 - 1;
        while (n8 >= 0) {
            n4 = n8 + 1;
            d5 = dArray2[n8];
            if (n8 != n7 - 1) {
                n3 = n4;
                while (n3 < n7) {
                    dArray3[n8][n3] = 0.0;
                    ++n3;
                }
            }
            if (d5 != 0.0) {
                if (n8 != n16 - 1) {
                    n3 = n4;
                    while (n3 < n7) {
                        d4 = 0.0;
                        n2 = n4;
                        while (n2 < n6) {
                            d4 += dArray3[n2][n8] * dArray3[n2][n3];
                            ++n2;
                        }
                        d3 = d4 / dArray3[n8][n8] / d5;
                        n2 = n8;
                        while (n2 < n6) {
                            double[] dArray13 = dArray3[n2];
                            int n17 = n3;
                            dArray13[n17] = dArray13[n17] + d3 * dArray3[n2][n8];
                            ++n2;
                        }
                        ++n3;
                    }
                }
                n3 = n8;
                while (n3 < n6) {
                    double[] dArray14 = dArray3[n3];
                    int n18 = n8;
                    dArray14[n18] = dArray14[n18] / d5;
                    ++n3;
                }
            } else {
                n3 = n8;
                while (n3 < n6) {
                    dArray3[n3][n8] = 0.0;
                    ++n3;
                }
            }
            double[] dArray15 = dArray3[n8];
            int n19 = n8--;
            dArray15[n19] = dArray15[n19] + 1.0;
        }
        double d8 = d7;
        n2 = n7 - 1;
        while (n2 >= 0) {
            int n20 = n2 - 1;
            int n21 = 0;
            while (true) {
                double d9;
                double d10;
                double d11;
                double d12;
                boolean bl2 = true;
                n4 = n2;
                while (n4 >= 0) {
                    n5 = n4 - 1;
                    d12 = d8 + Math.abs(dArray5[n4]);
                    if (d12 == d8) {
                        bl2 = false;
                        break;
                    }
                    d12 = d8 + Math.abs(dArray2[n5]);
                    if (d12 == d8) {
                        bl2 = true;
                        break;
                    }
                    --n4;
                }
                if (bl2) {
                    d11 = 0.0;
                    d4 = 1.0;
                    n8 = n4;
                    while (n8 < n2 + 1) {
                        d3 = d4 * dArray5[n8];
                        int n22 = n8;
                        dArray5[n22] = dArray5[n22] * d11;
                        d12 = d8 + Math.abs(d3);
                        if (d12 != d8) {
                            d5 = dArray2[n8];
                            dArray2[n8] = d2 = PolyWarpSolver.hypot(d3, d5);
                            d11 = d5 / d2;
                            d4 = -d3 / d2;
                            n3 = 0;
                            while (n3 < n6) {
                                d10 = dArray3[n3][n5];
                                d9 = dArray3[n3][n8];
                                dArray3[n3][n5] = d10 * d11 + d9 * d4;
                                dArray3[n3][n8] = -d10 * d4 + d9 * d11;
                                ++n3;
                            }
                        }
                        ++n8;
                    }
                }
                d9 = dArray2[n2];
                if (n4 == n2) {
                    if (!(d9 < 0.0)) break;
                    dArray2[n2] = -d9;
                    n3 = 0;
                    while (n3 < n7) {
                        dArray4[n3][n2] = -dArray4[n3][n2];
                        ++n3;
                    }
                    break;
                }
                if (n21 == 30) {
                    return false;
                }
                ++n21;
                d7 = dArray2[n4];
                d10 = dArray2[n20];
                d5 = dArray5[n20];
                d2 = dArray5[n2];
                d3 = 0.5 * ((d5 + d9) / d2 * ((d5 - d9) / d10) + d10 / d2 - d2 / d10);
                d5 = PolyWarpSolver.hypot(d3, 1.0);
                d3 = d7 - d9 / d7 * d9 + d2 / d7 * (d10 / (d3 + PolyWarpSolver.sign(d5, d3)) - d2);
                d11 = 1.0;
                d4 = 1.0;
                int n23 = n4;
                while (n23 <= n20) {
                    n8 = n23 + 1;
                    d5 = dArray5[n8];
                    d10 = dArray2[n8];
                    d2 = d4 * d5;
                    d5 = d11 * d5;
                    dArray5[n23] = d9 = PolyWarpSolver.hypot(d3, d2);
                    d11 = d3 / d9;
                    d4 = d2 / d9;
                    d3 = d7 * d11 + d5 * d4;
                    d5 = -d7 * d4 + d5 * d11;
                    d2 = d10 * d4;
                    d10 *= d11;
                    n3 = 0;
                    while (n3 < n7) {
                        d7 = dArray4[n3][n23];
                        d9 = dArray4[n3][n8];
                        dArray4[n3][n23] = d7 * d11 + d9 * d4;
                        dArray4[n3][n8] = -d7 * d4 + d9 * d11;
                        ++n3;
                    }
                    dArray2[n23] = d9 = PolyWarpSolver.hypot(d3, d2);
                    if (d9 != 0.0) {
                        d11 = d3 / d9;
                        d4 = d2 / d9;
                    }
                    d3 = d11 * d5 + d4 * d10;
                    d7 = -d4 * d5 + d11 * d10;
                    n3 = 0;
                    while (n3 < n6) {
                        d10 = dArray3[n3][n23];
                        d9 = dArray3[n3][n8];
                        dArray3[n3][n23] = d10 * d11 + d9 * d4;
                        dArray3[n3][n8] = -d10 * d4 + d9 * d11;
                        ++n3;
                    }
                    ++n23;
                }
                dArray5[n4] = 0.0;
                dArray5[n2] = d3;
                dArray2[n2] = d7;
            }
            --n2;
        }
        return true;
    }

    public static float[] getCoeffs(float[] fArray, int n2, float[] fArray2, int n3, int n4, float f2, float f3, float f4, float f5, int n5) {
        double d2;
        Object object;
        int n6 = n4 / 2;
        int n7 = (n5 + 1) * (n5 + 2) / 2;
        float[] fArray3 = new float[2 * n7];
        if (n5 == 1 && n4 == 3) {
            double d3 = fArray[0] * f2;
            double d4 = fArray[1] * f3;
            double d5 = fArray[2] * f2;
            double d6 = fArray[3] * f3;
            double d7 = fArray[4] * f3;
            double d8 = fArray[5] * f3;
            double d9 = fArray2[0] / f4;
            double d10 = fArray2[1] / f5;
            double d11 = fArray2[2] / f4;
            double d12 = fArray2[3] / f5;
            double d13 = fArray2[4] / f4;
            double d14 = fArray2[5] / f5;
            double d15 = d10 - d12;
            double d16 = d12 - d14;
            double d17 = d14 - d10;
            double d18 = d11 - d9;
            double d19 = d13 - d11;
            double d20 = d9 - d13;
            double d21 = d11 * d14 - d13 * d12;
            double d22 = d13 * d10 - d9 * d14;
            double d23 = d9 * d12 - d11 * d10;
            double d24 = 1.0 / (d9 * d16 + d10 * d19 + d21);
            fArray3[0] = (float)((d16 * d3 + d17 * d5 + d15 * d7) * d24);
            fArray3[1] = (float)((d19 * d3 + d20 * d5 + d18 * d7) * d24);
            fArray3[2] = (float)((d21 * d3 + d22 * d5 + d23 * d7) * d24);
            fArray3[3] = (float)((d16 * d4 + d17 * d6 + d15 * d8) * d24);
            fArray3[4] = (float)((d19 * d4 + d20 * d6 + d18 * d8) * d24);
            fArray3[5] = (float)((d21 * d4 + d22 * d6 + d23 * d8) * d24);
            return fArray3;
        }
        double[][] dArray = new double[n6][n7];
        double[] dArray2 = new double[n5 + 1];
        double[] dArray3 = new double[n5 + 1];
        int n8 = 0;
        while (n8 < n6) {
            object = dArray[n8];
            double d25 = fArray2[2 * n8 + n3] / f4;
            d2 = fArray2[2 * n8 + 1 + n3] / f5;
            double d26 = 1.0;
            double d27 = 1.0;
            int n9 = 0;
            while (n9 <= n5) {
                dArray2[n9] = d26;
                dArray3[n9] = d27;
                d26 *= d25;
                d27 *= d2;
                ++n9;
            }
            int n10 = 0;
            int n11 = 0;
            while (n11 <= n5) {
                int n12 = 0;
                while (n12 <= n11) {
                    object[n10++] = (double[])(dArray2[n11 - n12] * dArray3[n12]);
                    ++n12;
                }
                ++n11;
            }
            ++n8;
        }
        object = new double[n7][n7];
        double[] dArray4 = new double[n7];
        double[][] dArray5 = new double[n6][n7];
        PolyWarpSolver.SVD(dArray, dArray4, dArray5, object);
        int n13 = 0;
        while (n13 < n7) {
            d2 = dArray4[n13];
            if (d2 != 0.0) {
                d2 = 1.0 / d2;
            }
            n8 = 0;
            while (n8 < n7) {
                double[] dArray6 = object[n8];
                int n14 = n13;
                dArray6[n14] = dArray6[n14] * d2;
                ++n8;
            }
            ++n13;
        }
        double[][] dArray7 = PolyWarpSolver.matmul_t(object, dArray5);
        n8 = 0;
        while (n8 < n7) {
            double d28 = 0.0;
            double d29 = 0.0;
            n13 = 0;
            while (n13 < n6) {
                double d30 = dArray7[n8][n13];
                d28 += d30 * (double)fArray[2 * n13 + n2] * (double)f2;
                d29 += d30 * (double)fArray[2 * n13 + 1 + n2] * (double)f3;
                ++n13;
            }
            fArray3[n8] = (float)d28;
            fArray3[n8 + n7] = (float)d29;
            ++n8;
        }
        return fArray3;
    }

    private static float xpoly(float f2, float f3) {
        return (float)(c0[0] + c0[1] * (double)f2 + c0[2] * (double)f3 + c0[3] * (double)f2 * (double)f2 + c0[4] * (double)f2 * (double)f3 + c0[5] * (double)f3 * (double)f3 + myRandom.nextDouble() * noise);
    }

    private static float ypoly(float f2, float f3) {
        return (float)(c1[0] + c1[1] * (double)f2 + c1[2] * (double)f3 + c1[3] * (double)f2 * (double)f2 + c1[4] * (double)f2 * (double)f3 + c1[5] * (double)f3 * (double)f3 + myRandom.nextDouble() * noise);
    }

    private static void doTest(int n2, boolean bl2) {
        int n3 = 0;
        while (n3 < 6) {
            PolyWarpSolver.c0[n3] = myRandom.nextDouble() * 100.0;
            PolyWarpSolver.c1[n3] = myRandom.nextDouble() * 100.0;
            ++n3;
        }
        float[] fArray = new float[2 * n2];
        int n4 = 0;
        while (n4 < 2 * n2) {
            fArray[n4] = myRandom.nextFloat() * 100.0f;
            ++n4;
        }
        float[] fArray2 = new float[2 * n2];
        int n5 = 0;
        while (n5 < n2) {
            fArray2[2 * n5] = PolyWarpSolver.xpoly(fArray[2 * n5], fArray[2 * n5 + 1]);
            fArray2[2 * n5 + 1] = PolyWarpSolver.ypoly(fArray[2 * n5], fArray[2 * n5 + 1]);
            ++n5;
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray2, 0, fArray, 0, fArray2.length, 0.5f, 0.5f, 2.0f, 2.0f, 2);
        if (bl2) {
            System.out.println("Using " + n2 + " equations:");
            int n6 = 0;
            while (n6 < 6) {
                System.out.println("c0[" + n6 + "] = " + c0[n6] + ", recovered as " + fArray3[n6] + " (ratio = " + c0[n6] / (double)fArray3[n6] + ")");
                System.out.println("c1[" + n6 + "] = " + c1[n6] + ", recovered as " + fArray3[n6 + 6] + " (ratio = " + c1[n6] / (double)fArray3[n6 + 6] + ")");
                ++n6;
            }
        }
    }

    public static void main(String[] stringArray) {
        int n2 = 0;
        while (n2 < 3) {
            PolyWarpSolver.doTest(6 + 50 * n2, true);
            System.out.println();
            ++n2;
        }
        int n3 = 10000;
        int n4 = 6;
        long l2 = System.currentTimeMillis();
        int n5 = 0;
        while (n5 < n3) {
            PolyWarpSolver.doTest(n4, false);
            ++n5;
        }
        long l3 = System.currentTimeMillis();
        System.out.println("Did " + n3 + " " + n4 + "-point solutions in " + (float)(l3 - l2) / 1000.0f + " seconds.");
        System.out.println("Rate = " + (float)n3 * 1000.0f / (float)(l3 - l2) + " trials/second");
    }
}

