/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.util.LinkedList;
import java.util.ListIterator;

public final class RWLock {
    private boolean allowUpgrades;
    private static int READ = 1;
    private static int WRITE = 2;
    private static int NOT_FOUND = -1;
    private WaitingList waitingList = new WaitingList();

    public RWLock(boolean bl2) {
        this.allowUpgrades = bl2;
    }

    public RWLock() {
        this(true);
    }

    public synchronized boolean forReading(int n2) {
        ReaderWriter readerWriter = null;
        int n3 = this.waitingList.findMe();
        if (n3 != NOT_FOUND) {
            readerWriter = (ReaderWriter)this.waitingList.get(n3);
        } else {
            readerWriter = new ReaderWriter(READ);
            this.waitingList.add(readerWriter);
        }
        if (readerWriter.lockCount > 0) {
            ++readerWriter.lockCount;
            return true;
        }
        long l2 = System.currentTimeMillis();
        long l3 = (long)n2 + l2;
        do {
            int n4 = this.waitingList.indexOfFirstWriter();
            n3 = this.waitingList.findMe();
            if (n4 == NOT_FOUND || n4 > n3) {
                ++readerWriter.lockCount;
                readerWriter.granted = true;
                return true;
            }
            if (n2 == 0) {
                this.waitingList.remove(readerWriter);
                return false;
            }
            try {
                if (n2 < 0) {
                    this.wait();
                    continue;
                }
                long l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) continue;
                this.wait(l4);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(readerWriter.key.getName() + " : interrupted while waiting for a READ lock!");
            }
        } while (n2 < 0 || l3 > System.currentTimeMillis());
        this.waitingList.remove(readerWriter);
        this.notifyAll();
        return false;
    }

    public synchronized boolean forReading() {
        return this.forReading(-1);
    }

    public synchronized boolean forWriting(int n2) throws UpgradeNotAllowed {
        ReaderWriter readerWriter = null;
        int n3 = this.waitingList.findMe();
        if (n3 != NOT_FOUND) {
            readerWriter = (ReaderWriter)this.waitingList.get(n3);
        } else {
            readerWriter = new ReaderWriter(WRITE);
            this.waitingList.add(readerWriter);
        }
        if (readerWriter.granted && readerWriter.lockType == READ) {
            try {
                if (!this.upgrade(n2)) {
                    return false;
                }
            }
            catch (LockNotHeld lockNotHeld) {
                return false;
            }
        }
        if (readerWriter.lockCount > 0) {
            ++readerWriter.lockCount;
            return true;
        }
        long l2 = System.currentTimeMillis();
        long l3 = (long)n2 + l2;
        do {
            if ((n3 = this.waitingList.findMe()) == 0) {
                ++readerWriter.lockCount;
                readerWriter.granted = true;
                return true;
            }
            if (n2 == 0) {
                this.waitingList.remove(readerWriter);
                return false;
            }
            try {
                if (n2 < 0) {
                    this.wait();
                    continue;
                }
                long l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) continue;
                this.wait(l4);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(readerWriter.key.getName() + " : interrupted while waiting for a WRITE lock!");
            }
        } while (n2 < 0 || l3 > System.currentTimeMillis());
        this.waitingList.remove(readerWriter);
        this.notifyAll();
        return false;
    }

    public synchronized boolean forWriting() throws UpgradeNotAllowed {
        return this.forWriting(-1);
    }

    public synchronized boolean upgrade(int n2) throws UpgradeNotAllowed, LockNotHeld {
        if (!this.allowUpgrades) {
            throw new UpgradeNotAllowed();
        }
        int n3 = this.waitingList.findMe();
        if (n3 == NOT_FOUND) {
            throw new LockNotHeld();
        }
        ReaderWriter readerWriter = (ReaderWriter)this.waitingList.get(n3);
        if (readerWriter.lockType == WRITE) {
            return true;
        }
        int n4 = this.waitingList.indexOfLastGranted();
        if (n4 == NOT_FOUND) {
            throw new LockNotHeld();
        }
        if (n3 != n4) {
            this.waitingList.remove(n3);
            ListIterator<ReaderWriter> listIterator = this.waitingList.listIterator(n4);
            listIterator.add(readerWriter);
        }
        readerWriter.lockType = WRITE;
        long l2 = System.currentTimeMillis();
        long l3 = (long)n2 + l2;
        do {
            if ((n3 = this.waitingList.findMe()) == 0) {
                return true;
            }
            if (n2 == 0) {
                readerWriter.lockType = READ;
                return false;
            }
            try {
                if (n2 < 0) {
                    this.wait();
                    continue;
                }
                long l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) continue;
                this.wait(l4);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(readerWriter.key.getName() + " : interrupted while waiting to UPGRADE lock!");
            }
        } while (n2 < 0 || l3 > System.currentTimeMillis());
        readerWriter.lockType = READ;
        this.notifyAll();
        return false;
    }

    public synchronized boolean upgrade() throws UpgradeNotAllowed, LockNotHeld {
        return this.upgrade(-1);
    }

    public synchronized boolean downgrade() throws LockNotHeld {
        int n2 = this.waitingList.findMe();
        if (n2 == NOT_FOUND) {
            throw new LockNotHeld();
        }
        ReaderWriter readerWriter = (ReaderWriter)this.waitingList.get(n2);
        if (readerWriter.lockType == WRITE) {
            readerWriter.lockType = READ;
            this.notifyAll();
        }
        return true;
    }

    public synchronized void release() throws LockNotHeld {
        int n2 = this.waitingList.findMe();
        if (n2 == NOT_FOUND) {
            throw new LockNotHeld();
        }
        ReaderWriter readerWriter = (ReaderWriter)this.waitingList.get(n2);
        if (--readerWriter.lockCount == 0) {
            this.waitingList.remove(n2);
            this.notifyAll();
        }
    }

    public class LockNotHeld
    extends RuntimeException {
    }

    public class UpgradeNotAllowed
    extends RuntimeException {
    }

    private class ReaderWriter {
        Thread key = Thread.currentThread();
        int lockType;
        int lockCount;
        boolean granted;

        ReaderWriter() {
            this(0);
        }

        ReaderWriter(int n2) {
            this.lockType = n2;
            this.lockCount = 0;
            this.granted = false;
        }

        public boolean equals(Object object) {
            return this.key == ((ReaderWriter)object).key;
        }
    }

    private class WaitingList
    extends LinkedList {
        private WaitingList() {
        }

        int indexOfFirstWriter() {
            ListIterator listIterator = this.listIterator(0);
            int n2 = 0;
            while (listIterator.hasNext()) {
                if (((ReaderWriter)listIterator.next()).lockType == WRITE) {
                    return n2;
                }
                ++n2;
            }
            return NOT_FOUND;
        }

        int indexOfLastGranted() {
            ListIterator listIterator = this.listIterator(this.size());
            int n2 = this.size() - 1;
            while (listIterator.hasPrevious()) {
                if (((ReaderWriter)listIterator.previous()).granted) {
                    return n2;
                }
                --n2;
            }
            return NOT_FOUND;
        }

        int findMe() {
            return this.indexOf(new ReaderWriter());
        }
    }
}

