/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import javax.media.jai.CachedTile;
import javax.media.jai.PlanarImage;
import javax.media.jai.remote.SerializableRenderedImage;

final class SunCachedTile
implements CachedTile {
    Raster tile;
    WeakReference owner;
    int tileX;
    int tileY;
    Object tileCacheMetric;
    long timeStamp;
    Object key;
    long memorySize;
    SunCachedTile previous;
    SunCachedTile next;
    int action = 0;

    SunCachedTile(RenderedImage renderedImage, int n2, int n3, Raster raster, Object object) {
        this.owner = new WeakReference<RenderedImage>(renderedImage);
        this.tile = raster;
        this.tileX = n2;
        this.tileY = n3;
        this.tileCacheMetric = object;
        this.key = SunCachedTile.hashKey(renderedImage, n2, n3);
        DataBuffer dataBuffer = raster.getDataBuffer();
        this.memorySize = (long)DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8L * (long)dataBuffer.getSize() * (long)dataBuffer.getNumBanks();
    }

    static Object hashKey(RenderedImage renderedImage, int n2, int n3) {
        long l2 = (long)n3 * (long)renderedImage.getNumXTiles() + (long)n2;
        BigInteger bigInteger = null;
        if (renderedImage instanceof PlanarImage) {
            bigInteger = (BigInteger)((PlanarImage)renderedImage).getImageID();
        } else if (renderedImage instanceof SerializableRenderedImage) {
            bigInteger = (BigInteger)((SerializableRenderedImage)renderedImage).getImageID();
        }
        if (bigInteger != null) {
            byte[] byArray = bigInteger.toByteArray();
            int n4 = byArray.length;
            byte[] byArray2 = new byte[n4 + 8];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            int n5 = 7;
            int n6 = 0;
            while (n5 >= 0) {
                byArray2[n4++] = (byte)(l2 >> n6);
                --n5;
                n6 += 8;
            }
            return new BigInteger(byArray2);
        }
        return new Long((long)renderedImage.hashCode() << 32 | (l2 &= 0xFFFFFFFFL));
    }

    public String toString() {
        RenderedImage renderedImage = this.getOwner();
        String string = renderedImage == null ? "null" : renderedImage.toString();
        Raster raster = this.getTile();
        String string2 = raster == null ? "null" : raster.toString();
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + string + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + string2 + " key = " + (this.key instanceof Long ? Long.toHexString((Long)this.key) : this.key.toString()) + " memorySize = " + Long.toString(this.memorySize) + " timeStamp = " + Long.toString(this.timeStamp);
    }

    public Raster getTile() {
        return this.tile;
    }

    public RenderedImage getOwner() {
        return (RenderedImage)this.owner.get();
    }

    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public long getTileSize() {
        return this.memorySize;
    }

    public int getAction() {
        return this.action;
    }
}

