/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JaiI18N;
import com.sun.media.jai.util.Job;
import com.sun.media.jai.util.Request;
import com.sun.media.jai.util.RequestJob;
import com.sun.media.jai.util.TileJob;
import com.sun.media.jai.util.WorkerThread;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class SunTileScheduler
implements TileScheduler {
    private static final int NUM_THREADS_DEFAULT = 2;
    private static final int NUM_PREFETCH_THREADS_DEFAULT = 1;
    private static int numInstances = 0;
    private static String name = JaiI18N.getString("SunTileSchedulerName");
    private ThreadGroup rootGroup;
    private ThreadGroup standardGroup;
    private ThreadGroup prefetchGroup;
    private int parallelism = 2;
    private int prefetchParallelism = 1;
    private int priority = 5;
    private int prefetchPriority = 1;
    private LinkedList queue = null;
    private LinkedList prefetchQueue = null;
    private Vector workers = new Vector();
    private Vector prefetchWorkers = new Vector();
    private int numWorkerThreads = 0;
    private int numPrefetchThreads = 0;
    private Map tilesInProgress = new HashMap();
    Map tileRequests = new HashMap();
    Map tileJobs = new HashMap();
    private String nameOfThisInstance;

    static Object tileKey(PlanarImage planarImage, int n2, int n3) {
        long l2 = (long)n3 * (long)planarImage.getNumXTiles() + (long)n2;
        BigInteger bigInteger = (BigInteger)planarImage.getImageID();
        byte[] byArray = bigInteger.toByteArray();
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n4 + 8];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        int n5 = 7;
        int n6 = 0;
        while (n5 >= 0) {
            byArray2[n4++] = (byte)(l2 >> n6);
            --n5;
            n6 += 8;
        }
        return new BigInteger(byArray2);
    }

    static Set getListeners(List list) {
        int n2 = list.size();
        HashSet hashSet = null;
        int n3 = 0;
        while (n3 < n2) {
            Request request = (Request)list.get(n3);
            if (request.listeners != null && !request.listeners.isEmpty()) {
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.addAll(request.listeners);
            }
            ++n3;
        }
        return hashSet;
    }

    private static String getStackTraceString(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public SunTileScheduler(int n2, int n3, int n4, int n5) {
        this();
        this.setParallelism(n2);
        this.setPriority(n3);
        this.setPrefetchParallelism(n4);
        this.setPrefetchPriority(n5);
    }

    public SunTileScheduler() {
        this.queue = new LinkedList();
        this.prefetchQueue = new LinkedList();
        this.nameOfThisInstance = name + numInstances;
        this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
        this.rootGroup.setDaemon(true);
        this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
        this.standardGroup.setDaemon(true);
        this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
        this.prefetchGroup.setDaemon(true);
        ++numInstances;
    }

    Exception compute(PlanarImage planarImage, Point[] pointArray, Raster[] rasterArray, int n2, int n3, Request request) {
        Object object;
        Exception exception = null;
        int n4 = n2;
        if (request == null || request.listeners == null) {
            int n5 = 0;
            while (n5 < n3) {
                Point point = pointArray[n4];
                try {
                    rasterArray[n4] = planarImage.getTile(point.x, point.y);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    break;
                }
                ++n5;
                ++n4;
            }
        } else {
            TileRequest[] tileRequestArray = new Request[]{request};
            int n6 = 0;
            while (n6 < n3) {
                Point point = pointArray[n4];
                Integer n7 = new Integer(1);
                request.tileStatus.put(point, n7);
                try {
                    rasterArray[n4] = planarImage.getTile(point.x, point.y);
                    object = request.listeners.iterator();
                    while (object.hasNext()) {
                        n7 = new Integer(2);
                        request.tileStatus.put(point, n7);
                        TileComputationListener tileComputationListener = (TileComputationListener)object.next();
                        tileComputationListener.tileComputed(this, tileRequestArray, planarImage, point.x, point.y, rasterArray[n4]);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    break;
                }
                ++n6;
                ++n4;
            }
        }
        if (exception != null && request != null && request.listeners != null) {
            int n8 = n4;
            int n9 = n3 - (n8 - n2);
            int n10 = 0;
            int n11 = n8;
            while (n10 < n9) {
                object = new Integer(4);
                request.tileStatus.put(pointArray[n11++], object);
                ++n10;
            }
            object = new Request[]{request};
            int n12 = 0;
            int n13 = n8;
            while (n12 < n9) {
                Point point = pointArray[n13++];
                Iterator iterator = request.listeners.iterator();
                while (iterator.hasNext()) {
                    TileComputationListener tileComputationListener = (TileComputationListener)iterator.next();
                    tileComputationListener.tileComputationFailure(this, (TileRequest[])object, planarImage, point.x, point.y, exception);
                }
                ++n12;
            }
        }
        return exception;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Raster scheduleTile(OpImage opImage, int n2, int n3) {
        if (opImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler1"));
        }
        Raster raster = null;
        Object object = SunTileScheduler.tileKey(opImage, n2, n3);
        boolean bl2 = false;
        Object[] objectArray = null;
        Map map = this.tilesInProgress;
        // MONITORENTER : map
        bl2 = !this.tilesInProgress.containsKey(object);
        if (bl2) {
            objectArray = new Object[1];
            this.tilesInProgress.put(object, objectArray);
        } else {
            objectArray = (Object[])this.tilesInProgress.get(object);
        }
        // MONITOREXIT : map
        if (bl2) {
            try {
                try {
                    try {
                        raster = opImage.computeTile(n2, n3);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        TileCache tileCache = opImage.getTileCache();
                        if (tileCache != null) {
                            tileCache.flush();
                            System.gc();
                        }
                        raster = opImage.computeTile(n2, n3);
                    }
                    Object var12_15 = null;
                    Object[] objectArray2 = objectArray;
                }
                catch (Throwable outOfMemoryError) {
                    if (outOfMemoryError instanceof Error) {
                        throw (Error)outOfMemoryError;
                    }
                    if (outOfMemoryError instanceof RuntimeException) {
                        this.sendExceptionToListener(JaiI18N.getString("SunTileScheduler6"), outOfMemoryError);
                    } else {
                        String tileCache = JaiI18N.getString("SunTileScheduler6");
                        this.sendExceptionToListener(tileCache, new ImagingException(tileCache, outOfMemoryError));
                    }
                    Object var12_16 = null;
                    Object[] objectArray2 = objectArray;
                    // MONITORENTER : objectArray2
                    objectArray[0] = raster != null ? raster : new Object();
                    objectArray.notifyAll();
                    Map map3 = this.tilesInProgress;
                    // MONITORENTER : map3
                    this.tilesInProgress.remove(object);
                    // MONITOREXIT : map3
                    // MONITOREXIT : objectArray2
                    return raster;
                }
                objectArray[0] = raster != null ? raster : new Object();
                objectArray.notifyAll();
                Map map2 = this.tilesInProgress;
                // MONITORENTER : map2
                this.tilesInProgress.remove(object);
                // MONITOREXIT : map2
                // MONITOREXIT : objectArray2
                return raster;
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                Object[] objectArray4 = objectArray;
                // MONITORENTER : objectArray4
                objectArray[0] = raster != null ? raster : new Object();
                objectArray.notifyAll();
                Map map4 = this.tilesInProgress;
                // MONITORENTER : map4
                this.tilesInProgress.remove(object);
                // MONITOREXIT : map4
                // MONITOREXIT : objectArray4
                throw throwable;
            }
        }
        Object[] throwable = objectArray;
        // MONITORENTER : throwable
        if (objectArray[0] == null) {
            try {
                objectArray.wait();
            }
            catch (Exception string) {
                // empty catch block
            }
        }
        if (!(objectArray[0] instanceof Raster)) throw new RuntimeException(JaiI18N.getString("SunTileScheduler5"));
        return (Raster)objectArray[0];
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object scheduleJob(PlanarImage var1_1, Point[] var2_2, boolean var3_3, boolean var4_4, TileComputationListener[] var5_5) {
        block25: {
            if (var1_1 == null) throw new IllegalArgumentException();
            if (var2_2 == null) {
                throw new IllegalArgumentException();
            }
            if ((var3_3 || var4_4) && var5_5 != null) {
                throw new IllegalArgumentException();
            }
            if (var3_3 && var4_4) {
                throw new IllegalArgumentException();
            }
            var6_6 = var2_2.length;
            var8_8 /* !! */  = var7_7 = new Raster[var6_6];
            var9_9 = 0;
            var10_10 = null;
            var11_11 = 0;
            var12_12 = this.getWorkers(var4_4);
            synchronized (var12_12) {
                block23: {
                    block24: {
                        var9_9 = this.getNumThreads(var4_4);
                        if (var9_9 <= 0) break block23;
                        if (var6_6 > var9_9 && (var3_3 || var4_4)) break block24;
                        var10_10 = new Job[var6_6];
                        if (var3_3 || var4_4) ** GOTO lbl56
                        var13_13 = new Request(this, var1_1, var2_2, var5_5);
                        var8_8 /* !! */  = var13_13;
                        if (true) ** GOTO lbl52
                    }
                    var13_14 = 1.0f / (2.0f * (float)var9_9);
                    var14_16 = var9_9 == 1 ? var6_6 : Math.min(Math.max(1, (int)(var13_14 * (float)var6_6 / 2.0f + 0.5f)), var6_6);
                    var15_19 = var9_9 == 1 ? 1 : (int)((float)var6_6 / (float)var14_16 + 0.5f);
                    var10_10 = new TileJob[var15_19];
                    var16_21 = 0;
                    var17_24 = var6_6 - var16_21;
                    if (true) ** GOTO lbl69
                    do {
                        var14_15 /* !! */  = var2_2[var11_11];
                        var15_18 = SunTileScheduler.tileKey(var1_1, var14_15 /* !! */ .x, var14_15 /* !! */ .y);
                        var16_20 = this.tileRequests;
                        synchronized (var16_20) {
                            var17_23 = null;
                            if (this.tileRequests.containsKey(var15_18)) {
                                var17_23 = (List)this.tileRequests.get(var15_18);
                                var17_23.add(var13_13);
                                --var6_6;
                            } else {
                                var17_23 = new ArrayList<Object>();
                                var17_23.add(var13_13);
                                this.tileRequests.put(var15_18, var17_23);
                                var10_10[var11_11] = new RequestJob(this, var1_1, var14_15 /* !! */ .x, var14_15 /* !! */ .y, var7_7, var11_11);
                                this.tileJobs.put(var15_18, var10_10[var11_11]);
                                this.addJob(var10_10[var11_11++], false);
                            }
                        }
lbl52:
                        // 3 sources

                    } while (var11_11 < var6_6);
                    break block23;
lbl-1000:
                    // 1 sources

                    {
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var11_11, 1);
                        this.addJob(var10_10[var11_11++], var4_4);
lbl56:
                        // 2 sources

                        ** while (var11_11 < var6_6)
                    }
lbl57:
                    // 1 sources

                    break block23;
                    do {
                        if ((var18_27 = (int)(var13_14 * (float)var17_24 + 0.5f)) < var14_16) {
                            var18_27 = var14_16;
                        }
                        if (var18_27 > var17_24) {
                            var18_27 = var17_24;
                        }
                        if ((var17_24 -= var18_27) < var14_16) {
                            var18_27 += var17_24;
                            var17_24 = 0;
                        }
                        var10_10[var11_11] = new TileJob(this, var3_3, var1_1, var2_2, var7_7, var16_21, var18_27);
                        this.addJob(var10_10[var11_11++], var4_4);
                        var16_21 += var18_27;
lbl69:
                        // 2 sources

                    } while (var17_24 > 0);
                }
                if (var9_9 == 0) break block25;
            }
            if (var3_3 == false) return var8_8 /* !! */ ;
            var13_13 = this.getQueue(var4_4);
            var14_17 = 0;
            if (true) ** GOTO lbl100
        }
        var13_13 = null;
        if (!var3_3 && !var4_4) {
            var13_13 = new Request(this, var1_1, var2_2, var5_5);
            var8_8 /* !! */  = var13_13;
        }
        if ((var14_15 /* !! */  = this.compute(var1_1, var2_2, var7_7, 0, var6_6, (Request)var13_13)) == null) return var8_8 /* !! */ ;
        var15_18 = JaiI18N.getString("SunTileScheduler7");
        this.sendExceptionToListener((String)var15_18, new ImagingException((String)var15_18, var14_15 /* !! */ ));
        return var8_8 /* !! */ ;
        do {
            var15_18 = this;
            synchronized (var15_18) {
                while (var10_10[var14_17].notDone()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var16_22) {
                        // empty catch block
                    }
                }
            }
            var16_20 = var10_10[var14_17].getException();
            if (var16_20 != null) {
                var17_26 = JaiI18N.getString("SunTileScheduler7");
                this.sendExceptionToListener(var17_26, new ImagingException(var17_26, (Throwable)var16_20));
            }
            ++var14_17;
lbl100:
            // 2 sources

        } while (var14_17 < var11_11);
        return var8_8 /* !! */ ;
    }

    public Raster[] scheduleTiles(OpImage opImage, Point[] pointArray) {
        if (opImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        return (Raster[])this.scheduleJob(opImage, pointArray, true, false, null);
    }

    public TileRequest scheduleTiles(PlanarImage planarImage, Point[] pointArray, TileComputationListener[] tileComputationListenerArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler4"));
        }
        return (TileRequest)this.scheduleJob(planarImage, pointArray, false, false, tileComputationListenerArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler3"));
        }
        Request request = (Request)tileRequest;
        Map map = this.tileRequests;
        synchronized (map) {
            Point[] pointArray2;
            List list = request.indices;
            if (pointArray != null && pointArray.length > 0) {
                List<Point> list2 = Arrays.asList(pointArray);
                list2.retainAll(list);
                pointArray2 = list2.toArray(new Point[0]);
            } else {
                pointArray2 = list.toArray(new Point[0]);
            }
            int n2 = pointArray2.length;
            Integer n3 = new Integer(3);
            int n4 = 0;
            while (n4 < n2) {
                Point point = pointArray2[n4];
                Object object = SunTileScheduler.tileKey(request.image, point.x, point.y);
                List list3 = (List)this.tileRequests.get(object);
                if (list3 != null) {
                    Object object2;
                    TileRequest[] tileRequestArray;
                    list3.remove(request);
                    if (list3.isEmpty()) {
                        tileRequestArray = this.queue;
                        synchronized (tileRequestArray) {
                            object2 = this.tileJobs.remove(object);
                            if (object2 != null) {
                                this.queue.remove(object2);
                            }
                        }
                        this.tileRequests.remove(object);
                    }
                    request.tileStatus.put(point, n3);
                    if (request.listeners != null) {
                        tileRequestArray = new TileRequest[]{request};
                        object2 = request.listeners.iterator();
                        while (object2.hasNext()) {
                            TileComputationListener tileComputationListener = (TileComputationListener)object2.next();
                            tileComputationListener.tileCancelled(this, tileRequestArray, request.image, point.x, point.y);
                        }
                    }
                }
                ++n4;
            }
        }
    }

    public void prefetchTiles(PlanarImage planarImage, Point[] pointArray) {
        if (planarImage == null || pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler0"));
        }
        this.scheduleJob(planarImage, pointArray, false, true, null);
    }

    public void setParallelism(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.parallelism = n2;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setPrefetchParallelism(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("SunTileScheduler2"));
        }
        this.prefetchParallelism = n2;
    }

    public int getPrefetchParallelism() {
        return this.prefetchParallelism;
    }

    public void setPriority(int n2) {
        this.priority = Math.max(Math.min(n2, 10), 1);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPrefetchPriority(int n2) {
        this.prefetchPriority = Math.max(Math.min(n2, 10), 1);
    }

    public int getPrefetchPriority() {
        return this.prefetchPriority;
    }

    private void createThreadGroup(boolean bl2) {
        if (this.rootGroup == null || this.rootGroup.isDestroyed()) {
            this.rootGroup = new ThreadGroup(this.nameOfThisInstance);
            this.rootGroup.setDaemon(true);
        }
        if (bl2 && (this.prefetchGroup == null || this.prefetchGroup.isDestroyed())) {
            this.prefetchGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Prefetch");
            this.prefetchGroup.setDaemon(true);
        }
        if (!bl2 && (this.standardGroup == null || this.standardGroup.isDestroyed())) {
            this.standardGroup = new ThreadGroup(this.rootGroup, this.nameOfThisInstance + "Standard");
            this.standardGroup.setDaemon(true);
        }
        Vector vector = this.getWorkers(bl2);
        int n2 = vector.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            Thread thread = (Thread)vector.get(n3);
            if (!thread.isAlive()) {
                vector.remove(thread);
            }
            --n3;
        }
        if (bl2) {
            this.numPrefetchThreads = vector.size();
        } else {
            this.numWorkerThreads = vector.size();
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getNumThreads(boolean var1_1) {
        block9: {
            this.createThreadGroup(var1_1);
            var2_2 = this.getWorkers(var1_1);
            if (var1_1) {
                var3_3 = this.numPrefetchThreads;
                var4_4 = this.prefetchParallelism;
                var5_5 = this.prefetchPriority;
            } else {
                var3_3 = this.numWorkerThreads;
                var4_4 = this.parallelism;
                var5_5 = this.priority;
            }
            if (var3_3 > 0 && ((Thread)var2_2.get(0)).getPriority() != var5_5) {
                var6_6 = var2_2.size();
                var7_8 = 0;
                while (var7_8 < var6_6) {
                    var8_9 = (Thread)var2_2.get(var7_8);
                    if (var8_9 != null && var8_9.getThreadGroup() != null) {
                        var8_9.setPriority(var5_5);
                    }
                    ++var7_8;
                }
            }
            if (var3_3 >= var4_4) ** GOTO lbl31
            while (var3_3 < var4_4) {
                var6_7 = new WorkerThread(var1_1 != false ? this.prefetchGroup : this.standardGroup, this, var1_1);
                var6_7.setPriority(var5_5);
                var2_2.add(var6_7);
                ++var3_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                this.addJob(WorkerThread.TERMINATE, var1_1);
                --var3_3;
lbl31:
                // 2 sources

                ** while (var3_3 > var4_4)
            }
        }
        if (var1_1) {
            this.numPrefetchThreads = var3_3;
        } else {
            this.numWorkerThreads = var3_3;
        }
        return var3_3;
    }

    Vector getWorkers(boolean bl2) {
        return bl2 ? this.workers : this.prefetchWorkers;
    }

    LinkedList getQueue(boolean bl2) {
        return bl2 ? this.prefetchQueue : this.queue;
    }

    private void addJob(Object object, boolean bl2) {
        LinkedList linkedList;
        if (object == null || object != WorkerThread.TERMINATE && !(object instanceof Job)) {
            throw new IllegalArgumentException();
        }
        LinkedList linkedList2 = linkedList = this.getQueue(bl2);
        synchronized (linkedList2) {
            if (bl2 || linkedList.isEmpty() || object instanceof RequestJob) {
                linkedList.addLast(object);
            } else {
                boolean bl3 = false;
                int n2 = linkedList.size() - 1;
                while (n2 >= 0) {
                    if (linkedList.get(n2) instanceof TileJob) {
                        linkedList.add(n2 + 1, object);
                        bl3 = true;
                        break;
                    }
                    --n2;
                }
                if (!bl3) {
                    linkedList.addFirst(object);
                }
            }
            linkedList.notify();
        }
    }

    protected void finalize() throws Throwable {
        this.terminateAll(false);
        this.terminateAll(true);
        super.finalize();
    }

    private void terminateAll(boolean bl2) {
        Vector vector = this.getWorkers(bl2);
        synchronized (vector) {
            int n2 = bl2 ? this.numPrefetchThreads : this.numWorkerThreads;
            int n3 = 0;
            while (n3 < n2) {
                this.addJob(WorkerThread.TERMINATE, bl2);
                if (bl2) {
                    --this.numPrefetchThreads;
                } else {
                    --this.numWorkerThreads;
                }
                ++n3;
            }
        }
    }

    void sendExceptionToListener(String string, Throwable throwable) {
        ImagingListener imagingListener = ImageUtil.getImagingListener((RenderingHints)null);
        imagingListener.errorOccurred(string, throwable, this, false);
    }
}

