/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.mlib;

import com.sun.medialib.mlib.Constants;
import com.sun.medialib.mlib.mediaLibException;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class mediaLibImage
implements Cloneable,
Constants,
Serializable {
    protected int type = 1;
    protected int channels = 1;
    protected int width = 256;
    protected int height = 256;
    protected int stride = 256;
    protected int offset = 0;
    protected int bitoffset = 0;
    protected Object data;
    protected int format;
    protected byte[] paddings = new byte[]{0, 0, 0, 0};
    private static final int RAS_MAGIC = 1504078485;
    private static final int RT_OLD = 0;
    private static final int RT_STANDARD = 1;
    private static final int RT_BYTE_ENCODED = 2;
    private static final int RT_FORMAT_RGB = 3;
    private static final int RT_FORMAT_TIFF = 4;
    private static final int RT_FORMAT_IFF = 5;
    private static final int RT_EXPERIMENTAL = 65535;
    private static final int RMT_NONE = 0;
    private static final int RMT_EQUAL_RGB = 1;
    private static final int RMT_RAW = 2;
    private int depth = 0;
    private int length = 0;
    private int rttype = 1;
    private int maptype = 0;
    private int maplength = 0;
    private URL url = null;
    public static final int UNKNOWN = 0;
    public static final int INDEXED = 1;
    public static final int GRAYSCALE = 2;
    public static final int RGB = 3;
    public static final int BGR = 4;
    public static final int ARGB = 5;
    public static final int ABGR = 6;
    public static final int PACKED_ARGB = 7;
    public static final int PACKED_ABGR = 8;
    public static final int GRAYSCALE_ALPHA = 9;
    public static final int RGBA = 10;

    public mediaLibImage(URL uRL) {
        this.url = uRL;
        this.offset = 0;
        this.readSunImage(this.url);
    }

    public mediaLibImage(File file) {
        this.offset = 0;
        this.readSunImage(file);
    }

    public mediaLibImage(InputStream inputStream) throws IOException {
        this.offset = 0;
        this.readSunImage(inputStream);
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        this.type = n2;
        this.channels = n3;
        this.width = n4;
        this.height = n5;
        this.stride = n6;
        this.offset = n7;
        this.data = object;
        this.format = 0;
        this.paddings[0] = 0;
        this.paddings[1] = 0;
        this.paddings[2] = 0;
        this.paddings[3] = 0;
        this.bitoffset = 0;
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        this.type = n2;
        this.channels = n3;
        this.width = n4;
        this.height = n5;
        this.stride = n6;
        this.offset = n7;
        this.format = n8;
        this.data = object;
        this.paddings[0] = 0;
        this.paddings[1] = 0;
        this.paddings[2] = 0;
        this.paddings[3] = 0;
        this.bitoffset = 0;
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int n6, int n7, byte by2, Object object) {
        this.type = n2;
        this.channels = n3;
        this.width = n4;
        this.height = n5;
        this.stride = n6;
        this.offset = n7;
        this.data = object;
        this.format = 0;
        this.paddings[0] = 0;
        this.paddings[1] = 0;
        this.paddings[2] = 0;
        this.paddings[3] = 0;
        this.bitoffset = this.type == 0 ? by2 : (byte)0;
    }

    public mediaLibImage(int n2, int n3, int n4, int n5) {
        this.createImage(n2, n3, n4, n5);
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int n6) {
        this.createImage(n2, n3, n4, n5);
        this.setFormat(n6);
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int[] nArray) {
        this.createImage(n2, n3, n4, n5);
        this.setColor(nArray);
    }

    public mediaLibImage(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.createImage(n2, n3, n4, n5);
        this.setColor(nArray);
        this.setFormat(n6);
    }

    public mediaLibImage createSubimage(int n2, int n3, int n4, int n5) {
        mediaLibImage.validate(this);
        if (n4 <= 0 || n5 <= 0) {
            throw new mediaLibException(11);
        }
        if (n2 + n4 <= 0 || n3 + n5 <= 0 || n2 >= this.width || n3 >= this.height) {
            throw new mediaLibException(11);
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n3 < 0) {
            n5 += n3;
            n3 = 0;
        }
        if (n2 + n4 > this.width) {
            n4 = this.width - n2;
        }
        if (n3 + n5 > this.height) {
            n5 = this.height - n3;
        }
        int n6 = this.getOffset();
        int n7 = this.getBitOffset();
        if (this.type == 0) {
            n6 += n3 * this.stride + (n2 * this.channels + n7) / 8;
            n7 = n2 * this.channels + n7 & 7;
        } else {
            n6 += n3 * this.stride + n2 * this.channels;
        }
        mediaLibImage mediaLibImage2 = new mediaLibImage(this.getType(), this.getChannels(), n4, n5, this.getStride(), n6, this.getFormat(), this.getData());
        if (this.type == 0) {
            mediaLibImage2.bitoffset = n7;
        }
        return mediaLibImage2;
    }

    private void createImage(int n2, int n3, int n4, int n5) {
        this.type = n2;
        this.channels = n3;
        this.width = n4;
        this.height = n5;
        this.offset = 0;
        this.format = 0;
        this.paddings[0] = 0;
        this.paddings[1] = 0;
        this.paddings[2] = 0;
        this.paddings[3] = 0;
        this.bitoffset = 0;
        if (this.channels >= 1 && this.channels <= 4) {
            this.stride = this.channels * this.width;
            switch (this.type) {
                case 0: {
                    this.depth = this.channels * 1;
                    this.stride = (this.stride + 7) / 8;
                    this.data = new byte[this.stride * this.height];
                    break;
                }
                case 1: {
                    this.depth = this.channels * 8;
                    this.data = new byte[this.stride * this.height];
                    break;
                }
                case 2: 
                case 6: {
                    this.depth = this.channels * 16;
                    this.data = new short[this.stride * this.height];
                    break;
                }
                case 3: {
                    this.depth = this.channels * 32;
                    this.data = new int[this.stride * this.height];
                    break;
                }
                case 4: {
                    this.depth = this.channels * 32;
                    this.data = new float[this.stride * this.height];
                    break;
                }
                case 5: {
                    this.depth = this.channels * 64;
                    this.data = new double[this.stride * this.height];
                    break;
                }
                default: {
                    System.err.println("Wrong data type.");
                    break;
                }
            }
        } else {
            System.err.println("Wrong channels.");
        }
    }

    public void setColor(int[] nArray) {
        mediaLibImage.validate(this);
        this.checkChannels(nArray);
        if (this.getType() == 4 || this.getType() == 5) {
            throw new mediaLibException(4);
        }
        int n2 = this.getStride();
        int n3 = this.getOffset();
        switch (this.getType()) {
            case 0: {
                byte[] byArray = this.getBitData();
                int n4 = this.getBitOffset();
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < this.height) {
                    int n10 = byArray[n3 + n9 * n2];
                    int n11 = 0;
                    while (n11 < this.width) {
                        int n12 = 0;
                        while (n12 < this.channels) {
                            n7 = n11 * this.channels + n12 + n4;
                            n5 = n7 >> 3;
                            n8 = 7 - (n7 & 7);
                            int n13 = (nArray[n12] & 1) << n8;
                            n6 = 1 << n8;
                            n10 = n10 & ~n6 | n13;
                            if (n8 == 0) {
                                byArray[n3 + n9 * n2 + n5] = (byte)n10;
                                n10 = 0;
                            }
                            ++n12;
                        }
                        ++n11;
                    }
                    if (n8 != 0) {
                        n6 = 127 >> 7 - n8;
                        byArray[n3 + n9 * n2 + n5] = (byte)(byArray[n3 + n9 * n2 + n5] & n6 | n10);
                    }
                    ++n9;
                }
                break;
            }
            case 1: {
                byte[] byArray = this.getByteData();
                int n14 = 0;
                while (n14 < this.height) {
                    int n15 = 0;
                    int n16 = n3;
                    while (n15 < this.width) {
                        int n17 = 0;
                        while (n17 < this.channels) {
                            byArray[n16 + n17] = (byte)nArray[n17];
                            ++n17;
                        }
                        ++n15;
                        n16 += this.channels;
                    }
                    ++n14;
                    n3 += n2;
                }
                break;
            }
            case 2: {
                short[] sArray = this.getShortData();
                int n18 = 0;
                while (n18 < this.height) {
                    int n19 = 0;
                    int n20 = n3;
                    while (n19 < this.width) {
                        int n21 = 0;
                        while (n21 < this.channels) {
                            sArray[n20 + n21] = (short)nArray[n21];
                            ++n21;
                        }
                        ++n19;
                        n20 += this.channels;
                    }
                    ++n18;
                    n3 += n2;
                }
                break;
            }
            case 6: {
                short[] sArray = this.getUShortData();
                int n22 = 0;
                while (n22 < this.height) {
                    int n23 = 0;
                    int n24 = n3;
                    while (n23 < this.width) {
                        int n25 = 0;
                        while (n25 < this.channels) {
                            sArray[n24 + n25] = (short)nArray[n25];
                            ++n25;
                        }
                        ++n23;
                        n24 += this.channels;
                    }
                    ++n22;
                    n3 += n2;
                }
                break;
            }
            case 3: {
                int[] nArray2 = this.getIntData();
                int n26 = 0;
                while (n26 < this.height) {
                    int n27 = 0;
                    int n28 = n3;
                    while (n27 < this.width) {
                        int n29 = 0;
                        while (n29 < this.channels) {
                            nArray2[n28 + n29] = nArray[n29];
                            ++n29;
                        }
                        ++n27;
                        n28 += this.channels;
                    }
                    ++n26;
                    n3 += n2;
                }
                break;
            }
        }
    }

    public void setColor(double[] dArray) {
        mediaLibImage.validate(this);
        this.checkChannels(dArray);
        if (this.getType() == 0 || this.getType() == 1 || this.getType() == 2 || this.getType() == 6 || this.getType() == 3) {
            throw new mediaLibException(4);
        }
        int n2 = this.getStride();
        int n3 = this.getOffset();
        switch (this.getType()) {
            case 4: {
                float[] fArray = this.getFloatData();
                int n4 = 0;
                while (n4 < this.height) {
                    int n5 = 0;
                    int n6 = n3;
                    while (n5 < this.width) {
                        int n7 = 0;
                        while (n7 < this.channels) {
                            fArray[n6 + n7] = (float)dArray[n7];
                            ++n7;
                        }
                        ++n5;
                        n6 += this.channels;
                    }
                    ++n4;
                    n3 += n2;
                }
                break;
            }
            case 5: {
                double[] dArray2 = this.getDoubleData();
                int n8 = 0;
                while (n8 < this.height) {
                    int n9 = 0;
                    int n10 = n3;
                    while (n9 < this.width) {
                        int n11 = 0;
                        while (n11 < this.channels) {
                            dArray2[n10 + n11] = dArray[n11];
                            ++n11;
                        }
                        ++n9;
                        n10 += this.channels;
                    }
                    ++n8;
                    n3 += n2;
                }
                break;
            }
        }
    }

    public Object clone() {
        try {
            mediaLibImage mediaLibImage2 = (mediaLibImage)super.clone();
            switch (this.type) {
                case 0: {
                    mediaLibImage2.data = ((byte[])this.data).clone();
                    break;
                }
                case 1: {
                    mediaLibImage2.data = ((byte[])this.data).clone();
                    break;
                }
                case 2: 
                case 6: {
                    mediaLibImage2.data = ((short[])this.data).clone();
                    break;
                }
                case 3: {
                    mediaLibImage2.data = ((int[])this.data).clone();
                    break;
                }
                case 4: {
                    mediaLibImage2.data = ((float[])this.data).clone();
                    break;
                }
                case 5: {
                    mediaLibImage2.data = ((double[])this.data).clone();
                }
            }
            return mediaLibImage2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public mediaLibImage createCompatibleImage() {
        try {
            mediaLibImage mediaLibImage2 = (mediaLibImage)super.clone();
            switch (this.type) {
                case 0: {
                    mediaLibImage2.data = new byte[((byte[])this.data).length];
                    break;
                }
                case 1: {
                    mediaLibImage2.data = new byte[((byte[])this.data).length];
                    break;
                }
                case 2: 
                case 6: {
                    mediaLibImage2.data = new short[((short[])this.data).length];
                    break;
                }
                case 3: {
                    mediaLibImage2.data = new int[((int[])this.data).length];
                    break;
                }
                case 4: {
                    mediaLibImage2.data = new float[((float[])this.data).length];
                    break;
                }
                case 5: {
                    mediaLibImage2.data = new double[((double[])this.data).length];
                }
            }
            return mediaLibImage2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int getType() {
        return this.type;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStride() {
        return this.stride;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getBitOffset() {
        return this.bitoffset;
    }

    public int getFormat() {
        return this.format;
    }

    public Object getData() {
        return this.data;
    }

    public byte[] getPaddings() {
        return this.paddings;
    }

    public byte[] getBitData() {
        if (this.type == 0) {
            return (byte[])this.data;
        }
        return null;
    }

    public byte[] getByteData() {
        if (this.type == 1) {
            return (byte[])this.data;
        }
        return null;
    }

    public short[] getShortData() {
        if (this.type == 2) {
            return (short[])this.data;
        }
        return null;
    }

    public short[] getUShortData() {
        if (this.type == 6) {
            return (short[])this.data;
        }
        return null;
    }

    public int[] getIntData() {
        if (this.type == 3) {
            return (int[])this.data;
        }
        return null;
    }

    public float[] getFloatData() {
        if (this.type == 4) {
            return (float[])this.data;
        }
        return null;
    }

    public double[] getDoubleData() {
        if (this.type == 5) {
            return (double[])this.data;
        }
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public String getName() {
        return this.url.toString();
    }

    public void setFormat(int n2) {
        this.format = n2;
    }

    public void setPaddings(byte by2, byte by3, byte by4, byte by5) {
        if ((by2 & 0xFF) + (by4 & 0xFF) >= this.width || (by3 & 0xFF) + (by5 & 0xFF) >= this.height) {
            throw new mediaLibException(11);
        }
        this.paddings[0] = by2;
        this.paddings[1] = by3;
        this.paddings[2] = by4;
        this.paddings[3] = by5;
    }

    public void setPaddings(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length != 4) {
            throw new mediaLibException(11);
        }
        if ((byArray[0] & 0xFF) + (byArray[2] & 0xFF) >= this.width || (byArray[1] & 0xFF) + (byArray[3] & 0xFF) >= this.height) {
            throw new mediaLibException(11);
        }
        this.paddings[0] = byArray[0];
        this.paddings[1] = byArray[1];
        this.paddings[2] = byArray[2];
        this.paddings[3] = byArray[3];
    }

    public void readSunImage(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n2 = dataInputStream.readInt();
            if (n2 != 1504078485) {
                System.err.println("Not a Sun raster file.");
                dataInputStream.close();
                return;
            }
            this.width = dataInputStream.readInt();
            this.height = dataInputStream.readInt();
            this.depth = dataInputStream.readInt();
            this.length = dataInputStream.readInt();
            this.type = 1;
            this.channels = this.depth / 8;
            this.stride = this.channels * this.width;
            this.rttype = dataInputStream.readInt();
            if (this.rttype != 1) {
                System.err.println("Unsupported data type.");
                dataInputStream.close();
                return;
            }
            this.maptype = dataInputStream.readInt();
            this.maplength = dataInputStream.readInt();
            this.maplength /= 3;
            if (this.channels == 1 && this.maplength != 0) {
                this.format = 1;
            } else if (this.channels == 1 && this.maplength == 0) {
                this.format = 2;
            } else if (this.channels == 3) {
                this.format = 4;
            } else if (this.channels == 4) {
                this.format = 6;
            }
            byte[] byArray = new byte[this.maplength];
            byte[] byArray2 = new byte[this.maplength];
            byte[] byArray3 = new byte[this.maplength];
            dataInputStream.readFully(byArray);
            dataInputStream.readFully(byArray2);
            dataInputStream.readFully(byArray3);
            this.data = new byte[this.length];
            dataInputStream.readFully((byte[])this.data);
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when reading data from stream ");
            throw iOException;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data input stream ");
            throw iOException;
        }
    }

    public void writeSunImage(OutputStream outputStream) throws IOException, mediaLibException {
        if (this.type != 1) {
            throw new mediaLibException(4);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(1504078485);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.channels * 8);
            dataOutputStream.writeInt(this.width * this.channels * this.height);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            byte[] byArray = new byte[this.width * this.channels];
            byte[] byArray2 = this.getByteData();
            int n2 = this.offset;
            int n3 = 0;
            while (n3 < this.height) {
                int n4 = 0;
                while (n4 < this.width * this.channels) {
                    byArray[n4] = byArray2[n2 + n4];
                    ++n4;
                }
                n2 += this.stride;
                dataOutputStream.write(byArray, 0, this.width * this.channels);
                ++n3;
            }
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when writing data to stream ");
            throw iOException;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data output stream ");
            throw iOException;
        }
    }

    public void writeSunImage(OutputStream outputStream, mediaLibImageColormap mediaLibImageColormap2) throws IOException, mediaLibException {
        if (this.type != 1) {
            throw new mediaLibException(4);
        }
        if (mediaLibImageColormap2.getInType() != 1 || mediaLibImageColormap2.getOutType() != 1) {
            throw new mediaLibException(12);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(1504078485);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.channels * 8);
            dataOutputStream.writeInt(this.width * this.channels * this.height);
            dataOutputStream.writeInt(1);
            this.maplength = mediaLibImageColormap2.getLength();
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.maplength * 3);
            dataOutputStream.write((byte[])mediaLibImageColormap2.getRedMap(), 0, this.maplength);
            dataOutputStream.write((byte[])mediaLibImageColormap2.getGreenMap(), 0, this.maplength);
            dataOutputStream.write((byte[])mediaLibImageColormap2.getBlueMap(), 0, this.maplength);
            byte[] byArray = new byte[this.width * this.channels];
            byte[] byArray2 = this.getByteData();
            int n2 = this.offset;
            int n3 = 0;
            while (n3 < this.height) {
                int n4 = 0;
                while (n4 < this.width * this.channels) {
                    byArray[n4] = byArray2[n2 + n4];
                    ++n4;
                }
                n2 += this.stride;
                dataOutputStream.write(byArray, 0, this.width * this.channels);
                ++n3;
            }
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when writing data to stream ");
            throw iOException;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data output stream ");
            throw iOException;
        }
    }

    public void readSunImage(URL uRL) {
        InputStream inputStream;
        this.url = uRL;
        try {
            inputStream = this.url.openStream();
        }
        catch (IOException iOException) {
            System.err.println("IOException when opening Stream -> " + this.url.toString());
            return;
        }
        try {
            this.readSunImage(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("-> " + this.url.toString());
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException when closing stream -> " + this.url.toString());
        }
    }

    public void writeSunImage(URL uRL) throws mediaLibException {
        String string = uRL.getFile();
        File file = new File(string);
        this.writeSunImage(file);
    }

    public void writeSunImage(URL uRL, mediaLibImageColormap mediaLibImageColormap2) throws mediaLibException {
        String string = uRL.getFile();
        File file = new File(string);
        this.writeSunImage(file, mediaLibImageColormap2);
    }

    public void readSunImage(File file) {
        String string = file.getAbsolutePath();
        try {
            this.url = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed URL exception -> file:" + string);
            return;
        }
        this.offset = 0;
        this.readSunImage(this.url);
    }

    public void writeSunImage(File file) throws mediaLibException {
        FileOutputStream fileOutputStream;
        if (file.exists() && !file.canWrite()) {
            System.err.println("Current execution context is not allowed to write to file ->" + file.getAbsolutePath());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("IOException while opening file output stream ->" + file.getAbsolutePath());
            return;
        }
        try {
            this.writeSunImage(fileOutputStream);
        }
        catch (IOException iOException) {
            System.err.println("-> " + file.getAbsolutePath());
        }
        catch (mediaLibException mediaLibException2) {
            throw mediaLibException2;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException while closing file output stream ->" + file.getAbsolutePath());
            return;
        }
    }

    public void writeSunImage(File file, mediaLibImageColormap mediaLibImageColormap2) throws mediaLibException {
        FileOutputStream fileOutputStream;
        if (file.exists() && !file.canWrite()) {
            System.err.println("Current execution context is not allowed to write to file ->" + file.getAbsolutePath());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("IOException while opening file output stream ->" + file.getAbsolutePath());
            return;
        }
        try {
            this.writeSunImage(fileOutputStream, mediaLibImageColormap2);
        }
        catch (IOException iOException) {
            System.err.println("-> " + file.getAbsolutePath());
        }
        catch (mediaLibException mediaLibException2) {
            throw mediaLibException2;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException while closing file output stream ->" + file.getAbsolutePath());
            return;
        }
    }

    private boolean testData() {
        if (this.offset < 0) {
            throw new mediaLibException(9);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.width * this.channels;
        switch (this.type) {
            case 0: {
                n2 = ((byte[])this.data).length;
                if (n2 == 0) {
                    return true;
                }
                n4 = (n4 + 7) / 8;
                break;
            }
            case 1: {
                n2 = ((byte[])this.data).length;
                if (n2 != 0) break;
                return true;
            }
            case 2: 
            case 6: {
                n2 = ((short[])this.data).length;
                if (n2 != 0) break;
                return true;
            }
            case 3: {
                n2 = ((int[])this.data).length;
                if (n2 != 0) break;
                return true;
            }
            case 4: {
                n2 = ((float[])this.data).length;
                if (n2 != 0) break;
                return true;
            }
            case 5: {
                n2 = ((double[])this.data).length;
                if (n2 != 0) break;
                return true;
            }
        }
        n3 = n2 - this.offset;
        if (n3 <= 0) {
            throw new mediaLibException(9);
        }
        return n3 < (this.height - 1) * this.stride + n4;
    }

    protected void validate() {
        mediaLibImage.validate(this);
    }

    protected static void validate(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 6 && mediaLibImage2.type != 3 && mediaLibImage2.type != 4 && mediaLibImage2.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        if (mediaLibImage2.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        if (bl2) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        if (bl2) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, int n2) {
        mediaLibImage.validate(mediaLibImage2);
        if (mediaLibImage2.channels != 1) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.type != n2) {
            throw new mediaLibException(4);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 6 && mediaLibImage2.type != 3 && mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 6 && mediaLibImage3.type != 3 && mediaLibImage3.type != 4 && mediaLibImage3.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        int n3 = mediaLibImage3.width * mediaLibImage3.channels;
        if (mediaLibImage2.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n3 = (n3 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2 || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n3) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        boolean bl3 = mediaLibImage3.testData();
        if (bl2 || bl3) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 4 && mediaLibImage3.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        int n3 = mediaLibImage3.width * mediaLibImage3.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2 || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n3) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        boolean bl3 = mediaLibImage3.testData();
        if (bl2 || bl3) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 6 && mediaLibImage2.type != 3 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 6 && mediaLibImage3.type != 3 || mediaLibImage4.type != 0 && mediaLibImage4.type != 1 && mediaLibImage4.type != 2 && mediaLibImage4.type != 6 && mediaLibImage4.type != 3) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        int n3 = mediaLibImage3.width * mediaLibImage3.channels;
        int n4 = mediaLibImage4.width * mediaLibImage4.channels;
        if (mediaLibImage2.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n3 = (n3 + 7) / 8;
        }
        if (mediaLibImage4.type == 0) {
            n4 = (n4 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2 || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n3 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n4) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        boolean bl3 = mediaLibImage3.testData();
        boolean bl4 = mediaLibImage4.testData();
        if (bl2 || bl3 || bl4) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 4 && mediaLibImage3.type != 5 || mediaLibImage4.type != 4 && mediaLibImage4.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        int n3 = mediaLibImage3.width * mediaLibImage3.channels;
        int n4 = mediaLibImage4.width * mediaLibImage4.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2 || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n3 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n4) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        boolean bl3 = mediaLibImage3.testData();
        boolean bl4 = mediaLibImage4.testData();
        if (bl2 || bl3 || bl4) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4, mediaLibImage mediaLibImage5) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null || mediaLibImage5.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 6 && mediaLibImage2.type != 3 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 6 && mediaLibImage3.type != 3 || mediaLibImage4.type != 0 && mediaLibImage4.type != 1 && mediaLibImage4.type != 2 && mediaLibImage4.type != 6 && mediaLibImage4.type != 3 || mediaLibImage5.type != 0 && mediaLibImage5.type != 1 && mediaLibImage5.type != 2 && mediaLibImage5.type != 6 && mediaLibImage5.type != 3) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4 || mediaLibImage5.channels < 1 || mediaLibImage5.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0 || mediaLibImage5.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0 || mediaLibImage5.height <= 0) {
            throw new mediaLibException(7);
        }
        int n2 = mediaLibImage2.width * mediaLibImage2.channels;
        int n3 = mediaLibImage3.width * mediaLibImage3.channels;
        int n4 = mediaLibImage4.width * mediaLibImage4.channels;
        int n5 = mediaLibImage5.width * mediaLibImage5.channels;
        if (mediaLibImage2.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n3 = (n3 + 7) / 8;
        }
        if (mediaLibImage4.type == 0) {
            n4 = (n4 + 7) / 8;
        }
        if (mediaLibImage5.type == 0) {
            n5 = (n5 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n2 || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n3 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n4 || mediaLibImage5.stride <= 0 || mediaLibImage5.stride < n5) {
            throw new mediaLibException(8);
        }
        boolean bl2 = mediaLibImage2.testData();
        boolean bl3 = mediaLibImage3.testData();
        boolean bl4 = mediaLibImage4.testData();
        boolean bl5 = mediaLibImage5.testData();
        if (bl2 || bl3 || bl4 || bl5) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4, int n2) {
        mediaLibImage.validate(mediaLibImage2, mediaLibImage3, mediaLibImage4);
        if (mediaLibImage2.type != 1) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 3 || mediaLibImage3.channels < 3 || mediaLibImage4.channels < 3) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.channels == 4 && n2 != 1 && n2 != 8) {
            throw new mediaLibException(5);
        }
    }

    protected void checkCompatibility(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.getType() != this.type) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.getChannels() != this.channels) {
            throw new mediaLibException(5);
        }
    }

    protected void checkSize(mediaLibImage mediaLibImage2) {
        if (this.getWidth() != mediaLibImage2.getWidth()) {
            throw new mediaLibException(6);
        }
        if (this.getHeight() != mediaLibImage2.getHeight()) {
            throw new mediaLibException(7);
        }
    }

    protected void checkChannels(short[] sArray) {
        if (this.getChannels() > sArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkChannels(int[] nArray) {
        if (this.getChannels() > nArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkChannels(double[] dArray) {
        if (this.getChannels() > dArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkChannels(mediaLibImage mediaLibImage2) {
        if (this.getChannels() != mediaLibImage2.getChannels()) {
            throw new mediaLibException(5);
        }
    }

    protected void checkType(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.getType() != this.getType()) {
            throw new mediaLibException(4);
        }
    }
}

