/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.mlib;

import com.sun.medialib.mlib.mediaLibImage;
import com.sun.medialib.mlib.mediaLibImageColormap;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class mediaLibImageJPanel
extends JPanel {
    mediaLibImage myImg;
    mediaLibImageColormap myColormap;
    int myWidth;
    int myHeight;
    Object myData;

    public mediaLibImageJPanel(mediaLibImage mediaLibImage2) {
        this.myImg = mediaLibImage2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setPreferredSize(new Dimension(this.myWidth, this.myHeight));
    }

    public mediaLibImageJPanel(mediaLibImage mediaLibImage2, mediaLibImageColormap mediaLibImageColormap2) {
        this.myImg = mediaLibImage2;
        this.myColormap = mediaLibImageColormap2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setPreferredSize(new Dimension(this.myWidth, this.myHeight));
    }

    public void updateImage(mediaLibImage mediaLibImage2) {
        this.setImage(mediaLibImage2);
    }

    public void updateColormap(mediaLibImageColormap mediaLibImageColormap2) {
        this.myColormap = mediaLibImageColormap2;
        this.repaint();
    }

    public void setImage(mediaLibImage mediaLibImage2) {
        this.myImg = mediaLibImage2;
        this.myWidth = mediaLibImage2.getWidth();
        this.myHeight = mediaLibImage2.getHeight();
        this.myData = mediaLibImage2.getData();
        this.setPreferredSize(new Dimension(this.myWidth, this.myHeight));
        this.repaint();
    }

    public void setColormap(mediaLibImageColormap mediaLibImageColormap2) {
        this.myColormap = mediaLibImageColormap2;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Image image = null;
        int n2 = this.myImg.getFormat();
        int n3 = this.myImg.getChannels();
        int n4 = this.myImg.getType();
        if (n4 == 1) {
            if (n3 == 1) {
                if (n2 == 2) {
                    DirectColorModel directColorModel = new DirectColorModel(8, 255, 255, 255);
                    int n5 = this.myImg.getOffset();
                    int n6 = this.myImg.getStride();
                    image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (ColorModel)directColorModel, (byte[])this.myData, n5, n6));
                } else {
                    IndexColorModel indexColorModel = new IndexColorModel(32, this.myColormap.getLength(), this.myColormap.getByteRedMap(), this.myColormap.getByteGreenMap(), this.myColormap.getByteBlueMap());
                    int n7 = this.myImg.getOffset();
                    int n8 = this.myImg.getStride();
                    image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (ColorModel)indexColorModel, (byte[])this.myData, n7, n8));
                }
            } else if (n3 == 3) {
                int[] nArray = new int[this.myWidth * this.myHeight];
                if (n2 == 3) {
                    this.rgbImage2PackedARGB(this.myImg, nArray);
                } else if (n2 == 4) {
                    this.bgrImage2PackedARGB(this.myImg, nArray);
                }
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            } else {
                int[] nArray = new int[this.myWidth * this.myHeight];
                if (n2 == 5) {
                    this.argbImage2PackedARGB(this.myImg, nArray);
                } else if (n2 == 6) {
                    this.abgrImage2PackedARGB(this.myImg, nArray);
                }
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            }
        } else if (n4 == 3 && n3 == 1) {
            if (n2 == 7) {
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, (int[])this.myData, 0, this.myWidth));
            } else if (n2 == 8) {
                int[] nArray = new int[this.myWidth * this.myHeight];
                this.packedabgrImage2PackedARGB(this.myImg, nArray);
                image = this.createImage(new MemoryImageSource(this.myWidth, this.myHeight, nArray, 0, this.myWidth));
            }
        }
        graphics.drawImage(image, 0, 0, this);
        System.gc();
    }

    public Dimension setMinimumSize() {
        return new Dimension(this.myWidth, this.myHeight);
    }

    public Dimension setPreferredSize() {
        return new Dimension(this.myWidth, this.myHeight);
    }

    private void rgbImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n2 = mediaLibImage2.getWidth();
        int n3 = mediaLibImage2.getHeight();
        int n4 = mediaLibImage2.getStride();
        int n5 = mediaLibImage2.getOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n5 + n7 * n4;
            int n9 = 0;
            while (n9 < n2) {
                int n10 = byArray[n8] & 0xFF;
                int n11 = byArray[n8 + 1] & 0xFF;
                int n12 = byArray[n8 + 2] & 0xFF;
                int n13 = -16777216;
                n13 |= n10 << 16;
                n13 |= n11 << 8;
                nArray[n6++] = n13 |= n12;
                ++n9;
                n8 += 3;
            }
            ++n7;
        }
    }

    private void bgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n2 = mediaLibImage2.getWidth();
        int n3 = mediaLibImage2.getHeight();
        int n4 = mediaLibImage2.getStride();
        int n5 = mediaLibImage2.getOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n5 + n7 * n4;
            int n9 = 0;
            while (n9 < n2) {
                int n10 = byArray[n8] & 0xFF;
                int n11 = byArray[n8 + 1] & 0xFF;
                int n12 = byArray[n8 + 2] & 0xFF;
                int n13 = -16777216;
                n13 |= n12 << 16;
                n13 |= n11 << 8;
                nArray[n6++] = n13 |= n10;
                ++n9;
                n8 += 3;
            }
            ++n7;
        }
    }

    private void argbImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n2 = mediaLibImage2.getWidth();
        int n3 = mediaLibImage2.getHeight();
        int n4 = mediaLibImage2.getStride();
        int n5 = mediaLibImage2.getOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n5 + n7 * n4;
            int n9 = 0;
            while (n9 < n2) {
                int n10 = byArray[n8] & 0xFF;
                int n11 = byArray[n8 + 1] & 0xFF;
                int n12 = byArray[n8 + 2] & 0xFF;
                int n13 = byArray[n8 + 3] & 0xFF;
                int n14 = n10 << 24;
                n14 |= n11 << 16;
                n14 |= n12 << 8;
                nArray[n6++] = n14 |= n13;
                ++n9;
                n8 += 4;
            }
            ++n7;
        }
    }

    private void abgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        byte[] byArray = mediaLibImage2.getByteData();
        int n2 = mediaLibImage2.getWidth();
        int n3 = mediaLibImage2.getHeight();
        int n4 = mediaLibImage2.getStride();
        int n5 = mediaLibImage2.getOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n5 + n7 * n4;
            int n9 = 0;
            while (n9 < n2) {
                int n10 = byArray[n8] & 0xFF;
                int n11 = byArray[n8 + 1] & 0xFF;
                int n12 = byArray[n8 + 2] & 0xFF;
                int n13 = byArray[n8 + 3] & 0xFF;
                int n14 = n10 << 24;
                n14 |= n13 << 16;
                n14 |= n12 << 8;
                nArray[n6++] = n14 |= n11;
                ++n9;
                n8 += 4;
            }
            ++n7;
        }
    }

    private void packedabgrImage2PackedARGB(mediaLibImage mediaLibImage2, int[] nArray) {
        Object object = mediaLibImage2.getData();
        byte[] byArray = (byte[])object;
        int n2 = mediaLibImage2.getWidth();
        int n3 = mediaLibImage2.getHeight();
        int n4 = mediaLibImage2.getStride();
        int n5 = mediaLibImage2.getOffset();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n5 + n7 * n4;
            int n9 = 0;
            while (n9 < n2) {
                int n10 = byArray[n8] & 0xFF;
                int n11 = byArray[n8 + 1] & 0xFF;
                int n12 = byArray[n8 + 2] & 0xFF;
                int n13 = byArray[n8 + 3] & 0xFF;
                int n14 = n10 << 24;
                n14 |= n13 << 16;
                n14 |= n12 << 8;
                nArray[n6++] = n14 |= n11;
                ++n9;
                n8 += 4;
            }
            ++n7;
        }
    }
}

