/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int k = 8192;
    private ByteBuffer j = ByteBuffer.allocate(8);
    private ByteBuffer C;
    private ImageInputStream f;

    @Override
    public boolean isCachedFile() {
        BufferedImageInputStream a2;
        return a2.f.isCachedFile();
    }

    @Override
    public int readInt() throws IOException {
        BufferedImageInputStream a2;
        a2.readFully(a2.j.array(), 0, 4);
        return a2.j.getInt(0);
    }

    @Override
    public void close() throws IOException {
        BufferedImageInputStream a2;
        if (a2.f != null) {
            a2.f = null;
            a2.C = null;
        }
        super.close();
    }

    private /* synthetic */ int l(byte[] a2, int a3, int a4) {
        BufferedImageInputStream a5;
        if (!a5.C.hasRemaining()) {
            return -1;
        }
        int n2 = Math.min(a5.C.remaining(), a4);
        if (n2 > 0) {
            int n3 = a5.C.position();
            System.arraycopy(a5.C.array(), n3, a2, a3, n2);
            a5.C.position(n3 + n2);
        }
        a5.streamPos += (long)n2;
        return n2;
    }

    @Override
    public int read(byte[] a2, int a3, int a4) throws IOException {
        BufferedImageInputStream a5;
        a5.checkClosed();
        a5.bitOffset = 0;
        if (!a5.C.hasRemaining()) {
            if (a4 >= a5.C.capacity()) {
                return a5.F(a2, a3, a4);
            }
            a5.F();
        }
        return a5.l(a2, a3, a4);
    }

    @Override
    public void seek(long a2) throws IOException {
        BufferedImageInputStream a3;
        a3.checkClosed();
        a3.bitOffset = 0;
        if (a3.streamPos == a2) {
            return;
        }
        long l2 = (long)a3.C.position() + a2 - a3.streamPos;
        if (l2 >= 0L && l2 <= (long)a3.C.limit()) {
            a3.C.position((int)l2);
        } else {
            a3.C.limit(0);
            a3.f.seek(a2);
        }
        a3.streamPos = a2;
    }

    @Override
    public int read() throws IOException {
        BufferedImageInputStream a2;
        a2.checkClosed();
        if (!a2.C.hasRemaining()) {
            a2.F();
        }
        if (!a2.C.hasRemaining()) {
            return -1;
        }
        a2.bitOffset = 0;
        ++a2.streamPos;
        return a2.C.get() & 0xFF;
    }

    @Override
    public void flushBefore(long a2) throws IOException {
        BufferedImageInputStream a3;
        a3.checkClosed();
        a3.f.flushBefore(a2);
    }

    @Override
    public long readBits(int a2) throws IOException {
        int n2;
        BufferedImageInputStream a3;
        a3.checkClosed();
        if (a2 < 0 || a2 > 64) {
            throw new IllegalArgumentException();
        }
        if (a2 == 0) {
            return 0L;
        }
        int n3 = a3.bitOffset + a2 & 7;
        long l2 = 0L;
        for (n2 = a2 + a3.bitOffset; n2 > 0; n2 -= 8) {
            if (!a3.C.hasRemaining()) {
                a3.F();
                if (!a3.C.hasRemaining()) {
                    throw new EOFException();
                }
            }
            int n4 = a3.C.get() & 0xFF;
            l2 <<= 8;
            l2 |= (long)n4;
        }
        if (n3 != 0) {
            a3.C.position(a3.C.position() - 1);
        } else {
            ++a3.streamPos;
        }
        a3.bitOffset = n3;
        l2 >>>= -n2;
        return l2 &= -1L >>> 64 - a2;
    }

    @Override
    public long length() {
        try {
            BufferedImageInputStream a2;
            return a2.f.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public boolean isCachedMemory() {
        BufferedImageInputStream a2;
        return a2.f.isCachedMemory();
    }

    @Override
    public void setByteOrder(ByteOrder a2) {
        BufferedImageInputStream a3;
        super.setByteOrder(a2);
        a3.j.order(a2);
    }

    @Override
    public int readBit() throws IOException {
        BufferedImageInputStream a2;
        a2.checkClosed();
        if (!a2.C.hasRemaining()) {
            a2.F();
            if (!a2.C.hasRemaining()) {
                throw new EOFException();
            }
        }
        int n2 = a2.bitOffset + 1 & 7;
        int n3 = a2.C.get() & 0xFF;
        if (n2 != 0) {
            a2.C.position(a2.C.position() - 1);
            n3 >>= 8 - n2;
        } else {
            ++a2.streamPos;
        }
        a2.bitOffset = n2;
        return n3 & 1;
    }

    @Override
    public long readLong() throws IOException {
        BufferedImageInputStream a2;
        a2.readFully(a2.j.array(), 0, 8);
        return a2.j.getLong(0);
    }

    @Override
    protected void finalize() throws Throwable {
        BufferedImageInputStream a2;
        super.finalize();
    }

    private /* synthetic */ void F() throws IOException {
        BufferedImageInputStream a2;
        a2.C.clear();
        int n2 = a2.f.read(a2.C.array(), 0, a2.C.capacity());
        if (n2 >= 0) {
            a2.C.position(n2);
            a2.C.flip();
        } else {
            a2.C.limit(0);
        }
    }

    private /* synthetic */ int F(byte[] a2, int a3, int a4) throws IOException {
        BufferedImageInputStream a5;
        a5.C.limit(0);
        int n2 = a5.f.read(a2, a3, a4);
        if (n2 > 0) {
            a5.streamPos += (long)n2;
        }
        return n2;
    }

    @Override
    public boolean isCached() {
        BufferedImageInputStream a2;
        return a2.f.isCached();
    }

    private /* synthetic */ BufferedImageInputStream(ImageInputStream a2, int a3) throws IOException {
        BufferedImageInputStream a4;
        a4.f = Validate.F(a2, sD.F("\\n]\u007fNw"));
        a4.streamPos = a2.getStreamPosition();
        a4.C = ByteBuffer.allocate(a3);
        a4.C.limit(0);
    }

    public BufferedImageInputStream(ImageInputStream a2) throws IOException {
        a3(a2, 8192);
        BufferedImageInputStream a3;
    }

    @Override
    public short readShort() throws IOException {
        BufferedImageInputStream a2;
        a2.readFully(a2.j.array(), 0, 2);
        return a2.j.getShort(0);
    }

    @Override
    public long getFlushedPosition() {
        BufferedImageInputStream a2;
        return a2.f.getFlushedPosition();
    }
}

