/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    @Override
    public int readUnsignedShort() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        int n3 = a2.in.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    @Override
    public char readChar() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        int n3 = a2.in.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (char)(n3 << 24 >>> 16 | n2 << 24 >>> 24);
    }

    @Override
    public String readLine() throws IOException {
        LittleEndianDataInputStream a2;
        DataInputStream dataInputStream = new DataInputStream(a2.in);
        return dataInputStream.readLine();
    }

    @Override
    public final void readFully(byte[] a2) throws IOException {
        LittleEndianDataInputStream a3;
        a3.readFully(a2, 0, a2.length);
    }

    @Override
    public byte readByte() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    @Override
    public final float readFloat() throws IOException {
        LittleEndianDataInputStream a2;
        return Float.intBitsToFloat(a2.readInt());
    }

    @Override
    public int readUnsignedByte() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    public final int skipBytes(int a2) throws IOException {
        LittleEndianDataInputStream a3;
        int n2;
        int n3;
        for (n2 = 0; n2 < a2 && (n3 = (int)a3.in.skip(a2 - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    @Override
    public int readInt() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        int n3 = a2.in.read();
        int n4 = a2.in.read();
        int n5 = a2.in.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return n5 << 24 | n4 << 24 >>> 8 | n3 << 24 >>> 16 | n2 << 24 >>> 24;
    }

    @Override
    public short readShort() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        int n3 = a2.in.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (short)(n3 << 24 >>> 16 | n2 << 24 >>> 24);
    }

    @Override
    public long readLong() throws IOException {
        LittleEndianDataInputStream a2;
        long l2 = a2.in.read();
        long l3 = a2.in.read();
        long l4 = a2.in.read();
        long l5 = a2.in.read();
        long l6 = a2.in.read();
        long l7 = a2.in.read();
        long l8 = a2.in.read();
        long l9 = a2.in.read();
        if (l9 < 0L) {
            throw new EOFException();
        }
        return l9 << 56 | l8 << 56 >>> 8 | l7 << 56 >>> 16 | l6 << 56 >>> 24 | l5 << 56 >>> 32 | l4 << 56 >>> 40 | l3 << 56 >>> 48 | l2 << 56 >>> 56;
    }

    @Override
    public String readUTF() throws IOException {
        LittleEndianDataInputStream a2;
        int n2 = a2.in.read();
        int n3 = a2.in.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        int n4 = (n2 << 8) + n3;
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8 = a2.readUnsignedByte();
            int n9 = n8 >> 4;
            if (n9 < 8) {
                ++n5;
                cArray[n6++] = (char)n8;
                continue;
            }
            if (n9 == 12 || n9 == 13) {
                if ((n5 += 2) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = a2.readUnsignedByte();
                if ((n7 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0x1F) << 6 | n7 & 0x3F);
                continue;
            }
            if (n9 == 14) {
                if ((n5 += 3) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = a2.readUnsignedByte();
                int n10 = a2.readUnsignedByte();
                if ((n7 & 0xC0) != 128 || (n10 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0xF) << 12 | (n7 & 0x3F) << 6 | n10 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n6);
    }

    @Override
    public final void readFully(byte[] a2, int a3, int a4) throws IOException {
        int n2;
        if (a4 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = 0; i2 < a4; i2 += n2) {
            LittleEndianDataInputStream a5;
            n2 = a5.in.read(a2, a3 + i2, a4 - i2);
            if (n2 >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public final double readDouble() throws IOException {
        LittleEndianDataInputStream a2;
        return Double.longBitsToDouble(a2.readLong());
    }

    public LittleEndianDataInputStream(InputStream a2) {
        super(Validate.F(a2, zH.F("e}dlwd")));
        LittleEndianDataInputStream a3;
    }
}

