/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.lang.Validate;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int f;

    @Override
    public synchronized void write(byte[] a2, int a3, int a4) throws IOException {
        LittleEndianDataOutputStream a5;
        a5.out.write(a2, a3, a4);
        a5.f += a4;
    }

    @Override
    public void writeChar(int a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write(a2 & 0xFF);
        a3.out.write(a2 >>> 8 & 0xFF);
        a3.f += 2;
    }

    @Override
    public void writeUTF(String a2) throws IOException {
        LittleEndianDataOutputStream a3;
        char c2;
        int n2;
        int n3 = a2.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = a2.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n4;
                continue;
            }
            if (c2 > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 > 65535) {
            throw new UTFDataFormatException();
        }
        a3.out.write(n4 >>> 8 & 0xFF);
        a3.out.write(n4 & 0xFF);
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = a2.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                a3.out.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                a3.out.write(0xE0 | c2 >> 12 & 0xF);
                a3.out.write(0x80 | c2 >> 6 & 0x3F);
                a3.out.write(0x80 | c2 & 0x3F);
                a3.f += 2;
                continue;
            }
            a3.out.write(0xC0 | c2 >> 6 & 0x1F);
            a3.out.write(0x80 | c2 & 0x3F);
            ++a3.f;
        }
        a3.f += n3 + 2;
    }

    @Override
    public void writeBoolean(boolean a2) throws IOException {
        LittleEndianDataOutputStream a3;
        if (a2) {
            a3.write(1);
        } else {
            a3.write(0);
        }
    }

    @Override
    public void writeBytes(String a2) throws IOException {
        int n2 = a2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianDataOutputStream a3;
            a3.out.write((byte)a2.charAt(i2));
        }
        a3.f += n2;
    }

    public int F() {
        LittleEndianDataOutputStream a2;
        return a2.f;
    }

    @Override
    public void writeInt(int a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write(a2 & 0xFF);
        a3.out.write(a2 >>> 8 & 0xFF);
        a3.out.write(a2 >>> 16 & 0xFF);
        a3.out.write(a2 >>> 24 & 0xFF);
        a3.f += 4;
    }

    @Override
    public final void writeDouble(double a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.writeLong(Double.doubleToLongBits(a2));
    }

    @Override
    public synchronized void write(int a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write(a2);
        ++a3.f;
    }

    public LittleEndianDataOutputStream(OutputStream a2) {
        super(Validate.F(a2, Ag.F("8+9:*2")));
        LittleEndianDataOutputStream a3;
    }

    @Override
    public void writeChars(String a2) throws IOException {
        int n2 = a2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianDataOutputStream a3;
            char c2 = a2.charAt(i2);
            a3.out.write(c2 & 0xFF);
            a3.out.write(c2 >>> 8 & 0xFF);
        }
        a3.f += n2 * 2;
    }

    @Override
    public void writeByte(int a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write(a2);
        ++a3.f;
    }

    @Override
    public void writeLong(long a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write((int)a2 & 0xFF);
        a3.out.write((int)(a2 >>> 8) & 0xFF);
        a3.out.write((int)(a2 >>> 16) & 0xFF);
        a3.out.write((int)(a2 >>> 24) & 0xFF);
        a3.out.write((int)(a2 >>> 32) & 0xFF);
        a3.out.write((int)(a2 >>> 40) & 0xFF);
        a3.out.write((int)(a2 >>> 48) & 0xFF);
        a3.out.write((int)(a2 >>> 56) & 0xFF);
        a3.f += 8;
    }

    @Override
    public final void writeFloat(float a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.writeInt(Float.floatToIntBits(a2));
    }

    @Override
    public void writeShort(int a2) throws IOException {
        LittleEndianDataOutputStream a3;
        a3.out.write(a2 & 0xFF);
        a3.out.write(a2 >>> 8 & 0xFF);
        a3.f += 2;
    }
}

