/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.FileUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.nio.channels.FileChannel;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LittleEndianRandomAccessFile
implements DataInput,
DataOutput {
    private RandomAccessFile f;

    public int F(byte[] a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        return a3.f.read(a2);
    }

    @Override
    public char readChar() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        int n3 = a2.f.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 24 >>> 16) + (n2 << 24 >>> 24));
    }

    @Override
    public final void writeFloat(float a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.writeInt(Float.floatToIntBits(a2));
    }

    @Override
    public int readInt() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        int n3 = a2.f.read();
        int n4 = a2.f.read();
        int n5 = a2.f.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 24 >>> 8) + (n3 << 24 >>> 16) + (n2 << 24 >>> 24);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        int n3 = a2.f.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    @Override
    public void write(byte[] a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2);
    }

    @Override
    public void writeUTF(String a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        char c2;
        int n2;
        int n3 = a2.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = a2.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n4;
                continue;
            }
            if (c2 > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 > 65535) {
            throw new UTFDataFormatException();
        }
        a3.f.write(n4 >>> 8 & 0xFF);
        a3.f.write(n4 & 0xFF);
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = a2.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                a3.f.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                a3.f.write(0xE0 | c2 >> 12 & 0xF);
                a3.f.write(0x80 | c2 >> 6 & 0x3F);
                a3.f.write(0x80 | c2 & 0x3F);
                continue;
            }
            a3.f.write(0xC0 | c2 >> 6 & 0x1F);
            a3.f.write(0x80 | c2 & 0x3F);
        }
    }

    @Override
    public void write(byte[] a2, int a3, int a4) throws IOException {
        LittleEndianRandomAccessFile a5;
        a5.f.write(a2, a3, a4);
    }

    @Override
    public void write(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2);
    }

    public void F() throws IOException {
        LittleEndianRandomAccessFile a2;
        a2.f.close();
    }

    @Override
    public void writeInt(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2 & 0xFF);
        a3.f.write(a2 >>> 8 & 0xFF);
        a3.f.write(a2 >>> 16 & 0xFF);
        a3.f.write(a2 >>> 24 & 0xFF);
    }

    @Override
    public byte readByte() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public LittleEndianRandomAccessFile(String a2, String a3) throws FileNotFoundException {
        a4(FileUtil.F(a2), a3);
        LittleEndianRandomAccessFile a4;
    }

    public LittleEndianRandomAccessFile(File a2, String a3) throws FileNotFoundException {
        LittleEndianRandomAccessFile a4;
        a4.f = new RandomAccessFile(a2, a3);
    }

    public void l(long a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.seek(a2);
    }

    @Override
    public final double readDouble() throws IOException {
        LittleEndianRandomAccessFile a2;
        return Double.longBitsToDouble(a2.readLong());
    }

    @Override
    public int readUnsignedByte() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public int F(byte[] a2, int a3, int a4) throws IOException {
        LittleEndianRandomAccessFile a5;
        return a5.f.read(a2, a3, a4);
    }

    @Override
    public void readFully(byte[] a2, int a3, int a4) throws IOException {
        LittleEndianRandomAccessFile a5;
        a5.f.readFully(a2, a3, a4);
    }

    @Override
    public void writeBytes(String a2) throws IOException {
        int n2 = a2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianRandomAccessFile a3;
            a3.f.write((byte)a2.charAt(i2));
        }
    }

    @Override
    public void writeShort(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2 & 0xFF);
        a3.f.write(a2 >>> 8 & 0xFF);
    }

    @Override
    public void writeBoolean(boolean a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        if (a2) {
            a3.write(1);
        } else {
            a3.write(0);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    @Override
    public void readFully(byte[] a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.readFully(a2);
    }

    public FileDescriptor F() throws IOException {
        LittleEndianRandomAccessFile a2;
        return a2.f.getFD();
    }

    @Override
    public String readLine() throws IOException {
        LittleEndianRandomAccessFile a2;
        return a2.f.readLine();
    }

    public long l() throws IOException {
        LittleEndianRandomAccessFile a2;
        return a2.f.length();
    }

    @Override
    public void writeLong(long a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write((int)a2 & 0xFF);
        a3.f.write((int)(a2 >>> 8) & 0xFF);
        a3.f.write((int)(a2 >>> 16) & 0xFF);
        a3.f.write((int)(a2 >>> 24) & 0xFF);
        a3.f.write((int)(a2 >>> 32) & 0xFF);
        a3.f.write((int)(a2 >>> 40) & 0xFF);
        a3.f.write((int)(a2 >>> 48) & 0xFF);
        a3.f.write((int)(a2 >>> 56) & 0xFF);
    }

    @Override
    public int skipBytes(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        return a3.f.skipBytes(a2);
    }

    public void F(long a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.setLength(a2);
    }

    @Override
    public void writeChars(String a2) throws IOException {
        int n2 = a2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            LittleEndianRandomAccessFile a3;
            char c2 = a2.charAt(i2);
            a3.f.write(c2 & 0xFF);
            a3.f.write(c2 >>> 8 & 0xFF);
        }
    }

    @Override
    public String readUTF() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        int n3 = a2.f.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        int n4 = (n2 << 8) + n3;
        char[] cArray = new char[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8 = a2.readUnsignedByte();
            int n9 = n8 >> 4;
            if (n9 < 8) {
                ++n5;
                cArray[n6++] = (char)n8;
                continue;
            }
            if (n9 == 12 || n9 == 13) {
                if ((n5 += 2) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = a2.readUnsignedByte();
                if ((n7 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0x1F) << 6 | n7 & 0x3F);
                continue;
            }
            if (n9 == 14) {
                if ((n5 += 3) > n4) {
                    throw new UTFDataFormatException();
                }
                n7 = a2.readUnsignedByte();
                int n10 = a2.readUnsignedByte();
                if ((n7 & 0xC0) != 128 || (n10 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray[n6++] = (char)((n8 & 0xF) << 12 | (n7 & 0x3F) << 6 | n10 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n6);
    }

    @Override
    public void writeByte(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2);
    }

    @Override
    public short readShort() throws IOException {
        LittleEndianRandomAccessFile a2;
        int n2 = a2.f.read();
        int n3 = a2.f.read();
        if (n3 < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 24 >>> 16) + (n2 << 24) >>> 24);
    }

    public FileChannel F() {
        LittleEndianRandomAccessFile a2;
        return a2.f.getChannel();
    }

    @Override
    public long readLong() throws IOException {
        LittleEndianRandomAccessFile a2;
        long l2 = a2.f.read();
        long l3 = a2.f.read();
        long l4 = a2.f.read();
        long l5 = a2.f.read();
        long l6 = a2.f.read();
        long l7 = a2.f.read();
        long l8 = a2.f.read();
        long l9 = a2.f.read();
        if (l9 < 0L) {
            throw new EOFException();
        }
        return (l9 << 56) + (l8 << 56 >>> 8) + (l7 << 56 >>> 16) + (l6 << 56 >>> 24) + (l5 << 56 >>> 32) + (l4 << 56 >>> 40) + (l3 << 56 >>> 48) + (l2 << 56 >>> 56);
    }

    @Override
    public final void writeDouble(double a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.writeLong(Double.doubleToLongBits(a2));
    }

    public long F() throws IOException {
        LittleEndianRandomAccessFile a2;
        return a2.f.getFilePointer();
    }

    @Override
    public void writeChar(int a2) throws IOException {
        LittleEndianRandomAccessFile a3;
        a3.f.write(a2 & 0xFF);
        a3.f.write(a2 >>> 8 & 0xFF);
    }

    public int F() throws IOException {
        LittleEndianRandomAccessFile a2;
        return a2.f.read();
    }

    @Override
    public final float readFloat() throws IOException {
        LittleEndianRandomAccessFile a2;
        return Float.intBitsToFloat(a2.readInt());
    }
}

