/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.convert;

import com.twelvemonkeys.image.ImageFilterException;
import com.twelvemonkeys.lang.BeanUtil;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.LRUHashMap;
import com.twelvemonkeys.util.convert.ConversionException;
import com.twelvemonkeys.util.convert.PropertyConverter;
import com.twelvemonkeys.util.convert.TypeMismathException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class NumberConverter
implements PropertyConverter {
    private static final NumberFormat j;
    private static final DecimalFormatSymbols C;
    private static final Map<String, Format> f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String F(Object a2, String a3) throws ConversionException {
        if (a2 == null) {
            return null;
        }
        if (!(a2 instanceof Number)) {
            throw new TypeMismathException(a2.getClass());
        }
        try {
            NumberConverter a4;
            NumberFormat numberFormat;
            if (StringUtil.l(a3)) {
                return j.format(a2);
            }
            NumberFormat numberFormat2 = numberFormat = a4.F(a3);
            synchronized (numberFormat2) {
                return numberFormat.format(a2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ConversionException(runtimeException);
        }
    }

    private /* synthetic */ NumberFormat F(String a2) {
        NumberConverter a3;
        return (NumberFormat)a3.F(DecimalFormat.class, a2, C);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object F(String a2, Class a3, String a4) throws ConversionException {
        if (StringUtil.l(a2)) {
            return null;
        }
        try {
            Number number;
            NumberConverter a5;
            if (a3.equals(BigInteger.class)) {
                return new BigInteger(a2);
            }
            if (a3.equals(BigDecimal.class)) {
                return new BigDecimal(a2);
            }
            NumberFormat numberFormat = a4 == null ? j : a5.F(a4);
            NumberFormat numberFormat2 = numberFormat;
            synchronized (numberFormat2) {
                number = numberFormat.parse(a2);
            }
            if (a3 == Integer.TYPE || a3 == Integer.class) {
                return number.intValue();
            }
            if (a3 == Long.TYPE || a3 == Long.class) {
                return number.longValue();
            }
            if (a3 == Double.TYPE || a3 == Double.class) {
                return number.doubleValue();
            }
            if (a3 == Float.TYPE || a3 == Float.class) {
                return Float.valueOf(number.floatValue());
            }
            if (a3 == Byte.TYPE || a3 == Byte.class) {
                return number.byteValue();
            }
            if (a3 == Short.TYPE || a3 == Short.class) {
                return number.shortValue();
            }
            return number;
        }
        catch (ParseException parseException) {
            throw new ConversionException(parseException);
        }
        catch (RuntimeException runtimeException) {
            throw new ConversionException(runtimeException);
        }
    }

    public NumberConverter() {
        NumberConverter a2;
    }

    static {
        C = new DecimalFormatSymbols(Locale.US);
        j = new DecimalFormat(Rc.F("@\u001bM\b"), C);
        f = new LRUHashMap<String, Format>(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Format F(Class a2, Object ... a3) {
        Map<String, Format> map = f;
        synchronized (map) {
            String string = a2.getName() + ImageFilterException.F("Y") + Arrays.toString(a3);
            Format format = f.get(string);
            if (format == null) {
                try {
                    format = (Format)BeanUtil.F(a2, a3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                f.put(string, format);
            }
            return format;
        }
    }
}

