/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class AreaOpImage
extends OpImage {
    protected int leftPadding;
    protected int rightPadding;
    protected int topPadding;
    protected int bottomPadding;
    protected BorderExtender extender = null;
    private Rectangle theDest;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        if (imageLayout != null && renderedImage != null && (imageLayout.getValidMask() & 0xF) != 0) {
            Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            Rectangle rectangle2 = new Rectangle(imageLayout.getMinX(renderedImage), imageLayout.getMinY(renderedImage), imageLayout.getWidth(renderedImage), imageLayout.getHeight(renderedImage));
            if (rectangle2.intersection(rectangle).isEmpty()) {
                throw new IllegalArgumentException(JaiI18N.getString("AreaOpImage0"));
            }
        }
        return imageLayout;
    }

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = new RenderingHints(null);
                renderingHints.putAll((Map<?, ?>)map);
                map2 = renderingHints;
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.TRUE);
            }
        }
        return map2;
    }

    public AreaOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl2, BorderExtender borderExtender, int n2, int n3, int n4, int n5) {
        super(OpImage.vectorize(renderedImage), AreaOpImage.layoutHelper(imageLayout, renderedImage), AreaOpImage.configHelper(map), bl2);
        this.extender = borderExtender;
        this.leftPadding = n2;
        this.rightPadding = n3;
        this.topPadding = n4;
        this.bottomPadding = n5;
        if (borderExtender == null) {
            int n6 = this.getMinX() + n2;
            int n7 = this.getMinY() + n4;
            int n8 = this.getWidth() - n2 - n3;
            n8 = Math.max(n8, 0);
            int n9 = this.getHeight() - n4 - n5;
            n9 = Math.max(n9, 0);
            this.theDest = new Rectangle(n6, n7, n8, n9);
        } else {
            this.theDest = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public BorderExtender getBorderExtender() {
        return this.extender;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = this.getLeftPadding();
        int n4 = this.getRightPadding();
        int n5 = this.getTopPadding();
        int n6 = this.getBottomPadding();
        return new Rectangle(rectangle.x + n3, rectangle.y + n5, rectangle.width - n3 - n4, rectangle.height - n5 - n6);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n3 = this.getLeftPadding();
        int n4 = this.getRightPadding();
        int n5 = this.getTopPadding();
        int n6 = this.getBottomPadding();
        return new Rectangle(rectangle.x - n3, rectangle.y - n5, rectangle.width + n3 + n4, rectangle.height + n5 + n6);
    }

    public Raster computeTile(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (!this.cobbleSources) {
            return super.computeTile(n2, n3);
        }
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.theDest);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        PlanarImage planarImage = this.getSource(0);
        rectangle2 = rectangle2.intersection(planarImage.getBounds());
        Rectangle rectangle3 = new Rectangle(rectangle2);
        rectangle3.x -= this.getLeftPadding();
        rectangle3.width += this.getLeftPadding() + this.getRightPadding();
        rectangle3.y -= this.getTopPadding();
        rectangle3.height += this.getTopPadding() + this.getBottomPadding();
        IntegerSequence integerSequence = new IntegerSequence();
        IntegerSequence integerSequence2 = new IntegerSequence();
        planarImage.getSplits(integerSequence, integerSequence2, rectangle3);
        IntegerSequence integerSequence3 = new IntegerSequence(rectangle2.x, rectangle2.x + rectangle2.width);
        integerSequence3.insert(rectangle2.x);
        integerSequence3.insert(rectangle2.x + rectangle2.width);
        integerSequence.startEnumeration();
        while (integerSequence.hasMoreElements()) {
            int n7 = integerSequence.nextElement();
            n6 = n7 - this.getLeftPadding();
            n5 = n7 + this.getRightPadding();
            integerSequence3.insert(n6);
            integerSequence3.insert(n5);
        }
        IntegerSequence integerSequence4 = new IntegerSequence(rectangle2.y, rectangle2.y + rectangle2.height);
        integerSequence4.insert(rectangle2.y);
        integerSequence4.insert(rectangle2.y + rectangle2.height);
        integerSequence2.startEnumeration();
        while (integerSequence2.hasMoreElements()) {
            n6 = integerSequence2.nextElement();
            n5 = n6 - this.getBottomPadding();
            n4 = n6 + this.getTopPadding();
            integerSequence4.insert(n5);
            integerSequence4.insert(n4);
        }
        Raster[] rasterArray = new Raster[1];
        integerSequence4.startEnumeration();
        n4 = integerSequence4.nextElement();
        while (integerSequence4.hasMoreElements()) {
            int n8 = integerSequence4.nextElement();
            int n9 = n8 - n4;
            int n10 = n4 - this.getTopPadding();
            int n11 = n8 + this.getBottomPadding();
            int n12 = n11 - n10;
            integerSequence3.startEnumeration();
            n6 = integerSequence3.nextElement();
            while (integerSequence3.hasMoreElements()) {
                n5 = integerSequence3.nextElement();
                int n13 = n5 - n6;
                int n14 = n6 - this.getLeftPadding();
                int n15 = n5 + this.getRightPadding();
                int n16 = n15 - n14;
                Rectangle rectangle4 = new Rectangle(n14, n10, n16, n12);
                rasterArray[0] = this.extender != null ? planarImage.getExtendedData(rectangle4, this.extender) : planarImage.getData(rectangle4);
                Rectangle rectangle5 = new Rectangle(n6, n4, n13, n9);
                this.computeRect(rasterArray, writableRaster, rectangle5);
                if (planarImage.overlapsMultipleTiles(rectangle4)) {
                    this.recycleTile(rasterArray[0]);
                }
                n6 = n5;
            }
            n4 = n8;
        }
        return writableRaster;
    }
}

