/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.media.jai.AttributedImage;
import javax.media.jai.CollectionImage;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public class AttributedImageCollection
extends CollectionImage {
    protected AttributedImageCollection() {
    }

    public AttributedImageCollection(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException(JaiI18N.getString("AttributedImageCollection0"));
        }
        try {
            this.imageCollection = (Collection)collection.getClass().newInstance();
        }
        catch (Exception exception) {
            this.imageCollection = new ArrayList(collection.size());
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof AttributedImage) || this.imageCollection.contains(e2)) continue;
            this.imageCollection.add(e2);
        }
    }

    public Set getAll(Object object) {
        if (object == null) {
            return (Set)this.imageCollection;
        }
        HashSet<AttributedImage> hashSet = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!object.equals(attributedImage.getAttribute())) continue;
            if (hashSet == null) {
                hashSet = new HashSet<AttributedImage>();
            }
            hashSet.add(attributedImage);
        }
        return hashSet;
    }

    public Set getAll(PlanarImage planarImage) {
        if (planarImage == null) {
            return (Set)this.imageCollection;
        }
        HashSet<AttributedImage> hashSet = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!planarImage.equals(attributedImage.getImage())) continue;
            if (hashSet == null) {
                hashSet = new HashSet<AttributedImage>();
            }
            hashSet.add(attributedImage);
        }
        return hashSet;
    }

    public Set removeAll(Object object) {
        if (object == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        HashSet<AttributedImage> hashSet = null;
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!object.equals(attributedImage.getAttribute())) continue;
            iterator.remove();
            if (hashSet == null) {
                hashSet = new HashSet<AttributedImage>();
            }
            hashSet.add(attributedImage);
        }
        return hashSet;
    }

    public Set removeAll(PlanarImage planarImage) {
        if (planarImage == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        HashSet<AttributedImage> hashSet = null;
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!planarImage.equals(attributedImage.getImage())) continue;
            iterator.remove();
            if (hashSet == null) {
                hashSet = new HashSet<AttributedImage>();
            }
            hashSet.add(attributedImage);
        }
        return hashSet;
    }

    public boolean add(Object object) {
        if (object == null || !(object instanceof AttributedImage)) {
            throw new IllegalArgumentException(JaiI18N.getString("AttributedImageCollection1"));
        }
        if (this.imageCollection.contains(object)) {
            return false;
        }
        return this.imageCollection.add(object);
    }

    public boolean addAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof AttributedImage) || this.imageCollection.contains(e2) || !this.imageCollection.add(e2)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public AttributedImage getAttributedImage(PlanarImage planarImage) {
        if (planarImage == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!planarImage.equals(attributedImage.getImage())) continue;
            return attributedImage;
        }
        return null;
    }

    public AttributedImage getAttributedImage(Object object) {
        if (object == null) {
            return null;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            AttributedImage attributedImage = (AttributedImage)iterator.next();
            if (!object.equals(attributedImage.getAttribute())) continue;
            return attributedImage;
        }
        return null;
    }
}

