/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public final class BorderExtenderReflect
extends BorderExtender {
    BorderExtenderReflect() {
    }

    private void flipX(WritableRaster writableRaster) {
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getHeight();
        int n5 = writableRaster.getWidth();
        int n6 = n2 + n5 - 1;
        int n7 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n4 * n7];
                int[] nArray2 = new int[n4 * n7];
                int n8 = 0;
                while (n8 < n5 / 2) {
                    writableRaster.getPixels(n2 + n8, n3, 1, n4, nArray);
                    writableRaster.getPixels(n6 - n8, n3, 1, n4, nArray2);
                    writableRaster.setPixels(n2 + n8, n3, 1, n4, nArray2);
                    writableRaster.setPixels(n6 - n8, n3, 1, n4, nArray);
                    ++n8;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n4 * n7];
                float[] fArray2 = new float[n4 * n7];
                int n9 = 0;
                while (n9 < n5 / 2) {
                    writableRaster.getPixels(n2 + n9, n3, 1, n4, fArray);
                    writableRaster.getPixels(n6 - n9, n3, 1, n4, fArray2);
                    writableRaster.setPixels(n2 + n9, n3, 1, n4, fArray2);
                    writableRaster.setPixels(n6 - n9, n3, 1, n4, fArray);
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n4 * n7];
                double[] dArray2 = new double[n4 * n7];
                int n10 = 0;
                while (n10 < n5 / 2) {
                    writableRaster.getPixels(n2 + n10, n3, 1, n4, dArray);
                    writableRaster.getPixels(n6 - n10, n3, 1, n4, dArray2);
                    writableRaster.setPixels(n2 + n10, n3, 1, n4, dArray2);
                    writableRaster.setPixels(n6 - n10, n3, 1, n4, dArray);
                    ++n10;
                }
                break;
            }
        }
    }

    private void flipY(WritableRaster writableRaster) {
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getHeight();
        int n5 = writableRaster.getWidth();
        int n6 = n3 + n4 - 1;
        int n7 = writableRaster.getNumBands();
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n5 * n7];
                int[] nArray2 = new int[n5 * n7];
                int n8 = 0;
                while (n8 < n4 / 2) {
                    writableRaster.getPixels(n2, n3 + n8, n5, 1, nArray);
                    writableRaster.getPixels(n2, n6 - n8, n5, 1, nArray2);
                    writableRaster.setPixels(n2, n3 + n8, n5, 1, nArray2);
                    writableRaster.setPixels(n2, n6 - n8, n5, 1, nArray);
                    ++n8;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n5 * n7];
                float[] fArray2 = new float[n5 * n7];
                int n9 = 0;
                while (n9 < n4 / 2) {
                    writableRaster.getPixels(n2, n3 + n9, n5, 1, fArray);
                    writableRaster.getPixels(n2, n6 - n9, n5, 1, fArray2);
                    writableRaster.setPixels(n2, n3 + n9, n5, 1, fArray2);
                    writableRaster.setPixels(n2, n6 - n9, n5, 1, fArray);
                    ++n9;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n5 * n7];
                double[] dArray2 = new double[n5 * n7];
                int n10 = 0;
                while (n10 < n4 / 2) {
                    writableRaster.getPixels(n2, n3 + n10, n5, 1, dArray);
                    writableRaster.getPixels(n2, n6 - n10, n5, 1, dArray2);
                    writableRaster.setPixels(n2, n3 + n10, n5, 1, dArray2);
                    writableRaster.setPixels(n2, n6 - n10, n5, 1, dArray);
                    ++n10;
                }
                break;
            }
        }
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        if (writableRaster == null || planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getMinX();
        int n5 = n4 + n2;
        int n6 = writableRaster.getMinY();
        int n7 = n6 + n3;
        int n8 = planarImage.getMinX();
        int n9 = planarImage.getMinY();
        int n10 = planarImage.getWidth();
        int n11 = planarImage.getHeight();
        int n12 = Math.max(n8, n4);
        int n13 = Math.min(n8 + n10, n5);
        int n14 = Math.max(n9, n6);
        int n15 = Math.min(n9 + n11, n7);
        if (n12 > n13 || n14 > n15) {
            if (n12 > n13) {
                if (n4 == n12) {
                    n4 = planarImage.getMaxX() - 1;
                } else {
                    n5 = planarImage.getMinX();
                }
            }
            if (n14 > n15) {
                if (n6 == n14) {
                    n6 = planarImage.getMaxY() - 1;
                } else {
                    n7 = planarImage.getMinY();
                }
            }
            WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster(n4, n6, n5 - n4, n7 - n6);
            this.extend(writableRaster2, planarImage);
            Raster raster = writableRaster2.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), null);
            JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
            return;
        }
        Rectangle rectangle = new Rectangle();
        int n16 = PlanarImage.XToTileX(n4, n8, n10);
        int n17 = PlanarImage.XToTileX(n5 - 1, n8, n10);
        int n18 = PlanarImage.YToTileY(n6, n9, n11);
        int n19 = PlanarImage.YToTileY(n7 - 1, n9, n11);
        int n20 = n18;
        while (n20 <= n19) {
            int n21 = n20 * n11 + n9;
            int n22 = n16;
            while (n22 <= n17) {
                int n23 = n22 * n10 + n8;
                if (n22 != 0 || n20 != 0) {
                    boolean bl2 = Math.abs(n22) % 2 == 1;
                    boolean bl3 = Math.abs(n20) % 2 == 1;
                    rectangle.x = n23;
                    rectangle.y = n21;
                    rectangle.width = n10;
                    rectangle.height = n11;
                    int n24 = 0;
                    if (rectangle.x < n4) {
                        n24 = n4 - rectangle.x;
                        rectangle.x = n4;
                        rectangle.width -= n24;
                    }
                    int n25 = 0;
                    if (rectangle.y < n6) {
                        n25 = n6 - rectangle.y;
                        rectangle.y = n6;
                        rectangle.height -= n25;
                    }
                    if (rectangle.x + rectangle.width > n5) {
                        rectangle.width = n5 - rectangle.x;
                    }
                    if (rectangle.y + rectangle.height > n7) {
                        rectangle.height = n7 - rectangle.y;
                    }
                    int n26 = bl2 ? (n24 == 0 ? n8 + n10 - rectangle.width : n8) : n8 + n24;
                    int n27 = bl3 ? (n25 == 0 ? n9 + n11 - rectangle.height : n9) : n9 + n25;
                    WritableRaster writableRaster3 = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n26, n27, null);
                    planarImage.copyData(writableRaster3);
                    if (bl2) {
                        this.flipX(writableRaster3);
                    }
                    if (bl3) {
                        this.flipY(writableRaster3);
                    }
                }
                ++n22;
            }
            ++n20;
        }
    }
}

