/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.ImageJAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.WritablePropertySourceImpl;

public abstract class CollectionImage
implements ImageJAI,
Collection {
    protected Collection imageCollection;
    protected CollectionImageFactory imageFactory;
    private Boolean isFactorySet = Boolean.FALSE;
    protected PropertyChangeSupportJAI eventManager = new PropertyChangeSupportJAI(this);
    protected WritablePropertySourceImpl properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    protected Set sinks;

    protected CollectionImage() {
    }

    public CollectionImage(Collection collection) {
        this();
        if (collection == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.imageCollection = collection;
    }

    public Object get(int n2) {
        if (n2 < 0 || n2 >= this.imageCollection.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.imageCollection instanceof List) {
            return ((List)this.imageCollection).get(n2);
        }
        return this.imageCollection.toArray((Object[])null)[n2];
    }

    public void setImageFactory(CollectionImageFactory collectionImageFactory) {
        Boolean bl2 = this.isFactorySet;
        synchronized (bl2) {
            if (this.isFactorySet.booleanValue()) {
                throw new IllegalStateException();
            }
            this.imageFactory = collectionImageFactory;
            this.isFactorySet = Boolean.TRUE;
        }
    }

    public CollectionImageFactory getImageFactory() {
        Boolean bl2 = this.isFactorySet;
        synchronized (bl2) {
            CollectionImageFactory collectionImageFactory = this.imageFactory;
            return collectionImageFactory;
        }
    }

    public synchronized boolean addSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            this.sinks = new HashSet();
        }
        return this.sinks.add(new WeakReference<Object>(object));
    }

    public synchronized boolean removeSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = this.sinks.iterator();
        while (iterator.hasNext()) {
            Object t2 = ((WeakReference)iterator.next()).get();
            if (t2 == object) {
                iterator.remove();
                bl2 = true;
                continue;
            }
            if (t2 != null) continue;
            iterator.remove();
        }
        return bl2;
    }

    public synchronized Set getSinks() {
        HashSet hashSet = null;
        if (this.sinks != null && this.sinks.size() > 0) {
            hashSet = new HashSet(this.sinks.size());
            Iterator iterator = this.sinks.iterator();
            while (iterator.hasNext()) {
                Object t2 = ((WeakReference)iterator.next()).get();
                if (t2 == null) continue;
                hashSet.add(t2);
            }
            if (hashSet.size() == 0) {
                hashSet = null;
            }
        }
        return hashSet;
    }

    public synchronized void removeSinks() {
        this.sinks = null;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Object getProperty(String string, Collection collection) {
        return Image.UndefinedProperty;
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public int size() {
        return this.imageCollection.size();
    }

    public boolean isEmpty() {
        return this.imageCollection.isEmpty();
    }

    public boolean contains(Object object) {
        return this.imageCollection.contains(object);
    }

    public Iterator iterator() {
        return this.imageCollection.iterator();
    }

    public Object[] toArray() {
        return this.imageCollection.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.imageCollection.toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.imageCollection.add(object);
    }

    public boolean remove(Object object) {
        return this.imageCollection.remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.imageCollection.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.imageCollection.addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.imageCollection.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.imageCollection.retainAll(collection);
    }

    public void clear() {
        this.imageCollection.clear();
    }
}

