/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.JaiI18N;
import javax.media.jai.LookupTableJAI;

public class ColorCube
extends LookupTableJAI {
    public static final ColorCube BYTE_496 = ColorCube.createColorCube(0, 38, new int[]{4, 9, 6});
    public static final ColorCube BYTE_855 = ColorCube.createColorCube(0, 54, new int[]{8, 5, 5});
    private int[] dimension;
    private int[] dimsLessOne;
    private int[] multipliers;
    private int adjustedOffset;
    private int dataType;
    private int numBands;

    public static ColorCube createColorCube(int n2, int n3, int[] nArray) {
        ColorCube colorCube;
        switch (n2) {
            case 0: {
                colorCube = ColorCube.createColorCubeByte(n3, nArray);
                break;
            }
            case 2: {
                colorCube = ColorCube.createColorCubeShort(n3, nArray);
                break;
            }
            case 1: {
                colorCube = ColorCube.createColorCubeUShort(n3, nArray);
                break;
            }
            case 3: {
                colorCube = ColorCube.createColorCubeInt(n3, nArray);
                break;
            }
            case 4: {
                colorCube = ColorCube.createColorCubeFloat(n3, nArray);
                break;
            }
            case 5: {
                colorCube = ColorCube.createColorCubeDouble(n3, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube0"));
            }
        }
        return colorCube;
    }

    public static ColorCube createColorCube(int n2, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return ColorCube.createColorCube(n2, 0, nArray);
    }

    private static ColorCube createColorCubeByte(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayByte(n2, nArray), n2);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeShort(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayShort(n2, nArray), n2, false);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeUShort(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayUShort(n2, nArray), n2, true);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeInt(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayInt(n2, nArray), n2);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeFloat(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayFloat(n2, nArray), n2);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeDouble(int n2, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayDouble(n2, nArray), n2);
        colorCube.initFields(n2, nArray);
        return colorCube;
    }

    private static Object createDataArray(int n2, int n3, int[] nArray) {
        Object object;
        double d2;
        double d3;
        int n4 = nArray.length;
        if (n4 == 0) {
            throw new RuntimeException(JaiI18N.getString("ColorCube1"));
        }
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] == 0) {
                throw new RuntimeException(JaiI18N.getString("ColorCube2"));
            }
            ++n5;
        }
        int[] nArray2 = new int[n4];
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n6] = Math.abs(nArray[n6]);
            ++n6;
        }
        double d4 = nArray2[0];
        int n7 = 1;
        while (n7 < n4) {
            d4 *= (double)nArray2[n7];
            ++n7;
        }
        if (d4 > 2.147483647E9) {
            throw new RuntimeException(JaiI18N.getString("ColorCube3"));
        }
        int n8 = (int)d4;
        switch (n2) {
            case 0: {
                d3 = 0.0;
                d2 = 255.0;
                object = new byte[n4][n8];
                break;
            }
            case 2: {
                d3 = -32768.0;
                d2 = 32767.0;
                object = new short[n4][n8];
                break;
            }
            case 1: {
                d3 = 0.0;
                d2 = 65535.0;
                object = new short[n4][n8];
                break;
            }
            case 3: {
                d3 = -2.147483648E9;
                d2 = 2.147483647E9;
                object = new int[n4][n8];
                break;
            }
            case 4: {
                d3 = -3.4028234663852886E38;
                d2 = 3.4028234663852886E38;
                object = new float[n4][n8];
                break;
            }
            case 5: {
                d3 = -1.7976931348623157E308;
                d2 = Double.MAX_VALUE;
                object = new double[n4][n8];
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube7"));
            }
        }
        if ((double)(n8 + n3) > d2) {
            throw new RuntimeException(JaiI18N.getString("ColorCube4"));
        }
        int[] nArray3 = new int[n4];
        nArray3[0] = 1;
        int n9 = 1;
        while (n9 < n4) {
            nArray3[n9] = nArray3[n9 - 1] * nArray2[n9 - 1];
            ++n9;
        }
        int n10 = 0;
        while (n10 < n4) {
            double d5;
            int n11 = nArray2[n10];
            double d6 = n11 == 1 ? 0.0 : (n2 == 4 || n2 == 5 ? 1.0 / (double)(n11 - 1) : (d2 - d3) / (double)(n11 - 1));
            if (nArray[n10] < 0) {
                d6 = -d6;
                d5 = d2;
            } else {
                d5 = d3;
            }
            int n12 = nArray3[n10];
            switch (n2) {
                case 0: {
                    Object object2 = object;
                    int n13 = 0;
                    while (n13 < n8) {
                        double d7 = d5;
                        int n14 = 0;
                        while (n14 < n11) {
                            int n15 = 0;
                            while (n15 < n12) {
                                object2[n10][n13] = (byte)((int)(d7 + 0.5) & 0xFF);
                                ++n13;
                                ++n15;
                            }
                            d7 += d6;
                            ++n14;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = object;
                    int n13 = 0;
                    while (n13 < n8) {
                        double d8 = d5;
                        int n16 = 0;
                        while (n16 < n11) {
                            int n17 = 0;
                            while (n17 < n12) {
                                sArray[n10][n13] = (short)(d8 + 0.5);
                                ++n13;
                                ++n17;
                            }
                            d8 += d6;
                            ++n16;
                        }
                    }
                    break;
                }
                case 3: {
                    int n18;
                    int[][] nArray4 = object;
                    int n13 = 0;
                    while (n13 < n8) {
                        double d9 = d5;
                        int n19 = 0;
                        while (n19 < n11) {
                            n18 = 0;
                            while (n18 < n12) {
                                nArray4[n10][n13] = (int)(d9 + 0.5);
                                ++n13;
                                ++n18;
                            }
                            d9 += d6;
                            ++n19;
                        }
                    }
                    break;
                }
                case 4: {
                    int n20;
                    int n18;
                    float[][] fArray = object;
                    int n13 = 0;
                    while (n13 < n8) {
                        double d10 = d5;
                        n18 = 0;
                        while (n18 < n11) {
                            n20 = 0;
                            while (n20 < n12) {
                                fArray[n10][n13] = (float)d10;
                                ++n13;
                                ++n20;
                            }
                            d10 += d6;
                            ++n18;
                        }
                    }
                    break;
                }
                case 5: {
                    int n20;
                    double[][] dArray = object;
                    int n13 = 0;
                    while (n13 < n8) {
                        double d11 = d5;
                        n20 = 0;
                        while (n20 < n11) {
                            int n21 = 0;
                            while (n21 < n12) {
                                dArray[n10][n13] = d11;
                                ++n13;
                                ++n21;
                            }
                            d11 += d6;
                            ++n20;
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("ColorCube5"));
                }
            }
            ++n10;
        }
        return object;
    }

    private static byte[][] createDataArrayByte(int n2, int[] nArray) {
        return (byte[][])ColorCube.createDataArray(0, n2, nArray);
    }

    private static short[][] createDataArrayShort(int n2, int[] nArray) {
        return (short[][])ColorCube.createDataArray(2, n2, nArray);
    }

    private static short[][] createDataArrayUShort(int n2, int[] nArray) {
        return (short[][])ColorCube.createDataArray(1, n2, nArray);
    }

    private static int[][] createDataArrayInt(int n2, int[] nArray) {
        return (int[][])ColorCube.createDataArray(3, n2, nArray);
    }

    private static float[][] createDataArrayFloat(int n2, int[] nArray) {
        return (float[][])ColorCube.createDataArray(4, n2, nArray);
    }

    private static double[][] createDataArrayDouble(int n2, int[] nArray) {
        return (double[][])ColorCube.createDataArray(5, n2, nArray);
    }

    protected ColorCube(byte[][] byArray, int n2) {
        super(byArray, n2);
    }

    protected ColorCube(short[][] sArray, int n2, boolean bl2) {
        super(sArray, n2, bl2);
    }

    protected ColorCube(int[][] nArray, int n2) {
        super(nArray, n2);
    }

    protected ColorCube(float[][] fArray, int n2) {
        super(fArray, n2);
    }

    protected ColorCube(double[][] dArray, int n2) {
        super(dArray, n2);
    }

    private void initFields(int n2, int[] nArray) {
        this.dimension = nArray;
        this.multipliers = new int[nArray.length];
        this.dimsLessOne = new int[nArray.length];
        this.multipliers[0] = 1;
        int n3 = 1;
        while (n3 < this.multipliers.length) {
            this.multipliers[n3] = this.multipliers[n3 - 1] * Math.abs(nArray[n3 - 1]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.multipliers.length) {
            if (nArray[n4] < 0) {
                this.multipliers[n4] = -this.multipliers[n4];
            }
            this.dimsLessOne[n4] = Math.abs(nArray[n4]) - 1;
            ++n4;
        }
        this.adjustedOffset = n2;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] > 1 && this.multipliers[n5] < 0) {
                this.adjustedOffset += Math.abs(this.multipliers[n5]) * this.dimsLessOne[n5];
            }
            ++n5;
        }
        this.dataType = this.getDataType();
        this.numBands = this.getNumBands();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public int[] getDimsLessOne() {
        return this.dimsLessOne;
    }

    public int[] getMultipliers() {
        return this.multipliers;
    }

    public int getAdjustedOffset() {
        return this.adjustedOffset;
    }

    public int findNearestEntry(float[] fArray) {
        int n2 = -1;
        n2 = this.adjustedOffset;
        switch (this.dataType) {
            case 0: {
                int n3 = 0;
                while (n3 < this.numBands) {
                    int n4 = (int)(fArray[n3] * (float)this.dimsLessOne[n3]);
                    if ((n4 & 0xFF) > 127) {
                        n4 += 256;
                    }
                    n2 += (n4 >> 8) * this.multipliers[n3];
                    ++n3;
                }
                break;
            }
            case 2: {
                int n5 = 0;
                while (n5 < this.numBands) {
                    int n6 = (int)(fArray[n5] - -32768.0f) * this.dimsLessOne[n5];
                    if ((n6 & 0xFFFF) > Short.MAX_VALUE) {
                        n6 += 65536;
                    }
                    n2 += (n6 >> 16) * this.multipliers[n5];
                    ++n5;
                }
                break;
            }
            case 1: {
                int n7 = 0;
                while (n7 < this.numBands) {
                    int n8 = (int)(fArray[n7] * (float)this.dimsLessOne[n7]);
                    if ((n8 & 0xFFFF) > Short.MAX_VALUE) {
                        n8 += 65536;
                    }
                    n2 += (n8 >> 16) * this.multipliers[n7];
                    ++n7;
                }
                break;
            }
            case 3: {
                int n9 = 0;
                while (n9 < this.numBands) {
                    long l2 = (long)((fArray[n9] - -2.1474836E9f) * (float)this.dimsLessOne[n9]);
                    if (l2 > Integer.MAX_VALUE) {
                        l2 += 0L;
                    }
                    n2 += (int)(l2 >> 32) * this.multipliers[n9];
                    ++n9;
                }
                break;
            }
            case 4: {
                int n10 = 0;
                while (n10 < this.numBands) {
                    float f2 = fArray[n10] * (float)this.dimsLessOne[n10];
                    int n11 = (int)f2;
                    if (f2 - (float)n11 >= 0.5f) {
                        ++n11;
                    }
                    n2 += n11 * this.multipliers[n10];
                    ++n10;
                }
                break;
            }
            case 5: {
                int n12 = 0;
                while (n12 < this.numBands) {
                    double d2 = fArray[n12] * (float)this.dimsLessOne[n12];
                    int n13 = (int)d2;
                    if (d2 - (double)n13 >= 0.5) {
                        ++n13;
                    }
                    n2 += n13 * this.multipliers[n12];
                    ++n12;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube6"));
            }
        }
        return n2;
    }
}

