/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

public abstract class ColorSpaceJAI
extends ColorSpace {
    private static final double maxXYZ = 1.999969482421875;
    private static final double power1 = 0.4166666666666667;
    private static double[] LUT = new double[256];
    private boolean isRGBPreferredIntermediary;

    public static WritableRaster CIEXYZToRGB(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.CIEXYZToRGBByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.CIEXYZToRGBShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.CIEXYZToRGBInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.CIEXYZToRGBFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.CIEXYZToRGBDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    protected static void checkParameters(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI0"));
        }
        if (raster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI1"));
        }
        if (writableRaster != null && writableRaster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI2"));
        }
        if (nArray != null && nArray.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI3"));
        }
        if (nArray2 != null && nArray2.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI4"));
        }
    }

    static void convertToSigned(double[] dArray, int n2) {
        block3: {
            block2: {
                if (n2 != 2) break block2;
                int n3 = 0;
                while (n3 < dArray.length) {
                    short s2 = (short)((int)dArray[n3] & 0xFFFF);
                    dArray[n3] = s2;
                    ++n3;
                }
                break block3;
            }
            if (n2 != 3) break block3;
            int n4 = 0;
            while (n4 < dArray.length) {
                int n5 = (int)((long)dArray[n4] & 0xFFFFFFFFL);
                dArray[n4] = n5;
                ++n4;
            }
        }
    }

    static void XYZ2RGB(float[] fArray, float[] fArray2) {
        fArray2[0] = 2.9311228f * fArray[0] - 1.4111496f * fArray[1] - 0.6038046f * fArray[2];
        fArray2[1] = -0.8763701f * fArray[0] + 1.7219844f * fArray[1] + 0.0502565f * fArray[2];
        fArray2[2] = 0.05038065f * fArray[0] - 0.187272f * fArray[1] + 1.280027f * fArray[2];
        int n2 = 0;
        while (n2 < 3) {
            float f2 = fArray2[n2];
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 < 0.0031308f) {
                fArray2[n2] = 12.92f * f2;
            } else {
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                fArray2[n2] = (float)(1.055 * Math.pow(f2, 0.4166666666666667) - 0.055);
            }
            ++n2;
        }
    }

    private static void roundValues(double[] dArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = (long)(dArray[n2] + 0.5);
            ++n2;
        }
    }

    static void CIEXYZToRGBByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f4 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        if (n2 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray[0] = (float)(byArray[n13] & 0xFF) * f2;
                fArray[1] = (float)(byArray2[n14] & 0xFF) * f3;
                fArray[2] = (float)(byArray3[n15] & 0xFF) * f4;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n10++] = d2 * (double)fArray2[0];
                dArray[n10++] = d3 * (double)fArray2[1];
                dArray[n10++] = d4 * (double)fArray2[2];
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void CIEXYZToRGBShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f4 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        if (n2 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray[0] = (float)(sArray[n13] & 0xFFFF) * f2;
                fArray[1] = (float)(sArray2[n14] & 0xFFFF) * f3;
                fArray[2] = (float)(sArray3[n15] & 0xFFFF) * f4;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n10++] = d2 * (double)fArray2[0];
                dArray[n10++] = d3 * (double)fArray2[1];
                dArray[n10++] = d4 * (double)fArray2[2];
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void CIEXYZToRGBInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f4 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        if (n2 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray[0] = (float)((long)nArray3[n13] & 0xFFFFFFFFL) * f2;
                fArray[1] = (float)((long)nArray4[n14] & 0xFFFFFFFFL) * f3;
                fArray[2] = (float)((long)nArray5[n15] & 0xFFFFFFFFL) * f4;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n10++] = d2 * (double)fArray2[0];
                dArray[n10++] = d3 * (double)fArray2[1];
                dArray[n10++] = d4 * (double)fArray2[2];
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void CIEXYZToRGBFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        if (n2 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray4[0] = fArray[n13];
                fArray4[1] = fArray2[n14];
                fArray4[2] = fArray3[n15];
                ColorSpaceJAI.XYZ2RGB(fArray4, fArray5);
                dArray[n10++] = d2 * (double)fArray5[0];
                dArray[n10++] = d3 * (double)fArray5[1];
                dArray[n10++] = d4 * (double)fArray5[2];
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void CIEXYZToRGBDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        if (n2 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray[0] = (float)dArray[n13];
                fArray[1] = (float)dArray2[n14];
                fArray[2] = (float)dArray3[n15];
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray4[n10++] = d2 * (double)fArray2[0];
                dArray4[n10++] = d3 * (double)fArray2[1];
                dArray4[n10++] = d4 * (double)fArray2[2];
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray4);
        }
        ColorSpaceJAI.convertToSigned(dArray4, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray4);
    }

    public static WritableRaster RGBToCIEXYZ(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.RGBToCIEXYZByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.RGBToCIEXYZShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.RGBToCIEXYZInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.RGBToCIEXYZFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.RGBToCIEXYZDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    static void RGB2XYZ(float[] fArray, float[] fArray2) {
        int n2 = 0;
        while (n2 < 3) {
            if (fArray[n2] < 0.040449936f) {
                int n3 = n2;
                fArray[n3] = fArray[n3] / 12.92f;
            } else {
                fArray[n2] = (float)Math.pow(((double)fArray[n2] + 0.055) / 1.055, 2.4);
            }
            ++n2;
        }
        fArray2[0] = 0.45593762f * fArray[0] + 0.39533818f * fArray[1] + 0.19954965f * fArray[2];
        fArray2[1] = 0.23157515f * fArray[0] + 0.7790526f * fArray[1] + 0.07864978f * fArray[2];
        fArray2[2] = 0.01593493f * fArray[0] + 0.09841772f * fArray[1] + 0.7848861f * fArray[2];
    }

    private static void RGBToCIEXYZByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl2;
        double d2;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        int n2 = 8 - nArray[0];
        int n3 = 8 - nArray[1];
        int n4 = 8 - nArray[2];
        double d3 = d2 = 1.0;
        double d4 = d2;
        int n5 = writableRaster.getSampleModel().getDataType();
        boolean bl3 = bl2 = n5 < 4;
        if (bl2) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d4 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n6 = writableRaster.getHeight();
        int n7 = writableRaster.getWidth();
        double[] dArray = new double[3 * n6 * n7];
        int n8 = unpackedImageData.bandOffsets[0];
        int n9 = unpackedImageData.bandOffsets[1];
        int n10 = unpackedImageData.bandOffsets[2];
        int n11 = unpackedImageData.pixelStride;
        int n12 = unpackedImageData.lineStride;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n6) {
            int n15 = 0;
            int n16 = n8;
            int n17 = n9;
            int n18 = n10;
            while (n15 < n7) {
                double d5 = LUT[(byArray[n16] & 0xFF) << n2];
                double d6 = LUT[(byArray2[n17] & 0xFF) << n3];
                double d7 = LUT[(byArray3[n18] & 0xFF) << n4];
                if (bl2) {
                    dArray[n13++] = (0.45593763 * d5 + 0.39533819 * d6 + 0.19954964 * d7) * d2;
                    dArray[n13++] = (0.23157515 * d5 + 0.77905262 * d6 + 0.07864978 * d7) * d3;
                    dArray[n13++] = (0.01593493 * d5 + 0.09841772 * d6 + 0.78488615 * d7) * d4;
                } else {
                    dArray[n13++] = 0.45593763 * d5 + 0.39533819 * d6 + 0.19954964 * d7;
                    dArray[n13++] = 0.23157515 * d5 + 0.77905262 * d6 + 0.07864978 * d7;
                    dArray[n13++] = 0.01593493 * d5 + 0.09841772 * d6 + 0.78488615 * d7;
                }
                ++n15;
                n16 += n11;
                n17 += n11;
                n18 += n11;
            }
            ++n14;
            n8 += n12;
            n9 += n12;
            n10 += n12;
        }
        if (n5 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n5);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n7, n6, dArray);
    }

    private static void RGBToCIEXYZShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl2;
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        float f2 = (1 << nArray[0]) - 1;
        float f3 = (1 << nArray[1]) - 1;
        float f4 = (1 << nArray[2]) - 1;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        boolean bl3 = bl2 = n2 < 4;
        if (bl2) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d4 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray2[0] = (float)(sArray[n13] & 0xFFFF) / f2;
                fArray2[1] = (float)(sArray2[n14] & 0xFFFF) / f3;
                fArray2[2] = (float)(sArray3[n15] & 0xFFFF) / f4;
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl2) {
                    dArray[n10++] = (double)fArray[0] * d2;
                    dArray[n10++] = (double)fArray[1] * d3;
                    dArray[n10++] = (double)fArray[2] * d4;
                } else {
                    dArray[n10++] = fArray[0];
                    dArray[n10++] = fArray[1];
                    dArray[n10++] = fArray[2];
                }
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void RGBToCIEXYZInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl2;
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        float f2 = (1L << nArray[0]) - 1L;
        float f3 = (1L << nArray[1]) - 1L;
        float f4 = (1L << nArray[2]) - 1L;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        boolean bl3 = bl2 = n2 < 4;
        if (bl2) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d4 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray2[0] = (float)((long)nArray3[n13] & 0xFFFFFFFFL) / f2;
                fArray2[1] = (float)((long)nArray4[n14] & 0xFFFFFFFFL) / f3;
                fArray2[2] = (float)((long)nArray5[n15] & 0xFFFFFFFFL) / f4;
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl2) {
                    dArray[n10++] = (double)fArray[0] * d2;
                    dArray[n10++] = (double)fArray[1] * d2;
                    dArray[n10++] = (double)fArray[2] * d2;
                } else {
                    dArray[n10++] = fArray[0];
                    dArray[n10++] = fArray[1];
                    dArray[n10++] = fArray[2];
                }
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void RGBToCIEXYZFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl2;
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        boolean bl3 = bl2 = n2 < 4;
        if (bl2) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d4 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray5[0] = fArray[n13];
                fArray5[1] = fArray2[n14];
                fArray5[2] = fArray3[n15];
                ColorSpaceJAI.RGB2XYZ(fArray5, fArray4);
                if (bl2) {
                    dArray[n10++] = (double)fArray4[0] * d2;
                    dArray[n10++] = (double)fArray4[1] * d2;
                    dArray[n10++] = (double)fArray4[2] * d2;
                } else {
                    dArray[n10++] = fArray4[0];
                    dArray[n10++] = fArray4[1];
                    dArray[n10++] = fArray4[2];
                }
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray);
    }

    private static void RGBToCIEXYZDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl2;
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n2 = writableRaster.getSampleModel().getDataType();
        boolean bl3 = bl2 = n2 < 4;
        if (bl2) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d4 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n3 = writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n3 * n4];
        int n5 = unpackedImageData.bandOffsets[0];
        int n6 = unpackedImageData.bandOffsets[1];
        int n7 = unpackedImageData.bandOffsets[2];
        int n8 = unpackedImageData.pixelStride;
        int n9 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n3) {
            int n12 = 0;
            int n13 = n5;
            int n14 = n6;
            int n15 = n7;
            while (n12 < n4) {
                fArray2[0] = (float)dArray[n13];
                fArray2[1] = (float)dArray2[n14];
                fArray2[2] = (float)dArray3[n15];
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl2) {
                    dArray4[n10++] = (double)fArray[0] * d2;
                    dArray4[n10++] = (double)fArray[1] * d2;
                    dArray4[n10++] = (double)fArray[2] * d2;
                } else {
                    dArray4[n10++] = fArray[0];
                    dArray4[n10++] = fArray[1];
                    dArray4[n10++] = fArray[2];
                }
                ++n12;
                n13 += n8;
                n14 += n8;
                n15 += n8;
            }
            ++n11;
            n5 += n9;
            n6 += n9;
            n7 += n9;
        }
        if (n2 < 4) {
            ColorSpaceJAI.roundValues(dArray4);
        }
        ColorSpaceJAI.convertToSigned(dArray4, n2);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n4, n3, dArray4);
    }

    protected ColorSpaceJAI(int n2, int n3, boolean bl2) {
        super(n2, n3);
        this.isRGBPreferredIntermediary = bl2;
    }

    public boolean isRGBPreferredIntermediary() {
        return this.isRGBPreferredIntermediary;
    }

    public abstract WritableRaster fromCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster fromRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    static {
        int n2 = 0;
        while (n2 < 256) {
            double d2 = (double)n2 / 255.0;
            ColorSpaceJAI.LUT[n2] = d2 < 0.040449936 ? d2 / 12.92 : Math.pow((d2 + 0.055) / 1.055, 2.4);
            ++n2;
        }
    }
}

