/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PointOpImage;

public abstract class ColormapOpImage
extends PointOpImage {
    private boolean isInitialized = false;
    private boolean isColormapAccelerated = true;

    public ColormapOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl2) {
        super(renderedImage, imageLayout, map, bl2);
        Boolean bl3;
        Boolean bl4 = bl3 = map == null ? Boolean.TRUE : (Boolean)map.get(JAI.KEY_TRANSFORM_ON_COLORMAP);
        if (bl3 != null) {
            this.isColormapAccelerated = bl3;
        }
    }

    protected final boolean isColormapOperation() {
        return this.isColormapAccelerated;
    }

    protected final void initializeColormapOperation() {
        ColorModel colorModel = this.getSource(0).getColorModel();
        ColorModel colorModel2 = super.getColorModel();
        this.isColormapAccelerated &= colorModel != null && colorModel2 != null && colorModel instanceof IndexColorModel && colorModel2 instanceof IndexColorModel;
        this.isInitialized = true;
        if (this.isColormapAccelerated) {
            byte[] byArray;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel2;
            int n2 = indexColorModel.getMapSize();
            byte[][] byArray2 = new byte[3][n2];
            indexColorModel.getReds(byArray2[0]);
            indexColorModel.getGreens(byArray2[1]);
            indexColorModel.getBlues(byArray2[2]);
            this.transformColormap(byArray2);
            int n3 = 0;
            while (n3 < 3) {
                int n4 = 255 >> 8 - indexColorModel.getComponentSize(n3);
                if (n4 < 255) {
                    byArray = byArray2[n3];
                    int n5 = 0;
                    while (n5 < n2) {
                        if ((byArray[n5] & 0xFF) > n4) {
                            byArray[n5] = (byte)n4;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            byte[] byArray3 = byArray2[0];
            byArray = byArray2[1];
            byte[] byArray4 = byArray2[2];
            int[] nArray = new int[n2];
            if (indexColorModel.hasAlpha()) {
                byte[] byArray5 = new byte[n2];
                indexColorModel.getAlphas(byArray5);
                int n6 = 0;
                while (n6 < n2) {
                    nArray[n6] = (byArray5[n6] & 0xFF) << 24 | (byArray3[n6] & 0xFF) << 16 | (byArray[n6] & 0xFF) << 8 | byArray4[n6] & 0xFF;
                    ++n6;
                }
            } else {
                int n7 = 0;
                while (n7 < n2) {
                    nArray[n7] = (byArray3[n7] & 0xFF) << 16 | (byArray[n7] & 0xFF) << 8 | byArray4[n7] & 0xFF;
                    ++n7;
                }
            }
            this.colorModel = new IndexColorModel(indexColorModel.getPixelSize(), n2, nArray, 0, indexColorModel.hasAlpha(), indexColorModel.getTransparentPixel(), this.sampleModel.getTransferType());
        }
    }

    protected abstract void transformColormap(byte[][] var1);
}

