/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationGraph;
import javax.media.jai.PartialOrderNode;
import javax.media.jai.ProductOperationGraph;
import javax.media.jai.PropertyEnvironment;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertyGeneratorFromSource;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.RegistryMode;
import javax.media.jai.util.CaselessStringKey;

class DescriptorCache {
    final String modeName;
    final RegistryMode mode;
    final boolean arePreferencesSupported;
    final boolean arePropertiesSupported;
    private Hashtable descriptorNames;
    private Hashtable products;
    private Hashtable productPrefs;
    private Hashtable properties;
    private Hashtable suppressed;
    private Hashtable sourceForProp;
    private Hashtable propNames;

    DescriptorCache(String string) {
        this.modeName = string;
        this.mode = RegistryMode.getMode(string);
        this.arePreferencesSupported = this.mode.arePreferencesSupported();
        this.arePropertiesSupported = this.mode.arePropertiesSupported();
        this.descriptorNames = new Hashtable();
        this.products = new Hashtable();
        if (this.arePreferencesSupported) {
            this.productPrefs = new Hashtable();
        }
        this.properties = new Hashtable();
        this.suppressed = new Hashtable();
        this.sourceForProp = new Hashtable();
        this.propNames = new Hashtable();
    }

    boolean addDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        if (registryElementDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        String string = registryElementDescriptor.getName();
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (this.descriptorNames.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache0", new Object[]{string, this.modeName}));
        }
        this.descriptorNames.put(caselessStringKey, registryElementDescriptor);
        if (this.arePreferencesSupported) {
            this.products.put(caselessStringKey, new ProductOperationGraph());
        }
        if (!registryElementDescriptor.arePropertiesSupported()) {
            return true;
        }
        PropertyGenerator[] propertyGeneratorArray = registryElementDescriptor.getPropertyGenerators(this.modeName);
        if (propertyGeneratorArray != null) {
            int n2 = 0;
            while (n2 < propertyGeneratorArray.length) {
                Vector vector = (Vector)this.properties.get(caselessStringKey);
                if (vector == null) {
                    vector = new Vector();
                    vector.addElement(propertyGeneratorArray[n2]);
                    this.properties.put(caselessStringKey, vector);
                } else {
                    vector.addElement(propertyGeneratorArray[n2]);
                }
                vector = (Vector)this.suppressed.get(caselessStringKey);
                Hashtable hashtable = (Hashtable)this.sourceForProp.get(caselessStringKey);
                String[] stringArray = propertyGeneratorArray[n2].getPropertyNames();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    CaselessStringKey caselessStringKey2 = new CaselessStringKey(stringArray[n3]);
                    if (vector != null) {
                        vector.remove(caselessStringKey2);
                    }
                    if (hashtable != null) {
                        hashtable.remove(caselessStringKey2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return true;
    }

    boolean removeDescriptor(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.descriptorNames.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache1", new Object[]{string, this.modeName}));
        }
        RegistryElementDescriptor registryElementDescriptor = (RegistryElementDescriptor)this.descriptorNames.get(caselessStringKey);
        PropertyGenerator[] propertyGeneratorArray = null;
        if (registryElementDescriptor.arePropertiesSupported()) {
            propertyGeneratorArray = registryElementDescriptor.getPropertyGenerators(this.modeName);
        }
        if (propertyGeneratorArray != null) {
            int n2 = 0;
            while (n2 < propertyGeneratorArray.length) {
                if (propertyGeneratorArray[n2] == null) {
                    throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache2", new Object[]{new Integer(n2), string, this.modeName}));
                }
                Vector vector = (Vector)this.properties.get(caselessStringKey);
                if (vector != null) {
                    vector.removeElement(propertyGeneratorArray[n2]);
                }
                ++n2;
            }
        }
        this.descriptorNames.remove(caselessStringKey);
        if (this.arePreferencesSupported) {
            this.products.remove(caselessStringKey);
        }
        return true;
    }

    boolean removeDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        if (registryElementDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.removeDescriptor(registryElementDescriptor.getName());
    }

    RegistryElementDescriptor getDescriptor(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        return (RegistryElementDescriptor)this.descriptorNames.get(caselessStringKey);
    }

    List getDescriptors() {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.descriptorNames.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    String[] getDescriptorNames() {
        Enumeration enumeration = this.descriptorNames.keys();
        int n2 = this.descriptorNames.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            stringArray[n3] = caselessStringKey.getName();
            ++n3;
        }
        return stringArray;
    }

    OperationGraph addProduct(String string, String string2) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            return null;
        }
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2);
        if (partialOrderNode == null) {
            productOperationGraph.addProduct(string2);
            partialOrderNode = productOperationGraph.lookupOp(string2);
        }
        return (OperationGraph)partialOrderNode.getData();
    }

    boolean removeProduct(String string, String string2) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            return false;
        }
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2);
        if (partialOrderNode == null) {
            return false;
        }
        productOperationGraph.removeOp(string2);
        return true;
    }

    OperationGraph lookupProduct(String string, String string2) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            return null;
        }
        PartialOrderNode partialOrderNode = productOperationGraph.lookupOp(string2);
        if (partialOrderNode == null) {
            return null;
        }
        return (OperationGraph)partialOrderNode.getData();
    }

    boolean setProductPreference(String string, String string2, String string3) {
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache6", new Object[]{this.modeName}));
        }
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (string2.equalsIgnoreCase(string3)) {
            return false;
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.descriptorNames.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache1", new Object[]{string, this.modeName}));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache3", new Object[]{string, this.modeName}));
        }
        if (productOperationGraph.lookupOp(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string2}));
        }
        if (productOperationGraph.lookupOp(string3) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string3}));
        }
        productOperationGraph.setPreference(string2, string3);
        String[] stringArray = new String[]{string2, string3};
        if (!this.productPrefs.containsKey(caselessStringKey)) {
            Vector<String[]> vector = new Vector<String[]>();
            vector.addElement(stringArray);
            this.productPrefs.put(caselessStringKey, vector);
        } else {
            Vector vector = (Vector)this.productPrefs.get(caselessStringKey);
            vector.addElement(stringArray);
        }
        return true;
    }

    boolean unsetProductPreference(String string, String string2, String string3) {
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache6", new Object[]{this.modeName}));
        }
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (string2.equalsIgnoreCase(string3)) {
            return false;
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.descriptorNames.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache1", new Object[]{string, this.modeName}));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache3", new Object[]{string, this.modeName}));
        }
        if (productOperationGraph.lookupOp(string2) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string2}));
        }
        if (productOperationGraph.lookupOp(string3) == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string3}));
        }
        productOperationGraph.unsetPreference(string2, string3);
        if (!this.productPrefs.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache5", new Object[]{string, this.modeName}));
        }
        Vector vector = (Vector)this.productPrefs.get(caselessStringKey);
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            if (!stringArray[0].equalsIgnoreCase(string2) || !stringArray[1].equalsIgnoreCase(string3)) continue;
            iterator.remove();
            break;
        }
        return true;
    }

    boolean clearProductPreferences(String string) {
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache6", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.descriptorNames.containsKey(caselessStringKey)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache1", new Object[]{string, this.modeName}));
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache3", new Object[]{string, this.modeName}));
        }
        if (!this.productPrefs.containsKey(caselessStringKey)) {
            return true;
        }
        Vector vector = (Vector)this.productPrefs.get(caselessStringKey);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray = (String[])enumeration.nextElement();
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (productOperationGraph.lookupOp(string2) == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string2}));
            }
            if (productOperationGraph.lookupOp(string3) == null) {
                throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache4", new Object[]{string, this.modeName, string3}));
            }
            productOperationGraph.unsetPreference(string2, string3);
        }
        this.productPrefs.remove(caselessStringKey);
        return true;
    }

    String[][] getProductPreferences(String string) {
        if (!this.arePreferencesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache6", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.productPrefs.containsKey(caselessStringKey)) {
            return null;
        }
        Vector vector = (Vector)this.productPrefs.get(caselessStringKey);
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        String[][] stringArray = new String[n2][2];
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray2 = (String[])enumeration.nextElement();
            stringArray[n3][0] = stringArray2[0];
            stringArray[n3++][1] = stringArray2[1];
        }
        return stringArray;
    }

    Vector getOrderedProductList(String string) {
        if (!this.arePreferencesSupported) {
            return null;
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (!this.descriptorNames.containsKey(caselessStringKey)) {
            return null;
        }
        ProductOperationGraph productOperationGraph = (ProductOperationGraph)this.products.get(caselessStringKey);
        if (productOperationGraph == null) {
            return null;
        }
        Vector vector = productOperationGraph.getOrderedOperationList();
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n3 = 0;
        while (n3 < n2) {
            vector2.addElement(((PartialOrderNode)vector.elementAt(n3)).getName());
            ++n3;
        }
        return vector2;
    }

    private boolean arePropertiesSupported(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        RegistryElementDescriptor registryElementDescriptor = (RegistryElementDescriptor)this.descriptorNames.get(caselessStringKey);
        if (registryElementDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache1", new Object[]{string, this.modeName}));
        }
        return this.arePropertiesSupported;
    }

    void clearPropertyState() {
        if (!this.arePropertiesSupported) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        this.properties = new Hashtable();
        this.suppressed = new Hashtable();
    }

    void addPropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        if (string == null || propertyGenerator == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        Vector vector = (Vector)this.properties.get(caselessStringKey);
        if (vector == null) {
            vector = new Vector();
            this.properties.put(caselessStringKey, vector);
        }
        vector.addElement(propertyGenerator);
        vector = (Vector)this.suppressed.get(caselessStringKey);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(caselessStringKey);
        String[] stringArray = propertyGenerator.getPropertyNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            CaselessStringKey caselessStringKey2 = new CaselessStringKey(stringArray[n2]);
            if (vector != null) {
                vector.remove(caselessStringKey2);
            }
            if (hashtable != null) {
                hashtable.remove(caselessStringKey2);
            }
            ++n2;
        }
    }

    private void hashNames(String string) {
        Serializable serializable;
        int n2;
        String[] stringArray;
        Serializable serializable2;
        Object object;
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        Vector vector = (Vector)this.properties.get(caselessStringKey);
        Vector vector2 = (Vector)this.suppressed.get(caselessStringKey);
        Hashtable<Object, Serializable> hashtable = new Hashtable<Object, Serializable>();
        this.propNames.put(caselessStringKey, hashtable);
        if (vector != null) {
            object = ((AbstractList)vector).iterator();
            while (object.hasNext()) {
                serializable2 = (PropertyGenerator)object.next();
                stringArray = serializable2.getPropertyNames();
                n2 = 0;
                while (n2 < stringArray.length) {
                    serializable = new CaselessStringKey(stringArray[n2]);
                    if (vector2 == null || !vector2.contains(serializable)) {
                        hashtable.put(serializable, serializable2);
                    }
                    ++n2;
                }
            }
        }
        if ((serializable2 = (Hashtable)this.sourceForProp.get(caselessStringKey)) != null) {
            stringArray = ((Hashtable)serializable2).keys();
            while (stringArray.hasMoreElements()) {
                object = (CaselessStringKey)stringArray.nextElement();
                n2 = (Integer)((Hashtable)serializable2).get(object);
                serializable = new PropertyGeneratorFromSource(n2, ((CaselessStringKey)object).getName());
                hashtable.put(object, serializable);
            }
        }
    }

    void removePropertyGenerator(String string, PropertyGenerator propertyGenerator) {
        if (string == null || propertyGenerator == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        Vector vector = (Vector)this.properties.get(caselessStringKey);
        if (vector != null) {
            vector.removeElement(propertyGenerator);
        }
    }

    void suppressProperty(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        CaselessStringKey caselessStringKey2 = new CaselessStringKey(string2);
        Vector<CaselessStringKey> vector = (Vector<CaselessStringKey>)this.suppressed.get(caselessStringKey);
        if (vector == null) {
            vector = new Vector<CaselessStringKey>();
            this.suppressed.put(caselessStringKey, vector);
        }
        vector.addElement(caselessStringKey2);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(caselessStringKey);
        if (hashtable != null) {
            hashtable.remove(caselessStringKey2);
        }
    }

    void suppressAllProperties(String string) {
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        Vector vector = (Vector)this.properties.get(caselessStringKey);
        if (vector != null) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                PropertyGenerator propertyGenerator = (PropertyGenerator)iterator.next();
                String[] stringArray = propertyGenerator.getPropertyNames();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.suppressProperty(string, stringArray[n2]);
                    ++n2;
                }
            }
        }
    }

    void copyPropertyFromSource(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        CaselessStringKey caselessStringKey2 = new CaselessStringKey(string2);
        Hashtable<CaselessStringKey, Integer> hashtable = (Hashtable<CaselessStringKey, Integer>)this.sourceForProp.get(caselessStringKey);
        if (hashtable == null) {
            hashtable = new Hashtable<CaselessStringKey, Integer>();
            this.sourceForProp.put(caselessStringKey, hashtable);
        }
        hashtable.put(caselessStringKey2, new Integer(n2));
        Vector vector = (Vector)this.suppressed.get(caselessStringKey);
        if (vector != null) {
            vector.remove(caselessStringKey2);
        }
    }

    String[] getGeneratedPropertyNames(String string) {
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        this.hashNames(string);
        Hashtable hashtable = (Hashtable)this.propNames.get(caselessStringKey);
        if (hashtable != null && hashtable.size() > 0) {
            String[] stringArray = new String[hashtable.size()];
            int n2 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                CaselessStringKey caselessStringKey2 = (CaselessStringKey)enumeration.nextElement();
                stringArray[n2++] = caselessStringKey2.getName();
            }
            return n2 > 0 ? stringArray : null;
        }
        return null;
    }

    PropertySource getPropertySource(String string, Object object, Vector vector) {
        if (string == null || object == null || vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.arePropertiesSupported(string)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("DescriptorCache7", new Object[]{this.modeName}));
        }
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        Vector vector2 = (Vector)this.properties.get(caselessStringKey);
        Vector vector3 = (Vector)this.suppressed.get(caselessStringKey);
        Hashtable hashtable = (Hashtable)this.sourceForProp.get(caselessStringKey);
        return new PropertyEnvironment(vector, vector2, vector3, hashtable, object);
    }
}

