/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.UnpackedImageData;

public class Histogram
implements Serializable {
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private int numBands;
    private double[] binWidth;
    private int[][] bins = null;
    private int[] totals = null;
    private double[] mean = null;

    private static final int[] fill(int[] nArray, int n2) {
        int[] nArray2 = null;
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 > 0) {
            nArray2 = new int[n2];
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n4] = n4 < n3 ? nArray[n4] : nArray[0];
                ++n4;
            }
        }
        return nArray2;
    }

    private static final double[] fill(double[] dArray, int n2) {
        double[] dArray2 = null;
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 > 0) {
            dArray2 = new double[n2];
            int n3 = dArray.length;
            int n4 = 0;
            while (n4 < n2) {
                dArray2[n4] = n4 < n3 ? dArray[n4] : dArray[0];
                ++n4;
            }
        }
        return dArray2;
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2) {
        if (nArray == null || dArray == null || dArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.numBands = nArray.length;
        if (dArray.length != this.numBands || dArray2.length != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram0"));
        }
        if (this.numBands == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        int n2 = 0;
        while (n2 < this.numBands) {
            if (nArray[n2] <= 0) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
            }
            if (dArray[n2] >= dArray2[n2]) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
            }
            ++n2;
        }
        this.numBins = (int[])nArray.clone();
        this.lowValue = (double[])dArray.clone();
        this.highValue = (double[])dArray2.clone();
        this.binWidth = new double[this.numBands];
        int n3 = 0;
        while (n3 < this.numBands) {
            this.binWidth[n3] = (dArray2[n3] - dArray[n3]) / (double)nArray[n3];
            ++n3;
        }
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2, int n2) {
        this(Histogram.fill(nArray, n2), Histogram.fill(dArray, n2), Histogram.fill(dArray2, n2));
    }

    public Histogram(int n2, double d2, double d3, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
        }
        if (d2 >= d3) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
        }
        this.numBands = n3;
        this.numBins = new int[n3];
        this.lowValue = new double[n3];
        this.highValue = new double[n3];
        this.binWidth = new double[n3];
        double d4 = (d3 - d2) / (double)n2;
        int n4 = 0;
        while (n4 < n3) {
            this.numBins[n4] = n2;
            this.lowValue[n4] = d2;
            this.highValue[n4] = d3;
            this.binWidth[n4] = d4;
            ++n4;
        }
    }

    public int[] getNumBins() {
        return (int[])this.numBins.clone();
    }

    public int getNumBins(int n2) {
        return this.numBins[n2];
    }

    public double[] getLowValue() {
        return (double[])this.lowValue.clone();
    }

    public double getLowValue(int n2) {
        return this.lowValue[n2];
    }

    public double[] getHighValue() {
        return (double[])this.highValue.clone();
    }

    public double getHighValue(int n2) {
        return this.highValue[n2];
    }

    public int getNumBands() {
        return this.numBands;
    }

    public synchronized int[][] getBins() {
        if (this.bins == null) {
            this.bins = new int[this.numBands][];
            int n2 = 0;
            while (n2 < this.numBands) {
                this.bins[n2] = new int[this.numBins[n2]];
                ++n2;
            }
        }
        return this.bins;
    }

    public int[] getBins(int n2) {
        this.getBins();
        return this.bins[n2];
    }

    public int getBinSize(int n2, int n3) {
        this.getBins();
        return this.bins[n2][n3];
    }

    public double getBinLowValue(int n2, int n3) {
        return this.lowValue[n2] + (double)n3 * this.binWidth[n2];
    }

    public void clearHistogram() {
        if (this.bins != null) {
            int[][] nArray = this.bins;
            synchronized (nArray) {
                int n2 = 0;
                while (n2 < this.numBands) {
                    int[] nArray2 = this.bins[n2];
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        nArray2[n4] = 0;
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public int[] getTotals() {
        if (this.totals == null) {
            this.getBins();
            Histogram histogram = this;
            synchronized (histogram) {
                this.totals = new int[this.numBands];
                int n2 = 0;
                while (n2 < this.numBands) {
                    int[] nArray = this.bins[n2];
                    int n3 = nArray.length;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        n4 += nArray[n5];
                        ++n5;
                    }
                    this.totals[n2] = n4;
                    ++n2;
                }
            }
        }
        return this.totals;
    }

    public int getSubTotal(int n2, int n3, int n4) {
        if (n3 < 0 || n4 >= this.numBins[n2]) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("Histogram5"));
        }
        if (n3 > n4) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram10"));
        }
        int[] nArray = this.getBins(n2);
        int n5 = 0;
        int n6 = n3;
        while (n6 <= n4) {
            n5 += nArray[n6];
            ++n6;
        }
        return n5;
    }

    public double[] getMean() {
        if (this.mean == null) {
            this.getTotals();
            Histogram histogram = this;
            synchronized (histogram) {
                this.mean = new double[this.numBands];
                int n2 = 0;
                while (n2 < this.numBands) {
                    int[] nArray = this.getBins(n2);
                    int n3 = this.numBins[n2];
                    double d2 = this.getLowValue(n2);
                    double d3 = this.binWidth[n2];
                    double d4 = 0.0;
                    double d5 = this.totals[n2];
                    int n4 = 0;
                    while (n4 < n3) {
                        d4 += (double)nArray[n4] / d5 * d2;
                        d2 += d3;
                        ++n4;
                    }
                    this.mean[n2] = d4;
                    ++n2;
                }
            }
        }
        return this.mean;
    }

    public void countPixels(Raster raster, ROI rOI, int n2, int n3, int n4, int n5) {
        LinkedList linkedList;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram4"));
        }
        Rectangle rectangle = raster.getBounds();
        if (rOI == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = rOI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            int n6 = rectangle2.x;
            int n7 = rectangle2.y;
            rectangle2.x = this.startPosition(n6, n2, n4);
            rectangle2.y = this.startPosition(n7, n3, n5);
            rectangle2.width = n6 + rectangle2.width - rectangle2.x;
            rectangle2.height = n7 + rectangle2.height - rectangle2.y;
            if (rectangle2.width <= 0 || rectangle2.height <= 0) continue;
            switch (pixelAccessor.sampleType) {
                case -1: 
                case 0: {
                    this.countPixelsByte(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                case 1: {
                    this.countPixelsUShort(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                case 2: {
                    this.countPixelsShort(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                case 3: {
                    this.countPixelsInt(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                case 4: {
                    this.countPixelsFloat(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                case 5: {
                    this.countPixelsDouble(pixelAccessor, raster, rectangle2, n4, n5);
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("Histogram11"));
                }
            }
        }
    }

    private void countPixelsByte(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 0, false);
        byte[][] byArray = unpackedImageData.getByteData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            byte[] byArray2 = byArray[n6];
            int n7 = nArray[n6];
            int[] nArray2 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    int n11 = byArray2[n9] & 0xFF;
                    n9 += n4;
                    if ((double)n11 >= d2 && (double)n11 < d3) {
                        int n12;
                        int n13 = n12 = (int)(((double)n11 - d2) / d4);
                        nArray2[n13] = nArray2[n13] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray2);
            ++n6;
        }
    }

    private void countPixelsUShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 1, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            short[] sArray2 = sArray[n6];
            int n7 = nArray[n6];
            int[] nArray2 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    int n11 = sArray2[n9] & 0xFFFF;
                    n9 += n4;
                    if ((double)n11 >= d2 && (double)n11 < d3) {
                        int n12;
                        int n13 = n12 = (int)(((double)n11 - d2) / d4);
                        nArray2[n13] = nArray2[n13] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray2);
            ++n6;
        }
    }

    private void countPixelsShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 2, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            short[] sArray2 = sArray[n6];
            int n7 = nArray[n6];
            int[] nArray2 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    short s2 = sArray2[n9];
                    n9 += n4;
                    if ((double)s2 >= d2 && (double)s2 < d3) {
                        int n11;
                        int n12 = n11 = (int)(((double)s2 - d2) / d4);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray2);
            ++n6;
        }
    }

    private void countPixelsInt(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 3, false);
        int[][] nArray = unpackedImageData.getIntData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray2 = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            int[] nArray3 = nArray[n6];
            int n7 = nArray2[n6];
            int[] nArray4 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    int n11 = nArray3[n9];
                    n9 += n4;
                    if ((double)n11 >= d2 && (double)n11 < d3) {
                        int n12;
                        int n13 = n12 = (int)(((double)n11 - d2) / d4);
                        nArray4[n13] = nArray4[n13] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray4);
            ++n6;
        }
    }

    private void countPixelsFloat(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 4, false);
        float[][] fArray = unpackedImageData.getFloatData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            float[] fArray2 = fArray[n6];
            int n7 = nArray[n6];
            int[] nArray2 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    float f2 = fArray2[n9];
                    n9 += n4;
                    if ((double)f2 >= d2 && (double)f2 < d3) {
                        int n11;
                        int n12 = n11 = (int)(((double)f2 - d2) / d4);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray2);
            ++n6;
        }
    }

    private void countPixelsDouble(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n2, int n3) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 5, false);
        double[][] dArray = unpackedImageData.getDoubleData();
        int n4 = unpackedImageData.pixelStride * n2;
        int n5 = unpackedImageData.lineStride * n3;
        int[] nArray = unpackedImageData.bandOffsets;
        int n6 = 0;
        while (n6 < this.numBands) {
            double[] dArray2 = dArray[n6];
            int n7 = nArray[n6];
            int[] nArray2 = new int[this.numBins[n6]];
            double d2 = this.lowValue[n6];
            double d3 = this.highValue[n6];
            double d4 = this.binWidth[n6];
            int n8 = 0;
            while (n8 < rectangle.height) {
                int n9 = n7;
                n7 += n5;
                int n10 = 0;
                while (n10 < rectangle.width) {
                    double d5 = dArray2[n9];
                    n9 += n4;
                    if (d5 >= d2 && d5 < d3) {
                        int n11;
                        int n12 = n11 = (int)((d5 - d2) / d4);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n10 += n2;
                }
                n8 += n3;
            }
            this.mergeBins(n6, nArray2);
            ++n6;
        }
    }

    private int startPosition(int n2, int n3, int n4) {
        int n5 = (n2 - n3) % n4;
        return n5 == 0 ? n2 : n2 + (n4 - n5);
    }

    private void mergeBins(int n2, int[] nArray) {
        this.getBins();
        int[][] nArray2 = this.bins;
        synchronized (nArray2) {
            int[] nArray3 = this.bins[n2];
            int n3 = nArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4;
                nArray3[n5] = nArray3[n5] + nArray[n4];
                ++n4;
            }
        }
    }

    public double[] getMoment(int n2, boolean bl2, boolean bl3) {
        if (n2 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram6"));
        }
        if ((n2 == 1 || bl3) && this.mean == null) {
            this.getMean();
        }
        if (n2 == 1 && !bl2 && !bl3) {
            return this.mean;
        }
        double[] dArray = new double[this.numBands];
        if (n2 == 1 && bl3) {
            int n3 = 0;
            while (n3 < this.numBands) {
                dArray[n3] = 0.0;
                ++n3;
            }
        } else {
            this.getTotals();
            int n4 = 0;
            while (n4 < this.numBands) {
                int[] nArray = this.getBins(n4);
                int n5 = this.numBins[n4];
                double d2 = this.getLowValue(n4);
                double d3 = this.binWidth[n4];
                double d4 = this.totals[n4];
                double d5 = 0.0;
                if (bl3) {
                    int n6;
                    double d6 = this.mean[n4];
                    if (bl2 && n2 % 2 == 0) {
                        n6 = 0;
                        while (n6 < n5) {
                            d5 += Math.pow(d2 - d6, n2) * (double)nArray[n6] / d4;
                            d2 += d3;
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < n5) {
                            d5 += Math.abs(Math.pow(d2 - d6, n2)) * (double)nArray[n6] / d4;
                            d2 += d3;
                            ++n6;
                        }
                    }
                } else if (bl2 && n2 % 2 != 0) {
                    int n7 = 0;
                    while (n7 < n5) {
                        d5 += Math.abs(Math.pow(d2, n2)) * (double)nArray[n7] / d4;
                        d2 += d3;
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n5) {
                        d5 += Math.pow(d2, n2) * (double)nArray[n8] / d4;
                        d2 += d3;
                        ++n8;
                    }
                }
                dArray[n4] = d5;
                ++n4;
            }
        }
        return dArray;
    }

    public double[] getStandardDeviation() {
        this.getMean();
        double[] dArray = this.getMoment(2, false, false);
        double[] dArray2 = new double[this.numBands];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray2[n2] = Math.sqrt(dArray[n2] - this.mean[n2] * this.mean[n2]);
            ++n2;
        }
        return dArray2;
    }

    public double[] getEntropy() {
        this.getTotals();
        double d2 = Math.log(2.0);
        double[] dArray = new double[this.numBands];
        int n2 = 0;
        while (n2 < this.numBands) {
            int[] nArray = this.getBins(n2);
            int n3 = this.numBins[n2];
            double d3 = this.totals[n2];
            double d4 = 0.0;
            int n4 = 0;
            while (n4 < n3) {
                double d5 = (double)nArray[n4] / d3;
                if (d5 != 0.0) {
                    d4 -= d5 * (Math.log(d5) / d2);
                }
                ++n4;
            }
            dArray[n2] = d4;
            ++n2;
        }
        return dArray;
    }

    public Histogram getSmoothed(boolean bl2, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram7"));
        }
        if (n2 == 0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        double[] dArray = null;
        if (bl2) {
            n5 = 2 * n2 + 1;
            double d2 = n5 * n5;
            dArray = new double[n5];
            n4 = 0;
            while (n4 <= n2) {
                dArray[n4] = (double)(n4 + 1) / d2;
                ++n4;
            }
            n3 = n2 + 1;
            while (n3 < n5) {
                dArray[n3] = dArray[n5 - 1 - n3];
                ++n3;
            }
        }
        n5 = 0;
        while (n5 < this.numBands) {
            int n6;
            int n7;
            int n8;
            int n9;
            int[] nArray2 = this.getBins(n5);
            int[] nArray3 = nArray[n5];
            n4 = histogram.getNumBins(n5);
            n3 = 0;
            if (bl2) {
                n9 = 0;
                while (n9 < n4) {
                    n8 = Math.max(n9 - n2, 0);
                    n7 = Math.min(n9 + n2, n4);
                    n6 = n2 > n9 ? n2 - n9 : 0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    int n10 = n8;
                    while (n10 < n7) {
                        double d5 = dArray[n6++];
                        d3 += (double)nArray2[n10] * d5;
                        d4 += d5;
                        ++n10;
                    }
                    nArray3[n9] = (int)(d3 / d4 + 0.5);
                    n3 += nArray3[n9];
                    ++n9;
                }
            } else {
                n9 = 0;
                while (n9 < n4) {
                    n8 = Math.max(n9 - n2, 0);
                    n7 = Math.min(n9 + n2, n4);
                    n6 = 0;
                    int n11 = n8;
                    while (n11 < n7) {
                        n6 += nArray2[n11];
                        ++n11;
                    }
                    nArray3[n9] = (int)((double)n6 / (double)(n7 - n8 + 1) + 0.5);
                    n3 += nArray3[n9];
                    ++n9;
                }
            }
            double d6 = (double)this.totals[n5] / (double)n3;
            n7 = 0;
            while (n7 < n4) {
                nArray3[n7] = (int)((double)nArray3[n7] * d6 + 0.5);
                ++n7;
            }
            ++n5;
        }
        return histogram;
    }

    public Histogram getGaussianSmoothed(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram8"));
        }
        if (d2 == 0.0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        int n2 = (int)(5.16 * d2 + 0.5);
        if (n2 % 2 == 0) {
            ++n2;
        }
        double[] dArray = new double[n2];
        int n3 = n2 / 2;
        double d3 = d2 * d2;
        double d4 = 1.0 / Math.sqrt(Math.PI * 2 * d3);
        double d5 = -1.0 / (2.0 * d3);
        int n4 = n3;
        while (n4 < n2) {
            double d6 = n4 - n3;
            double d7 = d4 * Math.exp(d5 * d6 * d6);
            dArray[n2 - 1 - n4] = d7;
            dArray[n4] = d7;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.numBands) {
            int n6;
            int[] nArray2 = this.getBins(n5);
            int[] nArray3 = nArray[n5];
            int n7 = histogram.getNumBins(n5);
            int n8 = 0;
            int n9 = 0;
            while (n9 < n7) {
                int n10 = Math.max(n9 - n3, 0);
                int n11 = Math.min(n9 + n3, n7);
                n6 = n3 > n9 ? n3 - n9 : 0;
                double d8 = 0.0;
                double d9 = 0.0;
                int n12 = n10;
                while (n12 < n11) {
                    double d10 = dArray[n6++];
                    d8 += (double)nArray2[n12] * d10;
                    d9 += d10;
                    ++n12;
                }
                nArray3[n9] = (int)(d8 / d9 + 0.5);
                n8 += nArray3[n9];
                ++n9;
            }
            double d11 = (double)this.totals[n5] / (double)n8;
            n6 = 0;
            while (n6 < n7) {
                nArray3[n6] = (int)((double)nArray3[n6] * d11 + 0.5);
                ++n6;
            }
            ++n5;
        }
        return histogram;
    }

    public double[] getPTileThreshold(double d2) {
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram9"));
        }
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            int n4 = this.totals[n2];
            int n5 = 0;
            int n6 = nArray[0];
            int n7 = 0;
            while ((double)n6 / (double)n4 < d2) {
                ++n5;
                n6 += nArray[++n7];
            }
            dArray[n2] = this.getLowValue(n2) + (double)n5 * this.binWidth[n2];
            ++n2;
        }
        return dArray;
    }

    public double[] getModeThreshold(double d2) {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            int n4 = 0;
            int n5 = nArray[0];
            int n6 = 1;
            while (n6 < n3) {
                if (nArray[n6] > n5) {
                    n4 = n6;
                    n5 = nArray[n6];
                }
                ++n6;
            }
            int n7 = -1;
            double d3 = 0.0;
            int n8 = 0;
            while (n8 < n3) {
                double d4 = (double)nArray[n8] * Math.pow(Math.abs(n8 - n4), d2);
                if (d4 > d3) {
                    n7 = n8;
                    d3 = d4;
                }
                ++n8;
            }
            int n9 = n4;
            int n10 = nArray[n4];
            int n11 = n4 + 1;
            while (n11 <= n7) {
                if (nArray[n11] < n10) {
                    n9 = n11;
                    n10 = nArray[n11];
                }
                ++n11;
            }
            dArray[n2] = (int)((double)(n4 + n7) / 2.0 + 0.5);
            ++n2;
        }
        return dArray;
    }

    public double[] getIterativeThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            double d2 = this.binWidth[n2];
            double d3 = 0.5 * (this.getLowValue(n2) + this.getHighValue(n2));
            double d4 = 0.5 * (this.getLowValue(n2) + d3);
            double d5 = 0.5 * (d3 + this.getHighValue(n2));
            if (this.totals[n2] != 0) {
                double d6;
                double d7;
                int n4 = 1000;
                do {
                    dArray[n2] = d3;
                    double d8 = this.totals[n2];
                    double d9 = this.getLowValue(n2);
                    d7 = 0.0;
                    d6 = 0.0;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n3) {
                        if (d9 <= d3) {
                            int n7 = nArray[n6];
                            d7 += (double)n7 * d9;
                            n5 += n7;
                        } else {
                            d6 += (double)nArray[n6] * d9;
                        }
                        d9 += d2;
                        ++n6;
                    }
                    d7 = n5 != 0 ? (d7 /= (double)n5) : d4;
                    if (d8 != (double)n5) {
                        d6 /= d8 - (double)n5;
                        continue;
                    }
                    d6 = d5;
                } while (Math.abs((d3 = 0.5 * (d7 + d6)) - dArray[n2]) > 1.0E-6 && --n4 > 0);
            } else {
                dArray[n2] = d3;
            }
            ++n2;
        }
        return dArray;
    }

    public double[] getMaxVarianceThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        double[] dArray2 = this.getMoment(2, false, false);
        int n2 = 0;
        while (n2 < this.numBands) {
            double d2;
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            double d3 = this.totals[n2];
            double d4 = this.mean[n2];
            double d5 = this.binWidth[n2];
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = d2 = this.getLowValue(n2);
            double d9 = -1.7976931348623157E308;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                double d10 = (double)nArray[n6] / d3;
                if ((d6 += d10) != 0.0) {
                    double d11 = (d7 += d10 * d8) / d6;
                    double d12 = 1.0 - d6;
                    if (d12 != 0.0) {
                        double d13;
                        double d14;
                        double d15 = (d4 - d7) / d12;
                        double d16 = 0.0;
                        double d17 = d2;
                        int n7 = 0;
                        while (n7 <= n6) {
                            d14 = d17 - d11;
                            d16 += d14 * d14 * (double)nArray[n7];
                            ++n7;
                            d17 += d5;
                        }
                        d16 /= d3;
                        d14 = 0.0;
                        int n8 = n6 + 1;
                        while (n8 < n3) {
                            d13 = d17 - d15;
                            d14 += d13 * d13 * (double)nArray[n8];
                            ++n8;
                            d17 += d5;
                        }
                        if (d16 == 0.0 && (d14 /= d3) == 0.0 && d15 != 0.0) {
                            n4 = (int)(((d11 + d15) / 2.0 - this.getLowValue(n2)) / d5 + 0.5);
                            n5 = 0;
                            break;
                        }
                        if (!(d16 / d6 < 0.5) && !(d14 / d12 < 0.5)) {
                            d13 = d11 - d15;
                            double d18 = d6 * d12 * d13 * d13 / (d16 + d14);
                            if (d18 > d9) {
                                d9 = d18;
                                n4 = n6;
                                n5 = 0;
                            } else if (d18 == d9) {
                                ++n5;
                            }
                        }
                    }
                }
                ++n6;
                d8 += d5;
            }
            dArray[n2] = this.getLowValue(n2) + ((double)n4 + (double)n5 / 2.0 + 0.5) * d5;
            ++n2;
        }
        return dArray;
    }

    public double[] getMaxEntropyThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        double[] dArray2 = this.getEntropy();
        double d2 = Math.log(2.0);
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            double d3 = this.totals[n2];
            double d4 = dArray2[n2];
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = -1.7976931348623157E308;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                double d8 = (double)nArray[n6] / d3;
                if (d8 != 0.0) {
                    d5 += d8;
                    d6 -= d8 * Math.log(d8) / d2;
                    double d9 = 0.0;
                    int n7 = 0;
                    while (n7 <= n6) {
                        if ((double)nArray[n7] > d9) {
                            d9 = nArray[n7];
                        }
                        ++n7;
                    }
                    if (d9 != 0.0) {
                        double d10 = 0.0;
                        int n8 = n6 + 1;
                        while (n8 < n3) {
                            if ((double)nArray[n8] > d10) {
                                d10 = nArray[n8];
                            }
                            ++n8;
                        }
                        if (d10 != 0.0) {
                            double d11 = d6 / d4;
                            double d12 = d11 * Math.log(d5) / Math.log(d9 / d3) + (1.0 - d11) * Math.log(1.0 - d5) / Math.log(d10 / d3);
                            if (d12 > d7) {
                                d7 = d12;
                                n4 = n6;
                                n5 = 0;
                            } else if (d12 == d7) {
                                ++n5;
                            }
                        }
                    }
                }
                ++n6;
            }
            dArray[n2] = this.getLowValue(n2) + ((double)n4 + (double)n5 / 2.0 + 0.5) * this.binWidth[n2];
            ++n2;
        }
        return dArray;
    }

    public double[] getMinErrorThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n2 = 0;
        while (n2 < this.numBands) {
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            double d2 = this.totals[n2];
            double d3 = this.getLowValue(n2);
            double d4 = this.binWidth[n2];
            int n4 = 0;
            int n5 = this.totals[n2];
            double d5 = 0.0;
            double d6 = this.mean[n2] * d2;
            double d7 = d3;
            double d8 = Double.MAX_VALUE;
            int n6 = 0;
            int n7 = 0;
            double d9 = Double.MAX_VALUE;
            double d10 = Double.MAX_VALUE;
            double d11 = Double.MAX_VALUE;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = nArray[n9];
                n5 -= n10;
                double d12 = d7 * (double)n10;
                d6 -= d12;
                if ((n4 += n10) != 0 && (d5 += d12) != 0.0) {
                    double d13;
                    if (n5 == 0 || d6 == 0.0) break;
                    double d14 = d5 / (double)n4;
                    double d15 = d6 / (double)n5;
                    double d16 = 0.0;
                    double d17 = d3;
                    int n11 = 0;
                    while (n11 <= n9) {
                        d13 = d17 - d14;
                        d16 += (double)nArray[n11] * d13 * d13;
                        ++n11;
                        d17 += d4;
                    }
                    if (!((d16 /= (double)n4) < 0.5)) {
                        double d18;
                        d13 = 0.0;
                        int n12 = n9 + 1;
                        while (n12 < n3) {
                            d18 = d17 - d15;
                            d13 += (double)nArray[n12] * d18 * d18;
                            ++n12;
                            d17 += d4;
                        }
                        if (!((d13 /= (double)n5) < 0.5)) {
                            d18 = (double)n4 / d2;
                            double d19 = (double)n5 / d2;
                            double d20 = 1.0 + d18 * Math.log(d16) + d19 * Math.log(d13) - 2.0 * (d18 * Math.log(d18) + d19 * Math.log(d19));
                            d9 = d10;
                            d10 = d11;
                            d11 = d20;
                            if (++n8 >= 3 && d10 <= d9 && d10 <= d11) {
                                if (d10 < d8) {
                                    d8 = d10;
                                    n6 = n9 - 1;
                                    n7 = 0;
                                } else if (d10 == d8) {
                                    ++n7;
                                }
                            }
                        }
                    }
                }
                ++n9;
                d7 += d4;
            }
            dArray[n2] = n6 == 0 ? this.mean[n2] : this.getLowValue(n2) + ((double)n6 + (double)n7 / 2.0 + 0.5) * d4;
            ++n2;
        }
        return dArray;
    }

    public double[] getMinFuzzinessThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n2 = 0;
        while (n2 < this.numBands) {
            double d2;
            int n3 = this.numBins[n2];
            int[] nArray = this.getBins(n2);
            double d3 = this.totals[n2];
            double d4 = this.binWidth[n2];
            int n4 = 0;
            int n5 = this.totals[n2];
            double d5 = 0.0;
            double d6 = this.mean[n2] * d3;
            double d7 = d2 = this.getLowValue(n2);
            double d8 = this.getHighValue(n2) - d2;
            double d9 = Double.MAX_VALUE;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = nArray[n8];
                double d10 = d7 * (double)n9;
                d5 += d10;
                d6 -= d10;
                if ((n4 += n9) != 0 && (n5 -= n9) != 0) {
                    double d11 = d5 / (double)n4;
                    double d12 = d6 / (double)n5;
                    double d13 = d2;
                    double d14 = 0.0;
                    int n10 = 0;
                    while (n10 < n3) {
                        double d15 = n10 <= n8 ? 1.0 / (1.0 + Math.abs(d13 - d11) / d8) : 1.0 / (1.0 + Math.abs(d13 - d12) / d8);
                        double d16 = 1.0 - d15;
                        d14 += (-d15 * Math.log(d15) - d16 * Math.log(d16)) * ((double)nArray[n10] / d3);
                        ++n10;
                        d13 += d4;
                    }
                    if (d14 < d9) {
                        d9 = d14;
                        n6 = n8;
                        n7 = 0;
                    } else if (d14 == d9) {
                        ++n7;
                    }
                }
                ++n8;
                d7 += d4;
            }
            dArray[n2] = d2 + ((double)n6 + (double)n7 / 2.0 + 0.5) * d4;
            ++n2;
        }
        return dArray;
    }
}

