/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.Kernel;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public class KernelJAI
implements Serializable {
    public static final KernelJAI ERROR_FILTER_FLOYD_STEINBERG = new KernelJAI(3, 2, 1, 0, new float[]{0.0f, 0.0f, 0.4375f, 0.1875f, 0.3125f, 0.0625f});
    public static final KernelJAI ERROR_FILTER_JARVIS = new KernelJAI(5, 3, 2, 0, new float[]{0.0f, 0.0f, 0.0f, 0.14583333f, 0.104166664f, 0.0625f, 0.104166664f, 0.14583333f, 0.104166664f, 0.0625f, 0.020833334f, 0.0625f, 0.104166664f, 0.0625f, 0.020833334f});
    public static final KernelJAI ERROR_FILTER_STUCKI = new KernelJAI(5, 3, 2, 0, new float[]{0.0f, 0.0f, 0.0f, 0.16666667f, 0.11904762f, 0.04761905f, 0.0952381f, 0.1904762f, 0.0952381f, 0.04761905f, 0.023809524f, 0.04761905f, 0.0952381f, 0.04761905f, 0.023809524f});
    public static final KernelJAI[] DITHER_MASK_441 = new KernelJAI[]{new KernelJAI(4, 4, 1, 1, new float[]{0.9375f, 0.4375f, 0.8125f, 0.3125f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.0f, 0.5f, 0.125f, 0.625f})};
    public static final KernelJAI[] DITHER_MASK_443 = new KernelJAI[]{new KernelJAI(4, 4, 1, 1, new float[]{0.0f, 0.5f, 0.125f, 0.625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.9375f, 0.4375f, 0.8125f, 0.3125f}), new KernelJAI(4, 4, 1, 1, new float[]{0.625f, 0.125f, 0.5f, 0.0f, 0.375f, 0.875f, 0.25f, 0.75f, 0.5625f, 0.0625f, 0.6875f, 0.1875f, 0.3125f, 0.8125f, 0.4375f, 0.9375f}), new KernelJAI(4, 4, 1, 1, new float[]{0.9375f, 0.4375f, 0.8125f, 0.3125f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.0f, 0.5f, 0.125f, 0.625f})};
    public static final KernelJAI GRADIENT_MASK_SOBEL_VERTICAL = new KernelJAI(3, 3, 1, 1, new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f});
    public static final KernelJAI GRADIENT_MASK_SOBEL_HORIZONTAL = new KernelJAI(3, 3, 1, 1, new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f});
    protected int width;
    protected int height;
    protected int xOrigin;
    protected int yOrigin;
    protected float[] data = null;
    protected float[] dataH = null;
    protected float[] dataV = null;
    protected boolean isSeparable = false;
    protected boolean isHorizontallySymmetric = false;
    protected boolean isVerticallySymmetric = false;
    protected KernelJAI rotatedKernel = null;

    private synchronized void checkSeparable() {
        block17: {
            float f2;
            float f3;
            float f4;
            float f5;
            block16: {
                int n2;
                f5 = 1.0E-5f;
                if (this.isSeparable) {
                    return;
                }
                if (this.width <= 1 || this.height <= 1) {
                    return;
                }
                float f6 = 0.0f;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.data.length) {
                    float f7 = Math.abs(this.data[n5]);
                    if (f7 > f6) {
                        n3 = n5;
                        f6 = f7;
                    }
                    ++n5;
                }
                if (f6 < f5 / (float)this.data.length) {
                    this.isSeparable = false;
                    return;
                }
                float[] fArray = new float[this.width];
                f4 = 1.0f / this.data[n3];
                n4 = n3 % this.width;
                n3 /= this.width;
                int n6 = 0;
                while (n6 < this.width) {
                    fArray[n6] = this.data[n3 * this.width + n6] * f4;
                    ++n6;
                }
                int n7 = 0;
                int n8 = 0;
                while (n7 < this.height) {
                    n2 = 0;
                    while (n2 < this.width) {
                        f3 = Math.abs(this.data[n8 + n4] * fArray[n2] - this.data[n8 + n2]);
                        if (f3 > f5) {
                            this.isSeparable = false;
                            return;
                        }
                        ++n2;
                    }
                    ++n7;
                    n8 += this.width;
                }
                this.dataH = fArray;
                this.dataV = new float[this.height];
                n2 = 0;
                while (n2 < this.height) {
                    this.dataV[n2] = this.data[n4 + n2 * this.width];
                    ++n2;
                }
                this.isSeparable = true;
                f3 = 0.0f;
                f2 = 0.0f;
                int n9 = 0;
                while (n9 < this.width) {
                    f3 += this.dataH[n9];
                    ++n9;
                }
                int n10 = 0;
                while (n10 < this.height) {
                    f2 += this.dataV[n10];
                    ++n10;
                }
                if (!(Math.abs(f3) >= Math.abs(f2)) || !(Math.abs(f3) > f5)) break block16;
                f4 = 1.0f / f3;
                int n11 = 0;
                while (n11 < this.width) {
                    int n12 = n11++;
                    this.dataH[n12] = this.dataH[n12] * f4;
                }
                int n13 = 0;
                while (n13 < this.height) {
                    int n14 = n13++;
                    this.dataV[n14] = this.dataV[n14] * f3;
                }
                break block17;
            }
            if (!(Math.abs(f3) < Math.abs(f2)) || !(Math.abs(f2) > f5)) break block17;
            f4 = 1.0f / f2;
            int n15 = 0;
            while (n15 < this.width) {
                int n16 = n15++;
                this.dataH[n16] = this.dataH[n16] * f2;
            }
            int n17 = 0;
            while (n17 < this.height) {
                int n18 = n17++;
                this.dataV[n18] = this.dataV[n18] * f4;
            }
        }
    }

    private void classifyKernel() {
        if (!this.isSeparable) {
            this.checkSeparable();
        }
        this.isHorizontallySymmetric = false;
        this.isVerticallySymmetric = false;
    }

    public KernelJAI(int n2, int n3, int n4, int n5, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.width = n2;
        this.height = n3;
        this.xOrigin = n4;
        this.yOrigin = n5;
        this.data = (float[])fArray.clone();
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n2 * n3 != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI2"));
        }
        this.classifyKernel();
    }

    public KernelJAI(int n2, int n3, int n4, int n5, float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n2 != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI3"));
        }
        if (n3 != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI4"));
        }
        this.width = n2;
        this.height = n3;
        this.xOrigin = n4;
        this.yOrigin = n5;
        this.dataH = (float[])fArray.clone();
        this.dataV = (float[])fArray2.clone();
        this.data = new float[fArray.length * fArray2.length];
        int n6 = 0;
        int n7 = 0;
        while (n7 < fArray2.length) {
            float f2 = fArray2[n7];
            int n8 = 0;
            while (n8 < fArray.length) {
                this.data[n6 + n8] = f2 * fArray[n8];
                ++n8;
            }
            n6 += fArray.length;
            ++n7;
        }
        this.isSeparable = true;
        this.classifyKernel();
    }

    public KernelJAI(int n2, int n3, float[] fArray) {
        this(n2, n3, n2 / 2, n3 / 2, fArray);
    }

    public KernelJAI(Kernel kernel) {
        this(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), kernel.getKernelData(null));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXOrigin() {
        return this.xOrigin;
    }

    public int getYOrigin() {
        return this.yOrigin;
    }

    public float[] getKernelData() {
        return (float[])this.data.clone();
    }

    public float[] getHorizontalKernelData() {
        if (this.dataH == null) {
            return null;
        }
        return (float[])this.dataH.clone();
    }

    public float[] getVerticalKernelData() {
        if (this.dataV == null) {
            return null;
        }
        return (float[])this.dataV.clone();
    }

    public float getElement(int n2, int n3) {
        if (!this.isSeparable) {
            return this.data[n3 * this.width + n2];
        }
        return this.dataH[n2] * this.dataV[n3];
    }

    public boolean isSeparable() {
        return this.isSeparable;
    }

    public boolean isHorizontallySymmetric() {
        return this.isHorizontallySymmetric;
    }

    public boolean isVerticallySymmetric() {
        return this.isVerticallySymmetric;
    }

    public int getLeftPadding() {
        return this.xOrigin;
    }

    public int getRightPadding() {
        return this.width - this.xOrigin - 1;
    }

    public int getTopPadding() {
        return this.yOrigin;
    }

    public int getBottomPadding() {
        return this.height - this.yOrigin - 1;
    }

    public KernelJAI getRotatedKernel() {
        if (this.rotatedKernel == null) {
            if (this.isSeparable) {
                float[] fArray = new float[this.width];
                float[] fArray2 = new float[this.height];
                int n2 = 0;
                while (n2 < this.width) {
                    fArray[n2] = this.dataH[this.width - 1 - n2];
                    ++n2;
                }
                int n3 = 0;
                while (n3 < this.height) {
                    fArray2[n3] = this.dataV[this.height - 1 - n3];
                    ++n3;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray, fArray2);
            } else {
                int n4 = this.data.length;
                float[] fArray = new float[this.data.length];
                int n5 = 0;
                while (n5 < n4) {
                    fArray[n5] = this.data[n4 - 1 - n5];
                    ++n5;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray);
            }
        }
        return this.rotatedKernel;
    }
}

