/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class LookupTableJAI
implements Serializable {
    transient DataBuffer data;
    private int[] tableOffsets;

    public LookupTableJAI(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.data = new DataBufferByte(byArray, byArray.length);
        this.initOffsets(1, 0);
    }

    public LookupTableJAI(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n2);
        this.data = new DataBufferByte(byArray, byArray.length);
    }

    public LookupTableJAI(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, 0);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, n2);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int[] nArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, nArray);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(short[] sArray, boolean bl2) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = bl2 ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[] sArray, int n2, boolean bl2) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n2);
        this.data = bl2 ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[][] sArray, boolean bl2) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, 0);
        this.data = bl2 ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int n2, boolean bl2) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, n2);
        this.data = bl2 ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int[] nArray, boolean bl2) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, nArray);
        this.data = bl2 ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[] nArray, int n2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n2);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[][] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, 0);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int n2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, n2);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, nArray2);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[] fArray, int n2) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n2);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int n2) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, n2);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int[] nArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[] dArray, int n2) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n2);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int n2) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, n2);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int[] nArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : null;
    }

    public byte[] getByteData(int n2) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(n2) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int n2) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(n2);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(n2);
        }
        return null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : null;
    }

    public int[] getIntData(int n2) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(n2) : null;
    }

    public float[][] getFloatData() {
        return this.data.getDataType() == 4 ? DataBufferUtils.getBankDataFloat(this.data) : null;
    }

    public float[] getFloatData(int n2) {
        return this.data.getDataType() == 4 ? DataBufferUtils.getDataFloat(this.data, n2) : null;
    }

    public double[][] getDoubleData() {
        return this.data.getDataType() == 5 ? DataBufferUtils.getBankDataDouble(this.data) : null;
    }

    public double[] getDoubleData(int n2) {
        return this.data.getDataType() == 5 ? DataBufferUtils.getDataDouble(this.data, n2) : null;
    }

    public int[] getOffsets() {
        return this.tableOffsets;
    }

    public int getOffset() {
        return this.tableOffsets[0];
    }

    public int getOffset(int n2) {
        return this.tableOffsets[n2];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int n2) {
        int n3 = this.getNumBands();
        return n2 == 1 ? n3 : n2;
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getDestSampleModel(sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel, int n2, int n3) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.isIntegralDataType(sampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel(sampleModel, this.getDataType(), n2, n3, this.getDestNumBands(sampleModel.getNumBands()));
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public boolean isIntegralDataType(int n2) {
        return n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3;
    }

    public int lookup(int n2, int n3) {
        return this.data.getElem(n2, n3 - this.tableOffsets[n2]);
    }

    public float lookupFloat(int n2, int n3) {
        return this.data.getElemFloat(n2, n3 - this.tableOffsets[n2]);
    }

    public double lookupDouble(int n2, int n3) {
        return this.data.getElemDouble(n2, n3 - this.tableOffsets[n2]);
    }

    public WritableRaster lookup(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.lookup(writableRaster, writableRaster, writableRaster.getBounds());
    }

    public WritableRaster lookup(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        Object object2;
        Object[] objectArray;
        int n2;
        Object object3;
        Object object4;
        SampleModel sampleModel;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI1"));
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        if (!this.isIntegralDataType(sampleModel2)) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI2"));
        }
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (writableRaster != null) {
            rectangle = rectangle.intersection(writableRaster.getBounds());
        }
        if (writableRaster == null) {
            sampleModel = this.getDestSampleModel(sampleModel2, rectangle.width, rectangle.height);
            writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(rectangle.x, rectangle.y));
        } else {
            sampleModel = writableRaster.getSampleModel();
            if (sampleModel.getTransferType() != this.getDataType() || sampleModel.getNumBands() != this.getDestNumBands(sampleModel2.getNumBands())) {
                throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI3"));
            }
        }
        int n3 = RasterAccessor.findCompatibleTag(null, sampleModel2);
        int n4 = RasterAccessor.findCompatibleTag(null, sampleModel);
        RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel2, n3);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(sampleModel, n4);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle, rasterFormatTag, null);
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTag2, null);
        int n5 = rasterAccessor.getNumBands();
        int n6 = rasterAccessor.getDataType();
        int n7 = this.getNumBands();
        int n8 = this.getDataType();
        int n9 = rasterAccessor2.getWidth();
        int n10 = rasterAccessor2.getHeight();
        int n11 = rasterAccessor2.getNumBands();
        int n12 = rasterAccessor2.getDataType();
        int n13 = rasterAccessor.getScanlineStride();
        int n14 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        Object object5 = rasterAccessor.getByteDataArrays();
        Object object6 = rasterAccessor.getShortDataArrays();
        Object object7 = rasterAccessor.getIntDataArrays();
        if (n5 < n11) {
            int n15 = nArray[0];
            nArray = new int[n11];
            int n16 = 0;
            while (n16 < n11) {
                nArray[n16] = n15;
                ++n16;
            }
            switch (n6) {
                case 0: {
                    object4 = object5[0];
                    object5 = new byte[n11][];
                    int n17 = 0;
                    while (n17 < n11) {
                        object5[n17] = (byte[])object4;
                        ++n17;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    object3 = object6[0];
                    object6 = new short[n11][];
                    int n18 = 0;
                    while (n18 < n11) {
                        object6[n18] = (short[])object3;
                        ++n18;
                    }
                    break;
                }
                case 3: {
                    int[] nArray2 = object7[0];
                    object7 = new int[n11][];
                    n2 = 0;
                    while (n2 < n11) {
                        object7[n2] = nArray2;
                        ++n2;
                    }
                    break;
                }
            }
        }
        int[] nArray3 = this.getOffsets();
        Object object8 = this.getByteData();
        object4 = this.getShortData();
        Object object9 = this.getIntData();
        object3 = this.getFloatData();
        Object object10 = this.getDoubleData();
        if (n7 < n11) {
            int n19 = nArray3[0];
            nArray3 = new int[n11];
            n2 = 0;
            while (n2 < n11) {
                nArray3[n2] = n19;
                ++n2;
            }
            switch (n8) {
                case 0: {
                    objectArray = object8[0];
                    object8 = new byte[n11][];
                    int n20 = 0;
                    while (n20 < n11) {
                        object8[n20] = (byte[])objectArray;
                        ++n20;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    object2 = object4[0];
                    object4 = new short[n11][];
                    int n21 = 0;
                    while (n21 < n11) {
                        object4[n21] = (short[])object2;
                        ++n21;
                    }
                    break;
                }
                case 3: {
                    object = object9[0];
                    object9 = new int[n11][];
                    int n22 = 0;
                    while (n22 < n11) {
                        object9[n22] = object;
                        ++n22;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = object3[0];
                    object3 = new float[n11][];
                    int n23 = 0;
                    while (n23 < n11) {
                        object3[n23] = fArray;
                        ++n23;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = object10[0];
                    object10 = new double[n11][];
                    int n24 = 0;
                    while (n24 < n11) {
                        object10[n24] = dArray;
                        ++n24;
                    }
                    break;
                }
            }
        }
        int n25 = rasterAccessor2.getScanlineStride();
        n2 = rasterAccessor2.getPixelStride();
        objectArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        object2 = rasterAccessor2.getShortDataArrays();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        object = rasterAccessor2.getFloatDataArrays();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        block12 : switch (n12) {
            case 0: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object5, n9, n10, n11, n25, n2, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object7, n9, n10, n11, n25, n2, (int[])objectArray, byArray, nArray3, (byte[][])object8);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object5, n9, n10, n11, n25, n2, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object7, n9, n10, n11, n25, n2, (int[])objectArray, (short[][])object2, nArray3, (short[][])object4);
                    }
                }
                break;
            }
            case 3: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object5, n9, n10, n11, n25, n2, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object7, n9, n10, n11, n25, n2, (int[])objectArray, nArray4, nArray3, (int[][])object9);
                    }
                }
                break;
            }
            case 4: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object5, n9, n10, n11, n25, n2, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                        break;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object7, n9, n10, n11, n25, n2, (int[])objectArray, (float[][])object, nArray3, (float[][])object3);
                    }
                }
                break;
            }
            case 5: {
                switch (n6) {
                    case 0: {
                        this.lookup(n13, n14, nArray, (byte[][])object5, n9, n10, n11, n25, n2, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 2: {
                        this.lookup(n13, n14, nArray, (short[][])object6, n9, n10, n11, n25, n2, (int[])objectArray, dArray, nArray3, (double[][])object10);
                        break block12;
                    }
                    case 3: {
                        this.lookup(n13, n14, nArray, (int[][])object7, n9, n10, n11, n25, n2, (int[])objectArray, dArray, nArray3, (double[][])object10);
                    }
                }
            }
        }
        rasterAccessor2.copyDataToRaster();
        return writableRaster;
    }

    private void lookup(int n2, int n3, int[] nArray, byte[][] byArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, byte[][] byArray2, int[] nArray3, byte[][] byArray3) {
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray4 = byArray[n9];
            byte[] byArray5 = byArray2[n9];
            byte[] byArray6 = byArray3[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    byArray5[n15] = byArray6[(byArray4[n14] & 0xFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookupU(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    byArray3[n15] = byArray4[(sArray2[n14] & 0xFFFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    byArray3[n15] = byArray4[sArray2[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, int[][] nArray2, int n4, int n5, int n6, int n7, int n8, int[] nArray3, byte[][] byArray, int[] nArray4, byte[][] byArray2) {
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray5 = nArray2[n9];
            byte[] byArray3 = byArray[n9];
            byte[] byArray4 = byArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = nArray4[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    byArray3[n15] = byArray4[nArray5[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, byte[][] byArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, short[][] sArray, int[] nArray3, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray2 = byArray[n9];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    sArray3[n15] = sArray4[(byArray2[n14] & 0xFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookupU(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray4 = sArray[n9];
            short[] sArray5 = sArray2[n9];
            short[] sArray6 = sArray3[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    sArray5[n15] = sArray6[(sArray4[n14] & 0xFFFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray4 = sArray[n9];
            short[] sArray5 = sArray2[n9];
            short[] sArray6 = sArray3[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    sArray5[n15] = sArray6[sArray4[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, int[][] nArray2, int n4, int n5, int n6, int n7, int n8, int[] nArray3, short[][] sArray, int[] nArray4, short[][] sArray2) {
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray5 = nArray2[n9];
            short[] sArray3 = sArray[n9];
            short[] sArray4 = sArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = nArray4[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    sArray3[n15] = sArray4[nArray5[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, byte[][] byArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n9 = 0;
            while (n9 < n6) {
                byte[] byArray2 = byArray[n9];
                int[] nArray6 = nArray3[n9];
                int n10 = nArray[n9];
                int n11 = nArray2[n9];
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = n10;
                    int n14 = n11;
                    n10 += n2;
                    n11 += n7;
                    int n15 = 0;
                    while (n15 < n4) {
                        nArray6[n14] = this.data.getElem(n9, byArray2[n13] & 0xFF);
                        n13 += n3;
                        n14 += n8;
                        ++n15;
                    }
                    ++n12;
                }
                ++n9;
            }
        } else {
            int n16 = 0;
            while (n16 < n6) {
                byte[] byArray3 = byArray[n16];
                int[] nArray7 = nArray3[n16];
                int[] nArray8 = nArray5[n16];
                int n17 = nArray[n16];
                int n18 = nArray2[n16];
                int n19 = nArray4[n16];
                int n20 = 0;
                while (n20 < n5) {
                    int n21 = n17;
                    int n22 = n18;
                    n17 += n2;
                    n18 += n7;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray7[n22] = nArray8[(byArray3[n21] & 0xFF) - n19];
                        n21 += n3;
                        n22 += n8;
                        ++n23;
                    }
                    ++n20;
                }
                ++n16;
            }
        }
    }

    private void lookupU(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n9 = 0;
            while (n9 < n6) {
                short[] sArray2 = sArray[n9];
                int[] nArray6 = nArray3[n9];
                int n10 = nArray[n9];
                int n11 = nArray2[n9];
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = n10;
                    int n14 = n11;
                    n10 += n2;
                    n11 += n7;
                    int n15 = 0;
                    while (n15 < n4) {
                        nArray6[n14] = this.data.getElem(n9, sArray2[n13] & 0xFFFF);
                        n13 += n3;
                        n14 += n8;
                        ++n15;
                    }
                    ++n12;
                }
                ++n9;
            }
        } else {
            int n16 = 0;
            while (n16 < n6) {
                short[] sArray3 = sArray[n16];
                int[] nArray7 = nArray3[n16];
                int[] nArray8 = nArray5[n16];
                int n17 = nArray[n16];
                int n18 = nArray2[n16];
                int n19 = nArray4[n16];
                int n20 = 0;
                while (n20 < n5) {
                    int n21 = n17;
                    int n22 = n18;
                    n17 += n2;
                    n18 += n7;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray7[n22] = nArray8[(sArray3[n21] & 0xFFFF) - n19];
                        n21 += n3;
                        n22 += n8;
                        ++n23;
                    }
                    ++n20;
                }
                ++n16;
            }
        }
    }

    private void lookup(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n9 = 0;
            while (n9 < n6) {
                short[] sArray2 = sArray[n9];
                int[] nArray6 = nArray3[n9];
                int n10 = nArray[n9];
                int n11 = nArray2[n9];
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = n10;
                    int n14 = n11;
                    n10 += n2;
                    n11 += n7;
                    int n15 = 0;
                    while (n15 < n4) {
                        nArray6[n14] = this.data.getElem(n9, sArray2[n13]);
                        n13 += n3;
                        n14 += n8;
                        ++n15;
                    }
                    ++n12;
                }
                ++n9;
            }
        } else {
            int n16 = 0;
            while (n16 < n6) {
                short[] sArray3 = sArray[n16];
                int[] nArray7 = nArray3[n16];
                int[] nArray8 = nArray5[n16];
                int n17 = nArray[n16];
                int n18 = nArray2[n16];
                int n19 = nArray4[n16];
                int n20 = 0;
                while (n20 < n5) {
                    int n21 = n17;
                    int n22 = n18;
                    n17 += n2;
                    n18 += n7;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray7[n22] = nArray8[sArray3[n21] - n19];
                        n21 += n3;
                        n22 += n8;
                        ++n23;
                    }
                    ++n20;
                }
                ++n16;
            }
        }
    }

    private void lookup(int n2, int n3, int[] nArray, int[][] nArray2, int n4, int n5, int n6, int n7, int n8, int[] nArray3, int[][] nArray4, int[] nArray5, int[][] nArray6) {
        if (nArray6 == null) {
            int n9 = 0;
            while (n9 < n6) {
                int[] nArray7 = nArray2[n9];
                int[] nArray8 = nArray4[n9];
                int n10 = nArray[n9];
                int n11 = nArray3[n9];
                int n12 = 0;
                while (n12 < n5) {
                    int n13 = n10;
                    int n14 = n11;
                    n10 += n2;
                    n11 += n7;
                    int n15 = 0;
                    while (n15 < n4) {
                        nArray8[n14] = this.data.getElem(n9, nArray7[n13]);
                        n13 += n3;
                        n14 += n8;
                        ++n15;
                    }
                    ++n12;
                }
                ++n9;
            }
        } else {
            int n16 = 0;
            while (n16 < n6) {
                int[] nArray9 = nArray2[n16];
                int[] nArray10 = nArray4[n16];
                int[] nArray11 = nArray6[n16];
                int n17 = nArray[n16];
                int n18 = nArray3[n16];
                int n19 = nArray5[n16];
                int n20 = 0;
                while (n20 < n5) {
                    int n21 = n17;
                    int n22 = n18;
                    n17 += n2;
                    n18 += n7;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray10[n22] = nArray11[nArray9[n21] - n19];
                        n21 += n3;
                        n22 += n8;
                        ++n23;
                    }
                    ++n20;
                }
                ++n16;
            }
        }
    }

    private void lookup(int n2, int n3, int[] nArray, byte[][] byArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray2 = byArray[n9];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    fArray3[n15] = fArray4[(byArray2[n14] & 0xFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookupU(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    fArray3[n15] = fArray4[(sArray2[n14] & 0xFFFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    fArray3[n15] = fArray4[sArray2[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, int[][] nArray2, int n4, int n5, int n6, int n7, int n8, int[] nArray3, float[][] fArray, int[] nArray4, float[][] fArray2) {
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray5 = nArray2[n9];
            float[] fArray3 = fArray[n9];
            float[] fArray4 = fArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = nArray4[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    fArray3[n15] = fArray4[nArray5[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, byte[][] byArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n6) {
            byte[] byArray2 = byArray[n9];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    dArray3[n15] = dArray4[(byArray2[n14] & 0xFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookupU(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    dArray3[n15] = dArray4[(sArray2[n14] & 0xFFFF) - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, short[][] sArray, int n4, int n5, int n6, int n7, int n8, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n6) {
            short[] sArray2 = sArray[n9];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray2[n9];
            int n12 = nArray3[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    dArray3[n15] = dArray4[sArray2[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    private void lookup(int n2, int n3, int[] nArray, int[][] nArray2, int n4, int n5, int n6, int n7, int n8, int[] nArray3, double[][] dArray, int[] nArray4, double[][] dArray2) {
        int n9 = 0;
        while (n9 < n6) {
            int[] nArray5 = nArray2[n9];
            double[] dArray3 = dArray[n9];
            double[] dArray4 = dArray2[n9];
            int n10 = nArray[n9];
            int n11 = nArray3[n9];
            int n12 = nArray4[n9];
            int n13 = 0;
            while (n13 < n5) {
                int n14 = n10;
                int n15 = n11;
                n10 += n2;
                n11 += n7;
                int n16 = 0;
                while (n16 < n4) {
                    dArray3[n15] = dArray4[nArray5[n14] - n12];
                    n14 += n3;
                    n15 += n8;
                    ++n16;
                }
                ++n13;
            }
            ++n9;
        }
    }

    public int findNearestEntry(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = this.data.getDataType();
        int n3 = this.getNumBands();
        int n4 = this.getNumEntries();
        int n5 = -1;
        if (n2 == 0) {
            byte[][] byArray = this.getByteData();
            float f2 = 0.0f;
            n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                float f3 = fArray[n6] - (float)(byArray[n6][0] & 0xFF);
                f2 += f3 * f3;
                ++n6;
            }
            int n7 = 1;
            while (n7 < n4) {
                float f4 = 0.0f;
                int n8 = 0;
                while (n8 < n3) {
                    float f5 = fArray[n8] - (float)(byArray[n8][n7] & 0xFF);
                    f4 += f5 * f5;
                    ++n8;
                }
                if (f4 < f2) {
                    f2 = f4;
                    n5 = n7;
                }
                ++n7;
            }
        } else if (n2 == 2) {
            short[][] sArray = this.getShortData();
            float f6 = 0.0f;
            n5 = 0;
            int n9 = 0;
            while (n9 < n3) {
                float f7 = fArray[n9] - (float)sArray[n9][0];
                f6 += f7 * f7;
                ++n9;
            }
            int n10 = 1;
            while (n10 < n4) {
                float f8 = 0.0f;
                int n11 = 0;
                while (n11 < n3) {
                    float f9 = fArray[n11] - (float)sArray[n11][n10];
                    f8 += f9 * f9;
                    ++n11;
                }
                if (f8 < f6) {
                    f6 = f8;
                    n5 = n10;
                }
                ++n10;
            }
        } else if (n2 == 1) {
            short[][] sArray = this.getShortData();
            float f10 = 0.0f;
            n5 = 0;
            int n12 = 0;
            while (n12 < n3) {
                float f11 = fArray[n12] - (float)(sArray[n12][0] & 0xFFFF);
                f10 += f11 * f11;
                ++n12;
            }
            int n13 = 1;
            while (n13 < n4) {
                float f12 = 0.0f;
                int n14 = 0;
                while (n14 < n3) {
                    float f13 = fArray[n14] - (float)(sArray[n14][n13] & 0xFFFF);
                    f12 += f13 * f13;
                    ++n14;
                }
                if (f12 < f10) {
                    f10 = f12;
                    n5 = n13;
                }
                ++n13;
            }
        } else if (n2 == 3) {
            int[][] nArray = this.getIntData();
            float f14 = 0.0f;
            n5 = 0;
            int n15 = 0;
            while (n15 < n3) {
                float f15 = fArray[n15] - (float)nArray[n15][0];
                f14 += f15 * f15;
                ++n15;
            }
            int n16 = 1;
            while (n16 < n4) {
                float f16 = 0.0f;
                int n17 = 0;
                while (n17 < n3) {
                    float f17 = fArray[n17] - (float)nArray[n17][n16];
                    f16 += f17 * f17;
                    ++n17;
                }
                if (f16 < f14) {
                    f14 = f16;
                    n5 = n16;
                }
                ++n16;
            }
        } else if (n2 == 4) {
            float[][] fArray2 = this.getFloatData();
            float f18 = 0.0f;
            n5 = 0;
            int n18 = 0;
            while (n18 < n3) {
                float f19 = fArray[n18] - fArray2[n18][0];
                f18 += f19 * f19;
                ++n18;
            }
            int n19 = 1;
            while (n19 < n4) {
                float f20 = 0.0f;
                int n20 = 0;
                while (n20 < n3) {
                    float f21 = fArray[n20] - fArray2[n20][n19];
                    f20 += f21 * f21;
                    ++n20;
                }
                if (f20 < f18) {
                    f18 = f20;
                    n5 = n19;
                }
                ++n19;
            }
        } else if (n2 == 5) {
            double[][] dArray = this.getDoubleData();
            double d2 = 0.0;
            n5 = 0;
            int n21 = 0;
            while (n21 < n3) {
                double d3 = (double)fArray[n21] - dArray[n21][0];
                d2 += d3 * d3;
                ++n21;
            }
            int n22 = 1;
            while (n22 < n4) {
                double d4 = 0.0;
                int n23 = 0;
                while (n23 < n3) {
                    double d5 = (double)fArray[n23] - dArray[n23][n22];
                    d4 += d5 * d5;
                    ++n23;
                }
                if (d4 < d2) {
                    d2 = d4;
                    n5 = n22;
                }
                ++n22;
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("LookupTableJAI0"));
        }
        return n5 == -1 ? n5 : n5 + this.getOffset();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializerFactory.getState(this.data));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)object;
        this.data = (DataBuffer)serializableState.getObject();
    }

    private void initOffsets(int n2, int n3) {
        this.tableOffsets = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            this.tableOffsets[n4] = n3;
            ++n4;
        }
    }

    private void initOffsets(int n2, int[] nArray) {
        this.tableOffsets = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.tableOffsets[n3] = nArray[n3];
            ++n3;
        }
    }
}

