/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyEnvironment;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryMode;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class OperationNodeSupport
implements Serializable {
    private static final int PB_EQUAL = 0;
    private static final int PB_SOURCES_DIFFER = 1;
    private static final int PB_PARAMETERS_DIFFER = 2;
    private static final int PB_DIFFER = 3;
    private String registryModeName;
    private String opName;
    private transient OperationRegistry registry;
    private transient ParameterBlock pb;
    private transient RenderingHints hints;
    private PropertyChangeSupportJAI eventManager;
    private transient PropertyEnvironment propertySource = null;
    private Vector localPropEnv = new Vector();
    private Hashtable paramObservers = new Hashtable();

    private static int compare(ParameterBlock parameterBlock, ParameterBlock parameterBlock2) {
        if (parameterBlock == null && parameterBlock2 == null) {
            return 0;
        }
        if (parameterBlock == null && parameterBlock2 != null || parameterBlock != null && parameterBlock2 == null) {
            return 3;
        }
        int n2 = 0;
        if (!OperationNodeSupport.equals(parameterBlock.getSources(), parameterBlock2.getSources())) {
            n2 |= 1;
        }
        if (!OperationNodeSupport.equals(parameterBlock.getParameters(), parameterBlock2.getParameters())) {
            n2 |= 2;
        }
        return n2;
    }

    private static boolean equals(ParameterBlock parameterBlock, ParameterBlock parameterBlock2) {
        return parameterBlock == null ? parameterBlock2 == null : OperationNodeSupport.equals(parameterBlock.getSources(), parameterBlock2.getSources()) && OperationNodeSupport.equals(parameterBlock.getParameters(), parameterBlock2.getParameters());
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public OperationNodeSupport(String string, String string2, OperationRegistry operationRegistry, ParameterBlock parameterBlock, RenderingHints renderingHints, PropertyChangeSupportJAI propertyChangeSupportJAI) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.registryModeName = string;
        this.opName = string2;
        this.registry = operationRegistry == null ? JAI.getDefaultInstance().getOperationRegistry() : operationRegistry;
        this.pb = parameterBlock;
        this.hints = renderingHints;
        this.eventManager = propertyChangeSupportJAI;
        if (parameterBlock != null) {
            this.updateObserverMap(parameterBlock.getParameters());
        }
    }

    private void updateObserverMap(Vector vector) {
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            Object object;
            ParamObserver paramObserver;
            Object e2 = vector.get(n3);
            Integer n4 = new Integer(n3);
            if (e2 instanceof DeferredData) {
                paramObserver = new ParamObserver(n3, (DeferredData)e2);
                object = this.paramObservers.put(n4, paramObserver);
            } else {
                object = this.paramObservers.remove(n4);
            }
            if (object != null) {
                paramObserver = (ParamObserver)object;
                paramObserver.dd.deleteObserver(paramObserver);
            }
            ++n3;
        }
    }

    public String getRegistryModeName() {
        return this.registryModeName;
    }

    public String getOperationName() {
        return this.opName;
    }

    public void setOperationName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (string.equalsIgnoreCase(this.opName)) {
            return;
        }
        String string2 = this.opName;
        this.opName = string;
        this.fireEvent("OperationName", string2, string);
        this.resetPropertyEnvironment(false);
    }

    public OperationRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        if (operationRegistry != this.registry) {
            OperationRegistry operationRegistry2 = this.registry;
            this.registry = operationRegistry;
            this.fireEvent("OperationRegistry", operationRegistry2, operationRegistry);
            this.resetPropertyEnvironment(false);
        }
    }

    public ParameterBlock getParameterBlock() {
        return this.pb;
    }

    public void setParameterBlock(ParameterBlock parameterBlock) {
        int n2 = OperationNodeSupport.compare(this.pb, parameterBlock);
        if (n2 == 0) {
            return;
        }
        ParameterBlock parameterBlock2 = this.pb;
        this.pb = parameterBlock;
        if (parameterBlock != null) {
            this.updateObserverMap(parameterBlock.getParameters());
        }
        if (n2 == 1) {
            this.fireEvent("Sources", parameterBlock2.getSources(), parameterBlock.getSources());
        } else if (n2 == 2) {
            this.fireEvent("Parameters", parameterBlock2.getParameters(), parameterBlock.getParameters());
        } else {
            this.fireEvent("ParameterBlock", parameterBlock2, parameterBlock);
        }
        this.resetPropertyEnvironment(false);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (OperationNodeSupport.equals(this.hints, renderingHints)) {
            return;
        }
        RenderingHints renderingHints2 = this.hints;
        this.hints = renderingHints;
        this.fireEvent("RenderingHints", renderingHints2, renderingHints);
        this.resetPropertyEnvironment(false);
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (propertyGenerator == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(propertyGenerator);
        if (this.propertySource != null) {
            this.propertySource.addPropertyGenerator(propertyGenerator);
        }
    }

    public void copyPropertyFromSource(String string, int n2) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(new CopyDirective(string, n2));
        if (this.propertySource != null) {
            this.propertySource.copyPropertyFromSource(string, n2);
        }
    }

    public void suppressProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(string);
        if (this.propertySource != null) {
            this.propertySource.suppressProperty(string);
        }
    }

    public PropertySource getPropertySource(OperationNode operationNode, PropertySource propertySource) {
        if (operationNode == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.propertySource == null) {
            OperationNodeSupport operationNodeSupport = this;
            synchronized (operationNodeSupport) {
                RegistryMode registryMode = RegistryMode.getMode(this.registryModeName);
                this.propertySource = registryMode != null && registryMode.arePropertiesSupported() ? (PropertyEnvironment)this.registry.getPropertySource(operationNode) : new PropertyEnvironment(this.pb != null ? this.pb.getSources() : null, null, null, null, operationNode);
                this.updatePropertyEnvironment(this.propertySource);
            }
        }
        this.propertySource.setDefaultPropertySource(propertySource);
        return this.propertySource;
    }

    public void resetPropertyEnvironment(boolean bl2) {
        this.propertySource = null;
        if (bl2) {
            this.localPropEnv.clear();
        }
    }

    private void updatePropertyEnvironment(PropertyEnvironment propertyEnvironment) {
        if (propertyEnvironment != null) {
            OperationNodeSupport operationNodeSupport = this;
            synchronized (operationNodeSupport) {
                int n2 = this.localPropEnv.size();
                int n3 = 0;
                while (n3 < n2) {
                    Object e2 = this.localPropEnv.get(n3);
                    if (e2 instanceof String) {
                        propertyEnvironment.suppressProperty((String)e2);
                    } else if (e2 instanceof CopyDirective) {
                        CopyDirective copyDirective = (CopyDirective)e2;
                        propertyEnvironment.copyPropertyFromSource(copyDirective.getName(), copyDirective.getIndex());
                    } else if (e2 instanceof PropertyGenerator) {
                        propertyEnvironment.addPropertyGenerator((PropertyGenerator)e2);
                    }
                    ++n3;
                }
            }
        }
    }

    private void fireEvent(String string, Object object, Object object2) {
        if (this.eventManager != null) {
            Object object3 = this.eventManager.getPropertyChangeEventSource();
            PropertyChangeEventJAI propertyChangeEventJAI = new PropertyChangeEventJAI(object3, string, object, object2);
            this.eventManager.firePropertyChange(propertyChangeEventJAI);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        ParameterBlock parameterBlock = this.pb;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < parameterBlock.getNumSources()) {
            Object object2 = parameterBlock.getSource(n2);
            if (object2 != null && !(object2 instanceof Serializable)) {
                if (!bl2) {
                    parameterBlock = (ParameterBlock)this.pb.clone();
                    bl2 = true;
                }
                if (object2 instanceof RenderedImage) {
                    object = SerializerFactory.getState(object2, null);
                    parameterBlock.setSource(object, n2);
                } else {
                    throw new RuntimeException(object2.getClass().getName() + JaiI18N.getString("OperationNodeSupport0"));
                }
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < parameterBlock.getNumParameters()) {
            object = parameterBlock.getObjectParameter(n3);
            if (object != null && !(object instanceof Serializable)) {
                if (!bl2) {
                    parameterBlock = (ParameterBlock)this.pb.clone();
                    bl2 = true;
                }
                if (object instanceof Raster) {
                    parameterBlock.set(SerializerFactory.getState(object, null), n3);
                } else if (object instanceof RenderedImage) {
                    RenderedImage renderedImage = (RenderedImage)object;
                    RenderingHints renderingHints = new RenderingHints(null);
                    renderingHints.put(JAI.KEY_SERIALIZE_DEEP_COPY, new Boolean(true));
                    parameterBlock.set(SerializerFactory.getState(renderedImage, renderingHints), n3);
                } else {
                    throw new RuntimeException(object.getClass().getName() + JaiI18N.getString("OperationNodeSupport1"));
                }
            }
            ++n3;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(parameterBlock);
        objectOutputStream.writeObject(SerializerFactory.getState(this.hints, null));
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.pb = (ParameterBlock)objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)objectInputStream.readObject();
        this.hints = (RenderingHints)serializableState.getObject();
        int n2 = 0;
        while (n2 < this.pb.getNumSources()) {
            Object object2 = this.pb.getSource(n2);
            if (object2 instanceof SerializableState) {
                serializableState = (SerializableState)object2;
                object = PlanarImage.wrapRenderedImage((RenderedImage)serializableState.getObject());
                this.pb.setSource(object, n2);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.pb.getNumParameters()) {
            object = this.pb.getObjectParameter(n3);
            if (object instanceof SerializableState) {
                Object object3 = ((SerializableState)object).getObject();
                if (object3 instanceof Raster) {
                    this.pb.set(object3, n3);
                } else if (object3 instanceof RenderedImage) {
                    this.pb.set(PlanarImage.wrapRenderedImage((RenderedImage)object3), n3);
                } else {
                    this.pb.set(object3, n3);
                }
            }
            ++n3;
        }
        this.registry = JAI.getDefaultInstance().getOperationRegistry();
    }

    private class ParamObserver
    implements Observer {
        final int paramIndex;
        final DeferredData dd;

        ParamObserver(int n2, DeferredData deferredData) {
            if (deferredData == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            if (n2 < 0 || OperationNodeSupport.this.pb != null && n2 >= OperationNodeSupport.this.pb.getNumParameters()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.paramIndex = n2;
            this.dd = deferredData;
            deferredData.addObserver(this);
        }

        public synchronized void update(Observable observable, Object object) {
            if (observable != this.dd) {
                return;
            }
            if (object != null && OperationNodeSupport.this.eventManager != null) {
                Vector<Object> vector = OperationNodeSupport.this.pb.getParameters();
                Vector vector2 = (Vector)vector.clone();
                Vector vector3 = (Vector)vector.clone();
                vector2.set(this.paramIndex, object);
                vector3.set(this.paramIndex, this.dd.getData());
                OperationNodeSupport.this.fireEvent("Parameters", vector2, vector3);
            }
        }
    }

    private class CopyDirective
    implements Serializable {
        private String name;
        private int index;

        CopyDirective(String string, int n2) {
            if (string == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            this.name = string;
            this.index = n2;
        }

        String getName() {
            return this.name;
        }

        int getIndex() {
            return this.index;
        }
    }
}

