/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringArrayTable;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;

public class ParameterBlockJAI
extends ParameterBlock
implements ParameterList {
    private transient OperationDescriptor odesc;
    private String modeName;
    private ParameterListDescriptor pld;
    private CaselessStringArrayTable paramIndices;
    private CaselessStringArrayTable sourceIndices;
    private int numParameters;
    private String[] paramNames;
    private Class[] paramClasses;
    private Class[] sourceClasses;
    static /* synthetic */ Class class$javax$media$jai$OperationDescriptor;

    private static String getDefaultMode(OperationDescriptor operationDescriptor) {
        if (operationDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return operationDescriptor.getSupportedModes()[0];
    }

    public ParameterBlockJAI(OperationDescriptor operationDescriptor) {
        this(operationDescriptor, ParameterBlockJAI.getDefaultMode(operationDescriptor));
    }

    public ParameterBlockJAI(String string) {
        this((OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = ParameterBlockJAI.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor, string));
    }

    public ParameterBlockJAI(OperationDescriptor operationDescriptor, String string) {
        if (operationDescriptor == null || string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.odesc = operationDescriptor;
        this.modeName = string;
        this.pld = operationDescriptor.getParameterListDescriptor(string);
        this.numParameters = this.pld.getNumParameters();
        this.paramNames = this.pld.getParamNames();
        this.paramIndices = new CaselessStringArrayTable(this.pld.getParamNames());
        this.sourceIndices = new CaselessStringArrayTable(operationDescriptor.getSourceNames());
        this.paramClasses = this.pld.getParamClasses();
        this.sourceClasses = operationDescriptor.getSourceClasses(string);
        Object[] objectArray = this.pld.getParamDefaults();
        this.parameters = new Vector(this.numParameters);
        int n2 = 0;
        while (n2 < this.numParameters) {
            this.parameters.addElement(objectArray[n2]);
            ++n2;
        }
    }

    public ParameterBlockJAI(String string, String string2) {
        this((OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(string2, string), string2);
    }

    public int indexOfSource(String string) {
        return this.sourceIndices.indexOf(string);
    }

    public int indexOfParam(String string) {
        return this.paramIndices.indexOf(string);
    }

    public OperationDescriptor getOperationDescriptor() {
        return this.odesc;
    }

    public ParameterListDescriptor getParameterListDescriptor() {
        return this.pld;
    }

    public String getMode() {
        return this.modeName;
    }

    public ParameterBlockJAI setSource(String string, Object object) {
        if (object == null || string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = this.indexOfSource(string);
        if (!this.sourceClasses[n2].isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.getString("ParameterBlockJAI4"));
        }
        if (n2 >= this.odesc.getNumSources()) {
            this.addSource(object);
        } else {
            this.setSource(object, n2);
        }
        return this;
    }

    public Class[] getParamClasses() {
        return this.paramClasses;
    }

    private Object getObjectParameter0(String string) {
        Object object = this.getObjectParameter(this.indexOfParam(string));
        if (object == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
            throw new IllegalStateException(string + ":" + JaiI18N.getString("ParameterBlockJAI6"));
        }
        return object;
    }

    public Object getObjectParameter(String string) {
        return this.getObjectParameter0(string);
    }

    public byte getByteParameter(String string) {
        return (Byte)this.getObjectParameter0(string);
    }

    public boolean getBooleanParameter(String string) {
        return (Boolean)this.getObjectParameter0(string);
    }

    public char getCharParameter(String string) {
        return ((Character)this.getObjectParameter0(string)).charValue();
    }

    public short getShortParameter(String string) {
        return (Short)this.getObjectParameter0(string);
    }

    public int getIntParameter(String string) {
        return (Integer)this.getObjectParameter0(string);
    }

    public long getLongParameter(String string) {
        return (Long)this.getObjectParameter0(string);
    }

    public float getFloatParameter(String string) {
        return ((Float)this.getObjectParameter0(string)).floatValue();
    }

    public double getDoubleParameter(String string) {
        return (Double)this.getObjectParameter0(string);
    }

    public ParameterList setParameter(String string, byte by2) {
        return this.setParameter0(string, new Byte(by2));
    }

    public ParameterList setParameter(String string, boolean bl2) {
        return this.setParameter0(string, new Boolean(bl2));
    }

    public ParameterList setParameter(String string, char c2) {
        return this.setParameter0(string, new Character(c2));
    }

    public ParameterList setParameter(String string, short s2) {
        return this.setParameter0(string, new Short(s2));
    }

    public ParameterList setParameter(String string, int n2) {
        return this.setParameter0(string, new Integer(n2));
    }

    public ParameterList setParameter(String string, long l2) {
        return this.setParameter0(string, new Long(l2));
    }

    public ParameterList setParameter(String string, float f2) {
        return this.setParameter0(string, new Float(f2));
    }

    public ParameterList setParameter(String string, double d2) {
        return this.setParameter0(string, new Double(d2));
    }

    public ParameterList setParameter(String string, Object object) {
        return this.setParameter0(string, object);
    }

    private int checkParameter(String string, Object object) {
        int n2 = this.indexOfParam(string);
        if (object != null) {
            if (object == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
                throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterBlockJAI8"));
            }
            if (object instanceof DeferredData) {
                DeferredData deferredData = (DeferredData)object;
                if (!this.paramClasses[n2].isAssignableFrom(deferredData.getDataClass())) {
                    throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterBlockJAI0"));
                }
                if (deferredData.isValid() && !this.pld.isParameterValueValid(string, deferredData.getData())) {
                    throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterBlockJAI2"));
                }
            } else if (!this.paramClasses[n2].isInstance(object)) {
                throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterBlockJAI0"));
            }
        }
        if (!(object != null && object instanceof DeferredData || this.pld.isParameterValueValid(string, object))) {
            throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterBlockJAI2"));
        }
        return n2;
    }

    private ParameterList setParameter0(String string, Object object) {
        int n2 = this.checkParameter(string, object);
        this.parameters.setElementAt(object, n2);
        return this;
    }

    public ParameterBlock add(Object object) {
        throw new IllegalStateException(JaiI18N.getString("ParameterBlockJAI5"));
    }

    public ParameterBlock set(Object object, int n2) {
        if (n2 < 0 || n2 >= this.pld.getNumParameters()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setParameter0(this.paramNames[n2], object);
        return this;
    }

    public void setParameters(Vector vector) {
        if (vector == null || vector.size() != this.numParameters) {
            throw new IllegalArgumentException(JaiI18N.getString("ParameterBlockJAI7"));
        }
        int n2 = 0;
        while (n2 < this.numParameters) {
            this.checkParameter(this.paramNames[n2], vector.get(n2));
            ++n2;
        }
        this.parameters = vector;
    }

    public int indexOf(String string) {
        return this.indexOfParam(string);
    }

    public ParameterBlock set(byte by2, String string) {
        return this.set((Object)new Byte(by2), string);
    }

    public ParameterBlock set(char c2, String string) {
        return this.set((Object)new Character(c2), string);
    }

    public ParameterBlock set(short s2, String string) {
        return this.set((Object)new Short(s2), string);
    }

    public ParameterBlock set(int n2, String string) {
        return this.set((Object)new Integer(n2), string);
    }

    public ParameterBlock set(long l2, String string) {
        return this.set((Object)new Long(l2), string);
    }

    public ParameterBlock set(float f2, String string) {
        return this.set((Object)new Float(f2), string);
    }

    public ParameterBlock set(double d2, String string) {
        return this.set((Object)new Double(d2), string);
    }

    public ParameterBlock set(Object object, String string) {
        this.setParameter0(string, object);
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.odesc.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        this.odesc = (OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(this.modeName, string);
        if (this.odesc == null) {
            throw new NotSerializableException(string + " " + JaiI18N.getString("ParameterBlockJAI1"));
        }
    }

    public Object clone() {
        ParameterBlockJAI parameterBlockJAI = (ParameterBlockJAI)this.shallowClone();
        if (this.sources != null) {
            parameterBlockJAI.setSources((Vector)this.sources.clone());
        }
        if (this.parameters != null) {
            parameterBlockJAI.parameters = (Vector)this.parameters.clone();
        }
        return parameterBlockJAI;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

