/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringArrayTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.media.jai.JaiI18N;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;

public class ParameterListImpl
implements ParameterList,
Serializable {
    private ParameterListDescriptor pld;
    private CaselessStringArrayTable paramIndices;
    private Object[] paramValues;
    private Class[] paramClasses;

    public ParameterListImpl(ParameterListDescriptor parameterListDescriptor) {
        if (parameterListDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.pld = parameterListDescriptor;
        int n2 = this.pld.getNumParameters();
        if (n2 > 0) {
            Object[] objectArray = this.pld.getParamDefaults();
            this.paramClasses = this.pld.getParamClasses();
            this.paramIndices = new CaselessStringArrayTable(this.pld.getParamNames());
            this.paramValues = new Object[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.paramValues[n3] = objectArray[n3];
                ++n3;
            }
        } else {
            this.paramClasses = null;
            this.paramIndices = null;
            this.paramValues = null;
        }
    }

    public ParameterListDescriptor getParameterListDescriptor() {
        return this.pld;
    }

    private ParameterList setParameter0(String string, Object object) {
        int n2 = this.paramIndices.indexOf(string);
        if (object != null && !this.paramClasses[n2].isInstance(object)) {
            throw new IllegalArgumentException(this.formatMsg(JaiI18N.getString("ParameterListImpl0"), new Object[]{object.getClass().getName(), this.paramClasses[n2].getName(), string}));
        }
        if (!this.pld.isParameterValueValid(string, object)) {
            throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterListImpl1"));
        }
        this.paramValues[n2] = object;
        return this;
    }

    public ParameterList setParameter(String string, byte by2) {
        return this.setParameter0(string, new Byte(by2));
    }

    public ParameterList setParameter(String string, boolean bl2) {
        return this.setParameter0(string, new Boolean(bl2));
    }

    public ParameterList setParameter(String string, char c2) {
        return this.setParameter0(string, new Character(c2));
    }

    public ParameterList setParameter(String string, short s2) {
        return this.setParameter0(string, new Short(s2));
    }

    public ParameterList setParameter(String string, int n2) {
        return this.setParameter0(string, new Integer(n2));
    }

    public ParameterList setParameter(String string, long l2) {
        return this.setParameter0(string, new Long(l2));
    }

    public ParameterList setParameter(String string, float f2) {
        return this.setParameter0(string, new Float(f2));
    }

    public ParameterList setParameter(String string, double d2) {
        return this.setParameter0(string, new Double(d2));
    }

    public ParameterList setParameter(String string, Object object) {
        return this.setParameter0(string, object);
    }

    private Object getObjectParameter0(String string) {
        Object object = this.paramValues[this.paramIndices.indexOf(string)];
        if (object == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
            throw new IllegalStateException(string + ":" + JaiI18N.getString("ParameterListImpl2"));
        }
        return object;
    }

    public Object getObjectParameter(String string) {
        return this.getObjectParameter0(string);
    }

    public byte getByteParameter(String string) {
        return (Byte)this.getObjectParameter0(string);
    }

    public boolean getBooleanParameter(String string) {
        return (Boolean)this.getObjectParameter0(string);
    }

    public char getCharParameter(String string) {
        return ((Character)this.getObjectParameter0(string)).charValue();
    }

    public short getShortParameter(String string) {
        return (Short)this.getObjectParameter0(string);
    }

    public int getIntParameter(String string) {
        return (Integer)this.getObjectParameter0(string);
    }

    public long getLongParameter(String string) {
        return (Long)this.getObjectParameter0(string);
    }

    public float getFloatParameter(String string) {
        return ((Float)this.getObjectParameter0(string)).floatValue();
    }

    public double getDoubleParameter(String string) {
        return (Double)this.getObjectParameter0(string);
    }

    private String formatMsg(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.setLocale(Locale.getDefault());
        return messageFormat.format(objectArray);
    }
}

