/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PackedImageData;
import javax.media.jai.UnpackedImageData;

public final class PixelAccessor {
    public static final int TYPE_BIT = -1;
    public final SampleModel sampleModel;
    public final ColorModel colorModel;
    public final boolean isComponentSM;
    public final boolean isMultiPixelPackedSM;
    public final boolean isSinglePixelPackedSM;
    public final int sampleType;
    public final int bufferType;
    public final int transferType;
    public final int numBands;
    public final int[] sampleSize;
    public final boolean isPacked;
    public final boolean hasCompatibleCM;
    public final boolean isComponentCM;
    public final boolean isIndexCM;
    public final boolean isPackedCM;
    public final int componentType;
    public final int numComponents;
    public final int[] componentSize;

    private static SampleModel getSampleModel(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return renderedImage.getSampleModel();
    }

    public PixelAccessor(RenderedImage renderedImage) {
        this(PixelAccessor.getSampleModel(renderedImage), renderedImage.getColorModel());
    }

    public PixelAccessor(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
        this.isComponentSM = this.sampleModel instanceof ComponentSampleModel;
        this.isMultiPixelPackedSM = this.sampleModel instanceof MultiPixelPackedSampleModel;
        this.isSinglePixelPackedSM = this.sampleModel instanceof SinglePixelPackedSampleModel;
        this.bufferType = this.sampleModel.getDataType();
        this.transferType = this.sampleModel.getTransferType();
        this.numBands = this.sampleModel.getNumBands();
        this.sampleSize = this.sampleModel.getSampleSize();
        this.sampleType = this.isComponentSM ? this.bufferType : PixelAccessor.getType(this.sampleSize);
        this.isPacked = this.sampleType == -1 && this.numBands == 1;
        boolean bl2 = this.hasCompatibleCM = this.colorModel != null && JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel);
        if (this.hasCompatibleCM) {
            this.isComponentCM = this.colorModel instanceof ComponentColorModel;
            this.isIndexCM = this.colorModel instanceof IndexColorModel;
            this.isPackedCM = this.colorModel instanceof PackedColorModel;
            this.numComponents = this.colorModel.getNumComponents();
            this.componentSize = this.colorModel.getComponentSize();
            int n2 = PixelAccessor.getType(this.componentSize);
            this.componentType = n2 == -1 ? 0 : n2;
        } else {
            this.isComponentCM = false;
            this.isIndexCM = false;
            this.isPackedCM = false;
            this.numComponents = this.numBands;
            this.componentSize = this.sampleSize;
            this.componentType = this.sampleType;
        }
    }

    private static int getType(int[] nArray) {
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            n2 = Math.max(n2, nArray[n3]);
            ++n3;
        }
        int n4 = n2 < 1 ? 32 : (n2 == 1 ? -1 : (n2 <= 8 ? 0 : (n2 <= 16 ? 1 : (n2 <= 32 ? 3 : (n2 <= 64 ? 5 : 32)))));
        return n4;
    }

    public static int getPixelType(SampleModel sampleModel) {
        return sampleModel instanceof ComponentSampleModel ? sampleModel.getDataType() : PixelAccessor.getType(sampleModel.getSampleSize());
    }

    public static int getDestPixelType(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = 32;
        int n3 = vector.size();
        if (n3 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n2 = PixelAccessor.getPixelType(sampleModel);
            int n4 = 1;
            while (n4 < n3) {
                renderedImage = (RenderedImage)vector.get(n4);
                sampleModel = renderedImage.getSampleModel();
                int n5 = PixelAccessor.getPixelType(sampleModel);
                n2 = n2 == 1 && n5 == 2 || n2 == 2 && n5 == 1 ? 3 : Math.max(n2, n5);
                ++n4;
            }
        }
        return n2;
    }

    public static int getDestNumBands(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = 0;
        int n3 = vector.size();
        if (n3 > 0) {
            RenderedImage renderedImage = (RenderedImage)vector.get(0);
            SampleModel sampleModel = renderedImage.getSampleModel();
            n2 = sampleModel.getNumBands();
            int n4 = 1;
            while (n4 < n3) {
                renderedImage = (RenderedImage)vector.get(n4);
                sampleModel = renderedImage.getSampleModel();
                int n5 = sampleModel.getNumBands();
                n2 = n2 == 1 || n5 == 1 ? Math.max(n2, n5) : Math.min(n2, n5);
                ++n4;
            }
        }
        return n2;
    }

    public static boolean isPackedOperation(PixelAccessor[] pixelAccessorArray, PixelAccessor pixelAccessor) {
        boolean bl2 = pixelAccessor.isPacked;
        if (bl2 && pixelAccessorArray != null) {
            int n2 = 0;
            while (n2 < pixelAccessorArray.length) {
                boolean bl3 = bl2 = bl2 && pixelAccessorArray[n2].isPacked;
                if (!bl2) break;
                ++n2;
            }
        }
        return bl2;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked;
    }

    public static boolean isPackedOperation(PixelAccessor pixelAccessor, PixelAccessor pixelAccessor2, PixelAccessor pixelAccessor3) {
        return pixelAccessor.isPacked && pixelAccessor2.isPacked && pixelAccessor3.isPacked;
    }

    public UnpackedImageData getPixels(Raster raster, Rectangle rectangle, int n2, boolean bl2) {
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n2 < this.sampleType || this.sampleType == 1 && n2 == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor2"));
        }
        if (this.isComponentSM) {
            return this.getPixelsCSM(raster, rectangle, n2, bl2);
        }
        int n3 = rectangle.width * rectangle.height * this.numBands;
        Object object = null;
        switch (n2) {
            case 0: {
                byte[] byArray;
                if (bl2) {
                    byArray = new byte[n3];
                } else if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    byArray = (byte[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    byArray = new byte[n3];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n4 = 0;
                    while (n4 < n3) {
                        byArray[n4] = (byte)(nArray[n4] & 0xFF);
                        ++n4;
                    }
                }
                object = this.repeatBand(byArray, this.numBands);
                break;
            }
            case 1: {
                short[] sArray;
                if (bl2) {
                    sArray = new short[n3];
                } else if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    sArray = (short[])raster.getDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
                } else {
                    sArray = new short[n3];
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n5 = 0;
                    while (n5 < n3) {
                        sArray[n5] = (short)(nArray[n5] & 0xFFFF);
                        ++n5;
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 2: {
                short[] sArray = new short[n3];
                if (!bl2) {
                    int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
                    int n6 = 0;
                    while (n6 < n3) {
                        sArray[n6] = (short)nArray[n6];
                        ++n6;
                    }
                }
                object = this.repeatBand(sArray, this.numBands);
                break;
            }
            case 3: {
                return this.getPixelsInt(raster, rectangle, bl2);
            }
            case 4: {
                return this.getPixelsFloat(raster, rectangle, bl2);
            }
            case 5: {
                return this.getPixelsDouble(raster, rectangle, bl2);
            }
        }
        return new UnpackedImageData(raster, rectangle, n2, object, this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl2 & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsCSM(Raster raster, Rectangle rectangle, int n2, boolean bl2) {
        boolean bl3;
        int[] nArray;
        int n3;
        int n4;
        Object object = null;
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        if (n2 == this.sampleType) {
            DataBuffer dataBuffer = raster.getDataBuffer();
            int[] nArray2 = componentSampleModel.getBankIndices();
            switch (this.sampleType) {
                case 0: {
                    byte[][] byArray = ((DataBufferByte)dataBuffer).getBankData();
                    byte[][] byArrayArray = new byte[this.numBands][];
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        byArrayArray[n5] = byArray[nArray2[n5]];
                        ++n5;
                    }
                    object = byArrayArray;
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = this.sampleType == 1 ? ((DataBufferUShort)dataBuffer).getBankData() : ((DataBufferShort)dataBuffer).getBankData();
                    short[][] sArrayArray = new short[this.numBands][];
                    int n6 = 0;
                    while (n6 < this.numBands) {
                        sArrayArray[n6] = sArray[nArray2[n6]];
                        ++n6;
                    }
                    object = sArrayArray;
                    break;
                }
                case 3: {
                    int[][] nArray3 = ((DataBufferInt)dataBuffer).getBankData();
                    int[][] nArrayArray = new int[this.numBands][];
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        nArrayArray[n7] = nArray3[nArray2[n7]];
                        ++n7;
                    }
                    object = nArrayArray;
                    break;
                }
                case 4: {
                    float[][] fArray = DataBufferUtils.getBankDataFloat(dataBuffer);
                    float[][] fArrayArray = new float[this.numBands][];
                    int n8 = 0;
                    while (n8 < this.numBands) {
                        fArrayArray[n8] = fArray[nArray2[n8]];
                        ++n8;
                    }
                    object = fArrayArray;
                    break;
                }
                case 5: {
                    double[][] dArray = DataBufferUtils.getBankDataDouble(dataBuffer);
                    double[][] dArrayArray = new double[this.numBands][];
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        dArrayArray[n9] = dArray[nArray2[n9]];
                        ++n9;
                    }
                    object = dArrayArray;
                }
            }
            n4 = componentSampleModel.getPixelStride();
            n3 = componentSampleModel.getScanlineStride();
            int[] nArray4 = dataBuffer.getOffsets();
            int n10 = rectangle.x - raster.getSampleModelTranslateX();
            int n11 = rectangle.y - raster.getSampleModelTranslateY();
            nArray = new int[this.numBands];
            int n12 = 0;
            while (n12 < this.numBands) {
                nArray[n12] = componentSampleModel.getOffset(n10, n11, n12) + nArray4[nArray2[n12]];
                ++n12;
            }
            bl3 = false;
        } else {
            switch (n2) {
                case 3: {
                    return this.getPixelsInt(raster, rectangle, bl2);
                }
                case 4: {
                    return this.getPixelsFloat(raster, rectangle, bl2);
                }
                case 5: {
                    return this.getPixelsDouble(raster, rectangle, bl2);
                }
            }
            int n13 = rectangle.width * rectangle.height * this.numBands;
            short[] sArray = new short[n13];
            if (!bl2) {
                UnpackedImageData unpackedImageData = this.getPixelsCSM(raster, rectangle, this.sampleType, bl2);
                byte[][] byArray = unpackedImageData.getByteData();
                int n14 = 0;
                while (n14 < this.numBands) {
                    byte[] byArray2 = byArray[n14];
                    int n15 = unpackedImageData.getOffset(n14);
                    int n16 = n14;
                    int n17 = 0;
                    while (n17 < rectangle.height) {
                        int n18 = n15;
                        n15 += unpackedImageData.lineStride;
                        int n19 = 0;
                        while (n19 < rectangle.width) {
                            sArray[n16] = (short)(byArray2[n18] & 0xFF);
                            n18 += unpackedImageData.pixelStride;
                            n16 += this.numBands;
                            ++n19;
                        }
                        ++n17;
                    }
                    ++n14;
                }
            }
            object = this.repeatBand(sArray, this.numBands);
            n4 = this.numBands;
            n3 = n4 * rectangle.width;
            nArray = this.getInterleavedOffsets(this.numBands);
            bl3 = bl2 & raster instanceof WritableRaster;
        }
        return new UnpackedImageData(raster, rectangle, n2, object, n4, n3, nArray, bl3);
    }

    private UnpackedImageData getPixelsInt(Raster raster, Rectangle rectangle, boolean bl2) {
        int n2 = rectangle.width * rectangle.height * this.numBands;
        int[] nArray = bl2 ? new int[n2] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
        return new UnpackedImageData(raster, rectangle, 3, this.repeatBand(nArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl2 & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsFloat(Raster raster, Rectangle rectangle, boolean bl2) {
        int n2 = rectangle.width * rectangle.height * this.numBands;
        float[] fArray = bl2 ? new float[n2] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float[])null);
        return new UnpackedImageData(raster, rectangle, 4, this.repeatBand(fArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl2 & raster instanceof WritableRaster);
    }

    private UnpackedImageData getPixelsDouble(Raster raster, Rectangle rectangle, boolean bl2) {
        int n2 = rectangle.width * rectangle.height * this.numBands;
        double[] dArray = bl2 ? new double[n2] : raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (double[])null);
        return new UnpackedImageData(raster, rectangle, 5, this.repeatBand(dArray, this.numBands), this.numBands, this.numBands * rectangle.width, this.getInterleavedOffsets(this.numBands), bl2 & raster instanceof WritableRaster);
    }

    private byte[][] repeatBand(byte[] byArray, int n2) {
        byte[][] byArrayArray = new byte[n2][];
        int n3 = 0;
        while (n3 < n2) {
            byArrayArray[n3] = byArray;
            ++n3;
        }
        return byArrayArray;
    }

    private short[][] repeatBand(short[] sArray, int n2) {
        short[][] sArrayArray = new short[n2][];
        int n3 = 0;
        while (n3 < n2) {
            sArrayArray[n3] = sArray;
            ++n3;
        }
        return sArrayArray;
    }

    private int[][] repeatBand(int[] nArray, int n2) {
        int[][] nArrayArray = new int[n2][];
        int n3 = 0;
        while (n3 < n2) {
            nArrayArray[n3] = nArray;
            ++n3;
        }
        return nArrayArray;
    }

    private float[][] repeatBand(float[] fArray, int n2) {
        float[][] fArrayArray = new float[n2][];
        int n3 = 0;
        while (n3 < n2) {
            fArrayArray[n3] = fArray;
            ++n3;
        }
        return fArrayArray;
    }

    private double[][] repeatBand(double[] dArray, int n2) {
        double[][] dArrayArray = new double[n2][];
        int n3 = 0;
        while (n3 < n2) {
            dArrayArray[n3] = dArray;
            ++n3;
        }
        return dArrayArray;
    }

    private int[] getInterleavedOffsets(int n2) {
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = n3;
            ++n3;
        }
        return nArray;
    }

    public void setPixels(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.setPixels(unpackedImageData, true);
    }

    public void setPixels(UnpackedImageData unpackedImageData, boolean bl2) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        if (bl2) {
            switch (this.sampleType) {
                case 0: {
                    this.clampByte(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 1: {
                    this.clampUShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 2: {
                    this.clampShort(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 3: {
                    this.clampInt(unpackedImageData.data, unpackedImageData.type);
                    break;
                }
                case 4: {
                    this.clampFloat(unpackedImageData.data, unpackedImageData.type);
                }
            }
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n2 = unpackedImageData.type;
        switch (n2) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                if (this.isMultiPixelPackedSM && this.transferType == 0) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, byArray);
                    break;
                }
                int n3 = byArray.length;
                int[] nArray = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = byArray[n4] & 0xFF;
                    ++n4;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                if (this.isComponentSM) {
                    UnpackedImageData unpackedImageData2 = this.getPixelsCSM(writableRaster, rectangle, 0, true);
                    byte[][] byArray = unpackedImageData2.getByteData();
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        byte[] byArray2 = byArray[n5];
                        int n6 = unpackedImageData2.getOffset(n5);
                        int n7 = n5;
                        int n8 = 0;
                        while (n8 < rectangle.height) {
                            int n9 = n6;
                            n6 += unpackedImageData2.lineStride;
                            int n10 = 0;
                            while (n10 < rectangle.width) {
                                byArray2[n9] = (byte)sArray[n7];
                                n9 += unpackedImageData2.pixelStride;
                                n7 += this.numBands;
                                ++n10;
                            }
                            ++n8;
                        }
                        ++n5;
                    }
                    break;
                }
                if (this.isMultiPixelPackedSM && this.transferType == 1) {
                    writableRaster.setDataElements(rectangle.x, rectangle.y, rectangle.width, rectangle.height, sArray);
                    break;
                }
                int n11 = sArray.length;
                int[] nArray = new int[n11];
                if (n2 == 1) {
                    int n12 = 0;
                    while (n12 < n11) {
                        nArray[n12] = sArray[n12] & 0xFFFF;
                        ++n12;
                    }
                } else {
                    int n13 = 0;
                    while (n13 < n11) {
                        nArray[n13] = sArray[n13];
                        ++n13;
                    }
                }
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, nArray);
                break;
            }
            case 3: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getIntData(0));
                break;
            }
            case 4: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getFloatData(0));
                break;
            }
            case 5: {
                writableRaster.setPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, unpackedImageData.getDoubleData(0));
            }
        }
    }

    private void clampByte(Object object, int n2) {
        switch (n2) {
            case 1: {
                short[][] sArray = (short[][])object;
                int n3 = sArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    short[] sArray2 = sArray[n4];
                    int n5 = sArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = sArray2[n6] & 0xFFFF;
                        sArray2[n6] = (short)(n7 > 255 ? 255 : (short)n7);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
            case 2: {
                short[][] sArray = (short[][])object;
                int n8 = sArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    short[] sArray3 = sArray[n9];
                    int n10 = sArray3.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        short s2 = sArray3[n11];
                        sArray3[n11] = (short)(s2 > 255 ? 255 : (short)(s2 < 0 ? 0 : (short)s2));
                        ++n11;
                    }
                    ++n9;
                }
                break;
            }
            case 3: {
                int[][] nArray = (int[][])object;
                int n12 = nArray.length;
                int n13 = 0;
                while (n13 < n12) {
                    int[] nArray2 = nArray[n13];
                    int n14 = nArray2.length;
                    int n15 = 0;
                    while (n15 < n14) {
                        int n16 = nArray2[n15];
                        nArray2[n15] = n16 > 255 ? 255 : (n16 < 0 ? 0 : n16);
                        ++n15;
                    }
                    ++n13;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n17 = fArray.length;
                int n18 = 0;
                while (n18 < n17) {
                    float[] fArray2 = fArray[n18];
                    int n19 = fArray2.length;
                    int n20 = 0;
                    while (n20 < n19) {
                        float f2 = fArray2[n20];
                        fArray2[n20] = f2 > 255.0f ? 255.0f : (f2 < 0.0f ? 0.0f : f2);
                        ++n20;
                    }
                    ++n18;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n21 = dArray.length;
                int n22 = 0;
                while (n22 < n21) {
                    double[] dArray2 = dArray[n22];
                    int n23 = dArray2.length;
                    int n24 = 0;
                    while (n24 < n23) {
                        double d2 = dArray2[n24];
                        dArray2[n24] = d2 > 255.0 ? 255.0 : (d2 < 0.0 ? 0.0 : d2);
                        ++n24;
                    }
                    ++n22;
                }
                break;
            }
        }
    }

    private void clampUShort(Object object, int n2) {
        switch (n2) {
            case 3: {
                int[][] nArray = (int[][])object;
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int[] nArray2 = nArray[n4];
                    int n5 = nArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = nArray2[n6];
                        nArray2[n6] = n7 > 65535 ? 65535 : (n7 < 0 ? 0 : n7);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n8 = fArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    float[] fArray2 = fArray[n9];
                    int n10 = fArray2.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        float f2 = fArray2[n11];
                        fArray2[n11] = f2 > 65535.0f ? 65535.0f : (f2 < 0.0f ? 0.0f : f2);
                        ++n11;
                    }
                    ++n9;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n12 = dArray.length;
                int n13 = 0;
                while (n13 < n12) {
                    double[] dArray2 = dArray[n13];
                    int n14 = dArray2.length;
                    int n15 = 0;
                    while (n15 < n14) {
                        double d2 = dArray2[n15];
                        dArray2[n15] = d2 > 65535.0 ? 65535.0 : (d2 < 0.0 ? 0.0 : d2);
                        ++n15;
                    }
                    ++n13;
                }
                break;
            }
        }
    }

    private void clampShort(Object object, int n2) {
        switch (n2) {
            case 3: {
                int[][] nArray = (int[][])object;
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int[] nArray2 = nArray[n4];
                    int n5 = nArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = nArray2[n6];
                        nArray2[n6] = n7 > Short.MAX_VALUE ? Short.MAX_VALUE : (n7 < Short.MIN_VALUE ? Short.MIN_VALUE : n7);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
            case 4: {
                float[][] fArray = (float[][])object;
                int n8 = fArray.length;
                int n9 = 0;
                while (n9 < n8) {
                    float[] fArray2 = fArray[n9];
                    int n10 = fArray2.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        float f2 = fArray2[n11];
                        fArray2[n11] = f2 > 32767.0f ? 32767.0f : (f2 < -32768.0f ? -32768.0f : f2);
                        ++n11;
                    }
                    ++n9;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n12 = dArray.length;
                int n13 = 0;
                while (n13 < n12) {
                    double[] dArray2 = dArray[n13];
                    int n14 = dArray2.length;
                    int n15 = 0;
                    while (n15 < n14) {
                        double d2 = dArray2[n15];
                        dArray2[n15] = d2 > 32767.0 ? 32767.0 : (d2 < -32768.0 ? -32768.0 : d2);
                        ++n15;
                    }
                    ++n13;
                }
                break;
            }
        }
    }

    private void clampInt(Object object, int n2) {
        switch (n2) {
            case 4: {
                float[][] fArray = (float[][])object;
                int n3 = fArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    float[] fArray2 = fArray[n4];
                    int n5 = fArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        float f2 = fArray2[n6];
                        fArray2[n6] = f2 > 2.1474836E9f ? 2.1474836E9f : (f2 < -2.1474836E9f ? -2.1474836E9f : f2);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
            case 5: {
                double[][] dArray = (double[][])object;
                int n7 = dArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    double[] dArray2 = dArray[n8];
                    int n9 = dArray2.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        double d2 = dArray2[n10];
                        dArray2[n10] = d2 > 2.147483647E9 ? 2.147483647E9 : (d2 < -2.147483648E9 ? -2.147483648E9 : d2);
                        ++n10;
                    }
                    ++n8;
                }
                break;
            }
        }
    }

    private void clampFloat(Object object, int n2) {
        switch (n2) {
            case 5: {
                double[][] dArray = (double[][])object;
                int n3 = dArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    double[] dArray2 = dArray[n4];
                    int n5 = dArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        double d2 = dArray2[n6];
                        dArray2[n6] = d2 > 3.4028234663852886E38 ? 3.4028234663852886E38 : (d2 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2);
                        ++n6;
                    }
                    ++n4;
                }
                break;
            }
        }
    }

    public PackedImageData getPackedPixels(Raster raster, Rectangle rectangle, boolean bl2, boolean bl3) {
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        boolean bl4;
        block16: {
            block14: {
                block15: {
                    if (!this.isPacked) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor3"));
                    }
                    if (!raster.getBounds().contains(rectangle)) {
                        throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
                    }
                    if (!this.isMultiPixelPackedSM) break block14;
                    bl4 = bl2;
                    if (!bl3) break block15;
                    byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
                    n4 = (rectangle.width + 7) / 8;
                    n3 = 0;
                    n2 = 0;
                    break block16;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n5 = dataBuffer.getOffset();
                int n6 = rectangle.x - raster.getSampleModelTranslateX();
                int n7 = rectangle.y - raster.getSampleModelTranslateY();
                int n8 = multiPixelPackedSampleModel.getScanlineStride();
                int n9 = multiPixelPackedSampleModel.getOffset(n6, n7) + n5;
                int n10 = multiPixelPackedSampleModel.getOffset(n6 + rectangle.width - 1, n7) + n5;
                int n11 = n10 - n9 + 1;
                int n12 = multiPixelPackedSampleModel.getBitOffset(n6);
                switch (this.bufferType) {
                    case 0: {
                        byArray = ((DataBufferByte)dataBuffer).getData();
                        n4 = n8;
                        n2 = n9;
                        n3 = n12;
                        bl4 = false;
                        break block16;
                    }
                    case 1: {
                        n4 = n11 * 2;
                        n2 = n12 / 8;
                        n3 = n12 % 8;
                        byArray = new byte[n4 * rectangle.height];
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n13 = 0;
                        int n14 = 0;
                        while (n14 < rectangle.height) {
                            int n15 = n9;
                            while (n15 <= n10) {
                                short s2 = sArray[n15];
                                byArray[n13++] = (byte)(s2 >>> 8 & 0xFF);
                                byArray[n13++] = (byte)(s2 & 0xFF);
                                ++n15;
                            }
                            n9 += n8;
                            n10 += n8;
                            ++n14;
                        }
                        break block16;
                    }
                    case 3: {
                        n4 = n11 * 4;
                        n2 = n12 / 8;
                        n3 = n12 % 8;
                        byArray = new byte[n4 * rectangle.height];
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n16 = 0;
                        int n17 = 0;
                        while (n17 < rectangle.height) {
                            int n18 = n9;
                            while (n18 <= n10) {
                                int n19 = nArray[n18];
                                byArray[n16++] = (byte)(n19 >>> 24 & 0xFF);
                                byArray[n16++] = (byte)(n19 >>> 16 & 0xFF);
                                byArray[n16++] = (byte)(n19 >>> 8 & 0xFF);
                                byArray[n16++] = (byte)(n19 & 0xFF);
                                ++n18;
                            }
                            n9 += n8;
                            n10 += n8;
                            ++n17;
                        }
                        break block16;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            n4 = (rectangle.width + 7) / 8;
            n2 = 0;
            n3 = 0;
            bl4 = bl2 & raster instanceof WritableRaster;
            byArray = new byte[n4 * rectangle.height];
            if (!bl2) {
                int n20 = n4 * 8;
                int[] nArray = new int[n20];
                int n21 = 0;
                int n22 = 0;
                while (n22 < rectangle.height) {
                    nArray = raster.getPixels(rectangle.x, rectangle.y + n22, rectangle.width, 1, nArray);
                    int n23 = 0;
                    while (n23 < n20) {
                        byArray[n21++] = (byte)(nArray[n23] << 7 | nArray[n23 + 1] << 6 | nArray[n23 + 2] << 5 | nArray[n23 + 3] << 4 | nArray[n23 + 4] << 3 | nArray[n23 + 5] << 2 | nArray[n23 + 6] << 1 | nArray[n23 + 7]);
                        n23 += 8;
                    }
                    ++n22;
                }
            }
        }
        return new PackedImageData(raster, rectangle, byArray, n4, n2, n3, bl3, bl4);
    }

    public void setPackedPixels(PackedImageData packedImageData) {
        block14: {
            byte[] byArray;
            Rectangle rectangle;
            Raster raster;
            block12: {
                block13: {
                    if (packedImageData == null) {
                        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                    }
                    if (!packedImageData.convertToDest) {
                        return;
                    }
                    raster = packedImageData.raster;
                    rectangle = packedImageData.rect;
                    byArray = packedImageData.data;
                    if (!this.isMultiPixelPackedSM) break block12;
                    if (!packedImageData.coercedZeroOffset) break block13;
                    ImageUtil.setPackedBinaryData(byArray, (WritableRaster)raster, rectangle);
                    break block14;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)this.sampleModel;
                DataBuffer dataBuffer = raster.getDataBuffer();
                int n2 = dataBuffer.getOffset();
                int n3 = rectangle.x - raster.getSampleModelTranslateX();
                int n4 = rectangle.y - raster.getSampleModelTranslateY();
                int n5 = multiPixelPackedSampleModel.getScanlineStride();
                int n6 = multiPixelPackedSampleModel.getOffset(n3, n4) + n2;
                int n7 = multiPixelPackedSampleModel.getOffset(n3 + rectangle.width - 1, n4) + n2;
                switch (this.bufferType) {
                    case 1: {
                        short[] sArray = ((DataBufferUShort)dataBuffer).getData();
                        int n8 = 0;
                        int n9 = 0;
                        while (n9 < rectangle.height) {
                            int n10 = n6;
                            while (n10 <= n7) {
                                sArray[n10] = (short)(byArray[n8++] << 8 | byArray[n8++]);
                                ++n10;
                            }
                            n6 += n5;
                            n7 += n5;
                            ++n9;
                        }
                        break block14;
                    }
                    case 3: {
                        int[] nArray = ((DataBufferInt)dataBuffer).getData();
                        int n11 = 0;
                        int n12 = 0;
                        while (n12 < rectangle.height) {
                            int n13 = n6;
                            while (n13 <= n7) {
                                nArray[n13] = byArray[n11++] << 24 | byArray[n11++] << 16 | byArray[n11++] << 8 | byArray[n11++];
                                ++n13;
                            }
                            n6 += n5;
                            n7 += n5;
                            ++n12;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            WritableRaster writableRaster = (WritableRaster)raster;
            int n14 = packedImageData.lineStride * 8;
            int[] nArray = new int[n14];
            int n15 = 0;
            int n16 = 0;
            while (n16 < rectangle.height) {
                int n17 = 0;
                while (n17 < n14) {
                    nArray[n17] = byArray[n15] >>> 7 & 1;
                    nArray[n17 + 1] = byArray[n15] >>> 6 & 1;
                    nArray[n17 + 2] = byArray[n15] >>> 5 & 1;
                    nArray[n17 + 3] = byArray[n15] >>> 4 & 1;
                    nArray[n17 + 4] = byArray[n15] >>> 3 & 1;
                    nArray[n17 + 5] = byArray[n15] >>> 2 & 1;
                    nArray[n17 + 6] = byArray[n15] >>> 1 & 1;
                    nArray[n17 + 7] = byArray[n15] & 1;
                    ++n15;
                    n17 += 8;
                }
                writableRaster.setPixels(rectangle.x, rectangle.y + n16, rectangle.width, 1, nArray);
                ++n16;
            }
        }
    }

    public UnpackedImageData getComponents(Raster raster, Rectangle rectangle, int n2) {
        Object object;
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor1"));
        }
        if (n2 < this.componentType || this.componentType == 1 && n2 == 2) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor4"));
        }
        int n3 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = new int[n3];
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = 0;
        int n7 = rectangle.y;
        while (n7 < n5) {
            int n8 = rectangle.x;
            while (n8 < n4) {
                object = raster.getDataElements(n8, n7, null);
                this.colorModel.getComponents(object, nArray, n6);
                n6 += this.numComponents;
                ++n8;
            }
            ++n7;
        }
        Object object2 = null;
        switch (n2) {
            case 0: {
                object = new byte[n3];
                int n9 = 0;
                while (n9 < n3) {
                    object[n9] = (byte)(nArray[n9] & 0xFF);
                    ++n9;
                }
                object2 = this.repeatBand((byte[])object, this.numComponents);
                break;
            }
            case 1: {
                short[] sArray = new short[n3];
                int n10 = 0;
                while (n10 < n3) {
                    sArray[n10] = (short)(nArray[n10] & 0xFFFF);
                    ++n10;
                }
                object2 = this.repeatBand(sArray, this.numComponents);
                break;
            }
            case 2: {
                short[] sArray = new short[n3];
                int n11 = 0;
                while (n11 < n3) {
                    sArray[n11] = (short)nArray[n11];
                    ++n11;
                }
                object2 = this.repeatBand(sArray, this.numComponents);
                break;
            }
            case 3: {
                object2 = this.repeatBand(nArray, this.numComponents);
                break;
            }
            case 4: {
                float[] fArray = new float[n3];
                int n12 = 0;
                while (n12 < n3) {
                    fArray[n12] = nArray[n12];
                    ++n12;
                }
                object2 = this.repeatBand(fArray, this.numComponents);
                break;
            }
            case 5: {
                double[] dArray = new double[n3];
                int n13 = 0;
                while (n13 < n3) {
                    dArray[n13] = nArray[n13];
                    ++n13;
                }
                object2 = this.repeatBand(dArray, this.numComponents);
            }
        }
        return new UnpackedImageData(raster, rectangle, n2, object2, this.numComponents, this.numComponents * rectangle.width, this.getInterleavedOffsets(this.numComponents), raster instanceof WritableRaster);
    }

    public void setComponents(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n2 = unpackedImageData.type;
        int n3 = rectangle.width * rectangle.height * this.numComponents;
        int[] nArray = null;
        switch (n2) {
            case 0: {
                byte[] byArray = unpackedImageData.getByteData(0);
                nArray = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = byArray[n4] & 0xFF;
                    ++n4;
                }
                break;
            }
            case 1: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n3];
                int n5 = 0;
                while (n5 < n3) {
                    nArray[n5] = sArray[n5] & 0xFFFF;
                    ++n5;
                }
                break;
            }
            case 2: {
                short[] sArray = unpackedImageData.getShortData(0);
                nArray = new int[n3];
                int n6 = 0;
                while (n6 < n3) {
                    nArray[n6] = sArray[n6];
                    ++n6;
                }
                break;
            }
            case 3: {
                nArray = unpackedImageData.getIntData(0);
                break;
            }
            case 4: {
                float[] fArray = unpackedImageData.getFloatData(0);
                nArray = new int[n3];
                int n7 = 0;
                while (n7 < n3) {
                    nArray[n7] = (int)fArray[n7];
                    ++n7;
                }
                break;
            }
            case 5: {
                double[] dArray = unpackedImageData.getDoubleData(0);
                nArray = new int[n3];
                int n8 = 0;
                while (n8 < n3) {
                    nArray[n8] = (int)dArray[n8];
                    ++n8;
                }
                break;
            }
        }
        int n9 = rectangle.x + rectangle.width;
        int n10 = rectangle.y + rectangle.height;
        int n11 = 0;
        int n12 = rectangle.y;
        while (n12 < n10) {
            int n13 = rectangle.x;
            while (n13 < n9) {
                Object object = this.colorModel.getDataElements(nArray, n11, (Object)null);
                writableRaster.setDataElements(n13, n12, object);
                n11 += this.numComponents;
                ++n13;
            }
            ++n12;
        }
    }

    public UnpackedImageData getComponentsRGB(Raster raster, Rectangle rectangle) {
        if (!this.hasCompatibleCM) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor5"));
        }
        if (!raster.getBounds().contains(rectangle)) {
            throw new IllegalArgumentException(JaiI18N.getString("PixelAccessor0"));
        }
        int n2 = rectangle.width * rectangle.height;
        byte[][] byArray = new byte[4][n2];
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (this.isIndexCM) {
            IndexColorModel indexColorModel = (IndexColorModel)this.colorModel;
            int n5 = indexColorModel.getMapSize();
            byte[] byArray6 = new byte[n5];
            indexColorModel.getReds(byArray6);
            byte[] byArray7 = new byte[n5];
            indexColorModel.getGreens(byArray7);
            byte[] byArray8 = new byte[n5];
            indexColorModel.getBlues(byArray8);
            byte[] byArray9 = null;
            if (indexColorModel.hasAlpha()) {
                byArray9 = new byte[n5];
                indexColorModel.getAlphas(byArray9);
            }
            int[] nArray = raster.getPixels(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (int[])null);
            if (byArray9 == null) {
                int n6 = 0;
                int n7 = rectangle.y;
                while (n7 < n4) {
                    int n8 = rectangle.x;
                    while (n8 < n3) {
                        int n9 = nArray[n6];
                        byArray2[n6] = byArray6[n9];
                        byArray3[n6] = byArray7[n9];
                        byArray4[n6] = byArray8[n9];
                        ++n6;
                        ++n8;
                    }
                    ++n7;
                }
            } else {
                int n10 = 0;
                int n11 = rectangle.y;
                while (n11 < n4) {
                    int n12 = rectangle.x;
                    while (n12 < n3) {
                        int n13 = nArray[n10];
                        byArray2[n10] = byArray6[n13];
                        byArray3[n10] = byArray7[n13];
                        byArray4[n10] = byArray8[n13];
                        byArray5[n10] = byArray9[n13];
                        ++n10;
                        ++n12;
                    }
                    ++n11;
                }
            }
        } else {
            int n14 = 0;
            int n15 = rectangle.y;
            while (n15 < n4) {
                int n16 = rectangle.x;
                while (n16 < n3) {
                    Object object = raster.getDataElements(n16, n15, null);
                    byArray2[n14] = (byte)this.colorModel.getRed(object);
                    byArray3[n14] = (byte)this.colorModel.getGreen(object);
                    byArray4[n14] = (byte)this.colorModel.getBlue(object);
                    byArray5[n14] = (byte)this.colorModel.getAlpha(object);
                    ++n14;
                    ++n16;
                }
                ++n15;
            }
        }
        return new UnpackedImageData(raster, rectangle, 0, byArray, 1, rectangle.width, new int[4], raster instanceof WritableRaster);
    }

    public void setComponentsRGB(UnpackedImageData unpackedImageData) {
        if (unpackedImageData == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!unpackedImageData.convertToDest) {
            return;
        }
        byte[][] byArray = unpackedImageData.getByteData();
        byte[] byArray2 = byArray[0];
        byte[] byArray3 = byArray[1];
        byte[] byArray4 = byArray[2];
        byte[] byArray5 = byArray[3];
        WritableRaster writableRaster = (WritableRaster)unpackedImageData.raster;
        Rectangle rectangle = unpackedImageData.rect;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        int n4 = 0;
        int n5 = rectangle.y;
        while (n5 < n3) {
            int n6 = rectangle.x;
            while (n6 < n2) {
                int n7 = byArray5[n4] << 24 | byArray4[n4] << 16 | byArray3[n4] << 8 | byArray2[n4];
                Object object = this.colorModel.getDataElements(n7, null);
                writableRaster.setDataElements(n6, n5, object);
                ++n4;
                ++n6;
            }
            ++n5;
        }
    }
}

