/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.SnapshotImage;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileFactory;
import javax.media.jai.TileRequest;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.WritableRenderedImageAdapter;

public abstract class PlanarImage
implements ImageJAI,
RenderedImage {
    private Object UID;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    private Rectangle bounds = null;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int tileWidth;
    protected int tileHeight;
    protected SampleModel sampleModel = null;
    protected ColorModel colorModel = null;
    protected TileFactory tileFactory = null;
    private Vector sources = null;
    private Vector sinks = null;
    protected PropertyChangeSupportJAI eventManager = null;
    protected WritablePropertySourceImpl properties = null;
    private SnapshotImage snapshot = null;
    private WeakReference weakThis = new WeakReference<PlanarImage>(this);
    private Set tileListeners = null;
    private boolean disposed = false;
    private static final int MIN_ARRAYCOPY_SIZE = 64;

    public PlanarImage() {
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
        this.UID = ImageUtil.generateID(this);
    }

    public PlanarImage(ImageLayout imageLayout, Vector vector, Map map) {
        this();
        if (imageLayout != null) {
            this.setImageLayout(imageLayout);
        }
        if (vector != null) {
            this.setSources(vector);
        }
        if (map != null) {
            Object v2;
            this.properties.addProperties(map);
            if (map.containsKey(JAI.KEY_TILE_FACTORY) && (v2 = map.get(JAI.KEY_TILE_FACTORY)) instanceof TileFactory) {
                this.tileFactory = (TileFactory)v2;
            }
        }
    }

    protected void setImageLayout(ImageLayout imageLayout) {
        if (imageLayout == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (imageLayout.isValid(1)) {
            this.minX = imageLayout.getMinX(null);
        }
        if (imageLayout.isValid(2)) {
            this.minY = imageLayout.getMinY(null);
        }
        if (imageLayout.isValid(4)) {
            this.width = imageLayout.getWidth(null);
        }
        if (imageLayout.isValid(8)) {
            this.height = imageLayout.getHeight(null);
        }
        if (imageLayout.isValid(16)) {
            this.tileGridXOffset = imageLayout.getTileGridXOffset(null);
        }
        if (imageLayout.isValid(32)) {
            this.tileGridYOffset = imageLayout.getTileGridYOffset(null);
        }
        this.tileWidth = imageLayout.isValid(64) ? imageLayout.getTileWidth(null) : this.width;
        this.tileHeight = imageLayout.isValid(128) ? imageLayout.getTileHeight(null) : this.height;
        if (imageLayout.isValid(256)) {
            this.sampleModel = imageLayout.getSampleModel(null);
        }
        if (this.sampleModel != null && this.tileWidth > 0 && this.tileHeight > 0 && (this.sampleModel.getWidth() != this.tileWidth || this.sampleModel.getHeight() != this.tileHeight)) {
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        }
        if (imageLayout.isValid(512)) {
            this.colorModel = imageLayout.getColorModel(null);
        }
        if (this.colorModel != null && this.sampleModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage5"));
        }
    }

    public static PlanarImage wrapRenderedImage(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (renderedImage instanceof PlanarImage) {
            return (PlanarImage)renderedImage;
        }
        if (renderedImage instanceof WritableRenderedImage) {
            return new WritableRenderedImageAdapter((WritableRenderedImage)renderedImage);
        }
        return new RenderedImageAdapter(renderedImage);
    }

    public PlanarImage createSnapshot() {
        if (this instanceof WritableRenderedImage) {
            if (this.snapshot == null) {
                PlanarImage planarImage = this;
                synchronized (planarImage) {
                    this.snapshot = new SnapshotImage(this);
                }
            }
            return this.snapshot.createSnapshot();
        }
        return this;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumBands() {
        return this.getSampleModel().getNumBands();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                this.bounds = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
            }
        }
        Rectangle rectangle = this.bounds;
        synchronized (rectangle) {
            this.bounds.setBounds(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        }
        return this.bounds;
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getMinTileX() {
        return PlanarImage.XToTileX(this.getMinX(), this.getTileGridXOffset(), this.getTileWidth());
    }

    public int getMaxTileX() {
        return PlanarImage.XToTileX(this.getMinX() + this.getWidth() - 1, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int getNumXTiles() {
        int n2 = this.getMinX();
        int n3 = this.getTileGridXOffset();
        int n4 = this.getTileWidth();
        return PlanarImage.XToTileX(n2 + this.getWidth() - 1, n3, n4) - PlanarImage.XToTileX(n2, n3, n4) + 1;
    }

    public int getMinTileY() {
        return PlanarImage.YToTileY(this.getMinY(), this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getMaxTileY() {
        return PlanarImage.YToTileY(this.getMinY() + this.getHeight() - 1, this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getNumYTiles() {
        int n2 = this.getMinY();
        int n3 = this.getTileGridYOffset();
        int n4 = this.getTileHeight();
        return PlanarImage.YToTileY(n2 + this.getHeight() - 1, n3, n4) - PlanarImage.YToTileY(n2, n3, n4) + 1;
    }

    public static int XToTileX(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public static int YToTileY(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public int XToTileX(int n2) {
        return PlanarImage.XToTileX(n2, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int YToTileY(int n2) {
        return PlanarImage.YToTileY(n2, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static int tileXToX(int n2, int n3, int n4) {
        return n2 * n4 + n3;
    }

    public static int tileYToY(int n2, int n3, int n4) {
        return n2 * n4 + n3;
    }

    public int tileXToX(int n2) {
        return PlanarImage.tileXToX(n2, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int tileYToY(int n2) {
        return PlanarImage.tileYToY(n2, this.getTileGridYOffset(), this.getTileHeight());
    }

    public Rectangle getTileRect(int n2, int n3) {
        return this.getBounds().intersection(new Rectangle(this.tileXToX(n2), this.tileYToY(n3), this.getTileWidth(), this.getTileHeight()));
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public static ColorModel getDefaultColorModel(int n2, int n3) {
        if (n2 < 0 || n2 == 2 || n2 > 5 || n3 < 1 || n3 > 4) {
            return null;
        }
        ColorSpace colorSpace = n3 <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
        boolean bl2 = n3 == 2 || n3 == 4;
        int n4 = bl2 ? 3 : 1;
        return RasterFactory.createComponentColorModel(n2, colorSpace, bl2, false, n4);
    }

    public static ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = sampleModel.getNumBands();
        if (n2 < 1 || n2 > 4) {
            return null;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return PlanarImage.getDefaultColorModel(sampleModel.getDataType(), n2);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = nArray.length;
            if (n7 <= 2) {
                n4 = n5 = nArray[0];
                n3 = n5;
                if (n7 == 2) {
                    n6 = nArray[1];
                }
            } else {
                n3 = nArray[0];
                n4 = nArray[1];
                n5 = nArray[2];
                if (n7 == 4) {
                    n6 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n8 = 0;
            int n9 = 0;
            while (n9 < nArray2.length) {
                n8 += nArray2[n9];
                ++n9;
            }
            return new DirectColorModel(n8, n3, n4, n5, n6);
        }
        if (ImageUtil.isBinary(sampleModel)) {
            byte[] byArray = new byte[]{0, -1};
            return new IndexColorModel(1, 2, byArray, byArray, byArray);
        }
        return null;
    }

    public TileFactory getTileFactory() {
        return this.tileFactory;
    }

    public int getNumSources() {
        return this.sources == null ? 0 : this.sources.size();
    }

    public Vector getSources() {
        if (this.getNumSources() == 0) {
            return null;
        }
        Vector vector = this.sources;
        synchronized (vector) {
            Vector vector2 = (Vector)this.sources.clone();
            return vector2;
        }
    }

    public PlanarImage getSource(int n2) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            PlanarImage planarImage = (PlanarImage)this.sources.get(n2);
            return planarImage;
        }
    }

    protected void setSources(List list) {
        Object object;
        if (list == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = list.size();
        PlanarImage planarImage = this;
        synchronized (planarImage) {
            if (this.sources != null) {
                object = ((AbstractList)this.sources).iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    if (!(e2 instanceof PlanarImage)) continue;
                    ((PlanarImage)e2).removeSink(this);
                }
            }
            this.sources = new Vector(n2);
        }
        object = this.sources;
        synchronized (object) {
            int n3 = 0;
            while (n3 < n2) {
                Object e3 = list.get(n3);
                if (e3 == null) {
                    throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
                }
                this.sources.add(e3 instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)e3) : e3);
                if (e3 instanceof PlanarImage) {
                    ((PlanarImage)e3).addSink(this);
                }
                ++n3;
            }
        }
    }

    protected void removeSources() {
        if (this.sources != null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                if (this.sources != null) {
                    Iterator iterator = ((AbstractList)this.sources).iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        if (!(e2 instanceof PlanarImage)) continue;
                        ((PlanarImage)e2).removeSink(this);
                    }
                }
                this.sources = null;
            }
        }
    }

    public PlanarImage getSourceImage(int n2) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            PlanarImage planarImage = (PlanarImage)this.sources.get(n2);
            return planarImage;
        }
    }

    public Object getSourceObject(int n2) {
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            Object e2 = this.sources.get(n2);
            return e2;
        }
    }

    protected void addSource(Object object) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            object2 = this;
            synchronized (object2) {
                this.sources = new Vector();
            }
        }
        object2 = this.sources;
        synchronized (object2) {
            this.sources.add(object instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)object) : object);
        }
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        }
    }

    protected void setSource(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
        }
        Vector vector = this.sources;
        synchronized (vector) {
            if (n2 < this.sources.size() && this.sources.get(n2) instanceof PlanarImage) {
                this.getSourceImage(n2).removeSink(this);
            }
            this.sources.set(n2, object instanceof RenderedImage ? PlanarImage.wrapRenderedImage((RenderedImage)object) : object);
        }
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        }
    }

    protected boolean removeSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sources == null) {
            return false;
        }
        Vector vector = this.sources;
        synchronized (vector) {
            if (object instanceof PlanarImage) {
                ((PlanarImage)object).removeSink(this);
            }
            boolean bl2 = this.sources.remove(object);
            return bl2;
        }
    }

    public Vector getSinks() {
        Vector vector = null;
        if (this.sinks != null) {
            Vector vector2 = this.sinks;
            synchronized (vector2) {
                int n2 = this.sinks.size();
                vector = new Vector(n2);
                int n3 = 0;
                while (n3 < n2) {
                    Object t2 = ((WeakReference)this.sinks.get(n3)).get();
                    if (t2 != null) {
                        vector.add(t2);
                    }
                    ++n3;
                }
            }
            if (vector.size() == 0) {
                vector = null;
            }
        }
        return vector;
    }

    public synchronized boolean addSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            this.sinks = new Vector();
        }
        boolean bl2 = false;
        bl2 = object instanceof PlanarImage ? this.sinks.add(((PlanarImage)object).weakThis) : this.sinks.add(new WeakReference<Object>(object));
        return bl2;
    }

    public synchronized boolean removeSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        boolean bl2 = false;
        if (object instanceof PlanarImage) {
            bl2 = this.sinks.remove(((PlanarImage)object).weakThis);
        } else {
            Iterator iterator = ((AbstractList)this.sinks).iterator();
            while (iterator.hasNext()) {
                Object t2 = ((WeakReference)iterator.next()).get();
                if (t2 == object) {
                    iterator.remove();
                    bl2 = true;
                    continue;
                }
                if (t2 != null) continue;
                iterator.remove();
            }
        }
        return bl2;
    }

    protected void addSink(PlanarImage planarImage) {
        Object object;
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            object = this;
            synchronized (object) {
                this.sinks = new Vector();
            }
        }
        object = this.sinks;
        synchronized (object) {
            this.sinks.add(planarImage.weakThis);
        }
    }

    protected boolean removeSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.sinks == null) {
            return false;
        }
        Vector vector = this.sinks;
        synchronized (vector) {
            boolean bl2 = this.sinks.remove(planarImage.weakThis);
            return bl2;
        }
    }

    public void removeSinks() {
        if (this.sinks != null) {
            PlanarImage planarImage = this;
            synchronized (planarImage) {
                this.sinks = null;
            }
        }
    }

    protected Hashtable getProperties() {
        return (Hashtable)this.properties.getProperties();
    }

    protected void setProperties(Hashtable hashtable) {
        this.properties.addProperties(hashtable);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string.toLowerCase(), propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string.toLowerCase(), propertyChangeListener);
    }

    private synchronized Set getTileComputationListeners(boolean bl2) {
        if (bl2 && this.tileListeners == null) {
            this.tileListeners = Collections.synchronizedSet(new HashSet());
        }
        return this.tileListeners;
    }

    public synchronized void addTileComputationListener(TileComputationListener tileComputationListener) {
        if (tileComputationListener == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Set set = this.getTileComputationListeners(true);
        set.add(tileComputationListener);
    }

    public synchronized void removeTileComputationListener(TileComputationListener tileComputationListener) {
        if (tileComputationListener == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Set set = this.getTileComputationListeners(false);
        if (set != null) {
            set.remove(tileComputationListener);
        }
    }

    public TileComputationListener[] getTileComputationListeners() {
        Set set = this.getTileComputationListeners(false);
        if (set == null) {
            return null;
        }
        return set.toArray(new TileComputationListener[set.size()]);
    }

    public void getSplits(IntegerSequence integerSequence, IntegerSequence integerSequence2, Rectangle rectangle) {
        if (integerSequence == null || integerSequence2 == null || rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.tileXToX(n2);
        int n5 = n2;
        while (n5 <= n3) {
            integerSequence.insert(n4);
            n4 += this.tileWidth;
            ++n5;
        }
        int n6 = this.YToTileY(rectangle.y);
        int n7 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n8 = this.tileYToY(n6);
        int n9 = n6;
        while (n9 <= n7) {
            integerSequence2.insert(n8);
            n8 += this.tileHeight;
            ++n9;
        }
    }

    public Point[] getTileIndices(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = (Rectangle)this.getBounds().clone();
        } else {
            if (!rectangle.intersects(this.getBounds())) {
                return null;
            }
            if ((rectangle = rectangle.intersection(this.getBounds())).isEmpty()) {
                return null;
            }
        }
        if (rectangle == null) {
            rectangle = this.getBounds();
        } else {
            Rectangle rectangle2 = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth() + 1, this.getHeight() + 1);
            if (!rectangle.intersects(rectangle2)) {
                return null;
            }
            rectangle = rectangle.intersection(rectangle2);
        }
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y);
        int n5 = this.YToTileY(rectangle.y + rectangle.height - 1);
        Point[] pointArray = new Point[(n5 - n4 + 1) * (n3 - n2 + 1)];
        int n6 = 0;
        int n7 = n4;
        while (n7 <= n5) {
            int n8 = n2;
            while (n8 <= n3) {
                pointArray[n6++] = new Point(n8, n7);
                ++n8;
            }
            ++n7;
        }
        return pointArray;
    }

    public boolean overlapsMultipleTiles(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException("rect == null!");
        }
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        return !rectangle2.isEmpty() && (this.XToTileX(rectangle2.x) != this.XToTileX(rectangle2.x + rectangle2.width - 1) || this.YToTileY(rectangle2.y) != this.YToTileY(rectangle2.y + rectangle2.height - 1));
    }

    protected final WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        return this.tileFactory != null ? this.tileFactory.createTile(sampleModel, point) : RasterFactory.createWritableRaster(sampleModel, point);
    }

    public Raster getData() {
        return this.getData(null);
    }

    public Raster getData(Rectangle rectangle) {
        WritableRaster writableRaster;
        int n2;
        int n3;
        Rectangle rectangle2 = this.getBounds();
        if (rectangle == null) {
            rectangle = rectangle2;
        } else if (!rectangle.intersects(rectangle2)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage4"));
        }
        Rectangle rectangle3 = rectangle == rectangle2 ? rectangle : rectangle.intersection(rectangle2);
        int n4 = this.XToTileX(rectangle3.x);
        int n5 = this.YToTileY(rectangle3.y);
        int n6 = this.XToTileX(rectangle3.x + rectangle3.width - 1);
        int n7 = this.YToTileY(rectangle3.y + rectangle3.height - 1);
        if (n4 == n6 && n5 == n7 && this.getTileRect(n4, n5).contains(rectangle)) {
            Raster raster = this.getTile(n4, n5);
            if (this instanceof WritableRenderedImage) {
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
                    sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
                }
                WritableRaster writableRaster2 = this.createWritableRaster(sampleModel, rectangle.getLocation());
                Raster raster2 = raster.getBounds().equals(rectangle) ? raster : raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                JDKWorkarounds.setRect(writableRaster2, raster2);
                return writableRaster2;
            }
            return raster.getBounds().equals(rectangle) ? raster : raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        SampleModel sampleModel = this.getSampleModel();
        int n8 = sampleModel.getDataType();
        int n9 = sampleModel.getNumBands();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel = null;
        int[] nArray = null;
        boolean bl3 = false;
        if (sampleModel instanceof ComponentSampleModel) {
            componentSampleModel = (ComponentSampleModel)sampleModel;
            int n10 = componentSampleModel.getPixelStride();
            n3 = n10 == 1 && n9 > 1 ? 1 : 0;
            boolean bl4 = bl2 = n10 > 1 && n9 != n10;
            if (!bl2 && n3 == 0) {
                nArray = componentSampleModel.getBandOffsets();
                n2 = 0;
                while (n2 < n9) {
                    if (nArray[n2] >= n9) break;
                    ++n2;
                }
                if (n2 == n9) {
                    bl3 = true;
                }
            }
        }
        if (bl3) {
            try {
                SampleModel sampleModel2 = RasterFactory.createPixelInterleavedSampleModel(n8, rectangle.width, rectangle.height, n9, rectangle.width * n9, nArray);
                writableRaster = this.createWritableRaster(sampleModel2, rectangle.getLocation());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(JaiI18N.getString("PlanarImage2"));
            }
            switch (n8) {
                case 0: {
                    this.cobbleByte(rectangle, writableRaster);
                    break;
                }
                case 2: {
                    this.cobbleShort(rectangle, writableRaster);
                    break;
                }
                case 1: {
                    this.cobbleUShort(rectangle, writableRaster);
                    break;
                }
                case 3: {
                    this.cobbleInt(rectangle, writableRaster);
                    break;
                }
                case 4: {
                    this.cobbleFloat(rectangle, writableRaster);
                    break;
                }
                case 5: {
                    this.cobbleDouble(rectangle, writableRaster);
                    break;
                }
            }
        } else {
            SampleModel sampleModel3 = this.sampleModel;
            if (sampleModel3.getWidth() != rectangle.width || sampleModel3.getHeight() != rectangle.height) {
                sampleModel3 = sampleModel3.createCompatibleSampleModel(rectangle.width, rectangle.height);
            }
            try {
                writableRaster = this.createWritableRaster(sampleModel3, rectangle.getLocation());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(JaiI18N.getString("PlanarImage2"));
            }
            n3 = n5;
            while (n3 <= n7) {
                n2 = n4;
                while (n2 <= n6) {
                    Raster raster = this.getTile(n2, n3);
                    Rectangle rectangle4 = rectangle.intersection(raster.getBounds());
                    Raster raster3 = raster.createChild(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, rectangle4.x, rectangle4.y, null);
                    if (sampleModel3 instanceof ComponentSampleModel && bl2) {
                        switch (sampleModel3.getDataType()) {
                            case 4: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new float[n9 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                            case 5: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new double[n9 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                            default: {
                                writableRaster.setPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, raster3.getPixels(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height, new int[n9 * rectangle4.width * rectangle4.height]));
                                break;
                            }
                        }
                    } else {
                        JDKWorkarounds.setRect(writableRaster, raster3);
                    }
                    ++n2;
                }
                ++n3;
            }
        }
        return writableRaster;
    }

    public WritableRaster copyData() {
        return this.copyData(null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster == null) {
            rectangle = this.getBounds();
            SampleModel sampleModel = this.getSampleModel();
            if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
                sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
            }
            writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        } else {
            rectangle = writableRaster.getBounds().intersection(this.getBounds());
            if (rectangle.isEmpty()) {
                return writableRaster;
            }
        }
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n5 = this.YToTileY(rectangle.y + rectangle.height - 1);
        SampleModel[] sampleModelArray = new SampleModel[]{this.getSampleModel()};
        int n6 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterFormatTag rasterFormatTag = new RasterFormatTag(this.getSampleModel(), n6);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(writableRaster.getSampleModel(), n6);
        int n7 = n3;
        while (n7 <= n5) {
            int n8 = n2;
            while (n8 <= n4) {
                Raster raster = this.getTile(n8, n7);
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTag, this.getColorModel());
                RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTag2, null);
                ImageUtil.copyRaster(rasterAccessor, rasterAccessor2);
                ++n8;
            }
            ++n7;
        }
        return writableRaster;
    }

    public void copyExtendedData(WritableRaster writableRaster, BorderExtender borderExtender) {
        if (writableRaster == null || borderExtender == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = writableRaster.getBounds();
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2.contains(rectangle)) {
            this.copyData(writableRaster);
            return;
        }
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (!rectangle3.isEmpty()) {
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
            this.copyData(writableRaster2);
        }
        borderExtender.extend(writableRaster, this);
    }

    public Raster getExtendedData(Rectangle rectangle, BorderExtender borderExtender) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.getBounds().contains(rectangle)) {
            return this.getData(rectangle);
        }
        if (borderExtender == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = this.getSampleModel();
        if (sampleModel.getWidth() != rectangle.width || sampleModel.getHeight() != rectangle.height) {
            sampleModel = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        }
        WritableRaster writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        this.copyExtendedData(writableRaster, borderExtender);
        return writableRaster;
    }

    public BufferedImage getAsBufferedImage(Rectangle rectangle, ColorModel colorModel) {
        if (colorModel == null && (colorModel = this.getColorModel()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        if (!JDKWorkarounds.areCompatibleDataModels(this.sampleModel, colorModel)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage3"));
        }
        rectangle = rectangle == null ? this.getBounds() : this.getBounds().intersection(rectangle);
        SampleModel sampleModel = this.sampleModel.getWidth() != rectangle.width || this.sampleModel.getHeight() != rectangle.height ? this.sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height) : this.sampleModel;
        WritableRaster writableRaster = this.createWritableRaster(sampleModel, rectangle.getLocation());
        this.copyData(writableRaster);
        if (rectangle.x != 0 || rectangle.y != 0) {
            writableRaster = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null);
        }
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage getAsBufferedImage() {
        return this.getAsBufferedImage(null, null);
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError(JaiI18N.getString("PlanarImage1"));
    }

    public abstract Raster getTile(int var1, int var2);

    public Raster[] getTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n2 = pointArray.length;
        Raster[] rasterArray = new Raster[n2];
        int n3 = 0;
        while (n3 < pointArray.length) {
            Point point = pointArray[n3];
            rasterArray[n3] = this.getTile(point.x, point.y);
            ++n3;
        }
        return rasterArray;
    }

    public Raster[] getTiles() {
        return this.getTiles(this.getTileIndices(this.getBounds()));
    }

    public TileRequest queueTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        TileComputationListener[] tileComputationListenerArray = this.getTileComputationListeners();
        return JAI.getDefaultInstance().getTileScheduler().scheduleTiles(this, pointArray, tileComputationListenerArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        JAI.getDefaultInstance().getTileScheduler().cancelTiles(tileRequest, pointArray);
    }

    public void prefetchTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        JAI.getDefaultInstance().getTileScheduler().prefetchTiles(this, pointArray);
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Vector vector = this.getSources();
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e2 = vector.get(n3);
                if (e2 instanceof PlanarImage) {
                    ((PlanarImage)e2).removeSink(this);
                }
                ++n3;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    private void printBounds() {
        System.out.println("Bounds: [x=" + this.getMinX() + ", y=" + this.getMinY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "]");
    }

    private void printTile(int n2, int n3) {
        int n4 = n2 * this.getTileWidth() + this.getTileGridXOffset();
        int n5 = n3 * this.getTileHeight() + this.getTileGridYOffset();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(n4, n5, this.getTileWidth(), this.getTileHeight());
        rectangle2 = rectangle2.intersection(rectangle);
        Raster raster = this.getTile(n2, n3);
        Rectangle rectangle3 = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
        System.out.println("Tile bounds (actual)   = " + rectangle3);
        System.out.println("Tile bounds (computed) = " + rectangle2);
        n4 = rectangle2.x;
        n5 = rectangle2.y;
        int n6 = rectangle2.x + rectangle2.width - 1;
        int n7 = rectangle2.y + rectangle2.height - 1;
        int n8 = this.getSampleModel().getNumBands();
        int[] nArray = new int[n8];
        int n9 = n5;
        while (n9 <= n7) {
            int n10 = n4;
            while (n10 <= n6) {
                raster.getPixel(n10, n9, nArray);
                if (n8 == 1) {
                    System.out.print("(" + nArray[0] + ") ");
                } else if (n8 == 3) {
                    System.out.print("(" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ") ");
                }
                ++n10;
            }
            System.out.println();
            ++n9;
        }
    }

    public String toString() {
        return "PlanarImage[minX=" + this.minX + " minY=" + this.minY + " width=" + this.width + " height=" + this.height + " tileGridXOffset=" + this.tileGridXOffset + " tileGridYOffset=" + this.tileGridYOffset + " tileWidth=" + this.tileWidth + " tileHeight=" + this.tileHeight + " sampleModel=" + this.sampleModel + " colorModel=" + this.colorModel + "]";
    }

    private void cobbleByte(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBufferByte dataBufferByte2 = (DataBufferByte)raster2.getDataBuffer();
                    byte[] byArray2 = dataBufferByte2.getData();
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(byArray2, n26, byArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                byArray[n29++] = byArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    private void cobbleShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        short[] sArray = dataBufferShort.getData();
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBufferShort dataBufferShort2 = (DataBufferShort)raster2.getDataBuffer();
                    short[] sArray2 = dataBufferShort2.getData();
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(sArray2, n26, sArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                sArray[n29++] = sArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    private void cobbleUShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBufferUShort dataBufferUShort2 = (DataBufferUShort)raster2.getDataBuffer();
                    short[] sArray2 = dataBufferUShort2.getData();
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(sArray2, n26, sArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                sArray[n29++] = sArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    private void cobbleInt(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
                    int[] nArray2 = dataBufferInt2.getData();
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(nArray2, n26, nArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                nArray[n29++] = nArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    private void cobbleFloat(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBuffer dataBuffer = raster.getDataBuffer();
        float[] fArray = DataBufferUtils.getDataFloat(dataBuffer);
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBuffer dataBuffer2 = raster2.getDataBuffer();
                    float[] fArray2 = DataBufferUtils.getDataFloat(dataBuffer2);
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(fArray2, n26, fArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                fArray[n29++] = fArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    private void cobbleDouble(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.YToTileY(rectangle.y);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = this.XToTileX(n4);
        int n7 = this.YToTileY(n5);
        DataBuffer dataBuffer = raster.getDataBuffer();
        double[] dArray = DataBufferUtils.getDataDouble(dataBuffer);
        int n8 = componentSampleModel.getPixelStride();
        int n9 = componentSampleModel.getScanlineStride();
        boolean bl2 = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3;
        while (n12 <= n7) {
            int n13 = n2;
            while (n13 <= n6) {
                Raster raster2 = this.getTile(n13, n12);
                if (raster2 != null) {
                    int n14;
                    int n15;
                    int n16;
                    if (!bl2) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n10 = componentSampleModel2.getPixelStride();
                        n11 = componentSampleModel2.getScanlineStride();
                        bl2 = true;
                    }
                    int n17 = n16 = n12 * this.tileHeight + this.tileGridYOffset;
                    int n18 = n17 + this.tileHeight - 1;
                    if (rectangle.y > n17) {
                        n17 = rectangle.y;
                    }
                    if (n5 < n18) {
                        n18 = n5;
                    }
                    int n19 = n18 - n17 + 1;
                    int n20 = n15 = n13 * this.tileWidth + this.tileGridXOffset;
                    int n21 = n20 + this.tileWidth - 1;
                    if (rectangle.x > n20) {
                        n20 = rectangle.x;
                    }
                    if (n4 < n21) {
                        n21 = n4;
                    }
                    int n22 = n21 - n20 + 1;
                    int n23 = n20 - rectangle.x;
                    int n24 = n17 - rectangle.y;
                    DataBuffer dataBuffer2 = raster2.getDataBuffer();
                    double[] dArray2 = DataBufferUtils.getDataDouble(dataBuffer2);
                    int n25 = n22 * n10;
                    boolean bl3 = n25 >= 64;
                    int n26 = (n17 - n16) * n11 + (n20 - n15) * n10;
                    int n27 = n24 * n9 + n23 * n8;
                    if (bl3) {
                        n14 = 0;
                        while (n14 < n19) {
                            System.arraycopy(dArray2, n26, dArray, n27, n25);
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n19) {
                            int n28 = n26;
                            int n29 = n27;
                            int n30 = n29 + n25;
                            while (n29 < n30) {
                                dArray[n29++] = dArray2[n28++];
                            }
                            n26 += n11;
                            n27 += n9;
                            ++n14;
                        }
                    }
                }
                ++n13;
            }
            ++n12;
        }
    }

    public Object getImageID() {
        return this.UID;
    }
}

