/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

public abstract class PointOpImage
extends OpImage {
    private boolean isDisposed = false;
    private boolean areFieldsInitialized = false;
    private boolean checkInPlaceOperation = false;
    private boolean isInPlaceEnabled = false;
    private WritableRenderedImage source0AsWritableRenderedImage;
    private OpImage source0AsOpImage;
    private boolean source0IsWritableRenderedImage;
    private boolean sameBounds;
    private boolean sameTileGrid;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector, Map map) {
        Object object;
        int n2 = vector.size();
        if (n2 < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic5"));
        }
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = new Rectangle();
        int n3 = 1;
        while (n3 < n2) {
            object = (RenderedImage)vector.get(n3);
            rectangle2.setBounds(object.getMinX(), object.getMinY(), object.getWidth(), object.getHeight());
            rectangle = rectangle.intersection(rectangle2);
            ++n3;
        }
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException(JaiI18N.getString("PointOpImage0"));
        }
        if (imageLayout == null) {
            imageLayout = new ImageLayout(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            if (!(imageLayout = (ImageLayout)imageLayout.clone()).isValid(1)) {
                imageLayout.setMinX(rectangle.x);
            }
            if (!imageLayout.isValid(2)) {
                imageLayout.setMinY(rectangle.y);
            }
            if (!imageLayout.isValid(4)) {
                imageLayout.setWidth(rectangle.width);
            }
            if (!imageLayout.isValid(8)) {
                imageLayout.setHeight(rectangle.height);
            }
            if (((Rectangle)(object = new Rectangle(imageLayout.getMinX(null), imageLayout.getMinY(null), imageLayout.getWidth(null), imageLayout.getHeight(null)))).isEmpty()) {
                throw new IllegalArgumentException(JaiI18N.getString("PointOpImage1"));
            }
            if (!rectangle.contains((Rectangle)object)) {
                throw new IllegalArgumentException(JaiI18N.getString("PointOpImage2"));
            }
        }
        if (n2 > 1 && !imageLayout.isValid(256)) {
            int n4;
            Object object2;
            object = renderedImage.getSampleModel();
            ColorModel colorModel = renderedImage.getColorModel();
            int n5 = PointOpImage.getAppropriateDataType((SampleModel)object);
            int n6 = PointOpImage.getBandCount((SampleModel)object, colorModel);
            int n7 = n5;
            int n8 = n6;
            int n9 = 1;
            while (n9 < n2) {
                object2 = (RenderedImage)vector.get(n9);
                object = object2.getSampleModel();
                colorModel = object2.getColorModel();
                n4 = PointOpImage.getBandCount((SampleModel)object, colorModel);
                n7 = PointOpImage.mergeTypes(n7, PointOpImage.getPixelType((SampleModel)object));
                n8 = Math.min(n8, n4);
                ++n9;
            }
            if (n7 == -1 && n8 > 1) {
                n7 = 0;
            }
            if (n7 != ((SampleModel)(object2 = renderedImage.getSampleModel())).getDataType() || n8 != ((SampleModel)object2).getNumBands()) {
                n4 = imageLayout.getTileWidth(renderedImage);
                int n10 = imageLayout.getTileHeight(renderedImage);
                SampleModel sampleModel = n7 == -1 ? new MultiPixelPackedSampleModel(0, n4, n10, 1) : RasterFactory.createPixelInterleavedSampleModel(n7, n4, n10, n8);
                imageLayout.setSampleModel(sampleModel);
                if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                    colorModel = ImageUtil.getCompatibleColorModel(sampleModel, map);
                    imageLayout.setColorModel(colorModel);
                }
            }
        }
        return imageLayout;
    }

    private static int getPixelType(SampleModel sampleModel) {
        return ImageUtil.isBinary(sampleModel) ? -1 : sampleModel.getDataType();
    }

    private static int getBandCount(SampleModel sampleModel, ColorModel colorModel) {
        if (ImageUtil.isBinary(sampleModel)) {
            return 1;
        }
        if (colorModel instanceof IndexColorModel) {
            return colorModel.getNumComponents();
        }
        return sampleModel.getNumBands();
    }

    private static int getAppropriateDataType(SampleModel sampleModel) {
        int n2;
        int n3 = n2 = sampleModel.getDataType();
        if (ImageUtil.isBinary(sampleModel)) {
            n3 = -1;
        } else if (n2 == 1 || n2 == 3) {
            boolean bl2 = true;
            boolean bl3 = true;
            int[] nArray = sampleModel.getSampleSize();
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] > 16) {
                    bl2 = false;
                    bl3 = false;
                    break;
                }
                if (nArray[n4] > 8) {
                    bl2 = false;
                }
                ++n4;
            }
            if (bl2) {
                n3 = 0;
            } else if (bl3) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static int mergeTypes(int n2, int n3) {
        if (n2 == n3) {
            return n2;
        }
        int n4 = n3;
        switch (n2) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                if (n3 == 0) {
                    n4 = 2;
                    break;
                }
                if (n3 != 1) break;
                n4 = 3;
                break;
            }
            case 1: {
                if (n3 == 0) {
                    n4 = 1;
                    break;
                }
                if (n3 != 2) break;
                n4 = 3;
                break;
            }
            case 3: {
                if (n3 != 0 && n3 != 2 && n3 != 1) break;
                n4 = 3;
                break;
            }
            case 4: {
                if (n3 == 5) break;
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 5;
            }
        }
        return n4;
    }

    public PointOpImage(Vector vector, ImageLayout imageLayout, Map map, boolean bl2) {
        super(OpImage.checkSourceVector(vector, true), PointOpImage.layoutHelper(imageLayout, vector, map), map, bl2);
    }

    public PointOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl2) {
        this(OpImage.vectorize(renderedImage), imageLayout, map, bl2);
    }

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, ImageLayout imageLayout, Map map, boolean bl2) {
        this(OpImage.vectorize(renderedImage, renderedImage2), imageLayout, map, bl2);
    }

    public PointOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3, ImageLayout imageLayout, Map map, boolean bl2) {
        this(OpImage.vectorize(renderedImage, renderedImage2, renderedImage3), imageLayout, map, bl2);
    }

    private synchronized void initializeFields() {
        Object object;
        if (this.areFieldsInitialized) {
            return;
        }
        PlanarImage planarImage = this.getSource(0);
        if (this.checkInPlaceOperation) {
            Vector vector = planarImage.getSinks();
            boolean bl2 = this.isInPlaceEnabled = planarImage != null && this.getTileGridXOffset() == planarImage.getTileGridXOffset() && this.getTileGridYOffset() == planarImage.getTileGridYOffset() && this.getBounds().equals(planarImage.getBounds()) && planarImage instanceof OpImage && this.hasCompatibleSampleModel(planarImage) && (vector == null || vector.size() <= 1);
            if (this.isInPlaceEnabled && !((OpImage)planarImage).computesUniqueTiles()) {
                this.isInPlaceEnabled = false;
            }
            if (this.isInPlaceEnabled) {
                try {
                    Method method = planarImage.getClass().getMethod("getTile", Integer.TYPE, Integer.TYPE);
                    object = Class.forName("javax.media.jai.OpImage");
                    Class<?> clazz = method.getDeclaringClass();
                    if (!clazz.equals(object)) {
                        this.isInPlaceEnabled = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.isInPlaceEnabled = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.isInPlaceEnabled = false;
                }
            }
            if (this.isInPlaceEnabled) {
                this.source0IsWritableRenderedImage = planarImage instanceof WritableRenderedImage;
                if (this.source0IsWritableRenderedImage) {
                    this.source0AsWritableRenderedImage = (WritableRenderedImage)((Object)planarImage);
                } else {
                    this.source0AsOpImage = (OpImage)planarImage;
                }
            }
            this.checkInPlaceOperation = false;
        }
        int n2 = this.getNumSources();
        this.sameBounds = true;
        this.sameTileGrid = true;
        int n3 = 0;
        while (n3 < n2 && (this.sameBounds || this.sameTileGrid)) {
            object = this.getSource(n3);
            if (this.sameBounds) {
                boolean bl3 = this.sameBounds = this.sameBounds && this.minX == ((PlanarImage)object).minX && this.minY == ((PlanarImage)object).minY && this.width == ((PlanarImage)object).width && this.height == ((PlanarImage)object).height;
            }
            if (this.sameTileGrid) {
                this.sameTileGrid = this.sameTileGrid && this.tileGridXOffset == ((PlanarImage)object).tileGridXOffset && this.tileGridYOffset == ((PlanarImage)object).tileGridYOffset && this.tileWidth == ((PlanarImage)object).tileWidth && this.tileHeight == ((PlanarImage)object).tileHeight;
            }
            ++n3;
        }
        this.areFieldsInitialized = true;
    }

    private boolean hasCompatibleSampleModel(PlanarImage planarImage) {
        boolean bl2;
        SampleModel sampleModel = planarImage.getSampleModel();
        int n2 = this.sampleModel.getNumBands();
        boolean bl3 = bl2 = sampleModel.getTransferType() == this.sampleModel.getTransferType() && sampleModel.getWidth() == this.sampleModel.getWidth() && sampleModel.getHeight() == this.sampleModel.getHeight() && sampleModel.getNumBands() == n2 && sampleModel.getClass().equals(this.sampleModel.getClass());
        if (bl2) {
            if (this.sampleModel instanceof ComponentSampleModel) {
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
                ComponentSampleModel componentSampleModel2 = (ComponentSampleModel)this.sampleModel;
                bl2 = bl2 && componentSampleModel.getPixelStride() == componentSampleModel2.getPixelStride() && componentSampleModel.getScanlineStride() == componentSampleModel2.getScanlineStride();
                int[] nArray = componentSampleModel.getBankIndices();
                int[] nArray2 = componentSampleModel2.getBankIndices();
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int[] nArray4 = componentSampleModel2.getBandOffsets();
                int n3 = 0;
                while (n3 < n2 && bl2) {
                    bl2 = bl2 && nArray[n3] == nArray2[n3] && nArray3[n3] == nArray4[n3];
                    ++n3;
                }
            } else if (this.sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)this.sampleModel;
                bl2 = bl2 && singlePixelPackedSampleModel.getScanlineStride() == singlePixelPackedSampleModel2.getScanlineStride();
                int[] nArray = singlePixelPackedSampleModel.getBitMasks();
                int[] nArray5 = singlePixelPackedSampleModel2.getBitMasks();
                int n4 = 0;
                while (n4 < n2 && bl2) {
                    bl2 = bl2 && nArray[n4] == nArray5[n4];
                    ++n4;
                }
            } else if (this.sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)this.sampleModel;
                bl2 = bl2 && multiPixelPackedSampleModel.getPixelBitStride() == multiPixelPackedSampleModel2.getPixelBitStride() && multiPixelPackedSampleModel.getScanlineStride() == multiPixelPackedSampleModel2.getScanlineStride() && multiPixelPackedSampleModel.getDataBitOffset() == multiPixelPackedSampleModel2.getDataBitOffset();
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    protected void permitInPlaceOperation() {
        Object var1_1 = null;
        try {
            var1_1 = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = "javax.media.jai.PointOpImage.InPlace";
                    return System.getProperty(string);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.checkInPlaceOperation = var1_1 == null || !(var1_1 instanceof String) || !((String)var1_1).equalsIgnoreCase("false");
    }

    protected boolean isColormapOperation() {
        return false;
    }

    public Raster computeTile(int n2, int n3) {
        int n4;
        int n5;
        Object object;
        boolean bl2;
        if (!this.cobbleSources) {
            return super.computeTile(n2, n3);
        }
        this.initializeFields();
        WritableRaster writableRaster = null;
        if (this.isInPlaceEnabled) {
            if (this.source0IsWritableRenderedImage) {
                writableRaster = this.source0AsWritableRenderedImage.getWritableTile(n2, n3);
            } else {
                Raster raster = this.source0AsOpImage.getTileFromCache(n2, n3);
                if (raster == null) {
                    try {
                        raster = this.source0AsOpImage.computeTile(n2, n3);
                        if (raster instanceof WritableRaster) {
                            writableRaster = (WritableRaster)raster;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        boolean bl3 = bl2 = writableRaster != null;
        if (!bl2) {
            object = new Point(this.tileXToX(n2), this.tileYToY(n3));
            writableRaster = this.createWritableRaster(this.sampleModel, (Point)object);
        }
        if (this.isColormapOperation()) {
            if (!bl2) {
                object = this.getSource(0);
                Raster raster = null;
                Rectangle rectangle = null;
                Rectangle rectangle2 = writableRaster.getBounds();
                if (this.sameTileGrid) {
                    raster = this.getSource(0).getTile(n2, n3);
                } else if (rectangle2.intersects(((PlanarImage)object).getBounds())) {
                    raster = ((PlanarImage)object).getData(rectangle2);
                } else {
                    return writableRaster;
                }
                rectangle = raster.getBounds();
                if (!rectangle2.contains(rectangle)) {
                    rectangle = rectangle2.intersection(rectangle);
                    raster = raster.createChild(raster.getMinX(), raster.getMinY(), rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                }
                JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
            }
            return writableRaster;
        }
        int n6 = writableRaster.getMinX();
        int n7 = writableRaster.getMinY();
        int n8 = n6 + writableRaster.getWidth();
        int n9 = n7 + writableRaster.getHeight();
        Rectangle rectangle = this.getBounds();
        if (n6 < rectangle.x) {
            n6 = rectangle.x;
        }
        if (n8 > (n5 = rectangle.x + rectangle.width)) {
            n8 = n5;
        }
        if (n7 < rectangle.y) {
            n7 = rectangle.y;
        }
        if (n9 > (n4 = rectangle.y + rectangle.height)) {
            n9 = n4;
        }
        int n10 = this.getNumSources();
        if (bl2 && n10 == 1) {
            Raster[] rasterArray = new Raster[]{writableRaster};
            Rectangle rectangle3 = new Rectangle(n6, n7, n8 - n6, n9 - n7);
            this.computeRect(rasterArray, writableRaster, rectangle3);
        } else if (bl2 && this.sameBounds && this.sameTileGrid) {
            Raster[] rasterArray = new Raster[n10];
            rasterArray[0] = writableRaster;
            int n11 = 1;
            while (n11 < n10) {
                rasterArray[n11] = this.getSource(n11).getTile(n2, n3);
                ++n11;
            }
            Rectangle rectangle4 = new Rectangle(n6, n7, n8 - n6, n9 - n7);
            this.computeRect(rasterArray, writableRaster, rectangle4);
        } else {
            if (!this.sameBounds) {
                int n12 = bl2 ? 1 : 0;
                while (n12 < n10) {
                    rectangle = this.getSource(n12).getBounds();
                    if (n6 < rectangle.x) {
                        n6 = rectangle.x;
                    }
                    if (n8 > (n5 = rectangle.x + rectangle.width)) {
                        n8 = n5;
                    }
                    if (n7 < rectangle.y) {
                        n7 = rectangle.y;
                    }
                    if (n9 > (n4 = rectangle.y + rectangle.height)) {
                        n9 = n4;
                    }
                    if (n6 >= n8 || n7 >= n9) {
                        return writableRaster;
                    }
                    ++n12;
                }
            }
            Rectangle rectangle5 = new Rectangle(n6, n7, n8 - n6, n9 - n7);
            Raster[] rasterArray = new Raster[n10];
            if (this.sameTileGrid) {
                if (bl2) {
                    rasterArray[0] = writableRaster;
                }
                int n13 = bl2 ? 1 : 0;
                while (n13 < n10) {
                    rasterArray[n13] = this.getSource(n13).getTile(n2, n3);
                    ++n13;
                }
                this.computeRect(rasterArray, writableRaster, rectangle5);
            } else {
                IntegerSequence integerSequence = new IntegerSequence(n6, n8);
                integerSequence.insert(n6);
                integerSequence.insert(n8);
                IntegerSequence integerSequence2 = new IntegerSequence(n7, n9);
                integerSequence2.insert(n7);
                integerSequence2.insert(n9);
                int n14 = bl2 ? 1 : 0;
                while (n14 < n10) {
                    PlanarImage planarImage = this.getSource(n14);
                    planarImage.getSplits(integerSequence, integerSequence2, rectangle5);
                    ++n14;
                }
                Rectangle rectangle6 = new Rectangle();
                integerSequence2.startEnumeration();
                int n15 = integerSequence2.nextElement();
                while (integerSequence2.hasMoreElements()) {
                    int n16 = integerSequence2.nextElement();
                    int n17 = n16 - n15;
                    integerSequence.startEnumeration();
                    int n18 = integerSequence.nextElement();
                    while (integerSequence.hasMoreElements()) {
                        int n19 = integerSequence.nextElement();
                        int n20 = n19 - n18;
                        if (bl2) {
                            rasterArray[0] = writableRaster;
                        }
                        int n21 = bl2 ? 1 : 0;
                        while (n21 < n10) {
                            PlanarImage planarImage = this.getSource(n21);
                            int n22 = planarImage.XToTileX(n18);
                            int n23 = planarImage.YToTileY(n15);
                            rasterArray[n21] = planarImage.getTile(n22, n23);
                            ++n21;
                        }
                        rectangle6.x = n18;
                        rectangle6.y = n15;
                        rectangle6.width = n20;
                        rectangle6.height = n17;
                        this.computeRect(rasterArray, writableRaster, rectangle6);
                        n18 = n19;
                    }
                    n15 = n16;
                }
            }
        }
        if (bl2 && this.source0IsWritableRenderedImage) {
            this.source0AsWritableRenderedImage.releaseWritableTile(n2, n3);
        }
        return writableRaster;
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.cache != null && this.isInPlaceEnabled && this.tileRecycler != null) {
            this.cache.removeTiles(this);
        }
        super.dispose();
    }
}

