/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class ROI
implements Serializable {
    private transient RandomIter iter = null;
    transient PlanarImage theImage = null;
    int threshold = 127;

    protected static LinkedList mergeRunLengthList(LinkedList linkedList) {
        if (linkedList == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (linkedList.size() > 1) {
            int n2 = 0;
            while (n2 < linkedList.size() - 1) {
                ListIterator listIterator = linkedList.listIterator(n2);
                Rectangle rectangle = (Rectangle)listIterator.next();
                while (listIterator.hasNext()) {
                    Rectangle rectangle2 = (Rectangle)listIterator.next();
                    int n3 = rectangle.y + rectangle.height;
                    if (rectangle2.y == n3 && rectangle2.x == rectangle.x && rectangle2.width == rectangle.width) {
                        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + rectangle2.height);
                        listIterator.remove();
                        linkedList.set(n2, rectangle);
                        continue;
                    }
                    if (rectangle2.y > n3) break;
                }
                ++n2;
            }
        }
        return linkedList;
    }

    protected ROI() {
    }

    public ROI(RenderedImage renderedImage) {
        this(renderedImage, 127);
    }

    public ROI(RenderedImage renderedImage, int n2) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI0"));
        }
        this.threshold = n2;
        if (n2 >= 1 && ImageUtil.isBinary(sampleModel)) {
            this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        } else {
            ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("binarize");
            parameterBlockJAI.setSource("source0", renderedImage);
            parameterBlockJAI.setParameter("threshold", (double)n2);
            this.theImage = JAI.create("binarize", parameterBlockJAI, null);
        }
    }

    private RandomIter getIter() {
        if (this.iter == null) {
            this.iter = RandomIterFactory.create(this.theImage, null);
        }
        return this.iter;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n2) {
        this.threshold = n2;
        ((RenderedOp)this.theImage).setParameter((double)n2, 0);
        this.iter = null;
        this.getIter();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    public boolean contains(Point point) {
        if (point == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains(point.x, point.y);
    }

    public boolean contains(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean contains(int n2, int n3) {
        int n4 = this.theImage.getMinX();
        int n5 = this.theImage.getMinY();
        return n2 >= n4 && n2 < n4 + this.theImage.getWidth() && n3 >= n5 && n3 < n5 + this.theImage.getHeight() && this.getIter().getSample(n2, n3, 0) >= 1;
    }

    public boolean contains(double d2, double d3) {
        return this.contains((int)d2, (int)d3);
    }

    public boolean contains(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!rectangle.equals(rectangle.intersection(this.getBounds()))) {
            return false;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n2 = rectangle.width % 8;
        if (n2 == 0) {
            int n3 = 0;
            while (n3 < byArray.length) {
                if ((byArray[n3] & 0xFF) != 255) {
                    return false;
                }
                ++n3;
            }
        } else {
            int n4 = (1 << n2) - 1 << 8 - n2;
            int n5 = 0;
            int n6 = 0;
            while (n5 < rectangle.height) {
                int n7 = 0;
                while (n7 < rectangle.width - n2) {
                    if ((byArray[n6] & 0xFF) != 255) {
                        return false;
                    }
                    n7 += 8;
                    ++n6;
                }
                if ((byArray[n6] & n4) != n4) {
                    return false;
                }
                ++n6;
                ++n5;
            }
        }
        return true;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.contains(rectangle);
    }

    public boolean contains(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        return this.contains(rectangle);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        Rectangle rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d5);
        return this.contains(rectangle);
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            return false;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle2);
        int n2 = rectangle2.width % 8;
        if (n2 == 0) {
            int n3 = 0;
            while (n3 < byArray.length) {
                if ((byArray[n3] & 0xFF) != 0) {
                    return true;
                }
                ++n3;
            }
        } else {
            int n4 = (1 << n2) - 1 << 8 - n2;
            int n5 = 0;
            int n6 = 0;
            while (n5 < rectangle2.height) {
                int n7 = 0;
                while (n7 < rectangle2.width - n2) {
                    if ((byArray[n6] & 0xFF) != 0) {
                        return true;
                    }
                    n7 += 8;
                    ++n6;
                }
                if ((byArray[n6] & n4) != 0) {
                    return true;
                }
                ++n6;
                ++n5;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.intersects(rectangle);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        return this.intersects(rectangle);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        Rectangle rectangle = new Rectangle((int)d2, (int)d3, (int)d4, (int)d5);
        return this.intersects(rectangle);
    }

    private static PlanarImage createBinaryImage(Rectangle rectangle) {
        if (rectangle.x == 0 && rectangle.y == 0) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
            return PlanarImage.wrapRenderedImage(bufferedImage);
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, rectangle.width, rectangle.height, 1);
        return new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, multiPixelPackedSampleModel, PlanarImage.createColorModel(multiPixelPackedSampleModel));
    }

    private ROI createOpROI(ROI rOI, String string) {
        RenderedOp renderedOp;
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        PlanarImage planarImage = this.getAsImage();
        PlanarImage planarImage2 = rOI.getAsImage();
        Rectangle rectangle = planarImage.getBounds();
        Rectangle rectangle2 = planarImage2.getBounds();
        if (string.equals("and") || rectangle.equals(rectangle2)) {
            renderedOp = JAI.create(string, (RenderedImage)planarImage, planarImage2);
        } else if (string.equals("subtract") || rectangle.contains(rectangle2)) {
            PlanarImage planarImage3 = ROI.createBinaryImage(rectangle);
            planarImage3 = JAI.create("overlay", (RenderedImage)planarImage3, planarImage2);
            renderedOp = JAI.create(string, (RenderedImage)planarImage, planarImage3);
        } else if (rectangle2.contains(rectangle)) {
            PlanarImage planarImage4 = ROI.createBinaryImage(rectangle2);
            planarImage4 = JAI.create("overlay", (RenderedImage)planarImage4, planarImage);
            renderedOp = JAI.create(string, (RenderedImage)planarImage4, planarImage2);
        } else {
            Rectangle rectangle3 = rectangle.union(rectangle2);
            PlanarImage planarImage5 = ROI.createBinaryImage(rectangle3);
            PlanarImage planarImage6 = ROI.createBinaryImage(rectangle3);
            planarImage5 = JAI.create("overlay", (RenderedImage)planarImage5, planarImage);
            planarImage6 = JAI.create("overlay", (RenderedImage)planarImage6, planarImage2);
            renderedOp = JAI.create(string, (RenderedImage)planarImage5, planarImage6);
        }
        return new ROI(renderedOp, this.threshold);
    }

    public ROI add(ROI rOI) {
        return this.createOpROI(rOI, "add");
    }

    public ROI subtract(ROI rOI) {
        return this.createOpROI(rOI, "subtract");
    }

    public ROI intersect(ROI rOI) {
        return this.createOpROI(rOI, "and");
    }

    public ROI exclusiveOr(ROI rOI) {
        return this.createOpROI(rOI, "xor");
    }

    public ROI transform(AffineTransform affineTransform, Interpolation interpolation) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI5"));
        }
        if (interpolation == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI6"));
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(affineTransform);
        parameterBlock.add(interpolation);
        return this.performImageOp("Affine", parameterBlock, 0, null);
    }

    public ROI transform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.transform(affineTransform, Interpolation.getInstance(0));
    }

    public ROI performImageOp(RenderedImageFactory renderedImageFactory, ParameterBlock parameterBlock, int n2, RenderingHints renderingHints) {
        if (renderedImageFactory == null || parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n2);
        RenderedImage renderedImage = renderedImageFactory.create(parameterBlock2, renderingHints);
        return new ROI(renderedImage, this.threshold);
    }

    public ROI performImageOp(String string, ParameterBlock parameterBlock, int n2, RenderingHints renderingHints) {
        if (string == null || parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n2);
        RenderedOp renderedOp = JAI.create(string, parameterBlock2, renderingHints);
        return new ROI(renderedOp, this.threshold);
    }

    public Shape getAsShape() {
        return null;
    }

    public PlanarImage getAsImage() {
        return this.theImage;
    }

    public int[][] getAsBitmask(int n2, int n3, int n4, int n5, int[][] nArray) {
        int n6;
        int n7;
        int n8;
        Rectangle rectangle = this.getBounds().intersection(new Rectangle(n2, n3, n4, n5));
        if (rectangle.isEmpty()) {
            return null;
        }
        int n9 = (n4 + 31) / 32;
        if (nArray == null) {
            nArray = new int[n5][n9];
        } else if (nArray.length < n5 || nArray[0].length < n9) {
            throw new RuntimeException(JaiI18N.getString("ROI3"));
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n10 = rectangle.width % 8;
        if (n10 != 0) {
            n8 = (1 << n10) - 1 << 8 - n10;
            n7 = (n4 + 7) / 8;
            n6 = n7 - 1;
            while (n6 < byArray.length) {
                byArray[n6] = (byte)(byArray[n6] & n8);
                n6 += n7;
            }
        }
        n8 = (rectangle.width + 7) / 8;
        n7 = n8 % 4;
        int n11 = (n8 - n7) / 4;
        n6 = 0;
        int n12 = 0;
        while (n6 < rectangle.height) {
            int[] nArray2 = nArray[n6];
            int n13 = 0;
            while (n13 < n11) {
                nArray2[n13] = (byArray[n12] & 0xFF) << 24 | (byArray[n12 + 1] & 0xFF) << 16 | (byArray[n12 + 2] & 0xFF) << 8 | (byArray[n12 + 3] & 0xFF) << 0;
                n12 += 4;
                ++n13;
            }
            switch (n7) {
                case 0: {
                    break;
                }
                case 1: {
                    nArray2[n13++] = (byArray[n12] & 0xFF) << 24;
                    break;
                }
                case 2: {
                    nArray2[n13++] = (byArray[n12] & 0xFF) << 24 | (byArray[n12 + 1] & 0xFF) << 16;
                    break;
                }
                case 3: {
                    nArray2[n13++] = (byArray[n12] & 0xFF) << 24 | (byArray[n12 + 1] & 0xFF) << 16 | (byArray[n12 + 2] & 0xFF) << 8;
                }
            }
            n12 += n7;
            Arrays.fill(nArray2, n13, n9, 0);
            ++n6;
        }
        n6 = rectangle.height;
        while (n6 < n5) {
            Arrays.fill(nArray[n6], 0);
            ++n6;
        }
        return nArray;
    }

    public LinkedList getAsRectangleList(int n2, int n3, int n4, int n5) {
        return this.getAsRectangleList(n2, n3, n4, n5, true);
    }

    protected LinkedList getAsRectangleList(int n2, int n3, int n4, int n5, boolean bl2) {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.intersects(rectangle = new Rectangle(n2, n3, n4, n5))) {
            return null;
        }
        if (!rectangle2.contains(rectangle)) {
            rectangle = rectangle2.intersection(rectangle);
            n2 = rectangle.x;
            n3 = rectangle.y;
            n4 = rectangle.width;
            n5 = rectangle.height;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n6 = (n4 + 7) / 8;
        int n7 = n4 % 8;
        int n8 = n7 == 0 ? 255 : (1 << n7) - 1 << 8 - n7;
        LinkedList linkedList = new LinkedList();
        int n9 = 0;
        int n10 = 0;
        while (n9 < n5) {
            int n11 = -1;
            int n12 = 0;
            boolean bl3 = false;
            while (n12 < n6) {
                int n13 = byArray[n10] & (n12 == n6 - 1 ? n8 : 255);
                if (n13 == 0) {
                    if (n11 >= 0) {
                        linkedList.addLast(new Rectangle(n2 + n11, n3 + n9, n12 * 8 - n11, 1));
                        n11 = -1;
                    }
                } else if (n13 == 255) {
                    if (n11 < 0) {
                        n11 = n12 * 8;
                    }
                } else {
                    int n14 = 7;
                    while (n14 >= 0) {
                        if ((n13 & 1 << n14) == 0) {
                            if (n11 >= 0) {
                                linkedList.addLast(new Rectangle(n2 + n11, n3 + n9, n12 * 8 + (7 - n14) - n11, 1));
                                n11 = -1;
                            }
                        } else if (n11 < 0) {
                            n11 = n12 * 8 + (7 - n14);
                        }
                        --n14;
                    }
                }
                ++n12;
                ++n10;
            }
            if (n11 >= 0) {
                linkedList.addLast(new Rectangle(n2 + n11, n3 + n9, n12 * 8 - n11, 1));
            }
            ++n9;
        }
        return bl2 ? ROI.mergeRunLengthList(linkedList) : linkedList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.theImage != null) {
            objectOutputStream.writeBoolean(true);
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(JAI.KEY_SERIALIZE_DEEP_COPY, new Boolean(true));
            objectOutputStream.writeObject(SerializerFactory.getState(this.theImage, renderingHints));
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream.readBoolean()) {
            SerializableState serializableState = (SerializableState)objectInputStream.readObject();
            RenderedImage renderedImage = (RenderedImage)serializableState.getObject();
            this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        } else {
            this.theImage = null;
        }
        this.iter = null;
    }
}

