/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MultiPixelPackedSampleModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.TiledImage;

public class ROIShape
extends ROI {
    transient Shape theShape = null;

    private static Point2D.Double getIntersection(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[][] dArray = new double[2][2];
        dArray[0][0] = d5 - d3;
        dArray[0][1] = d2 - d4;
        dArray[1][0] = d9 - d7;
        dArray[1][1] = d6 - d8;
        double[] dArray2 = new double[]{d3 * (d2 - d4) + d2 * (d5 - d3), d7 * (d6 - d8) + d6 * (d9 - d7)};
        double d10 = dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        double d11 = dArray[0][0];
        dArray[0][0] = dArray[1][1] / d10;
        dArray[0][1] = -dArray[0][1] / d10;
        dArray[1][0] = -dArray[1][0] / d10;
        dArray[1][1] = d11 / d10;
        double d12 = dArray[0][0] * dArray2[0] + dArray[0][1] * dArray2[1];
        double d13 = dArray[1][0] * dArray2[0] + dArray[1][1] * dArray2[1];
        return new Point2D.Double(d12, d13);
    }

    private LinkedList polygonToRunLengthList(Rectangle rectangle, Polygon polygon) {
        PolyShape polyShape = new PolyShape(polygon, rectangle);
        return polyShape.getAsRectList();
    }

    private static int[][] rectangleListToBitmask(LinkedList linkedList, Rectangle rectangle, int[][] nArray) {
        int n2 = Integer.MIN_VALUE;
        int n3 = (rectangle.width + 31) / 32;
        if (nArray == null) {
            nArray = new int[rectangle.height][n3];
        } else if (nArray.length < rectangle.height || nArray[0].length < n3) {
            throw new RuntimeException(JaiI18N.getString("ROIShape0"));
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            if (!rectangle.intersects(rectangle2)) continue;
            rectangle2 = rectangle.intersection(rectangle2);
            int n4 = rectangle2.y - rectangle.y;
            int n5 = rectangle2.x - rectangle.x;
            int n6 = n4 + rectangle2.height - 1;
            int n7 = n5 + rectangle2.width - 1;
            int n8 = n4;
            while (n8 <= n6) {
                int[] nArray2 = nArray[n8];
                int n9 = n5;
                while (n9 <= n7) {
                    int n10 = n9 / 32;
                    int n11 = n9 % 32;
                    int n12 = n10;
                    nArray2[n12] = nArray2[n12] | n2 >>> n11;
                    ++n9;
                }
                ++n8;
            }
        }
        return nArray;
    }

    public ROIShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape2"));
        }
        this.theShape = shape;
    }

    public ROIShape(Area area) {
        AffineTransform affineTransform = new AffineTransform();
        PathIterator pathIterator = area.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        generalPath.append(pathIterator, false);
        this.theShape = generalPath;
    }

    public Rectangle getBounds() {
        return this.theShape.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.theShape.getBounds2D();
    }

    public boolean contains(Point point) {
        if (point == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains(point.x, point.y);
    }

    public boolean contains(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean contains(int n2, int n3) {
        return this.theShape.contains(n2, n3);
    }

    public boolean contains(double d2, double d3) {
        return this.contains((int)d2, (int)d3);
    }

    public boolean contains(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public boolean contains(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.theShape.contains(rectangle2D);
    }

    public boolean contains(int n2, int n3, int n4, int n5) {
        return this.contains(new Rectangle2D.Float(n2, n3, n4, n5));
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.theShape.contains(d2, d3, d4, d5);
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.intersects(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.theShape.intersects(rectangle2D);
    }

    public boolean intersects(int n2, int n3, int n4, int n5) {
        return this.intersects(new Rectangle2D.Float(n2, n3, n4, n5));
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.theShape.intersects(d2, d3, d4, d5);
    }

    public ROI add(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.add(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.add(area2);
        return new ROIShape(area);
    }

    public ROI subtract(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.subtract(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.subtract(area2);
        return new ROIShape(area);
    }

    public ROI intersect(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.intersect(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.intersect(area2);
        return new ROIShape(area);
    }

    public ROI exclusiveOr(ROI rOI) {
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROIShape3"));
        }
        if (!(rOI instanceof ROIShape)) {
            return super.exclusiveOr(rOI);
        }
        ROIShape rOIShape = (ROIShape)rOI;
        Area area = new Area(this.theShape);
        Area area2 = new Area(rOIShape.theShape);
        area.exclusiveOr(area2);
        return new ROIShape(area);
    }

    public Shape getAsShape() {
        return this.theShape;
    }

    public PlanarImage getAsImage() {
        Graphics2D graphics2D;
        PlanarImage planarImage;
        if (this.theImage != null) {
            return this.theImage;
        }
        Rectangle rectangle = this.theShape.getBounds();
        if (rectangle.x == 0 && rectangle.y == 0) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
            planarImage = PlanarImage.wrapRenderedImage(bufferedImage);
            graphics2D = bufferedImage.createGraphics();
        } else {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, rectangle.width, rectangle.height, 1);
            TiledImage tiledImage = new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, multiPixelPackedSampleModel, PlanarImage.createColorModel(multiPixelPackedSampleModel));
            planarImage = tiledImage;
            graphics2D = tiledImage.createGraphics();
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(this.theShape);
        this.theImage = planarImage;
        return this.theImage;
    }

    public ROI transform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return new ROIShape(affineTransform.createTransformedShape(this.theShape));
    }

    public int[][] getAsBitmask(int n2, int n3, int n4, int n5, int[][] nArray) {
        LinkedList linkedList = this.getAsRectangleList(n2, n3, n4, n5, false);
        if (linkedList == null) {
            return null;
        }
        return ROIShape.rectangleListToBitmask(linkedList, new Rectangle(n2, n3, n4, n5), nArray);
    }

    public LinkedList getAsRectangleList(int n2, int n3, int n4, int n5) {
        return this.getAsRectangleList(n2, n3, n4, n5, true);
    }

    protected LinkedList getAsRectangleList(int n2, int n3, int n4, int n5, boolean bl2) {
        LinkedList<Rectangle> linkedList = null;
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (!new Area(this.theShape).intersects(rectangle)) {
            return null;
        }
        if (this.theShape instanceof Rectangle2D) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Rectangle2D.intersect((Rectangle2D)this.theShape, rectangle, double_);
            int n6 = (int)Math.round(double_.getMinX());
            int n7 = (int)Math.round(double_.getMinY());
            int n8 = (int)Math.round(double_.getMaxX() - (double)n6);
            int n9 = (int)Math.round(double_.getMaxY() - (double)n7);
            linkedList = new LinkedList<Rectangle>();
            linkedList.addLast(new Rectangle(n6, n7, n8, n9));
        } else if (this.theShape instanceof Polygon) {
            linkedList = this.polygonToRunLengthList(rectangle, (Polygon)this.theShape);
            if (bl2 && linkedList != null) {
                linkedList = ROI.mergeRunLengthList(linkedList);
            }
        } else {
            this.getAsImage();
            linkedList = super.getAsRectangleList(n2, n3, n4, n5, bl2);
        }
        return linkedList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        LinkedList linkedList = null;
        if (this.theShape == null) {
            linkedList = new LinkedList();
        } else {
            Rectangle rectangle = this.getBounds();
            linkedList = this.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(linkedList);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LinkedList linkedList = null;
        objectInputStream.defaultReadObject();
        linkedList = (LinkedList)objectInputStream.readObject();
        Area area = new Area();
        int n2 = linkedList.size();
        int n3 = 0;
        while (n3 < n2) {
            area.add(new Area((Rectangle)linkedList.get(n3)));
            ++n3;
        }
        this.theShape = area;
    }

    private class PolyShape {
        private static final int POLYGON_UNCLASSIFIED = 0;
        private static final int POLYGON_DEGENERATE = 1;
        private static final int POLYGON_CONVEX = 2;
        private static final int POLYGON_CONCAVE = 3;
        private Polygon poly;
        private Rectangle clip;
        private int type = 0;
        private boolean insidePolygon = false;

        PolyShape(Polygon polygon, Rectangle rectangle) {
            this.poly = polygon;
            this.clip = rectangle;
            this.insidePolygon = this.poly.contains(rectangle);
            this.type = 0;
        }

        public LinkedList getAsRectList() {
            LinkedList linkedList = new LinkedList();
            if (this.insidePolygon) {
                linkedList.addLast(this.poly.getBounds());
            } else {
                this.classifyPolygon();
                switch (this.type) {
                    case 1: {
                        linkedList = null;
                        break;
                    }
                    case 2: {
                        linkedList = this.scanConvex(linkedList);
                        break;
                    }
                    case 3: {
                        linkedList = this.scanConcave(linkedList);
                        break;
                    }
                    default: {
                        throw new RuntimeException(JaiI18N.getString("ROIShape1"));
                    }
                }
            }
            return linkedList;
        }

        private int classifyPolygon() {
            boolean bl2;
            if (this.type != 0) {
                return this.type;
            }
            int n2 = this.poly.npoints;
            if (n2 < 3) {
                this.type = 1;
                return this.type;
            }
            if (this.poly.getBounds().contains(this.clip)) {
                this.type = 2;
                return this.type;
            }
            int[] nArray = this.poly.xpoints;
            int[] nArray2 = this.poly.ypoints;
            int n3 = this.sgn((nArray[0] - nArray[1]) * (nArray2[1] - nArray2[2]) - (nArray[1] - nArray[2]) * (nArray2[0] - nArray2[1]));
            boolean bl3 = bl2 = n3 == 0;
            int n4 = nArray[0] < nArray[1] ? -1 : (nArray[0] > nArray[1] ? 1 : (nArray2[0] < nArray2[1] ? -1 : (nArray2[0] > nArray2[1] ? 1 : 0)));
            int n5 = 0;
            int n6 = 1;
            while (n6 < n2) {
                int n7 = (n6 + 1) % n2;
                int n8 = (n6 + 2) % n2;
                int n9 = nArray[n6] < nArray[n7] ? -1 : (nArray[n6] > nArray[n7] ? 1 : (nArray2[n6] < nArray2[n7] ? -1 : (nArray2[n6] > nArray2[n7] ? 1 : 0)));
                if (n9 != 0 && n9 == -n4) {
                    ++n5;
                }
                n4 = n9;
                int n10 = this.sgn((nArray[n6] - nArray[n7]) * (nArray2[n7] - nArray2[n8]) - (nArray[n7] - nArray[n8]) * (nArray2[n6] - nArray2[n7]));
                boolean bl4 = bl2 = bl2 && n10 == 0;
                if (!bl2) {
                    if (n10 != 0 && n10 == -n3) {
                        this.type = 3;
                        break;
                    }
                    if (n10 != 0) {
                        n3 = n10;
                    }
                }
                ++n6;
            }
            if (this.type == 0) {
                this.type = bl2 ? 1 : (n5 > 2 ? 3 : 2);
            }
            return this.type;
        }

        private final int sgn(int n2) {
            int n3 = n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
            return n3;
        }

        /*
         * Unable to fully structure code
         */
        private LinkedList scanConvex(LinkedList var1_1) {
            if (var1_1 == null) {
                var1_1 = new LinkedList<Rectangle>();
            }
            var2_2 = this.poly.ypoints[0];
            var3_3 = 0;
            var4_4 = this.poly.npoints;
            var5_5 = 1;
            while (var5_5 < var4_4) {
                if (this.poly.ypoints[var5_5] < var2_2) {
                    var2_2 = this.poly.ypoints[var5_5];
                    var3_3 = var5_5;
                }
                ++var5_5;
            }
            var6_6 = var3_3;
            var7_7 = var3_3;
            var8_8 = var4_4;
            var9_9 = var2_2;
            var11_11 = var10_10 = var9_9 - 1;
            var12_12 = this.intArrayToDoubleArray(this.poly.xpoints);
            var13_13 = this.poly.ypoints;
            var14_14 = new double[1];
            var15_15 = new double[1];
            var16_16 = new double[1];
            var17_17 = new double[1];
            ** GOTO lbl50
            {
                --var8_8;
                var18_18 = var6_6 - 1;
                if (var18_18 < 0) {
                    var18_18 = var4_4 - 1;
                }
                this.intersectX(var12_12[var6_6], var13_13[var6_6], var12_12[var18_18], var13_13[var18_18], var9_9, var14_14, var15_15);
                var10_10 = var13_13[var18_18];
                var6_6 = var18_18;
                do {
                    if (var10_10 <= var9_9 && var8_8 > 0) continue block1;
                    while (var11_11 <= var9_9 && var8_8 > 0) {
                        --var8_8;
                        var18_18 = var7_7 + 1;
                        if (var18_18 >= var4_4) {
                            var18_18 = 0;
                        }
                        this.intersectX(var12_12[var7_7], var13_13[var7_7], var12_12[var18_18], var13_13[var18_18], var9_9, var16_16, var17_17);
                        var11_11 = var13_13[var18_18];
                        var7_7 = var18_18;
                    }
                    while (var9_9 < var10_10 && var9_9 < var11_11) {
                        if (var9_9 >= this.clip.y && (double)var9_9 <= this.clip.getMaxY() && (var19_19 = var14_14[0] <= var16_16[0] ? this.scanSegment(var9_9, var14_14[0], var16_16[0]) : this.scanSegment(var9_9, var16_16[0], var14_14[0])) != null) {
                            var1_1.addLast(var19_19);
                        }
                        ++var9_9;
                        var14_14[0] = var14_14[0] + var15_15[0];
                        var16_16[0] = var16_16[0] + var17_17[0];
                    }
lbl50:
                    // 2 sources

                } while (var8_8 > 0);
            }
            return var1_1;
        }

        private Rectangle scanSegment(int n2, double d2, double d3) {
            double d4 = d2 - 0.5;
            int n3 = d4 < (double)this.clip.x ? this.clip.x : (int)Math.ceil(d4);
            int n4 = (int)Math.floor(d3 - 0.5);
            if (n4 >= this.clip.x + this.clip.width) {
                n4 = this.clip.x + this.clip.width - 1;
            }
            if (n3 > n4) {
                return null;
            }
            return new Rectangle(n3, n2, n4 - n3 + 1, 1);
        }

        private void intersectX(double d2, int n2, double d3, int n3, int n4, double[] dArray, double[] dArray2) {
            int n5 = n3 - n2;
            if (n5 == 0) {
                n5 = 1;
            }
            double d4 = (double)(n4 - n2) + 0.5;
            dArray2[0] = (d3 - d2) / (double)n5;
            dArray[0] = d2 + dArray2[0] * d4;
        }

        /*
         * Exception decompiling
         */
        private LinkedList scanConcave(LinkedList var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void deleteEdge(Vector vector, int n2) {
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                PolyEdge polyEdge = (PolyEdge)vector.get(n4);
                if (polyEdge.i == n2) break;
                ++n4;
            }
            if (n4 < n3) {
                vector.removeElementAt(n4);
            }
        }

        private void appendEdge(Vector vector, int n2, int n3) {
            int n4;
            int n5;
            int n6 = (n2 + 1) % this.poly.npoints;
            if (this.poly.ypoints[n2] < this.poly.ypoints[n6]) {
                n5 = n2;
                n4 = n6;
            } else {
                n5 = n6;
                n4 = n2;
            }
            double d2 = (double)(this.poly.xpoints[n4] - this.poly.xpoints[n5]) / (double)(this.poly.ypoints[n4] - this.poly.ypoints[n5]);
            double d3 = d2 * (double)((float)n3 + 0.5f - (float)this.poly.ypoints[n5]) + (double)this.poly.xpoints[n5];
            vector.add(new PolyEdge(d3, d2, n2));
        }

        private double[] intArrayToDoubleArray(int[] nArray) {
            int n2 = nArray.length;
            double[] dArray = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                dArray[n3] = nArray[n3];
                ++n3;
            }
            return dArray;
        }

        private int[] vectorToIntArray(Vector vector) {
            int n2 = vector.size();
            int[] nArray = new int[n2];
            Object[] objectArray = vector.toArray();
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = (Integer)objectArray[n3];
                ++n3;
            }
            return nArray;
        }

        private class PolyEdge
        implements Comparator {
            public double x;
            public double dx;
            public int i;

            PolyEdge(double d2, double d3, int n2) {
                this.x = d2;
                this.dx = d3;
                this.i = n2;
            }

            public int compare(Object object, Object object2) {
                double d2 = ((PolyEdge)object).x;
                double d3 = ((PolyEdge)object2).x;
                int n2 = d2 < d3 ? -1 : (d2 > d3 ? 1 : 0);
                return n2;
            }
        }
    }
}

