/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterFormatTag;
import sun.awt.image.BytePackedRaster;

public class RasterAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 2;
    public static final int COPY_MASK = 384;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    private static final int EXPANSION_MASK_SHIFT = 9;
    private static final int EXPANSION_MASK_SIZE = 2;
    public static final int EXPANSION_MASK = 1536;
    public static final int DEFAULTEXPANSION = 0;
    public static final int EXPANDED = 512;
    public static final int UNEXPANDED = 1024;
    public static final int DATATYPE_MASK = 127;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    public static final int TAG_BYTE_EXPANDED = 512;
    private static final int TAG_BINARY = 1152;
    protected Raster raster;
    protected int rectWidth;
    protected int rectHeight;
    protected int rectX;
    protected int rectY;
    protected int formatTagID;
    protected byte[] binaryDataArray;
    protected byte[][] byteDataArrays;
    protected short[][] shortDataArrays;
    protected int[][] intDataArrays;
    protected float[][] floatDataArrays;
    protected double[][] doubleDataArrays;
    protected int[] bandDataOffsets;
    protected int[] bandOffsets;
    protected int numBands;
    protected int scanlineStride;
    protected int pixelStride;

    public static RasterFormatTag[] findCompatibleTags(RenderedImage[] renderedImageArray, RenderedImage renderedImage) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = renderedImageArray != null ? new int[renderedImageArray.length + 1] : new int[1];
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n6 = n5 = sampleModel.getTransferType();
        boolean bl2 = ImageUtil.isBinary(sampleModel);
        if (bl2) {
            n6 = 0;
        } else if (n5 == 0 || n5 == 1 || n5 == 2) {
            n6 = 3;
        }
        if (renderedImageArray != null) {
            n4 = renderedImageArray.length;
            n3 = 0;
            while (n3 < n4) {
                SampleModel sampleModel2 = renderedImageArray[n3].getSampleModel();
                n2 = sampleModel2.getTransferType();
                if (!(bl2 && ImageUtil.isBinary(sampleModel2) || n2 <= n6)) {
                    n6 = n2;
                }
                ++n3;
            }
        }
        n4 = n6 | 0x80;
        if (sampleModel instanceof ComponentSampleModel) {
            if (renderedImageArray != null) {
                n3 = renderedImageArray.length;
                int n7 = 0;
                while (n7 < n3) {
                    SampleModel sampleModel3 = renderedImageArray[n7].getSampleModel();
                    int n8 = sampleModel3.getTransferType();
                    if (!(sampleModel3 instanceof ComponentSampleModel) || n8 != n5) break;
                    ++n7;
                }
                if (n7 == n3) {
                    n4 = n5 | 0;
                }
            } else {
                n4 = n5 | 0;
            }
        }
        RasterFormatTag[] rasterFormatTagArray = new RasterFormatTag[nArray.length];
        if (renderedImageArray != null) {
            int n9 = 0;
            while (n9 < renderedImageArray.length) {
                nArray[n9] = renderedImageArray[n9].getColorModel() instanceof IndexColorModel ? (renderedImage.getColorModel() instanceof IndexColorModel ? n4 | 0x400 : n4 | 0x200) : (renderedImageArray[n9].getColorModel() instanceof ComponentColorModel || bl2 && ImageUtil.isBinary(renderedImageArray[n9].getSampleModel()) ? n4 | 0x400 : n4 | 0);
                ++n9;
            }
            nArray[renderedImageArray.length] = n4 | 0x400;
            n2 = 0;
            while (n2 < renderedImageArray.length) {
                rasterFormatTagArray[n2] = new RasterFormatTag(renderedImageArray[n2].getSampleModel(), nArray[n2]);
                ++n2;
            }
            rasterFormatTagArray[renderedImageArray.length] = new RasterFormatTag(sampleModel, nArray[renderedImageArray.length]);
        } else {
            rasterFormatTagArray[0] = new RasterFormatTag(sampleModel, n4 | 0x400);
        }
        return rasterFormatTagArray;
    }

    public static int findCompatibleTag(SampleModel[] sampleModelArray, SampleModel sampleModel) {
        int n2 = sampleModel.getTransferType();
        int n3 = n2 | 0x80;
        if (ImageUtil.isBinary(sampleModel)) {
            n3 = 128;
        } else if (n2 == 0 || n2 == 1 || n2 == 2) {
            n3 = 131;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModelArray != null) {
                int n4 = sampleModelArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = sampleModelArray[n5].getTransferType();
                    if (!(sampleModelArray[n5] instanceof ComponentSampleModel) || n6 != n2) break;
                    ++n5;
                }
                if (n5 == n4) {
                    n3 = n2 | 0;
                }
            } else {
                n3 = n2 | 0;
            }
        }
        return n3 | 0x400;
    }

    public RasterAccessor(Raster raster, Rectangle rectangle, RasterFormatTag rasterFormatTag, ColorModel colorModel) {
        block89: {
            block90: {
                block88: {
                    int n2;
                    int n3;
                    this.binaryDataArray = null;
                    this.byteDataArrays = null;
                    this.shortDataArrays = null;
                    this.intDataArrays = null;
                    this.floatDataArrays = null;
                    this.doubleDataArrays = null;
                    if (raster == null || rectangle == null || rasterFormatTag == null) {
                        throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
                    }
                    if (!raster.getBounds().contains(rectangle)) {
                        throw new IllegalArgumentException(JaiI18N.getString("RasterAccessor2"));
                    }
                    this.raster = raster;
                    this.rectX = rectangle.x;
                    this.rectY = rectangle.y;
                    this.rectWidth = rectangle.width;
                    this.rectHeight = rectangle.height;
                    this.formatTagID = rasterFormatTag.getFormatTagID();
                    if ((this.formatTagID & 0x180) != 0) break block88;
                    this.numBands = rasterFormatTag.getNumBands();
                    this.pixelStride = rasterFormatTag.getPixelStride();
                    ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                    this.scanlineStride = componentSampleModel.getScanlineStride();
                    int[] nArray = null;
                    if (rasterFormatTag.isPixelSequential()) {
                        this.bandOffsets = rasterFormatTag.getBandOffsets();
                        nArray = rasterFormatTag.getBankIndices();
                    } else {
                        this.bandOffsets = componentSampleModel.getBandOffsets();
                        nArray = componentSampleModel.getBankIndices();
                    }
                    this.bandDataOffsets = new int[this.numBands];
                    int[] nArray2 = raster.getDataBuffer().getOffsets();
                    int n4 = (this.rectY - raster.getSampleModelTranslateY()) * this.scanlineStride + (this.rectX - raster.getSampleModelTranslateX()) * this.pixelStride;
                    if (nArray2.length == 1) {
                        n3 = nArray2[0];
                        n2 = 0;
                        while (n2 < this.numBands) {
                            this.bandDataOffsets[n2] = this.bandOffsets[n2] + n3 + n4;
                            ++n2;
                        }
                    } else if (nArray2.length == this.bandDataOffsets.length) {
                        n3 = 0;
                        while (n3 < this.numBands) {
                            this.bandDataOffsets[n3] = this.bandOffsets[n3] + nArray2[n3] + n4;
                            ++n3;
                        }
                    } else {
                        throw new RuntimeException(JaiI18N.getString("RasterAccessor0"));
                    }
                    switch (this.formatTagID & 0x7F) {
                        case 0: {
                            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                            this.byteDataArrays = new byte[this.numBands][];
                            n2 = 0;
                            while (n2 < this.numBands) {
                                this.byteDataArrays[n2] = dataBufferByte.getData(nArray[n2]);
                                ++n2;
                            }
                            break;
                        }
                        case 1: {
                            DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                            this.shortDataArrays = new short[this.numBands][];
                            int n5 = 0;
                            while (n5 < this.numBands) {
                                this.shortDataArrays[n5] = dataBufferUShort.getData(nArray[n5]);
                                ++n5;
                            }
                            break;
                        }
                        case 2: {
                            DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                            this.shortDataArrays = new short[this.numBands][];
                            int n6 = 0;
                            while (n6 < this.numBands) {
                                this.shortDataArrays[n6] = dataBufferShort.getData(nArray[n6]);
                                ++n6;
                            }
                            break;
                        }
                        case 3: {
                            DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                            this.intDataArrays = new int[this.numBands][];
                            int n7 = 0;
                            while (n7 < this.numBands) {
                                this.intDataArrays[n7] = dataBufferInt.getData(nArray[n7]);
                                ++n7;
                            }
                            break;
                        }
                        case 4: {
                            DataBuffer dataBuffer = raster.getDataBuffer();
                            this.floatDataArrays = new float[this.numBands][];
                            int n8 = 0;
                            while (n8 < this.numBands) {
                                this.floatDataArrays[n8] = DataBufferUtils.getDataFloat(dataBuffer, nArray[n8]);
                                ++n8;
                            }
                            break;
                        }
                        case 5: {
                            DataBuffer dataBuffer = raster.getDataBuffer();
                            this.doubleDataArrays = new double[this.numBands][];
                            int n9 = 0;
                            while (n9 < this.numBands) {
                                this.doubleDataArrays[n9] = DataBufferUtils.getDataDouble(dataBuffer, nArray[n9]);
                                ++n9;
                            }
                            break;
                        }
                    }
                    if ((this.formatTagID & 0x600) == 512 && colorModel instanceof IndexColorModel) {
                        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                        int n10 = indexColorModel.getNumComponents();
                        int n11 = indexColorModel.getMapSize();
                        int[] nArray3 = new int[n10];
                        int n12 = this.rectWidth * n10;
                        int n13 = n10;
                        byte[][] byArray = new byte[n10][n11];
                        indexColorModel.getReds(byArray[0]);
                        indexColorModel.getGreens(byArray[1]);
                        indexColorModel.getBlues(byArray[2]);
                        byte[] byArray2 = byArray[0];
                        byte[] byArray3 = byArray[1];
                        byte[] byArray4 = byArray[2];
                        byte[] byArray5 = null;
                        if (n10 == 4) {
                            indexColorModel.getAlphas(byArray[3]);
                            byArray5 = byArray[3];
                        }
                        int n14 = 0;
                        while (n14 < n10) {
                            nArray3[n14] = n14;
                            ++n14;
                        }
                        switch (this.formatTagID & 0x7F) {
                            case 0: {
                                int n15;
                                byte[] byArray6 = new byte[this.rectWidth * this.rectHeight * n10];
                                byte[] byArray7 = this.byteDataArrays[0];
                                int n16 = this.bandDataOffsets[0];
                                int n17 = 0;
                                int n18 = 0;
                                while (n18 < this.rectHeight) {
                                    n15 = n16;
                                    int n19 = n17;
                                    int n20 = 0;
                                    while (n20 < this.rectWidth) {
                                        int n21 = byArray7[n15] & 0xFF;
                                        int n22 = 0;
                                        while (n22 < n10) {
                                            byArray6[n19 + n22] = byArray[n22][n21];
                                            ++n22;
                                        }
                                        n15 += this.pixelStride;
                                        n19 += n13;
                                        ++n20;
                                    }
                                    n16 += this.scanlineStride;
                                    n17 += n12;
                                    ++n18;
                                }
                                this.byteDataArrays = new byte[n10][];
                                n15 = 0;
                                while (n15 < n10) {
                                    this.byteDataArrays[n15] = byArray6;
                                    ++n15;
                                }
                                break;
                            }
                            case 1: {
                                int n23;
                                short[] sArray = new short[this.rectWidth * this.rectHeight * n10];
                                short[] sArray2 = this.shortDataArrays[0];
                                int n24 = this.bandDataOffsets[0];
                                int n25 = 0;
                                int n26 = 0;
                                while (n26 < this.rectHeight) {
                                    n23 = n24;
                                    int n27 = n25;
                                    int n28 = 0;
                                    while (n28 < this.rectWidth) {
                                        int n29 = sArray2[n23] & 0xFFFF;
                                        int n30 = 0;
                                        while (n30 < n10) {
                                            sArray[n27 + n30] = (short)(byArray[n30][n29] & 0xFF);
                                            ++n30;
                                        }
                                        n23 += this.pixelStride;
                                        n27 += n13;
                                        ++n28;
                                    }
                                    n24 += this.scanlineStride;
                                    n25 += n12;
                                    ++n26;
                                }
                                this.shortDataArrays = new short[n10][];
                                n23 = 0;
                                while (n23 < n10) {
                                    this.shortDataArrays[n23] = sArray;
                                    ++n23;
                                }
                                break;
                            }
                            case 2: {
                                int n31;
                                short[] sArray = new short[this.rectWidth * this.rectHeight * n10];
                                short[] sArray3 = this.shortDataArrays[0];
                                int n32 = this.bandDataOffsets[0];
                                int n33 = 0;
                                int n34 = 0;
                                while (n34 < this.rectHeight) {
                                    n31 = n32;
                                    int n35 = n33;
                                    int n36 = 0;
                                    while (n36 < this.rectWidth) {
                                        short s2 = sArray3[n31];
                                        int n37 = 0;
                                        while (n37 < n10) {
                                            sArray[n35 + n37] = (short)(byArray[n37][s2] & 0xFF);
                                            ++n37;
                                        }
                                        n31 += this.pixelStride;
                                        n35 += n13;
                                        ++n36;
                                    }
                                    n32 += this.scanlineStride;
                                    n33 += n12;
                                    ++n34;
                                }
                                this.shortDataArrays = new short[n10][];
                                n31 = 0;
                                while (n31 < n10) {
                                    this.shortDataArrays[n31] = sArray;
                                    ++n31;
                                }
                                break;
                            }
                            case 3: {
                                int n38;
                                int[] nArray4 = new int[this.rectWidth * this.rectHeight * n10];
                                int[] nArray5 = this.intDataArrays[0];
                                int n39 = this.bandDataOffsets[0];
                                int n40 = 0;
                                int n41 = 0;
                                while (n41 < this.rectHeight) {
                                    n38 = n39;
                                    int n42 = n40;
                                    int n43 = 0;
                                    while (n43 < this.rectWidth) {
                                        int n44 = nArray5[n38];
                                        int n45 = 0;
                                        while (n45 < n10) {
                                            nArray4[n42 + n45] = byArray[n45][n44] & 0xFF;
                                            ++n45;
                                        }
                                        n38 += this.pixelStride;
                                        n42 += n13;
                                        ++n43;
                                    }
                                    n39 += this.scanlineStride;
                                    n40 += n12;
                                    ++n41;
                                }
                                this.intDataArrays = new int[n10][];
                                n38 = 0;
                                while (n38 < n10) {
                                    this.intDataArrays[n38] = nArray4;
                                    ++n38;
                                }
                                break;
                            }
                            case 4: {
                                int n46;
                                float[] fArray = new float[this.rectWidth * this.rectHeight * n10];
                                float[] fArray2 = this.floatDataArrays[0];
                                int n47 = this.bandDataOffsets[0];
                                int n48 = 0;
                                int n49 = 0;
                                while (n49 < this.rectHeight) {
                                    n46 = n47;
                                    int n50 = n48;
                                    int n51 = 0;
                                    while (n51 < this.rectWidth) {
                                        int n52 = (int)fArray2[n46];
                                        int n53 = 0;
                                        while (n53 < n10) {
                                            fArray[n50 + n53] = byArray[n53][n52] & 0xFF;
                                            ++n53;
                                        }
                                        n46 += this.pixelStride;
                                        n50 += n13;
                                        ++n51;
                                    }
                                    n47 += this.scanlineStride;
                                    n48 += n12;
                                    ++n49;
                                }
                                this.floatDataArrays = new float[n10][];
                                n46 = 0;
                                while (n46 < n10) {
                                    this.floatDataArrays[n46] = fArray;
                                    ++n46;
                                }
                                break;
                            }
                            case 5: {
                                int n54;
                                double[] dArray = new double[this.rectWidth * this.rectHeight * n10];
                                double[] dArray2 = this.doubleDataArrays[0];
                                int n55 = this.bandDataOffsets[0];
                                int n56 = 0;
                                int n57 = 0;
                                while (n57 < this.rectHeight) {
                                    n54 = n55;
                                    int n58 = n56;
                                    int n59 = 0;
                                    while (n59 < this.rectWidth) {
                                        int n60 = (int)dArray2[n54];
                                        int n61 = 0;
                                        while (n61 < n10) {
                                            dArray[n58 + n61] = byArray[n61][n60] & 0xFF;
                                            ++n61;
                                        }
                                        n54 += this.pixelStride;
                                        n58 += n13;
                                        ++n59;
                                    }
                                    n55 += this.scanlineStride;
                                    n56 += n12;
                                    ++n57;
                                }
                                this.doubleDataArrays = new double[n10][];
                                n54 = 0;
                                while (n54 < n10) {
                                    this.doubleDataArrays[n54] = dArray;
                                    ++n54;
                                }
                                break;
                            }
                        }
                        this.numBands = n10;
                        this.pixelStride = n13;
                        this.scanlineStride = n12;
                        this.bandDataOffsets = nArray3;
                        this.bandOffsets = nArray3;
                    }
                    break block89;
                }
                if ((this.formatTagID & 0x180) != 128 || (this.formatTagID & 0x600) == 1024 || colorModel == null) break block90;
                this.pixelStride = this.numBands = colorModel instanceof IndexColorModel ? colorModel.getNumComponents() : raster.getSampleModel().getNumBands();
                this.scanlineStride = this.rectWidth * this.numBands;
                this.bandOffsets = new int[this.numBands];
                int n62 = 0;
                while (n62 < this.numBands) {
                    this.bandOffsets[n62] = n62;
                    ++n62;
                }
                this.bandDataOffsets = this.bandOffsets;
                Object object = null;
                int n63 = 0;
                int[] nArray = new int[colorModel.getNumComponents()];
                switch (this.formatTagID & 0x7F) {
                    case 3: {
                        int[] nArray6 = new int[this.rectWidth * this.rectHeight * this.numBands];
                        this.intDataArrays = new int[this.numBands][];
                        int n64 = 0;
                        while (n64 < this.numBands) {
                            this.intDataArrays[n64] = nArray6;
                            ++n64;
                        }
                        object = raster.getDataElements(this.rectX, this.rectY, null);
                        n63 = 0;
                        byte[] byArray = null;
                        if (raster instanceof BytePackedRaster) {
                            byArray = (byte[])object;
                        }
                        int n65 = this.rectY;
                        while (n65 < this.rectY + this.rectHeight) {
                            int n66 = this.rectX;
                            while (n66 < this.rectX + this.rectWidth) {
                                if (byArray != null) {
                                    byArray[0] = (byte)raster.getSample(n66, n65, 0);
                                } else {
                                    raster.getDataElements(n66, n65, object);
                                }
                                colorModel.getComponents(object, nArray, 0);
                                nArray6[n63] = nArray[0];
                                nArray6[n63 + 1] = nArray[1];
                                nArray6[n63 + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    nArray6[n63 + 3] = nArray[3];
                                }
                                n63 += this.pixelStride;
                                ++n66;
                            }
                            ++n65;
                        }
                        break block89;
                    }
                    case 4: {
                        float[] fArray = new float[this.rectWidth * this.rectHeight * this.numBands];
                        this.floatDataArrays = new float[this.numBands][];
                        int n67 = 0;
                        while (n67 < this.numBands) {
                            this.floatDataArrays[n67] = fArray;
                            ++n67;
                        }
                        object = null;
                        n63 = 0;
                        int n68 = this.rectY;
                        while (n68 < this.rectY + this.rectHeight) {
                            int n69 = this.rectX;
                            while (n69 < this.rectX + this.rectWidth) {
                                object = raster.getDataElements(n69, n68, object);
                                colorModel.getComponents(object, nArray, 0);
                                fArray[n63] = nArray[0];
                                fArray[n63 + 1] = nArray[1];
                                fArray[n63 + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    fArray[n63 + 3] = nArray[3];
                                }
                                n63 += this.pixelStride;
                                ++n69;
                            }
                            ++n68;
                        }
                        break block89;
                    }
                    case 5: {
                        double[] dArray = new double[this.rectWidth * this.rectHeight * this.numBands];
                        this.doubleDataArrays = new double[this.numBands][];
                        int n70 = 0;
                        while (n70 < this.numBands) {
                            this.doubleDataArrays[n70] = dArray;
                            ++n70;
                        }
                        object = null;
                        n63 = 0;
                        int n71 = this.rectY;
                        while (n71 < this.rectY + this.rectHeight) {
                            int n72 = this.rectX;
                            while (n72 < this.rectX + this.rectWidth) {
                                object = raster.getDataElements(n72, n71, object);
                                colorModel.getComponents(object, nArray, 0);
                                dArray[n63] = nArray[0];
                                dArray[n63 + 1] = nArray[1];
                                dArray[n63 + 2] = nArray[2];
                                if (this.numBands > 3) {
                                    dArray[n63 + 3] = nArray[3];
                                }
                                n63 += this.pixelStride;
                                ++n72;
                            }
                            ++n71;
                        }
                        break block89;
                    }
                }
                break block89;
            }
            this.pixelStride = this.numBands = rasterFormatTag.getNumBands();
            this.scanlineStride = this.rectWidth * this.numBands;
            this.bandDataOffsets = rasterFormatTag.getBandOffsets();
            this.bandOffsets = this.bandDataOffsets;
            switch (this.formatTagID & 0x7F) {
                case 3: {
                    int[] nArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (int[])null);
                    this.intDataArrays = new int[this.numBands][];
                    int n73 = 0;
                    while (n73 < this.numBands) {
                        this.intDataArrays[n73] = nArray;
                        ++n73;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (float[])null);
                    this.floatDataArrays = new float[this.numBands][];
                    int n74 = 0;
                    while (n74 < this.numBands) {
                        this.floatDataArrays[n74] = fArray;
                        ++n74;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = raster.getPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, (double[])null);
                    this.doubleDataArrays = new double[this.numBands][];
                    int n75 = 0;
                    while (n75 < this.numBands) {
                        this.doubleDataArrays[n75] = dArray;
                        ++n75;
                    }
                    break;
                }
            }
        }
    }

    public int getX() {
        return this.rectX;
    }

    public int getY() {
        return this.rectY;
    }

    public int getWidth() {
        return this.rectWidth;
    }

    public int getHeight() {
        return this.rectHeight;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public boolean isBinary() {
        return (this.formatTagID & 0x480) == 1152 && ImageUtil.isBinary(this.raster.getSampleModel());
    }

    public byte[] getBinaryDataArray() {
        if (this.binaryDataArray == null && this.isBinary()) {
            this.binaryDataArray = ImageUtil.getPackedBinaryData(this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
        }
        return this.binaryDataArray;
    }

    public byte[][] getByteDataArrays() {
        if (this.byteDataArrays == null && this.isBinary()) {
            byte[] byArray = ImageUtil.getUnpackedBinaryData(this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
            this.byteDataArrays = new byte[][]{byArray};
        }
        return this.byteDataArrays;
    }

    public byte[] getByteDataArray(int n2) {
        byte[][] byArray = this.getByteDataArrays();
        return byArray == null ? null : byArray[n2];
    }

    public short[][] getShortDataArrays() {
        return this.shortDataArrays;
    }

    public short[] getShortDataArray(int n2) {
        return this.shortDataArrays == null ? null : this.shortDataArrays[n2];
    }

    public int[][] getIntDataArrays() {
        return this.intDataArrays;
    }

    public int[] getIntDataArray(int n2) {
        return this.intDataArrays == null ? null : this.intDataArrays[n2];
    }

    public float[][] getFloatDataArrays() {
        return this.floatDataArrays;
    }

    public float[] getFloatDataArray(int n2) {
        return this.floatDataArrays == null ? null : this.floatDataArrays[n2];
    }

    public double[][] getDoubleDataArrays() {
        return this.doubleDataArrays;
    }

    public double[] getDoubleDataArray(int n2) {
        return this.doubleDataArrays == null ? null : this.doubleDataArrays[n2];
    }

    public Object getDataArray(int n2) {
        Object[] objectArray = null;
        switch (this.getDataType()) {
            case 0: {
                objectArray = this.getByteDataArray(n2);
                break;
            }
            case 1: 
            case 2: {
                objectArray = this.getShortDataArray(n2);
                break;
            }
            case 3: {
                objectArray = this.getIntDataArray(n2);
                break;
            }
            case 4: {
                objectArray = this.getFloatDataArray(n2);
                break;
            }
            case 5: {
                objectArray = this.getDoubleDataArray(n2);
                break;
            }
            default: {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public int[] getBandOffsets() {
        return this.bandDataOffsets;
    }

    public int[] getOffsetsForBands() {
        return this.bandOffsets;
    }

    public int getBandOffset(int n2) {
        return this.bandDataOffsets[n2];
    }

    public int getOffsetForBand(int n2) {
        return this.bandOffsets[n2];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getDataType() {
        return this.formatTagID & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTagID & 0x180) == 128;
    }

    public void copyBinaryDataToRaster() {
        if (this.binaryDataArray == null || !this.isBinary()) {
            return;
        }
        ImageUtil.setPackedBinaryData(this.binaryDataArray, (WritableRaster)this.raster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
    }

    public void copyDataToRaster() {
        if (this.isDataCopy()) {
            WritableRaster writableRaster = (WritableRaster)this.raster;
            switch (this.getDataType()) {
                case 0: {
                    if (!this.isBinary()) {
                        throw new RuntimeException(JaiI18N.getString("RasterAccessor1"));
                    }
                    ImageUtil.setUnpackedBinaryData(this.byteDataArrays[0], writableRaster, new Rectangle(this.rectX, this.rectY, this.rectWidth, this.rectHeight));
                    break;
                }
                case 3: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.intDataArrays[0]);
                    break;
                }
                case 4: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.floatDataArrays[0]);
                    break;
                }
                case 5: {
                    writableRaster.setPixels(this.rectX, this.rectY, this.rectWidth, this.rectHeight, this.doubleDataArrays[0]);
                }
            }
        }
    }

    public boolean needsClamping() {
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 32) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void clampDataArrays() {
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = nArray[0];
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 32) {
                bl2 = true;
            }
            if (nArray[n3] != n2) {
                bl3 = false;
            }
            ++n3;
        }
        if (!bl2) {
            return;
        }
        int n4 = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n4 == 1 && bl3 && nArray[0] == 16) {
            int n5 = 0;
            while (n5 < nArray.length) {
                dArray[n5] = 65535.0;
                dArray2[n5] = 0.0;
                ++n5;
            }
        } else if (n4 == 2 && bl3 && nArray[0] == 16) {
            int n6 = 0;
            while (n6 < nArray.length) {
                dArray[n6] = 32767.0;
                dArray2[n6] = -32768.0;
                ++n6;
            }
        } else if (n4 == 3 && bl3 && nArray[0] == 32) {
            int n7 = 0;
            while (n7 < nArray.length) {
                dArray[n7] = 2.147483647E9;
                dArray2[n7] = -2.147483648E9;
                ++n7;
            }
        } else {
            int n8 = 0;
            while (n8 < nArray.length) {
                dArray[n8] = (1 << nArray[n8]) - 1;
                dArray2[n8] = 0.0;
                ++n8;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
            }
        }
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            nArray[n2] = (int)dArray[n2];
            ++n2;
        }
        return nArray;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            fArray[n2] = (float)dArray[n2];
            ++n2;
        }
        return fArray;
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n2 = this.rectWidth;
        int n3 = this.rectHeight;
        int n4 = 0;
        while (n4 < this.numBands) {
            int[] nArray3 = this.intDataArrays[n4];
            int n5 = this.bandDataOffsets[n4];
            int n6 = nArray[n4];
            int n7 = nArray2[n4];
            int n8 = 0;
            while (n8 < n3) {
                int n9 = n5;
                int n10 = 0;
                while (n10 < n2) {
                    int n11 = nArray3[n9];
                    if (n11 < n7) {
                        nArray3[n9] = n7;
                    } else if (n11 > n6) {
                        nArray3[n9] = n6;
                    }
                    n9 += this.pixelStride;
                    ++n10;
                }
                n5 += this.scanlineStride;
                ++n8;
            }
            ++n4;
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n2 = this.rectWidth;
        int n3 = this.rectHeight;
        int n4 = 0;
        while (n4 < this.numBands) {
            float[] fArray3 = this.floatDataArrays[n4];
            int n5 = this.bandDataOffsets[n4];
            float f2 = fArray[n4];
            float f3 = fArray2[n4];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = n5;
                int n8 = 0;
                while (n8 < n2) {
                    float f4 = fArray3[n7];
                    if (f4 < f3) {
                        fArray3[n7] = f3;
                    } else if (f4 > f2) {
                        fArray3[n7] = f2;
                    }
                    n7 += this.pixelStride;
                    ++n8;
                }
                n5 += this.scanlineStride;
                ++n6;
            }
            ++n4;
        }
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n2 = this.rectWidth;
        int n3 = this.rectHeight;
        int n4 = 0;
        while (n4 < this.numBands) {
            double[] dArray3 = this.doubleDataArrays[n4];
            int n5 = this.bandDataOffsets[n4];
            double d2 = dArray[n4];
            double d3 = dArray2[n4];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = n5;
                int n8 = 0;
                while (n8 < n2) {
                    double d4 = dArray3[n7];
                    if (d4 < d3) {
                        dArray3[n7] = d3;
                    } else if (d4 > d2) {
                        dArray3[n7] = d2;
                    }
                    n7 += this.pixelStride;
                    ++n8;
                }
                n5 += this.scanlineStride;
                ++n6;
            }
            ++n4;
        }
    }
}

