/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;

public final class RasterFormatTag {
    private static final int COPY_MASK = 384;
    private static final int UNCOPIED = 0;
    private static final int COPIED = 128;
    private int formatTagID;
    private int[] bankIndices;
    private int numBands;
    private int[] bandOffsets;
    private int pixelStride;
    private boolean isPixelSequential;

    public RasterFormatTag(SampleModel sampleModel, int n2) {
        this.formatTagID = n2;
        if ((n2 & 0x180) == 0) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.bankIndices = componentSampleModel.getBankIndices();
            this.numBands = componentSampleModel.getNumDataElements();
            this.bandOffsets = componentSampleModel.getBandOffsets();
            this.pixelStride = componentSampleModel.getPixelStride();
            if (this.pixelStride != this.bandOffsets.length) {
                this.isPixelSequential = false;
            } else {
                this.isPixelSequential = true;
                int n3 = 0;
                while (n3 < this.bandOffsets.length) {
                    if (this.bandOffsets[n3] >= this.pixelStride || this.bankIndices[n3] != this.bankIndices[0]) {
                        this.isPixelSequential = false;
                    }
                    int n4 = n3 + 1;
                    while (n4 < this.bandOffsets.length) {
                        if (this.bandOffsets[n3] == this.bandOffsets[n4]) {
                            this.isPixelSequential = false;
                        }
                        ++n4;
                    }
                    if (this.isPixelSequential) {
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        } else if ((n2 & 0x180) == 128) {
            this.numBands = sampleModel.getNumBands();
            this.bandOffsets = new int[this.numBands];
            this.pixelStride = this.numBands;
            this.bankIndices = new int[this.numBands];
            int n5 = 0;
            while (n5 < this.numBands) {
                this.bandOffsets[n5] = n5;
                this.bankIndices[n5] = 0;
                ++n5;
            }
            this.isPixelSequential = true;
        }
    }

    public final boolean isPixelSequential() {
        return this.isPixelSequential;
    }

    public final int getFormatTagID() {
        return this.formatTagID;
    }

    public final int[] getBankIndices() {
        if (this.isPixelSequential) {
            return this.bankIndices;
        }
        return null;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int[] getBandOffsets() {
        if (this.isPixelSequential) {
            return this.bandOffsets;
        }
        return null;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }
}

